// Code generated by smithy-go-codegen DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates a summary of managed instance/node metadata based on the filters and
// aggregators you specify. Results are grouped by the input aggregator you
// specify.
func (c *Client) ListNodesSummary(ctx context.Context, params *ListNodesSummaryInput, optFns ...func(*Options)) (*ListNodesSummaryOutput, error) {
	if params == nil {
		params = &ListNodesSummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListNodesSummary", params, optFns, c.addOperationListNodesSummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListNodesSummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListNodesSummaryInput struct {

	// Specify one or more aggregators to return a count of managed nodes that match
	// that expression. For example, a count of managed nodes by operating system.
	//
	// This member is required.
	Aggregators []types.NodeAggregator

	// One or more filters. Use a filter to generate a summary that matches your
	// specified filter criteria.
	Filters []types.NodeFilter

	// The maximum number of items to return for this call. The call also returns a
	// token that you can specify in a subsequent call to get the next set of results.
	MaxResults *int32

	// The token for the next set of items to return. (You received this token from a
	// previous call.) The call also returns a token that you can specify in a
	// subsequent call to get the next set of results.
	NextToken *string

	// The name of the resource data sync to retrieve information about. Required for
	// cross-account/cross-Region configuration. Optional for single
	// account/single-Region configurations.
	SyncName *string

	noSmithyDocumentSerde
}

type ListNodesSummaryOutput struct {

	// The token to use when requesting the next set of items. If there are no
	// additional items to return, the string is empty.
	NextToken *string

	// A collection of objects reporting information about your managed nodes, such as
	// the count of nodes by operating system.
	Summary []map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListNodesSummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListNodesSummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListNodesSummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListNodesSummary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListNodesSummaryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListNodesSummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListNodesSummaryPaginatorOptions is the paginator options for ListNodesSummary
type ListNodesSummaryPaginatorOptions struct {
	// The maximum number of items to return for this call. The call also returns a
	// token that you can specify in a subsequent call to get the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListNodesSummaryPaginator is a paginator for ListNodesSummary
type ListNodesSummaryPaginator struct {
	options   ListNodesSummaryPaginatorOptions
	client    ListNodesSummaryAPIClient
	params    *ListNodesSummaryInput
	nextToken *string
	firstPage bool
}

// NewListNodesSummaryPaginator returns a new ListNodesSummaryPaginator
func NewListNodesSummaryPaginator(client ListNodesSummaryAPIClient, params *ListNodesSummaryInput, optFns ...func(*ListNodesSummaryPaginatorOptions)) *ListNodesSummaryPaginator {
	if params == nil {
		params = &ListNodesSummaryInput{}
	}

	options := ListNodesSummaryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListNodesSummaryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListNodesSummaryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListNodesSummary page.
func (p *ListNodesSummaryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListNodesSummaryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListNodesSummary(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListNodesSummaryAPIClient is a client that implements the ListNodesSummary
// operation.
type ListNodesSummaryAPIClient interface {
	ListNodesSummary(context.Context, *ListNodesSummaryInput, ...func(*Options)) (*ListNodesSummaryOutput, error)
}

var _ ListNodesSummaryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListNodesSummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListNodesSummary",
	}
}
