/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class BitStringInlineEditor
extends BaseValueEditor<Text> {
    public BitStringInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Text createControl(Composite editPlaceholder) {
        boolean inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        Text editor = new Text(this.valueController.getEditPlaceholder(), inline ? 2048 : 0);
        editor.setEditable(!this.valueController.isReadOnly());
        editor.setTextLimit(this.getValueLength(this.valueController.getValueType()));
        editor.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i = 0;
                while (i < e.text.length()) {
                    char ch = e.text.charAt(i);
                    if (ch != '0' && ch != '1') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                e.doit = true;
            }
        });
        return editor;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        ((Text)this.control).setText(value == null ? "" : value.toString());
    }

    @Override
    public Object extractEditorValue() {
        return ((Text)this.control).getText();
    }

    private int getValueLength(@NotNull DBSTypedObject object) {
        if (object.getPrecision() != null) {
            return Math.max(1, object.getPrecision());
        }
        return Math.max(1, (int)Math.min(object.getMaxLength(), Integer.MAX_VALUE));
    }
}

