/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.legacy;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIIcons;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryItem;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.AIUIUtils;
import org.jkiss.dbeaver.ui.ai.controls.ScopeSelectorControl;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.ai.legacy.InMemoryHistoryManager;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class AISuggestionPopup
extends AbstractPopupPanel {
    @NotNull
    private final DBSLogicalDataSource dataSource;
    @NotNull
    private final DBCExecutionContext executionContext;
    private final AICompletionSettings settings;
    private Text inputField;
    private String inputText;
    private ScopeSelectorControl scopeSelectorControl;

    public AISuggestionPopup(@NotNull Shell parentShell, @NotNull String title, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull AICompletionSettings settings) {
        super(parentShell, title);
        this.dataSource = dataSource;
        this.executionContext = executionContext;
        this.settings = settings;
        this.setImage((DBPImage)AIIcons.AI);
        this.setModeless(true);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite placeholder = super.createDialogArea(parent);
        Composite hintPanel = UIUtils.createComposite((Composite)placeholder, (int)2);
        hintPanel.setLayoutData((Object)new GridData(768));
        Link hintLabel = new Link(hintPanel, 0);
        hintLabel.setText(AIUIMessages.ai_suggestion_popup_message);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        hintLabel.setLayoutData((Object)gd);
        hintLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)HelpUtils.getHelpGitHubReference((String)"AI-Smart-Assistance-in-DBeaver-Community"));
            }
        });
        this.scopeSelectorControl = new ScopeSelectorControl(placeholder, this.dataSource, this.executionContext, this.settings);
        this.scopeSelectorControl.setLayoutData(new GridData(768));
        UIUtils.createToolItem((ToolBar)this.scopeSelectorControl.getToolBar(), (String)"Settings", (DBPImage)UIIcon.CONFIGURATION, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> AIUIUtils.showPreferences(this.getShell())));
        this.inputField = new Text(placeholder, 2050);
        gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Font)placeholder.getFont()) * 10;
        gd.widthHint = UIUtils.getFontHeight((Font)placeholder.getFont()) * 40;
        this.inputField.setLayoutData((Object)gd);
        this.inputField.setTextLimit(10000);
        this.inputField.addModifyListener(e -> {
            String string = this.inputText = this.inputField.getText();
        });
        this.inputField.addListener(1, event -> {
            if (event.keyCode == 13 && event.stateMask == 0) {
                event.doit = false;
                this.okPressed();
            }
        });
        Composite miscPanel = UIUtils.createComposite((Composite)placeholder, (int)2);
        miscPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)miscPanel, (String)"&History");
        final Combo historyCombo = new Combo(miscPanel, 12);
        historyCombo.setLayoutData((Object)new GridData(768));
        Button applyButton = UIUtils.createDialogButton((Composite)placeholder, (String)"&Translate", (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> this.okPressed()));
        ((GridData)applyButton.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)applyButton.getLayoutData()).horizontalAlignment = 3;
        parent.getShell().setDefaultButton(applyButton);
        this.closeOnFocusLost(new Control[]{this.inputField, this.scopeSelectorControl.getScopeCombo(), this.scopeSelectorControl.getScopeText(), historyCombo, applyButton});
        historyCombo.setEnabled(false);
        AbstractJob completionJob = new AbstractJob("Read completion history"){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                List<QMTranslationHistoryItem> queries = InMemoryHistoryManager.readTranslationHistory(AISuggestionPopup.this.dataSource);
                UIUtils.syncExec(() -> {
                    if (!CommonUtils.isEmpty((Collection)queries)) {
                        for (QMTranslationHistoryItem query : queries) {
                            historyCombo.add(query.getNaturalText());
                        }
                        historyCombo.select(0);
                        AISuggestionPopup.this.inputField.setText(((QMTranslationHistoryItem)queries.get(0)).getNaturalText());
                        AISuggestionPopup.this.inputField.selectAll();
                        historyCombo.setEnabled(true);
                    } else {
                        historyCombo.setEnabled(false);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        completionJob.schedule();
        this.inputField.setFocus();
        historyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = historyCombo.getText();
                if (!CommonUtils.isEmpty((String)text)) {
                    AISuggestionPopup.this.inputField.setText(text);
                }
            }
        });
        return placeholder;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected boolean isModeless() {
        return true;
    }

    public String getInputText() {
        return this.inputText;
    }

    public AIDatabaseScope getScope() {
        return this.scopeSelectorControl.getScope();
    }

    public List<DBSObject> getCustomEntities(@NotNull DBRProgressMonitor monitor) {
        return this.scopeSelectorControl.getCustomEntities(monitor);
    }

    protected void okPressed() {
        this.inputText = this.inputField.getText().trim();
        this.settings.setScope(this.scopeSelectorControl.getScope());
        this.settings.setCustomObjectIds(this.scopeSelectorControl.getCheckedObjectIds().toArray(new String[0]));
        this.settings.saveSettings();
        super.okPressed();
    }
}

