# License information

This file summarizes the licenses of Joplin and the direct and indirect dependencies of packages in the Joplin monorepo. Many of these dependencies are used only at build time.

## Joplin's license

```
All code in this repository is licensed under the AGPL-3.0-or-later License
**unless a directory contains a LICENSE or LICENSE.md file**, in which case that
file applies to the code in that sub-directory.

For example, packages/server contains a LICENSE.md file, thus all code under the
packages/server directory is licensed under that license.

For example, packages/app-cli does NOT contain a LICENSE file, thus all code
under that directory is licensed under the default license, which is
AGPL-3.0-or-later.

* * *

Joplin® is a trademark of JOPLIN SAS registered in the European Union, with
filing number 018544315.

* * *

Logo and Icon License

The Joplin logos and icons are copyright (c) Laurent Cozic, all rights reserved,
and may not be used without a permission. If you would like to use the logos or
icons please contact the author in order to get a permission.

* * *

AGPL-3.0-or-later License

Copyright (c) 2016-2025 Laurent Cozic

https://spdx.org/licenses/AGPL-3.0-or-later.html

```

### AGPLv3 License

```

                    GNU AFFERO GENERAL PUBLIC LICENSE
                       Version 3, 19 November 2007
 Copyright (C) 2007 Free Software Foundation, Inc. <https://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.
                            Preamble
  The GNU Affero General Public License is a free, copyleft license for
software and other kinds of works, specifically designed to ensure
cooperation with the community in the case of network server software.
  The licenses for most software and other practical works are designed
to take away your freedom to share and change the works.  By contrast,
our General Public Licenses are intended to guarantee your freedom to
share and change all versions of a program--to make sure it remains free
software for all its users.
  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
them if you wish), that you receive source code or can get it if you
want it, that you can change the software or use pieces of it in new
free programs, and that you know you can do these things.
  Developers that use our General Public Licenses protect your rights
with two steps: (1) assert copyright on the software, and (2) offer
you this License which gives you legal permission to copy, distribute
and/or modify the software.
  A secondary benefit of defending all users' freedom is that
improvements made in alternate versions of the program, if they
receive widespread use, become available for other developers to
incorporate.  Many developers of free software are heartened and
encouraged by the resulting cooperation.  However, in the case of
software used on network servers, this result may fail to come about.
The GNU General Public License permits making a modified version and
letting the public access it on a server without ever releasing its
source code to the public.
  The GNU Affero General Public License is designed specifically to
ensure that, in such cases, the modified source code becomes available
to the community.  It requires the operator of a network server to
provide the source code of the modified version running there to the
users of that server.  Therefore, public use of a modified version, on
a publicly accessible server, gives the public access to the source
code of the modified version.
  An older license, called the Affero General Public License and
published by Affero, was designed to accomplish similar goals.  This is
a different license, not a version of the Affero GPL, but Affero has
released a new version of the Affero GPL which permits relicensing under
this license.
  The precise terms and conditions for copying, distribution and
modification follow.
                       TERMS AND CONDITIONS
  0. Definitions.
  "This License" refers to version 3 of the GNU Affero General Public License.
  "Copyright" also means copyright-like laws that apply to other kinds of
works, such as semiconductor masks.
  "The Program" refers to any copyrightable work licensed under this
License.  Each licensee is addressed as "you".  "Licensees" and
"recipients" may be individuals or organizations.
  To "modify" a work means to copy from or adapt all or part of the work
in a fashion requiring copyright permission, other than the making of an
exact copy.  The resulting work is called a "modified version" of the
earlier work or a work "based on" the earlier work.
  A "covered work" means either the unmodified Program or a work based
on the Program.
  To "propagate" a work means to do anything with it that, without
permission, would make you directly or secondarily liable for
infringement under applicable copyright law, except executing it on a
computer or modifying a private copy.  Propagation includes copying,
distribution (with or without modification), making available to the
public, and in some countries other activities as well.
  To "convey" a work means any kind of propagation that enables other
parties to make or receive copies.  Mere interaction with a user through
a computer network, with no transfer of a copy, is not conveying.
  An interactive user interface displays "Appropriate Legal Notices"
to the extent that it includes a convenient and prominently visible
feature that (1) displays an appropriate copyright notice, and (2)
tells the user that there is no warranty for the work (except to the
extent that warranties are provided), that licensees may convey the
work under this License, and how to view a copy of this License.  If
the interface presents a list of user commands or options, such as a
menu, a prominent item in the list meets this criterion.
  1. Source Code.
  The "source code" for a work means the preferred form of the work
for making modifications to it.  "Object code" means any non-source
form of a work.
  A "Standard Interface" means an interface that either is an official
standard defined by a recognized standards body, or, in the case of
interfaces specified for a particular programming language, one that
is widely used among developers working in that language.
  The "System Libraries" of an executable work include anything, other
than the work as a whole, that (a) is included in the normal form of
packaging a Major Component, but which is not part of that Major
Component, and (b) serves only to enable use of the work with that
Major Component, or to implement a Standard Interface for which an
implementation is available to the public in source code form.  A
"Major Component", in this context, means a major essential component
(kernel, window system, and so on) of the specific operating system
(if any) on which the executable work runs, or a compiler used to
produce the work, or an object code interpreter used to run it.
  The "Corresponding Source" for a work in object code form means all
the source code needed to generate, install, and (for an executable
work) run the object code and to modify the work, including scripts to
control those activities.  However, it does not include the work's
System Libraries, or general-purpose tools or generally available free
programs which are used unmodified in performing those activities but
which are not part of the work.  For example, Corresponding Source
includes interface definition files associated with source files for
the work, and the source code for shared libraries and dynamically
linked subprograms that the work is specifically designed to require,
such as by intimate data communication or control flow between those
subprograms and other parts of the work.
  The Corresponding Source need not include anything that users
can regenerate automatically from other parts of the Corresponding
Source.
  The Corresponding Source for a work in source code form is that
same work.
  2. Basic Permissions.
  All rights granted under this License are granted for the term of
copyright on the Program, and are irrevocable provided the stated
conditions are met.  This License explicitly affirms your unlimited
permission to run the unmodified Program.  The output from running a
covered work is covered by this License only if the output, given its
content, constitutes a covered work.  This License acknowledges your
rights of fair use or other equivalent, as provided by copyright law.
  You may make, run and propagate covered works that you do not
convey, without conditions so long as your license otherwise remains
in force.  You may convey covered works to others for the sole purpose
of having them make modifications exclusively for you, or provide you
with facilities for running those works, provided that you comply with
the terms of this License in conveying all material for which you do
not control copyright.  Those thus making or running the covered works
for you must do so exclusively on your behalf, under your direction
and control, on terms that prohibit them from making any copies of
your copyrighted material outside their relationship with you.
  Conveying under any other circumstances is permitted solely under
the conditions stated below.  Sublicensing is not allowed; section 10
makes it unnecessary.
  3. Protecting Users' Legal Rights From Anti-Circumvention Law.
  No covered work shall be deemed part of an effective technological
measure under any applicable law fulfilling obligations under article
11 of the WIPO copyright treaty adopted on 20 December 1996, or
similar laws prohibiting or restricting circumvention of such
measures.
  When you convey a covered work, you waive any legal power to forbid
circumvention of technological measures to the extent such circumvention
is effected by exercising rights under this License with respect to
the covered work, and you disclaim any intention to limit operation or
modification of the work as a means of enforcing, against the work's
users, your or third parties' legal rights to forbid circumvention of
technological measures.
  4. Conveying Verbatim Copies.
  You may convey verbatim copies of the Program's source code as you
receive it, in any medium, provided that you conspicuously and
appropriately publish on each copy an appropriate copyright notice;
keep intact all notices stating that this License and any
non-permissive terms added in accord with section 7 apply to the code;
keep intact all notices of the absence of any warranty; and give all
recipients a copy of this License along with the Program.
  You may charge any price or no price for each copy that you convey,
and you may offer support or warranty protection for a fee.
  5. Conveying Modified Source Versions.
  You may convey a work based on the Program, or the modifications to
produce it from the Program, in the form of source code under the
terms of section 4, provided that you also meet all of these conditions:
    a) The work must carry prominent notices stating that you modified
    it, and giving a relevant date.
    b) The work must carry prominent notices stating that it is
    released under this License and any conditions added under section
    7.  This requirement modifies the requirement in section 4 to
    "keep intact all notices".
    c) You must license the entire work, as a whole, under this
    License to anyone who comes into possession of a copy.  This
    License will therefore apply, along with any applicable section 7
    additional terms, to the whole of the work, and all its parts,
    regardless of how they are packaged.  This License gives no
    permission to license the work in any other way, but it does not
    invalidate such permission if you have separately received it.
    d) If the work has interactive user interfaces, each must display
    Appropriate Legal Notices; however, if the Program has interactive
    interfaces that do not display Appropriate Legal Notices, your
    work need not make them do so.
  A compilation of a covered work with other separate and independent
works, which are not by their nature extensions of the covered work,
and which are not combined with it such as to form a larger program,
in or on a volume of a storage or distribution medium, is called an
"aggregate" if the compilation and its resulting copyright are not
used to limit the access or legal rights of the compilation's users
beyond what the individual works permit.  Inclusion of a covered work
in an aggregate does not cause this License to apply to the other
parts of the aggregate.
  6. Conveying Non-Source Forms.
  You may convey a covered work in object code form under the terms
of sections 4 and 5, provided that you also convey the
machine-readable Corresponding Source under the terms of this License,
in one of these ways:
    a) Convey the object code in, or embodied in, a physical product
    (including a physical distribution medium), accompanied by the
    Corresponding Source fixed on a durable physical medium
    customarily used for software interchange.
    b) Convey the object code in, or embodied in, a physical product
    (including a physical distribution medium), accompanied by a
    written offer, valid for at least three years and valid for as
    long as you offer spare parts or customer support for that product
    model, to give anyone who possesses the object code either (1) a
    copy of the Corresponding Source for all the software in the
    product that is covered by this License, on a durable physical
    medium customarily used for software interchange, for a price no
    more than your reasonable cost of physically performing this
    conveying of source, or (2) access to copy the
    Corresponding Source from a network server at no charge.
    c) Convey individual copies of the object code with a copy of the
    written offer to provide the Corresponding Source.  This
    alternative is allowed only occasionally and noncommercially, and
    only if you received the object code with such an offer, in accord
    with subsection 6b.
    d) Convey the object code by offering access from a designated
    place (gratis or for a charge), and offer equivalent access to the
    Corresponding Source in the same way through the same place at no
    further charge.  You need not require recipients to copy the
    Corresponding Source along with the object code.  If the place to
    copy the object code is a network server, the Corresponding Source
    may be on a different server (operated by you or a third party)
    that supports equivalent copying facilities, provided you maintain
    clear directions next to the object code saying where to find the
    Corresponding Source.  Regardless of what server hosts the
    Corresponding Source, you remain obligated to ensure that it is
    available for as long as needed to satisfy these requirements.
    e) Convey the object code using peer-to-peer transmission, provided
    you inform other peers where the object code and Corresponding
    Source of the work are being offered to the general public at no
    charge under subsection 6d.
  A separable portion of the object code, whose source code is excluded
from the Corresponding Source as a System Library, need not be
included in conveying the object code work.
  A "User Product" is either (1) a "consumer product", which means any
tangible personal property which is normally used for personal, family,
or household purposes, or (2) anything designed or sold for incorporation
into a dwelling.  In determining whether a product is a consumer product,
doubtful cases shall be resolved in favor of coverage.  For a particular
product received by a particular user, "normally used" refers to a
typical or common use of that class of product, regardless of the status
of the particular user or of the way in which the particular user
actually uses, or expects or is expected to use, the product.  A product
is a consumer product regardless of whether the product has substantial
commercial, industrial or non-consumer uses, unless such uses represent
the only significant mode of use of the product.
  "Installation Information" for a User Product means any methods,
procedures, authorization keys, or other information required to install
and execute modified versions of a covered work in that User Product from
a modified version of its Corresponding Source.  The information must
suffice to ensure that the continued functioning of the modified object
code is in no case prevented or interfered with solely because
modification has been made.
  If you convey an object code work under this section in, or with, or
specifically for use in, a User Product, and the conveying occurs as
part of a transaction in which the right of possession and use of the
User Product is transferred to the recipient in perpetuity or for a
fixed term (regardless of how the transaction is characterized), the
Corresponding Source conveyed under this section must be accompanied
by the Installation Information.  But this requirement does not apply
if neither you nor any third party retains the ability to install
modified object code on the User Product (for example, the work has
been installed in ROM).
  The requirement to provide Installation Information does not include a
requirement to continue to provide support service, warranty, or updates
for a work that has been modified or installed by the recipient, or for
the User Product in which it has been modified or installed.  Access to a
network may be denied when the modification itself materially and
adversely affects the operation of the network or violates the rules and
protocols for communication across the network.
  Corresponding Source conveyed, and Installation Information provided,
in accord with this section must be in a format that is publicly
documented (and with an implementation available to the public in
source code form), and must require no special password or key for
unpacking, reading or copying.
  7. Additional Terms.
  "Additional permissions" are terms that supplement the terms of this
License by making exceptions from one or more of its conditions.
Additional permissions that are applicable to the entire Program shall
be treated as though they were included in this License, to the extent
that they are valid under applicable law.  If additional permissions
apply only to part of the Program, that part may be used separately
under those permissions, but the entire Program remains governed by
this License without regard to the additional permissions.
  When you convey a copy of a covered work, you may at your option
remove any additional permissions from that copy, or from any part of
it.  (Additional permissions may be written to require their own
removal in certain cases when you modify the work.)  You may place
additional permissions on material, added by you to a covered work,
for which you have or can give appropriate copyright permission.
  Notwithstanding any other provision of this License, for material you
add to a covered work, you may (if authorized by the copyright holders of
that material) supplement the terms of this License with terms:
    a) Disclaiming warranty or limiting liability differently from the
    terms of sections 15 and 16 of this License; or
    b) Requiring preservation of specified reasonable legal notices or
    author attributions in that material or in the Appropriate Legal
    Notices displayed by works containing it; or
    c) Prohibiting misrepresentation of the origin of that material, or
    requiring that modified versions of such material be marked in
    reasonable ways as different from the original version; or
    d) Limiting the use for publicity purposes of names of licensors or
    authors of the material; or
    e) Declining to grant rights under trademark law for use of some
    trade names, trademarks, or service marks; or
    f) Requiring indemnification of licensors and authors of that
    material by anyone who conveys the material (or modified versions of
    it) with contractual assumptions of liability to the recipient, for
    any liability that these contractual assumptions directly impose on
    those licensors and authors.
  All other non-permissive additional terms are considered "further
restrictions" within the meaning of section 10.  If the Program as you
received it, or any part of it, contains a notice stating that it is
governed by this License along with a term that is a further
restriction, you may remove that term.  If a license document contains
a further restriction but permits relicensing or conveying under this
License, you may add to a covered work material governed by the terms
of that license document, provided that the further restriction does
not survive such relicensing or conveying.
  If you add terms to a covered work in accord with this section, you
must place, in the relevant source files, a statement of the
additional terms that apply to those files, or a notice indicating
where to find the applicable terms.
  Additional terms, permissive or non-permissive, may be stated in the
form of a separately written license, or stated as exceptions;
the above requirements apply either way.
  8. Termination.
  You may not propagate or modify a covered work except as expressly
provided under this License.  Any attempt otherwise to propagate or
modify it is void, and will automatically terminate your rights under
this License (including any patent licenses granted under the third
paragraph of section 11).
  However, if you cease all violation of this License, then your
license from a particular copyright holder is reinstated (a)
provisionally, unless and until the copyright holder explicitly and
finally terminates your license, and (b) permanently, if the copyright
holder fails to notify you of the violation by some reasonable means
prior to 60 days after the cessation.
  Moreover, your license from a particular copyright holder is
reinstated permanently if the copyright holder notifies you of the
violation by some reasonable means, this is the first time you have
received notice of violation of this License (for any work) from that
copyright holder, and you cure the violation prior to 30 days after
your receipt of the notice.
  Termination of your rights under this section does not terminate the
licenses of parties who have received copies or rights from you under
this License.  If your rights have been terminated and not permanently
reinstated, you do not qualify to receive new licenses for the same
material under section 10.
  9. Acceptance Not Required for Having Copies.
  You are not required to accept this License in order to receive or
run a copy of the Program.  Ancillary propagation of a covered work
occurring solely as a consequence of using peer-to-peer transmission
to receive a copy likewise does not require acceptance.  However,
nothing other than this License grants you permission to propagate or
modify any covered work.  These actions infringe copyright if you do
not accept this License.  Therefore, by modifying or propagating a
covered work, you indicate your acceptance of this License to do so.
  10. Automatic Licensing of Downstream Recipients.
  Each time you convey a covered work, the recipient automatically
receives a license from the original licensors, to run, modify and
propagate that work, subject to this License.  You are not responsible
for enforcing compliance by third parties with this License.
  An "entity transaction" is a transaction transferring control of an
organization, or substantially all assets of one, or subdividing an
organization, or merging organizations.  If propagation of a covered
work results from an entity transaction, each party to that
transaction who receives a copy of the work also receives whatever
licenses to the work the party's predecessor in interest had or could
give under the previous paragraph, plus a right to possession of the
Corresponding Source of the work from the predecessor in interest, if
the predecessor has it or can get it with reasonable efforts.
  You may not impose any further restrictions on the exercise of the
rights granted or affirmed under this License.  For example, you may
not impose a license fee, royalty, or other charge for exercise of
rights granted under this License, and you may not initiate litigation
(including a cross-claim or counterclaim in a lawsuit) alleging that
any patent claim is infringed by making, using, selling, offering for
sale, or importing the Program or any portion of it.
  11. Patents.
  A "contributor" is a copyright holder who authorizes use under this
License of the Program or a work on which the Program is based.  The
work thus licensed is called the contributor's "contributor version".
  A contributor's "essential patent claims" are all patent claims
owned or controlled by the contributor, whether already acquired or
hereafter acquired, that would be infringed by some manner, permitted
by this License, of making, using, or selling its contributor version,
but do not include claims that would be infringed only as a
consequence of further modification of the contributor version.  For
purposes of this definition, "control" includes the right to grant
patent sublicenses in a manner consistent with the requirements of
this License.
  Each contributor grants you a non-exclusive, worldwide, royalty-free
patent license under the contributor's essential patent claims, to
make, use, sell, offer for sale, import and otherwise run, modify and
propagate the contents of its contributor version.
  In the following three paragraphs, a "patent license" is any express
agreement or commitment, however denominated, not to enforce a patent
(such as an express permission to practice a patent or covenant not to
sue for patent infringement).  To "grant" such a patent license to a
party means to make such an agreement or commitment not to enforce a
patent against the party.
  If you convey a covered work, knowingly relying on a patent license,
and the Corresponding Source of the work is not available for anyone
to copy, free of charge and under the terms of this License, through a
publicly available network server or other readily accessible means,
then you must either (1) cause the Corresponding Source to be so
available, or (2) arrange to deprive yourself of the benefit of the
patent license for this particular work, or (3) arrange, in a manner
consistent with the requirements of this License, to extend the patent
license to downstream recipients.  "Knowingly relying" means you have
actual knowledge that, but for the patent license, your conveying the
covered work in a country, or your recipient's use of the covered work
in a country, would infringe one or more identifiable patents in that
country that you have reason to believe are valid.
  If, pursuant to or in connection with a single transaction or
arrangement, you convey, or propagate by procuring conveyance of, a
covered work, and grant a patent license to some of the parties
receiving the covered work authorizing them to use, propagate, modify
or convey a specific copy of the covered work, then the patent license
you grant is automatically extended to all recipients of the covered
work and works based on it.
  A patent license is "discriminatory" if it does not include within
the scope of its coverage, prohibits the exercise of, or is
conditioned on the non-exercise of one or more of the rights that are
specifically granted under this License.  You may not convey a covered
work if you are a party to an arrangement with a third party that is
in the business of distributing software, under which you make payment
to the third party based on the extent of your activity of conveying
the work, and under which the third party grants, to any of the
parties who would receive the covered work from you, a discriminatory
patent license (a) in connection with copies of the covered work
conveyed by you (or copies made from those copies), or (b) primarily
for and in connection with specific products or compilations that
contain the covered work, unless you entered into that arrangement,
or that patent license was granted, prior to 28 March 2007.
  Nothing in this License shall be construed as excluding or limiting
any implied license or other defenses to infringement that may
otherwise be available to you under applicable patent law.
  12. No Surrender of Others' Freedom.
  If conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot convey a
covered work so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you may
not convey it at all.  For example, if you agree to terms that obligate you
to collect a royalty for further conveying from those to whom you convey
the Program, the only way you could satisfy both those terms and this
License would be to refrain entirely from conveying the Program.
  13. Remote Network Interaction; Use with the GNU General Public License.
  Notwithstanding any other provision of this License, if you modify the
Program, your modified version must prominently offer all users
interacting with it remotely through a computer network (if your version
supports such interaction) an opportunity to receive the Corresponding
Source of your version by providing access to the Corresponding Source
from a network server at no charge, through some standard or customary
means of facilitating copying of software.  This Corresponding Source
shall include the Corresponding Source for any work covered by version 3
of the GNU General Public License that is incorporated pursuant to the
following paragraph.
  Notwithstanding any other provision of this License, you have
permission to link or combine any covered work with a work licensed
under version 3 of the GNU General Public License into a single
combined work, and to convey the resulting work.  The terms of this
License will continue to apply to the part which is the covered work,
but the work with which it is combined will remain governed by version
3 of the GNU General Public License.
  14. Revised Versions of this License.
  The Free Software Foundation may publish revised and/or new versions of
the GNU Affero General Public License from time to time.  Such new versions
will be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.
  Each version is given a distinguishing version number.  If the
Program specifies that a certain numbered version of the GNU Affero General
Public License "or any later version" applies to it, you have the
option of following the terms and conditions either of that numbered
version or of any later version published by the Free Software
Foundation.  If the Program does not specify a version number of the
GNU Affero General Public License, you may choose any version ever published
by the Free Software Foundation.
  If the Program specifies that a proxy can decide which future
versions of the GNU Affero General Public License can be used, that proxy's
public statement of acceptance of a version permanently authorizes you
to choose that version for the Program.
  Later license versions may give you additional or different
permissions.  However, no additional obligations are imposed on any
author or copyright holder as a result of your choosing to follow a
later version.
  15. Disclaimer of Warranty.
  THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY
OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
  16. Limitation of Liability.
  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS
THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD
PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),
EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
  17. Interpretation of Sections 15 and 16.
  If the disclaimer of warranty and limitation of liability provided
above cannot be given local legal effect according to their terms,
reviewing courts shall apply local law that most closely approximates
an absolute waiver of all civil liability in connection with the
Program, unless a warranty or assumption of liability accompanies a
copy of the Program in return for a fee.
                     END OF TERMS AND CONDITIONS
            How to Apply These Terms to Your New Programs
  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.
  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
state the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.
    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
Also add information on how to contact you by electronic and paper mail.
  If your software can interact with users remotely through a computer
network, you should also make sure that it provides a way for users to
get its source.  For example, if your program is a web application, its
interface could display a "Source" link that leads users to an archive
of the code.  There are many ways you could offer source, and different
solutions will be better for different programs; see section 13 for the
specific requirements.
  You should also get your employer (if you work as a programmer) or school,
if any, to sign a "copyright disclaimer" for the program, if necessary.
For more information on this, and how to apply and follow the GNU AGPL, see
<https://www.gnu.org/licenses/>.

```

## Joplin Server license

This license applies only to **Joplin Server** -- the files in the `packages/server` directory.

```
**JOPLIN SERVER PERSONAL USE LICENSE**

v.1: 21 December 2021

This Joplin Server Personal Use License (the "**License**") is a legally binding
agreement between JOPLIN registered under the laws of France (the
"**Licensor**"), the owner of the server entitled "Joplin Server", the related
software applications, and services  (collectively, the "**Software**") and an
individual user accessing the Software (the "**Licensee**")  (each individually
a "**Party**" and collectively, the "**Parties**").

# 1. Acceptance of the License

* **1.1**  By accessing or otherwise using the Software, the Licensee confirms
  that the Licensee has read the License, accepts the terms of the License, and
  agrees to become legally bound by the License.

* **1.2** If the Licensee is entering into the License on behalf of a legal
  entity, the Licensee represents that the Licensee has the authority and the
  necessary capacity to bind such entity and its affiliates to the terms of the
  License.

* **1.3**  If the Licensee does not have the authority specified in section 1.2
  or if the Licensee does not agree with one or more provisions of the License,
  the Licensee is not allowed to access the Software and the Licensee must not
  accept the License.

* **1.4** By using the Software, the Licensee acknowledges, agrees, and warrants
  that the Licensee:

    * i. Shall comply with the terms of the License and all applicable local,
      state, national and foreign laws, treaties, and regulations;

    * ii. Shall provide only true, accurate, complete, and up-to-date
      information; and

    * iii. Has the capacity to conclude legally binding contracts with the
      Licensor.

# 2. Grant of RIGHTS

* **2.1**  The Licensor hereby grants the Licensee a worldwide, non-exclusive,
  royalty free, and revocable license to access and use the Software in
  accordance with the terms of this License and the applicable laws.

* **2.2** Subject to the terms of the License, the Licensee is entitled to
  access and use the Software for non-commercial purposes for taking personal
  and professional notes, sharing notes with other users of the Software, and
  synchronising data.

* **2.3** Unless authorised by the Licensor in writing, the Software may be used
  for personal non-commercial purposes only. The Licensee is allowed to grant
  access to the Software to others for non-commercial purposes, provided that
  (i) the Licensee is not a business entity, (ii) the Licensee or the third
  party to which the access is granted does not use the Software to generate
  profits of any kind, and (iii) the Software is used for non-commercial
  purposes only. The Licensee is not allowed to: (i) use the Software for
  commercial purposes and (ii) grant others the right to use the Software for a
  fee or for any commercial purposes, including, without limitation, copying,
  reproducing, publishing, transmitting, transferring, selling, renting,
  modifying, creating derivative works from, distributing, reposting,
  performing, displaying, or in any other way commercially exploiting the
  Software without prior written authorisation from the Licensor. By way of
  illustration, the Licensee is not allowed to:

    1.  Install the Software on Licensee's infrastructure and charge others for
        the use of the Software;

    2.  Install the Software behind a proxy and charge others for the use of the
        Software;

    3.  Install the Software on a Licensee's or third party's server and provide
        access to the Software to third parties (a) for a fee or (b) free of
        charge, if the said third parties may use the Software for commercial
        purposes;

    4.  Grant access to the Software to others for a fee or for any commercial
        purposes;

    5.  Grant access to the Software to others for a fee or free of charge if
        the Licensee is a legal or natural person engaged in commercial
        activities; or

    6.  Use the Software or grant other the right to use the Software in a way
        that generates income or commercial profits.

* **2.4** This License does not govern any commercial use of the Software, as
  authorised by the Licensor.

* **2.5**  The Software is licensed and not sold. By accepting the License, the
  Licensee obtains the right to use the Software and not the ownership of the
  Software.

* **2.6**  The Licensor reserves any rights not expressly granted to the
  Licensee under this License.

* **2.7** The Licensee is allowed to make a reasonable number of copies of the
  Software, as and if necessary for the purposes set forth herein, provided that
  only complete copies of the Software are made, including without limitation
  all "read me" files, copyright notices, and other legal notices and terms
  included in the Software.

* **2.8**  The Licensee is permitted to load and run the Software on any device,
  network or cloud virtual machines under Licensee's control (collectively, the
  "**Devices**"), if such Devices are compatible with the Software. The Licensee
  is solely responsible for assessing the compatibility of the Devices to be
  used with the Software.

* **2.9**  It is Licensee's sole responsibility to verify and assess the
  suitability, validity and integrity of the Software prior to using it and to
  decide whether or not the Software fits for the intended use.

* **2.10**  The Licensor reserves the right to grant the right to use the
  Software to third parties.

* **2.11** The Licensee acknowledges and agrees that any use of the Software
  that is prohibited by this License may be unlawful and may result in
  Licensee's criminal liability.

# 3. Covered Software and services

* **3.1**  The License applies only to the Software as provided to the Licensee
  by the Licensor. The License also applies to updates, supplements, and support
  services related to the Software, or any other services provided in relation
  to the Software, unless other terms and conditions have been provided thereto.

* **3.2**  Any software or services that are not provided by the Licensor are
  not covered by this License. Such Software and services are subject to the
  terms and conditions set by the respective third party and the Licensee is
  solely responsible for obtaining, agreeing to, and complying with the
  respective terms and conditions at its own cost and expense.

* **3.3**  The Licensor reserves the right, but is not under any obligation, to
  provide paid or free-of-charge updates and technical support services with
  regard to the Software, including fixing bugs and errors, and the possibility
  to use new versions of the Software.

# 4. Intellectual property and ownership

* **4.1**  All title and copyright in and to the Software (including, but not
  limited to, any source code, images, graphics, photographs, animations, video,
  audio, music, text, and applets, incorporated in the Software) are owned by
  the Licensor. The Software is protected by the English copyright laws and
  international treaties. The Licensee is not allowed to incorporate any portion
  of the Software into other programs or compile any portion of it in
  combination with other programs, or otherwise copy (except to exercise rights
  granted in this License), modify, create derivative works of, distribute,
  assign any rights to, or license the Software in whole or in part.

* **4.2**  The Licensee is not permitted to, without obtaining prior written
  authorisation from the Licensor, to use the trade names, trademarks, service
  marks or product names of the Licensor, except as required for the use of the
  Software.

* **4.3**  The Licensor has made all efforts possible to avoid the Software
  being subject to the rights of third parties, in particular that its use does
  not infringe patents, copyrights or other intellectual property rights of
  third parties. However, the Licensor does not guarantee that the Software is
  not subject to the rights of third parties. The Licensee agrees to notify the
  Licensor immediately and in writing if any third party asserts an infringement
  claim against the Licensee in connection with the Software.

* **4.4**  By submitting any content through the Software (the "Licensee's
  Content"), the Licensee grants  the Licensor unrestricted, sub-licensable,
  royalty-free, perpetual, and irrevocable rights to process the Licensee's
  Content for the purposes of providing the Licensee with the Software and
  carrying out Licensor's legitimate business interests.

* **4.5** The Licensee is not permitted to remove any copyright or other
  proprietary notices and legends.

# 5. PRIVACY AND DATA PROTECTION

* **5.1** The Licensor does not have access in any manner to the Licensee's
  Content. Therefore, the Licensee is solely responsible for creating, keeping
  and maintaining any backup copies of any Licensee's Content or other
  information submitted to, through, or in relation to the Software.

The Parties agree to individually comply with the applicable data protection
laws pertaining to the Software.

# 6. AVAILABILITY

* **6.1**  The availability of the Software may be affected by factors, which
  the Licensor cannot reasonably control, such as bandwidth problems, equipment
  failure, acts and omissions of our third-party service providers, or *force
  majeure* events. The Licensor takes no responsibility for the unavailability
  of the Software caused by such factors.

# 7. Limitation of liability and disclaimer of warranties

* **7.1**  To the extent permitted by the applicable law, the Licensor expressly
  disclaims all warranties, express or implied, for the Software. The Licensor
  provides the Software on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
  ANY KIND, either express or implied, including, without limitation, any
  warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or
  FITNESS FOR A PARTICULAR PURPOSE. The entire risk arising out of use or
  performance of the Software remains with the Licensee.

* **7.2**  In no event shall the Licensor be liable for any damages whatsoever
  (including, without limitation, damages for loss of business profits, business
  interruption, loss of business information, or any other pecuniary loss)
  arising out of the Licensee's Content, the use of or inability to use the
  Software, even if the Licensor has been advised of the possibility of such
  damages.

* **7.3**  The Licensee is solely responsible for determining the
  appropriateness of the Software and assumes any risks associated with
  Licensee's exercise of permissions under the License.

* **7.4**  Third-party content or services are not covered by this License. The
  Licensee shall ensure Licensee's compliance with any terms set forth by the
  respective third parties at its own risk, cost and expense.  To the maximum
  extent permitted by law, the Licensor excludes any liability for any loss or
  damage resulting from the acts and omissions of such third-party service
  providers.

# 8. Governing Law AND DISPUTE RESOLUTION

* 8.1  This License and any disputes arising out of or in connection with the
  License and the Software shall be governed by and construed in accordance with
  the laws of France. Unless otherwise provided by the applicable law, all
  disputes arising out of or in connection with the License shall be submitted
  to the exclusive jurisdiction of the courts in London, the United Kingdom.

# 9. FINAL PROVISIONS

* **9.1**  **Indemnification.** The Licensee shall indemnify the Licensor at
  Licensee's expense if any claims are asserted by a third party against the
  Licensor by reason of Licensee's misconduct or breach of any terms of the
  License, including failed adherence by the Licensee with any applicable laws,
  including, whether express or implied.

* **9.2**  **Severability.** The unenforceability of any single provision of
  this License shall not affect any other provision hereof. Where such a
  provision is held to be unenforceable, the Parties shall use their best
  endeavours to negotiate and agree upon an enforceable provision, which
  achieves, to the greatest extent possible, the economic, legal and commercial
  objectives of the unenforceable provision.

* **9.3**  **Waiver.** A failure of either Party to enforce strictly a provision
  of this License shall in no event be considered a waiver of any part of such
  provision. No waiver by either Party of any breach or default by the other
  party shall operate as a waiver of any succeeding breach or other default or
  breach by such other Party. No waiver shall have any effect unless it is
  specific, irrevocable and in writing.

* **9.4**  **Term and termination.** The License shall commence upon Licensee's
  access to the Software and continue until terminated by the Licensor. Upon
  termination of the License, the Licensee agrees to (i) stop all access and use
  of the Software and (ii) destroy all copies of the Software and all its
  component parts (if any) stored on the Devices. The provisions of the License
  that, by their nature, continue and survive will survive any termination of
  the License.

* **9.5**  **Amendments.** The Licensor reserves the right, at its sole
  discretion, to change or modify this License at any time by sending a prior
  notification to the Licensee (if the contact details of the Licensee are
  available to the Licensor).  Any modifications to the License shall become
  effective on the date indicated at the top of the amended License.  By
  continuing to use the Software after the date on which the modifications were
  communicated, the Licensee agrees to be bound by the modified License.  The
  Licensor reserves the right to change or discontinue the Software and any
  feature thereof with or without a prior notice to the Licensee.

* **9.6**  **Entire agreement.**  This License constitutes the entire
  understanding between the Parties with respect to the subject matter thereof
  and supersedes all prior agreements, negotiations and discussions between the
  Parties relating thereto.

* **9.7**  **Transfer of rights.** The Licensee is not allowed to assign
  Licensee's rights under the License. The Licensor is entitled to transfer its
  rights and obligations under the License entirely or partially to a third
  party by giving a prior notice to the Licensee. If the Licensee does not agree
  to the transfer, the Licensee can terminate this License by ceasing to use the
  Software.

* **9.8**  **Contact.** For general enquiries and commercial licenses to use the
  Software, please contact the Licensor directly.

***

```



## Production dependencies



Dependencies in this section are listed as "Production" dependencies in one of the `package.json` files of a Joplin package, or a dependency of a Joplin package.

### @0no-co/graphql.web@1.0.8, @0no-co/graphql.web@1.1.2

From https://github.com/0no-co/graphql.web.

**MIT**:

Copyright: Copyright (c) 0no.co

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @adobe/css-tools@4.4.3

From https://github.com/adobe/css-tools.

**MIT**:

Copyright: Copyright (c) 2022 Jean-Philippe Zolesio <holblin@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @ampproject/remapping@2.2.1

From https://github.com/ampproject/remapping.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### @asamuzakjp/css-color@3.2.0

From https://github.com/asamuzaK/cssColor.

**MIT**:

```
MIT License

Copyright (c) 2024 asamuzaK (Kazz)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### @aws-crypto/crc32@3.0.0, @aws-crypto/crc32c@3.0.0, @aws-crypto/ie11-detection@3.0.0, @aws-crypto/sha1-browser@3.0.0, @aws-crypto/sha256-browser@3.0.0, @aws-crypto/sha256-js@3.0.0, @aws-crypto/supports-web-crypto@3.0.0, @aws-crypto/util@3.0.0

From https://github.com/aws/aws-sdk-js-crypto-helpers.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "{}"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright {yyyy} {name of copyright owner}

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

**NOTICE**:

```
AWS SDK JS Crypto Helpers
Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved. 

```

### @aws-sdk/abort-controller@3.296.0, @aws-sdk/chunked-blob-reader-native@3.295.0, @aws-sdk/chunked-blob-reader@3.295.0, @aws-sdk/client-s3@3.296.0, @aws-sdk/client-sso-oidc@3.296.0, @aws-sdk/client-sso@3.296.0, @aws-sdk/client-sts@3.296.0, @aws-sdk/config-resolver@3.296.0, @aws-sdk/credential-provider-env@3.296.0, @aws-sdk/credential-provider-imds@3.296.0, @aws-sdk/credential-provider-ini@3.296.0, @aws-sdk/credential-provider-node@3.296.0, @aws-sdk/credential-provider-process@3.296.0, @aws-sdk/credential-provider-sso@3.296.0, @aws-sdk/credential-provider-web-identity@3.296.0, @aws-sdk/eventstream-codec@3.296.0, @aws-sdk/eventstream-serde-browser@3.296.0, @aws-sdk/eventstream-serde-config-resolver@3.296.0, @aws-sdk/eventstream-serde-node@3.296.0, @aws-sdk/eventstream-serde-universal@3.296.0, @aws-sdk/fetch-http-handler@3.296.0, @aws-sdk/hash-blob-browser@3.296.0, @aws-sdk/hash-node@3.296.0, @aws-sdk/hash-stream-node@3.296.0, @aws-sdk/invalid-dependency@3.296.0, @aws-sdk/is-array-buffer@3.295.0, @aws-sdk/md5-js@3.296.0, @aws-sdk/middleware-bucket-endpoint@3.296.0, @aws-sdk/middleware-content-length@3.296.0, @aws-sdk/middleware-endpoint@3.296.0, @aws-sdk/middleware-expect-continue@3.296.0, @aws-sdk/middleware-flexible-checksums@3.296.0, @aws-sdk/middleware-host-header@3.296.0, @aws-sdk/middleware-location-constraint@3.296.0, @aws-sdk/middleware-logger@3.296.0, @aws-sdk/middleware-recursion-detection@3.296.0, @aws-sdk/middleware-retry@3.296.0, @aws-sdk/middleware-sdk-s3@3.296.0, @aws-sdk/middleware-sdk-sts@3.296.0, @aws-sdk/middleware-serde@3.296.0, @aws-sdk/middleware-signing@3.296.0, @aws-sdk/middleware-ssec@3.296.0, @aws-sdk/middleware-stack@3.296.0, @aws-sdk/middleware-user-agent@3.296.0, @aws-sdk/node-config-provider@3.296.0, @aws-sdk/node-http-handler@3.296.0, @aws-sdk/property-provider@3.296.0, @aws-sdk/protocol-http@3.296.0, @aws-sdk/querystring-builder@3.296.0, @aws-sdk/querystring-parser@3.296.0, @aws-sdk/s3-request-presigner@3.296.0, @aws-sdk/service-error-classification@3.296.0, @aws-sdk/shared-ini-file-loader@3.296.0, @aws-sdk/signature-v4-multi-region@3.296.0, @aws-sdk/signature-v4@3.296.0, @aws-sdk/smithy-client@3.296.0, @aws-sdk/token-providers@3.296.0, @aws-sdk/types@3.296.0, @aws-sdk/types@3.310.0, @aws-sdk/url-parser@3.296.0, @aws-sdk/util-arn-parser@3.295.0, @aws-sdk/util-base64@3.295.0, @aws-sdk/util-body-length-browser@3.295.0, @aws-sdk/util-body-length-node@3.295.0, @aws-sdk/util-buffer-from@3.295.0, @aws-sdk/util-config-provider@3.295.0, @aws-sdk/util-create-request@3.296.0, @aws-sdk/util-defaults-mode-browser@3.296.0, @aws-sdk/util-defaults-mode-node@3.296.0, @aws-sdk/util-endpoints@3.296.0, @aws-sdk/util-format-url@3.296.0, @aws-sdk/util-hex-encoding@3.295.0, @aws-sdk/util-locate-window@3.37.0, @aws-sdk/util-middleware@3.296.0, @aws-sdk/util-retry@3.296.0, @aws-sdk/util-stream-browser@3.296.0, @aws-sdk/util-stream-node@3.296.0, @aws-sdk/util-uri-escape@3.295.0, @aws-sdk/util-user-agent-browser@3.296.0, @aws-sdk/util-user-agent-node@3.296.0, @aws-sdk/util-utf8-browser@3.37.0, @aws-sdk/util-utf8@3.295.0, @aws-sdk/util-waiter@3.296.0, @aws-sdk/xml-builder@3.295.0

From https://github.com/aws/aws-sdk-js-v3.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "{}"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright 2018-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
```

### @babel/code-frame@7.10.4, @babel/code-frame@7.22.5, @babel/code-frame@7.24.7, @babel/code-frame@7.26.2, @babel/compat-data@7.22.5, @babel/compat-data@7.23.2, @babel/compat-data@7.24.7, @babel/compat-data@7.26.8, @babel/core@7.22.5, @babel/core@7.26.0, @babel/core@7.26.10, @babel/generator@7.22.5, @babel/generator@7.24.7, @babel/generator@7.25.6, @babel/generator@7.27.0, @babel/helper-annotate-as-pure@7.22.5, @babel/helper-annotate-as-pure@7.24.7, @babel/helper-annotate-as-pure@7.25.9, @babel/helper-builder-binary-assignment-operator-visitor@7.22.5, @babel/helper-compilation-targets@7.22.15, @babel/helper-compilation-targets@7.22.5, @babel/helper-compilation-targets@7.24.7, @babel/helper-compilation-targets@7.27.0, @babel/helper-create-class-features-plugin@7.22.5, @babel/helper-create-class-features-plugin@7.24.7, @babel/helper-create-class-features-plugin@7.25.4, @babel/helper-create-class-features-plugin@7.27.0, @babel/helper-create-regexp-features-plugin@7.22.5, @babel/helper-create-regexp-features-plugin@7.24.7, @babel/helper-environment-visitor@7.22.5, @babel/helper-environment-visitor@7.24.7, @babel/helper-function-name@7.22.5, @babel/helper-function-name@7.24.7, @babel/helper-hoist-variables@7.22.5, @babel/helper-hoist-variables@7.24.7, @babel/helper-member-expression-to-functions@7.22.5, @babel/helper-member-expression-to-functions@7.24.7, @babel/helper-member-expression-to-functions@7.24.8, @babel/helper-member-expression-to-functions@7.25.9, @babel/helper-module-imports@7.22.5, @babel/helper-module-imports@7.24.7, @babel/helper-module-imports@7.25.9, @babel/helper-module-transforms@7.22.5, @babel/helper-module-transforms@7.24.7, @babel/helper-module-transforms@7.26.0, @babel/helper-optimise-call-expression@7.22.5, @babel/helper-optimise-call-expression@7.24.7, @babel/helper-optimise-call-expression@7.25.9, @babel/helper-plugin-utils@7.22.5, @babel/helper-plugin-utils@7.24.7, @babel/helper-plugin-utils@7.24.8, @babel/helper-plugin-utils@7.26.5, @babel/helper-plugin-utils@7.27.1, @babel/helper-remap-async-to-generator@7.22.5, @babel/helper-remap-async-to-generator@7.24.7, @babel/helper-remap-async-to-generator@7.25.9, @babel/helper-replace-supers@7.22.5, @babel/helper-replace-supers@7.24.7, @babel/helper-replace-supers@7.25.0, @babel/helper-replace-supers@7.26.5, @babel/helper-simple-access@7.22.5, @babel/helper-simple-access@7.24.7, @babel/helper-skip-transparent-expression-wrappers@7.22.5, @babel/helper-skip-transparent-expression-wrappers@7.24.7, @babel/helper-skip-transparent-expression-wrappers@7.25.9, @babel/helper-split-export-declaration@7.22.5, @babel/helper-split-export-declaration@7.24.7, @babel/helper-string-parser@7.22.5, @babel/helper-string-parser@7.24.7, @babel/helper-string-parser@7.24.8, @babel/helper-string-parser@7.25.9, @babel/helper-validator-identifier@7.22.5, @babel/helper-validator-identifier@7.24.7, @babel/helper-validator-identifier@7.25.9, @babel/helper-validator-option@7.22.15, @babel/helper-validator-option@7.22.5, @babel/helper-validator-option@7.24.7, @babel/helper-validator-option@7.25.9, @babel/helper-wrap-function@7.22.5, @babel/helper-wrap-function@7.24.7, @babel/helper-wrap-function@7.25.9, @babel/helpers@7.22.5, @babel/helpers@7.27.0, @babel/highlight@7.22.5, @babel/highlight@7.24.7, @babel/parser@7.22.5, @babel/parser@7.24.7, @babel/parser@7.25.6, @babel/parser@7.27.0, @babel/plugin-proposal-async-generator-functions@7.20.7, @babel/plugin-proposal-class-properties@7.18.6, @babel/plugin-proposal-decorators@7.24.7, @babel/plugin-proposal-export-default-from@7.16.0, @babel/plugin-proposal-export-default-from@7.25.9, @babel/plugin-proposal-nullish-coalescing-operator@7.18.6, @babel/plugin-proposal-object-rest-spread@7.20.7, @babel/plugin-proposal-optional-catch-binding@7.18.6, @babel/plugin-proposal-optional-chaining@7.21.0, @babel/plugin-syntax-class-properties@7.12.13, @babel/plugin-syntax-decorators@7.24.7, @babel/plugin-syntax-export-default-from@7.16.0, @babel/plugin-syntax-export-default-from@7.25.9, @babel/plugin-syntax-flow@7.22.5, @babel/plugin-syntax-flow@7.23.3, @babel/plugin-syntax-flow@7.26.0, @babel/plugin-syntax-import-meta@7.10.4, @babel/plugin-syntax-jsx@7.18.6, @babel/plugin-syntax-jsx@7.24.7, @babel/plugin-syntax-jsx@7.25.9, @babel/plugin-syntax-logical-assignment-operators@7.10.4, @babel/plugin-syntax-numeric-separator@7.10.4, @babel/plugin-syntax-private-property-in-object@7.14.5, @babel/plugin-syntax-top-level-await@7.14.5, @babel/plugin-syntax-typescript@7.20.0, @babel/plugin-syntax-typescript@7.25.4, @babel/plugin-syntax-typescript@7.25.9, @babel/plugin-transform-arrow-functions@7.22.5, @babel/plugin-transform-arrow-functions@7.24.7, @babel/plugin-transform-async-generator-functions@7.26.8, @babel/plugin-transform-async-to-generator@7.22.5, @babel/plugin-transform-async-to-generator@7.24.7, @babel/plugin-transform-block-scoped-functions@7.22.5, @babel/plugin-transform-block-scoping@7.22.5, @babel/plugin-transform-block-scoping@7.27.0, @babel/plugin-transform-class-properties@7.25.9, @babel/plugin-transform-classes@7.22.5, @babel/plugin-transform-classes@7.25.9, @babel/plugin-transform-computed-properties@7.22.5, @babel/plugin-transform-computed-properties@7.24.7, @babel/plugin-transform-destructuring@7.22.5, @babel/plugin-transform-destructuring@7.25.9, @babel/plugin-transform-exponentiation-operator@7.22.5, @babel/plugin-transform-export-namespace-from@7.27.1, @babel/plugin-transform-flow-strip-types@7.19.0, @babel/plugin-transform-flow-strip-types@7.26.5, @babel/plugin-transform-for-of@7.22.5, @babel/plugin-transform-for-of@7.24.7, @babel/plugin-transform-function-name@7.22.5, @babel/plugin-transform-function-name@7.25.9, @babel/plugin-transform-literals@7.22.5, @babel/plugin-transform-literals@7.25.9, @babel/plugin-transform-logical-assignment-operators@7.24.7, @babel/plugin-transform-member-expression-literals@7.22.5, @babel/plugin-transform-modules-commonjs@7.22.5, @babel/plugin-transform-modules-commonjs@7.24.7, @babel/plugin-transform-modules-commonjs@7.26.3, @babel/plugin-transform-named-capturing-groups-regex@7.22.5, @babel/plugin-transform-named-capturing-groups-regex@7.24.7, @babel/plugin-transform-nullish-coalescing-operator@7.24.7, @babel/plugin-transform-numeric-separator@7.24.7, @babel/plugin-transform-object-rest-spread@7.24.7, @babel/plugin-transform-object-super@7.22.5, @babel/plugin-transform-optional-catch-binding@7.24.7, @babel/plugin-transform-optional-chaining@7.25.9, @babel/plugin-transform-parameters@7.22.5, @babel/plugin-transform-parameters@7.24.7, @babel/plugin-transform-private-methods@7.24.7, @babel/plugin-transform-private-property-in-object@7.24.7, @babel/plugin-transform-property-literals@7.22.5, @babel/plugin-transform-react-display-name@7.16.0, @babel/plugin-transform-react-display-name@7.24.7, @babel/plugin-transform-react-jsx-development@7.24.7, @babel/plugin-transform-react-jsx-self@7.16.0, @babel/plugin-transform-react-jsx-self@7.25.9, @babel/plugin-transform-react-jsx-source@7.16.0, @babel/plugin-transform-react-jsx-source@7.25.9, @babel/plugin-transform-react-jsx@7.19.0, @babel/plugin-transform-react-jsx@7.25.2, @babel/plugin-transform-react-jsx@7.25.9, @babel/plugin-transform-react-pure-annotations@7.24.7, @babel/plugin-transform-regenerator@7.24.7, @babel/plugin-transform-runtime@7.16.4, @babel/plugin-transform-runtime@7.26.10, @babel/plugin-transform-shorthand-properties@7.22.5, @babel/plugin-transform-shorthand-properties@7.24.7, @babel/plugin-transform-spread@7.22.5, @babel/plugin-transform-spread@7.24.7, @babel/plugin-transform-sticky-regex@7.22.5, @babel/plugin-transform-sticky-regex@7.24.7, @babel/plugin-transform-template-literals@7.22.5, @babel/plugin-transform-typescript@7.20.7, @babel/plugin-transform-typescript@7.25.2, @babel/plugin-transform-typescript@7.27.0, @babel/plugin-transform-unicode-regex@7.22.5, @babel/plugin-transform-unicode-regex@7.24.7, @babel/preset-flow@7.18.6, @babel/preset-react@7.24.7, @babel/preset-typescript@7.18.6, @babel/preset-typescript@7.24.7, @babel/register@7.18.9, @babel/runtime@7.22.5, @babel/runtime@7.23.2, @babel/runtime@7.25.6, @babel/runtime@7.27.0, @babel/template@7.22.5, @babel/template@7.24.7, @babel/template@7.25.0, @babel/template@7.27.0, @babel/traverse@7.22.5, @babel/traverse@7.24.7, @babel/traverse@7.25.6, @babel/traverse@7.27.0, @babel/types@7.22.5, @babel/types@7.24.7, @babel/types@7.25.6, @babel/types@7.26.0, @babel/types@7.27.0

From https://github.com/babel/babel.

**MIT**:

Copyright: Copyright (c) 2014-present Sebastian McKenzie and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/helper-define-polyfill-provider@0.3.3, @babel/helper-define-polyfill-provider@0.6.2, @babel/helper-define-polyfill-provider@0.6.4, babel-plugin-polyfill-corejs2@0.3.0, babel-plugin-polyfill-corejs2@0.4.11, babel-plugin-polyfill-corejs3@0.11.1, babel-plugin-polyfill-corejs3@0.4.0, babel-plugin-polyfill-regenerator@0.3.0, babel-plugin-polyfill-regenerator@0.6.2

From https://github.com/babel/babel-polyfills.

**MIT**:

Copyright: Copyright (c) 2014-present Nicolò Ribaudo and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/plugin-syntax-async-generators@7.8.4, @babel/plugin-syntax-bigint@7.8.3, @babel/plugin-syntax-dynamic-import@7.8.3, @babel/plugin-syntax-json-strings@7.8.3, @babel/plugin-syntax-nullish-coalescing-operator@7.8.3, @babel/plugin-syntax-object-rest-spread@7.8.3, @babel/plugin-syntax-optional-catch-binding@7.8.3, @babel/plugin-syntax-optional-chaining@7.8.3, babel-plugin-syntax-trailing-function-commas@7.0.0-beta.0

From https://github.com/babel/babel.git#master.

**MIT**:

Copyright: Copyright (c) 2014-present Sebastian McKenzie and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/regjsgen@0.8.0

From https://github.com/bnjmnt4n/regjsgen.

**MIT**:

Copyright: Copyright 2014-2020 Benjamin Tan <https://ofcr.se/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @bam.tech/react-native-image-resizer@3.0.11

From https://github.com/bamlab/react-native-image-resizer.

**MIT**:

Copyright: Copyright (c) 2022 Clément Taboulot

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @callstack/react-theme-provider@3.0.9

From https://github.com/callstack/react-theme-provider.

**MIT**:

Copyright: Copyright (c) 2018 Callstack

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/autocomplete@6.18.3

From https://github.com/codemirror/autocomplete.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/commands@6.7.1

From https://github.com/codemirror/commands.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-angular@0.1.3

From https://github.com/codemirror/lang-angular.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-cpp@6.0.2

From https://github.com/codemirror/lang-cpp.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-css@6.3.0

From https://github.com/codemirror/lang-css.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-html@6.4.9

From https://github.com/codemirror/lang-html.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-java@6.0.1

From https://github.com/codemirror/lang-java.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-javascript@6.2.2

From https://github.com/codemirror/lang-javascript.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-json@6.0.1

From https://github.com/codemirror/lang-json.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-less@6.0.2

From https://github.com/codemirror/lang-less.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-markdown@6.3.1

From https://github.com/codemirror/lang-markdown.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-php@6.0.1

From https://github.com/codemirror/lang-php.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-python@6.1.6

From https://github.com/codemirror/lang-python.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-rust@6.0.1

From https://github.com/codemirror/lang-rust.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-sass@6.0.2

From https://github.com/codemirror/lang-sass.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-sql@6.8.0

From https://github.com/codemirror/lang-sql.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-vue@0.1.3

From https://github.com/codemirror/lang-vue.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-wast@6.0.2

From https://github.com/codemirror/lang-wast.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lang-xml@6.1.0

From https://github.com/codemirror/lang-xml.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/language-data@6.3.1

From https://github.com/codemirror/language-data.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/language@6.10.4

From https://github.com/codemirror/language.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/legacy-modes@6.4.2

From https://github.com/codemirror/legacy-modes.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/lint@6.8.3

From https://github.com/codemirror/lint.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/search@6.5.8

From https://github.com/codemirror/search.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/state@6.4.1

From https://github.com/codemirror/state.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @codemirror/view@6.35.0

From https://github.com/codemirror/view.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @craftzdog/react-native-buffer@6.0.5

From https://github.com/craftzdog/react-native-buffer.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh, and other contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @csstools/color-helpers@5.0.2

From https://github.com/csstools/postcss-plugins.

**MIT-0**:

```
MIT No Attribution (MIT-0)

Copyright © CSSTools Contributors

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the “Software”), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### @csstools/css-calc@2.1.4, @csstools/css-color-parser@3.0.10, @csstools/css-parser-algorithms@3.0.5, @csstools/css-tokenizer@3.0.4

From https://github.com/csstools/postcss-plugins.

**MIT**:

Copyright: Copyright 2022 Romain Menke, Antonio Laguna <antonio@laguna.es>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @expo/cli@0.24.20, @expo/config-plugins@10.1.2, @expo/config-types@53.0.5, @expo/config@11.0.13, @expo/env@1.0.7, @expo/fingerprint@0.13.4, @expo/image-utils@0.7.6, @expo/json-file@9.1.5, @expo/metro-config@0.20.17, @expo/osascript@2.2.5, @expo/package-manager@1.8.6, @expo/plist@0.3.5, @expo/prebuild-config@9.0.11, babel-preset-expo@13.2.3, expo-asset@11.1.7, expo-av@15.1.7, expo-camera@16.1.11, expo-constants@17.1.7, expo-file-system@18.1.11, expo-font@13.3.2, expo-keep-awake@14.1.4, expo-local-authentication@16.0.5, expo-modules-autolinking@2.1.14, expo-modules-core@2.5.0, expo@53.0.20

From https://github.com/expo/expo.

**MIT**:

Copyright: Copyright (c) 2015-present 650 Industries, Inc. (aka Expo)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @expo/code-signing-certificates@0.0.5

From https://github.com/expo/code-signing-certificates.

**MIT**:

Copyright: Copyright (c) 2020-present 650 Industries, Inc. (aka Expo)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @expo/devcert@1.2.0

From https://github.com/expo/devcert.

**MIT**:

```
## License

MIT © [Dave Wasmer](http://davewasmer.com)

```

### @expo/sdk-runtime-versions@1.0.0, @expo/ws-tunnel@1.0.6, @isaacs/brace-expansion@5.0.0



**MIT**:

```
# @expo/sdk-runtime-versions

A small library that converts between Expo SDK versions and EAS runtime versions. Note that this expects the non-prerelease semver SDK version (no beta/alpha).

For example, when a managed project has SDK version `41.0.0`, its runtime version is `exposdk:41.0.0`.

```

### @npmcli/fs@1.0.0



**ISC**:

```
ISC License

Copyright npm, Inc.

Permission to use, copy, modify, and/or distribute this
software for any purpose with or without fee is hereby
granted, provided that the above copyright notice and this
permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND NPM DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
EVENT SHALL NPM BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.

```

### @types/nanoid@3.0.0, babel-core@7.0.0-bridge.0, for-each-property-deep@0.0.3, for-each-property@0.0.4, inspect-function@0.2.2, inspect-function@0.3.4, inspect-parameters-declaration@0.0.10, inspect-parameters-declaration@0.0.8, inspect-parameters-declaration@0.0.9, inspect-property@0.0.6



**MIT**:

```
    MIT License

    Copyright (c) Microsoft Corporation.

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE

```

### lighthouse-logger@1.4.2



**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright 2014 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### magicli@0.0.5



**MIT**:


````
# MagiCLI

Automagically generates command-line interfaces (CLI), for any module.
Just `require('magicli')();` and your module is ready to be run via CLI.

The goal is to have any module prepared to be installed globally `-g` and to be run via CLI, with no efforts. Follow these 3 steps and you are done:

 * `npm install magicli --save`
 * Add the property `bin` to your package.json with the value `./bin/cli.js`
 * Create the file `./bin/cli.js` with the following content:

```javascript
#!/usr/bin/env node

require('magicli')();
```

**That's it!** Install your module with `-g` and run it with `--help`. In the same way you can just run `node ./bin/cli.js --help` to test it quickly, without install.

## How it works

Let's suppose that `your-module` exports the function:

```javascript
module.exports = function(param1, param2) {
    return param1 + param2;
}
```

When calling it via CLI, the program will be expecting the parameters names as options. It doesn't need to follow the same order as defined in the function. Example:

```bash
$ your-module --param2="K" --param1="Z"
```
It will work with any kind of function declaration, e.g.:
```javascript
// An Arrow function with Destructuring assignment and Default values
const fn = ([param1, [param2]] = ['z', ['k']], { param3 }) => {};
module.exports = fn;
```

````

### minipass-collect@1.0.2, minipass-pipeline@1.2.4



**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### object-to-arguments@0.0.8, split-skip@0.0.1, split-skip@0.0.2, stringify-parameters@0.0.4, style-mod@4.0.0, unpack-string@0.0.2



**MIT**:


````
# object-to-arguments

[![Build Status](https://api.travis-ci.org/DiegoZoracKy/object-to-arguments.svg)](https://travis-ci.org/DiegoZoracKy/object-to-arguments) [![npm](https://img.shields.io/npm/v/object-to-arguments.svg)]() [![npm](https://img.shields.io/npm/l/object-to-arguments.svg)]()

Transforms object's properties into an array of arguments tailored for a specific function, respecting the expected **order** and handling **destructuring** and **rest** parameters when needed.

## Installation

```bash
npm install object-to-arguments
```

**CLI**
```bash
npm install object-to-arguments -g
```

## Usage

`objectToArguments.call(fn, object);`


`objectToArguments.call(fn, object);`

 * **fn** must be a *function* reference or a function stringified (e.g. `fn.toString()`) for which the arguments array will be created for.

 * **object** is a flat *object literal* containing all the parameters names and its desired arguments. Note that in case of destructuring parameters, the object must still be flat, and the engine will create the structure needed for it.
 	* Every argument defined that is not expected as a parameter will be appended to the end of the arguments array (it will be available to be accessed via *arguments* or via rest parameter *...args*)

## Example

```javascript
const objectToArguments = require('object-to-arguments');

const fn = (a = 'defaultA', b, ...args) => {
	return { a, b, args};
};

const objectArgs = {
	extra1: 'EXTRA1',
	b: 'argB',
	extra2: 'EXTRA2'
};

// fnArguments = [ undefined, 'argB', 'EXTRA1', 'EXTRA2' ]
const fnArguments = objectToArguments(fn, objectArgs);

// fnReturn = { a: 'defaultA', b: 'argB', args: [ 'EXTRA1', 'EXTRA2' ] }
const fnReturn = fn(...fnArguments);
```

**An example with complex *destructuring parameters* and *default values* set in many ways**

```javascript
const objectToArguments = require('object-to-arguments');

const fn = function([a, [b, [c, [d,e] = ['dD', 'dE'] ]]] = ['dA', ['dB', ['dC', ]]], {f} = {}, {g = 'dG'} = {}, {h: {i} = {}} = {},{j: {k = 'dK'} = {}} = {},{l: {m, n: {o} = {}} = {}} = {}, {p,q = 'dQ', r} = {}, [[[s,{t: {u} = {}} = {}]]] = [[[]]], {v: [{w} = {}, x = 'dX'] = []} = {}) {
	return { a, b, c, d, e, f, g, i, k, m, o, p, q, r, s, u, w, x, arguments };
};

const objectArgs = {
	a: 'aA',
	b: 'aB',
	c: 'aC',
	f: 'aF',
	k: 'aK',
	p: 'aP',
	q: 'aQ',
	s: 'aS',
	u: 'aU',
	v: 'aV',
	w: 'aW',
	x: 'aX',
	extra1: 'EXTRA1',
	extra2: 'EXTRA2'
};

const fnArgs = objectToArguments(fn, objectArgs);
const fnReturn = fn(...fnArgs);

/////////////////////
// fnArgs will be: //
/////////////////////
// [
//     [
//         "aA",
//         [
//             "aB",
//             [
//                 "aC",
//                 undefined
//             ]
//         ]
//     ],
//     {
//         "f": "aF"
//     },
//     undefined,
//     undefined,
//     {
//         "j": {
//             "k": "aK"
//         }
//     },
//     undefined,
//     {
//         "p": "aP",
//         "q": "aQ"
//     },
//     [
//         [
//             [
//                 "aS",
//                 {
//                     "t": {
//                         "u": "aU"
//                     }
//                 }
//             ]
//         ]
//     ],
//     {
//         "v": [
//             {
//                 "w": "aW"
//             },
//             "aX"
//         ]
//     },
//     "aV",
//     "EXTRA1",
//     "EXTRA2"
// ]


///////////////////////
// fnReturn will be: //
///////////////////////
// {
//     "a": "aA",
//     "b": "aB",
//     "c": "aC",
//     "d": "dD",
//     "e": "dE",
//     "f": "aF",
//     "g": "dG",
//     "k": "aK",
//     "p": "aP",
//     "q": "aQ",
//     "s": "aS",
//     "u": "aU",
//     "w": "aW",
//     "x": "aX",
//     "arguments": {
//         "0": [
//             "aA",
//             [
//                 "aB",
//                 [
//                     "aC",
//                     null
//                 ]
//             ]
//         ],
//         "1": {
//             "f": "aF"
//         },
//         "4": {
//             "j": {
//                 "k": "aK"
//             }
//         },
//         "6": {
//             "p": "aP",
//             "q": "aQ"
//         },
//         "7": [
//             [
//                 [
//                     "aS",
//                     {
//                         "t": {
//                             "u": "aU"
//                         }
//                     }
//                 ]
//             ]
//         ],
//         "8": {
//             "v": [
//                 {
//                     "w": "aW"
//                 },
//                 "aX"
//             ]
//         },
//         "9": "aV",
//         "10": "EXTRA1",
//         "11": "EXTRA2"
//     }
// }
```

````

### @expo/spawn-async@1.7.2

From https://github.com/expo/spawn-async.

**MIT**:

Copyright: Copyright (c) 2015 650 Industries

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @expo/sudo-prompt@9.3.2

From https://github.com/expo/sudo-prompt.

**MIT**:

Copyright: Copyright (c) 2015 Joran Dirk Greef

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @expo/vector-icons@14.0.4

From https://github.com/expo/vector-icons.

**MIT**:

Copyright: Copyright (c) 2020 650 Industries

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @expo/xcpretty@4.3.1

From https://github.com/expo/expo-cli.

**BSD-3-Clause**:


````
# @expo/xcpretty

This can be used to parse and format xcodebuild logs.
The default error and warning format matches that of other tools in the Expo ecosystem.

```ts
import { Formatter } from '@expo/xcpretty';

const formatter = new Formatter({ projectRoot: '/' });

const lines = formatter.pipe('xcodebuild log results...');

for (const line of lines) {
  console.log(line);
}
```


````

### @gar/promisify@1.1.2

From https://github.com/wraithgar/gar-promisify.

**MIT**:

```
The MIT License (MIT)

Copyright © 2020-2022 Michael Garvin

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


```

### @hapi/hoek@9.2.1

From https://github.com/hapijs/hoek.

**BSD-3-Clause**:

```
Copyright (c) 2011-2020, Sideway Inc, and project contributors  
Copyright (c) 2011-2014, Walmart  
Copyright (c) 2011, Yahoo Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS OFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @hapi/topo@5.1.0

From https://github.com/hapijs/topo.

**BSD-3-Clause**:

```
Copyright (c) 2012-2020, Sideway Inc, and project contributors  
Copyright (c) 2012-2014, Walmart.  
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS OFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @isaacs/balanced-match@4.0.1

From https://github.com/isaacs/balanced-match.

**MIT**:

```
(MIT)

Original code Copyright Julian Gruber <julian@juliangruber.com>

Port to TypeScript Copyright Isaac Z. Schlueter <i@izs.me>

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### @isaacs/cliui@8.0.2, cliui@6.0.0, cliui@7.0.4, cliui@8.0.1

From https://github.com/yargs/cliui.

**ISC**:

```
Copyright (c) 2015, Contributors

Permission to use, copy, modify, and/or distribute this software
for any purpose with or without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE
LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### @isaacs/fs-minipass@4.0.1, fs-minipass@2.1.0

From https://github.com/npm/fs-minipass.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### @isaacs/ttlcache@1.4.1

From https://github.com/isaacs/ttlcache.

**ISC**:

```
The ISC License

Copyright (c) 2022-2023 - Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### @istanbuljs/load-nyc-config@1.1.0

From https://github.com/istanbuljs/load-nyc-config.

**ISC**:

```
ISC License

Copyright (c) 2019, Contributors

Permission to use, copy, modify, and/or distribute this software
for any purpose with or without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE
LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### @istanbuljs/schema@0.1.3

From https://github.com/istanbuljs/schema.

**MIT**:

Copyright: Copyright (c) 2019 CFWare, LLC

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jest/create-cache-key-function@27.4.2, @jest/types@26.6.2, @jest/types@27.4.2, @jest/types@27.5.1, jest-get-type@26.3.0, jest-regex-util@27.5.1, jest-serializer@27.5.1, jest-util@27.5.1, jest-validate@26.6.2, jest-worker@27.5.1, pretty-format@26.6.2

From https://github.com/facebook/jest.

**MIT**:

Copyright: Copyright (c) Facebook, Inc. and its affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jest/create-cache-key-function@29.7.0, @jest/environment@29.7.0, @jest/fake-timers@29.7.0, @jest/schemas@29.6.3, @jest/transform@29.7.0, @jest/types@29.6.3, babel-jest@29.7.0, babel-plugin-jest-hoist@29.6.3, babel-preset-jest@29.6.3, jest-environment-node@29.7.0, jest-get-type@29.6.3, jest-haste-map@29.7.0, jest-message-util@29.7.0, jest-mock@29.7.0, jest-regex-util@29.6.3, jest-util@29.7.0, jest-validate@29.7.0, jest-worker@29.7.0, pretty-format@29.7.0

From https://github.com/jestjs/jest.

**MIT**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jridgewell/gen-mapping@0.3.2, @jridgewell/gen-mapping@0.3.3, @jridgewell/gen-mapping@0.3.5

From https://github.com/jridgewell/gen-mapping.

**MIT**:

Copyright: Copyright 2022 Justin Ridgewell <jridgewell@google.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jridgewell/resolve-uri@3.1.0, @jridgewell/resolve-uri@3.1.1

From https://github.com/jridgewell/resolve-uri.

**MIT**:

Copyright: Copyright 2019 Justin Ridgewell <jridgewell@google.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jridgewell/set-array@1.1.2, @jridgewell/set-array@1.2.1

From https://github.com/jridgewell/set-array.

**MIT**:

Copyright: Copyright 2022 Justin Ridgewell <jridgewell@google.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jridgewell/source-map@0.3.3

From https://github.com/jridgewell/source-map.

**MIT**:

Copyright: Copyright 2019 Justin Ridgewell <jridgewell@google.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jridgewell/sourcemap-codec@1.4.14, @jridgewell/sourcemap-codec@1.4.15

From https://github.com/jridgewell/sourcemap-codec.

**MIT**:

Copyright: Copyright (c) 2015 Rich Harris

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @jridgewell/trace-mapping@0.3.14, @jridgewell/trace-mapping@0.3.18, @jridgewell/trace-mapping@0.3.19, @jridgewell/trace-mapping@0.3.25

From https://github.com/jridgewell/trace-mapping.

**MIT**:

Copyright: Copyright 2022 Justin Ridgewell <justin@ridgewell.name>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/common@1.2.3

From https://github.com/lezer-parser/common.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/cpp@1.1.2

From https://github.com/lezer-parser/cpp.

**MIT**:

Copyright: Copyright (C) 2020 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/css@1.1.9

From https://github.com/lezer-parser/css.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/highlight@1.2.1

From https://github.com/lezer-parser/highlight.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/html@1.3.10

From https://github.com/lezer-parser/html.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/java@1.1.3

From https://github.com/lezer-parser/java.

**MIT**:

Copyright: Copyright (C) 2020 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/javascript@1.4.19

From https://github.com/lezer-parser/javascript.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/json@1.0.2

From https://github.com/lezer-parser/json.

**MIT**:

Copyright: Copyright (C) 2020 by Marijn Haverbeke <marijn@haverbeke.berlin>, Arun Srinivasan <rulfzid@gmail.com>, and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/lr@1.4.2

From https://github.com/lezer-parser/lr.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/markdown@1.3.2

From https://github.com/lezer-parser/markdown.

**MIT**:

Copyright: Copyright (C) 2020 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/php@1.0.2

From https://github.com/lezer-parser/php.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/python@1.1.14

From https://github.com/lezer-parser/python.

**MIT**:

Copyright: Copyright (C) 2020 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/rust@1.0.2

From https://github.com/lezer-parser/rust.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/sass@1.0.7

From https://github.com/lezer-parser/sass.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @lezer/xml@1.0.5

From https://github.com/lezer-parser/xml.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @mapbox/node-pre-gyp@1.0.10

From https://github.com/mapbox/node-pre-gyp.

**BSD-3-Clause**:

```
Copyright (c), Mapbox

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of node-pre-gyp nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @nodelib/fs.scandir@2.1.5, @nodelib/fs.stat@2.0.5, @nodelib/fs.walk@1.2.8

From https://github.com/nodelib/nodelib.git#master.

**MIT**:

Copyright: Copyright (c) Denis Malinochkin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @npmcli/move-file@1.1.2

From https://github.com/npm/move-file.

**MIT**:

Copyright: Copyright (c) npm, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @pkgjs/parseargs@0.11.0

From https://github.com/pkgjs/parseargs.

**MIT**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### @react-native-clipboard/clipboard@1.16.3

From https://github.com/react-native-clipboard/clipboard.

**MIT**:

Copyright: Copyright (c) 2015-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native-community/cli-clean@16.0.3, @react-native-community/cli-clean@9.2.1, @react-native-community/cli-config-android@16.0.3, @react-native-community/cli-config-apple@16.0.3, @react-native-community/cli-config@16.0.3, @react-native-community/cli-config@9.2.1, @react-native-community/cli-debugger-ui@16.0.3, @react-native-community/cli-debugger-ui@9.0.0, @react-native-community/cli-doctor@16.0.3, @react-native-community/cli-doctor@9.3.0, @react-native-community/cli-hermes@9.3.1, @react-native-community/cli-platform-android@16.0.3, @react-native-community/cli-platform-android@9.3.1, @react-native-community/cli-platform-apple@16.0.3, @react-native-community/cli-platform-ios@16.0.3, @react-native-community/cli-platform-ios@9.3.0, @react-native-community/cli-plugin-metro@9.2.1, @react-native-community/cli-server-api@16.0.3, @react-native-community/cli-server-api@9.2.1, @react-native-community/cli-tools@16.0.3, @react-native-community/cli-tools@9.2.1, @react-native-community/cli-types@16.0.3, @react-native-community/cli-types@9.1.0, @react-native-community/cli@16.0.3, @react-native-community/cli@9.3.2

From https://github.com/react-native-community/cli.

**MIT**:

Copyright: Copyright (c) 2018 react-native-community

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native-community/datetimepicker@8.4.2

From https://github.com/react-native-community/datetimepicker.

**MIT**:

Copyright: Copyright (c) 2019 React Native Community

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native-community/geolocation@3.4.0

From https://github.com/michalchudziak/react-native-geolocation.

**MIT**:

Copyright: Copyright (c) 2022-present, React Native Community

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native-community/netinfo@11.4.1

From https://github.com/react-native-netinfo/react-native-netinfo.

**MIT**:

Copyright: Copyright (c) 2015-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native-community/push-notification-ios@1.11.0

From https://github.com/react-native-community/push-notification-ios.

**MIT**:

```
MIT License

Copyright (c) 2020 react-native-community

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.% 
```

### @react-native-documents/picker@10.1.5

From https://github.com/react-native-documents/document-picker.

**MIT**:

Copyright: Copyright (c) 2025 Vojtech Novak

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native/assets-registry@0.79.2, @react-native/assets@1.0.0, @react-native/babel-plugin-codegen@0.79.5, @react-native/babel-preset@0.79.5, @react-native/codegen@0.79.2, @react-native/codegen@0.79.5, @react-native/community-cli-plugin@0.79.2

From https://github.com/facebook/react-native.

**MIT**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native/debugger-frontend@0.79.2, @react-native/debugger-frontend@0.79.5

From https://github.com/facebook/react-native.

**BSD-3-Clause**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @react-native/dev-middleware@0.79.2, @react-native/dev-middleware@0.79.5, @react-native/gradle-plugin@0.79.2, @react-native/js-polyfills@0.79.2, @react-native/normalize-color@2.0.0, @react-native/normalize-colors@0.73.2, @react-native/normalize-colors@0.74.84, @react-native/normalize-colors@0.79.2, @react-native/normalize-colors@0.79.5, @react-native/polyfills@2.0.0, @react-native/virtualized-lists@0.79.2, react-native-codegen@0.70.6, react-native-gradle-plugin@0.70.3, react-native@0.70.6, react-native@0.79.2

From https://github.com/facebook/react-native.

**MIT**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @replit/codemirror-vim@6.2.1

From https://github.com/replit/codemirror-vim.

**MIT**:

Copyright: Copyright (C) 2018-2021 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @sideway/address@4.1.3

From https://github.com/sideway/address.

**BSD-3-Clause**:

```
Copyright (c) 2019-2020, Sideway, Inc. and Project contributors
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @sideway/formula@3.0.0

From https://github.com/sideway/formula.

**BSD-3-Clause**:

```
Copyright (c) 2019-2020, Sideway. Inc, and project contributors
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @sideway/pinpoint@2.0.0

From https://github.com/sideway/pinpoint.

**BSD-3-Clause**:

```
Copyright (c) 2019-2020, Sideway. Inc, and project contributors  

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS OFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @sinclair/typebox@0.27.8

From https://github.com/sinclairzx81/typebox.

**MIT**:

```
TypeBox: JSON Schema Type Builder with Static Type Resolution for TypeScript 

The MIT License (MIT)

Copyright (c) 2017-2023 Haydn Paterson (sinclair) <haydn.developer@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
```

### @sinonjs/commons@2.0.0

From https://github.com/sinonjs/commons.

**BSD-3-Clause**:

```
BSD 3-Clause License

Copyright (c) 2018, Sinon.JS
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @sinonjs/fake-timers@10.0.2

From https://github.com/sinonjs/fake-timers.

**BSD-3-Clause**:

```
Copyright (c) 2010-2014, Christian Johansen, christian@cjohansen.no. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
```

### @tokenizer/token@0.3.0

From https://github.com/Borewit/tokenizer-token.

**MIT**:

```
[![npm version](https://badge.fury.io/js/%40tokenizer%2Ftoken.svg)](https://www.npmjs.com/package/@tokenizer/token)
[![npm downloads](http://img.shields.io/npm/dm/@tokenizer/token.svg)](https://npmcharts.com/compare/@tokenizer/token?interval=30)

# @tokenizer/token

TypeScript definition of an [strtok3](https://github.com/Borewit/strtok3) token.

## Licence

(The MIT License)

Copyright (c) 2020 Borewit

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 'Software'), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


```

### @tootallnate/once@1.1.2

From https://github.com/TooTallNate/once.

**MIT**:

Copyright: Copyright (c) 2020 Nathan Rajlich

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @types/babel__core@7.1.19, @types/babel__generator@7.6.3, @types/babel__template@7.4.1, @types/babel__traverse@7.14.2, @types/graceful-fs@4.1.5, @types/hoist-non-react-statics@3.3.1, @types/istanbul-lib-coverage@2.0.3, @types/istanbul-lib-report@3.0.0, @types/istanbul-reports@3.0.1, @types/node@16.11.11, @types/prop-types@15.7.4, @types/react@17.0.37, @types/react@19.0.14, @types/scheduler@0.16.2, @types/stack-utils@2.0.1, @types/trusted-types@2.0.7, @types/use-sync-external-store@0.0.3, @types/yargs-parser@20.2.1, @types/yargs@15.0.14, @types/yargs@16.0.4, @types/yargs@17.0.10, @types/cacheable-request@6.0.2, @types/http-cache-semantics@4.0.1, @types/keyv@3.1.3, @types/node@22.13.10, @types/responselike@1.0.0, @types/yauzl@2.10.0, @types/asn1@0.2.4, @types/uuid@10.0.0

From https://github.com/DefinitelyTyped/DefinitelyTyped.

**MIT**:

```
    MIT License

    Copyright (c) Microsoft Corporation.

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE

```

### @urql/core@5.1.1, @urql/exchange-retry@1.3.1

From https://github.com/urql-graphql/urql.

**MIT**:

Copyright: Copyright (c) urql GraphQL Team and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @vscode/sudo-prompt@9.3.1

From https://github.com/bpasero/sudo-prompt.

**MIT**:

Copyright: Copyright (c) 2015 Joran Dirk Greef

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @xmldom/xmldom@0.8.8, @xmldom/xmldom@0.8.10

From https://github.com/xmldom/xmldom.

**MIT**:

Copyright: Copyright 2012 - 2017 @jindw <jindw@xidea.org> and other contributors, as listed in: https://github.com/jindw/xmldom/graphs/contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### abbrev@1.1.1

From https://github.com/isaacs/abbrev-js.

**ISC**:

```
This software is dual-licensed under the ISC and MIT licenses.
You may use this software under EITHER of the following licenses.

----------

The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

----------

Copyright Isaac Z. Schlueter and Contributors
All rights reserved.

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

```

### abort-controller@3.0.0

From https://github.com/mysticatea/abort-controller.

**MIT**:

Copyright: Copyright (c) 2017 Toru Nagashima

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### absolute-path@0.0.0

From https://github.com/filearts/node-absolute-path.

**MIT**:

Copyright: Copyright (c) 2014 filearts

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### accepts@1.3.7, accepts@1.3.8

From https://github.com/jshttp/accepts.

**MIT**:

Copyright: Copyright (c) 2015 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### acorn@8.8.2

From https://github.com/acornjs/acorn.

**MIT**:

Copyright: Copyright (C) 2012-2022 by various contributors (see AUTHORS)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### adm-zip@0.5.16

From https://github.com/cthackers/adm-zip.

**MIT**:

Copyright: Copyright (c) 2012 Another-D-Mention Software and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### agent-base@6.0.2

From https://github.com/TooTallNate/node-agent-base.

**MIT**:


````
agent-base
==========
### Turn a function into an [`http.Agent`][http.Agent] instance
[![Build Status](https://github.com/TooTallNate/node-agent-base/workflows/Node%20CI/badge.svg)](https://github.com/TooTallNate/node-agent-base/actions?workflow=Node+CI)

This module provides an `http.Agent` generator. That is, you pass it an async
callback function, and it returns a new `http.Agent` instance that will invoke the
given callback function when sending outbound HTTP requests.

#### Some subclasses:

Here's some more interesting uses of `agent-base`.
Send a pull request to list yours!

 * [`http-proxy-agent`][http-proxy-agent]: An HTTP(s) proxy `http.Agent` implementation for HTTP endpoints
 * [`https-proxy-agent`][https-proxy-agent]: An HTTP(s) proxy `http.Agent` implementation for HTTPS endpoints
 * [`pac-proxy-agent`][pac-proxy-agent]: A PAC file proxy `http.Agent` implementation for HTTP and HTTPS
 * [`socks-proxy-agent`][socks-proxy-agent]: A SOCKS proxy `http.Agent` implementation for HTTP and HTTPS


Installation
------------

Install with `npm`:

``` bash
$ npm install agent-base
```


Example
-------

Here's a minimal example that creates a new `net.Socket` connection to the server
for every HTTP request (i.e. the equivalent of `agent: false` option):

```js
var net = require('net');
var tls = require('tls');
var url = require('url');
var http = require('http');
var agent = require('agent-base');

var endpoint = 'http://nodejs.org/api/';
var parsed = url.parse(endpoint);

// This is the important part!
parsed.agent = agent(function (req, opts) {
  var socket;
  // `secureEndpoint` is true when using the https module
  if (opts.secureEndpoint) {
    socket = tls.connect(opts);
  } else {
    socket = net.connect(opts);
  }
  return socket;
});

// Everything else works just like normal...
http.get(parsed, function (res) {
  console.log('"response" event!', res.headers);
  res.pipe(process.stdout);
});
```

Returning a Promise or using an `async` function is also supported:

```js
agent(async function (req, opts) {
  await sleep(1000);
  // etc…
});
```

Return another `http.Agent` instance to "pass through" the responsibility
for that HTTP request to that agent:

```js
agent(function (req, opts) {
  return opts.secureEndpoint ? https.globalAgent : http.globalAgent;
});
```


API
---

## Agent(Function callback[, Object options]) → [http.Agent][]

Creates a base `http.Agent` that will execute the callback function `callback`
for every HTTP request that it is used as the `agent` for. The callback function
is responsible for creating a `stream.Duplex` instance of some kind that will be
used as the underlying socket in the HTTP request.

The `options` object accepts the following properties:

  * `timeout` - Number - Timeout for the `callback()` function in milliseconds. Defaults to Infinity (optional).

The callback function should have the following signature:

### callback(http.ClientRequest req, Object options, Function cb) → undefined

The ClientRequest `req` can be accessed to read request headers and
and the path, etc. The `options` object contains the options passed
to the `http.request()`/`https.request()` function call, and is formatted
to be directly passed to `net.connect()`/`tls.connect()`, or however
else you want a Socket to be created. Pass the created socket to
the callback function `cb` once created, and the HTTP request will
continue to proceed.

If the `https` module is used to invoke the HTTP request, then the
`secureEndpoint` property on `options` _will be set to `true`_.


License
-------

(The MIT License)

Copyright (c) 2013 Nathan Rajlich &lt;nathan@tootallnate.net&gt;

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

[http-proxy-agent]: https://github.com/TooTallNate/node-http-proxy-agent
[https-proxy-agent]: https://github.com/TooTallNate/node-https-proxy-agent
[pac-proxy-agent]: https://github.com/TooTallNate/node-pac-proxy-agent
[socks-proxy-agent]: https://github.com/TooTallNate/node-socks-proxy-agent
[http.Agent]: https://nodejs.org/api/http.html#http_class_http_agent


````

### agent-base@7.1.0, agent-base@7.1.4, http-proxy-agent@7.0.2, https-proxy-agent@7.0.5, https-proxy-agent@7.0.6

From https://github.com/TooTallNate/proxy-agents.

**MIT**:


````
agent-base
==========
### Turn a function into an [`http.Agent`][http.Agent] instance

This module is a thin wrapper around the base `http.Agent` class.

It provides an abstract class that must define a `connect()` function,
which is responsible for creating the underlying socket that the HTTP
client requests will use.

The `connect()` function may return an arbitrary `Duplex` stream, or
another `http.Agent` instance to delegate the request to, and may be
asynchronous (by defining an `async` function).

Instances of this agent can be used with the `http` and `https`
modules. To differentiate, the options parameter in the `connect()`
function includes a `secureEndpoint` property, which can be checked
to determine what type of socket should be returned.

#### Some subclasses:

Here are some more interesting uses of `agent-base`.
Send a pull request to list yours!

 * [`http-proxy-agent`][http-proxy-agent]: An HTTP(s) proxy `http.Agent` implementation for HTTP endpoints
 * [`https-proxy-agent`][https-proxy-agent]: An HTTP(s) proxy `http.Agent` implementation for HTTPS endpoints
 * [`pac-proxy-agent`][pac-proxy-agent]: A PAC file proxy `http.Agent` implementation for HTTP and HTTPS
 * [`socks-proxy-agent`][socks-proxy-agent]: A SOCKS proxy `http.Agent` implementation for HTTP and HTTPS

Example
-------

Here's a minimal example that creates a new `net.Socket` or `tls.Socket`
based on the `secureEndpoint` property. This agent can be used with both
the `http` and `https` modules.

```ts
import * as net from 'net';
import * as tls from 'tls';
import * as http from 'http';
import { Agent } from 'agent-base';

class MyAgent extends Agent {
  connect(req, opts) {
    // `secureEndpoint` is true when using the "https" module
    if (opts.secureEndpoint) {
      return tls.connect(opts);
    } else {
      return net.connect(opts);
    }
  }
});

// Keep alive enabled means that `connect()` will only be
// invoked when a new connection needs to be created
const agent = new MyAgent({ keepAlive: true });

// Pass the `agent` option when creating the HTTP request
http.get('http://nodejs.org/api/', { agent }, (res) => {
  console.log('"response" event!', res.headers);
  res.pipe(process.stdout);
});
```

License
-------

(The MIT License)

Copyright (c) 2013 Nathan Rajlich &lt;nathan@tootallnate.net&gt;

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

[http-proxy-agent]: ../http-proxy-agent
[https-proxy-agent]: ../https-proxy-agent
[pac-proxy-agent]: ../pac-proxy-agent
[socks-proxy-agent]: ../socks-proxy-agent
[http.Agent]: https://nodejs.org/api/http.html#http_class_http_agent


````

### agentkeepalive@4.1.4

From https://github.com/node-modules/agentkeepalive.

**MIT**:

```
The MIT License

Copyright(c) node-modules and other contributors.
Copyright(c) 2012 - 2015 fengmk2 <fengmk2@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### aggregate-error@3.1.0

From https://github.com/sindresorhus/aggregate-error.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ajv@6.12.6

From https://github.com/ajv-validator/ajv.

**MIT**:

Copyright: Copyright (c) 2015-2017 Evgeny Poberezkin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### anser@1.4.10

From https://github.com/IonicaBizau/anser.

**MIT**:

Copyright: Copyright (c) 2012-20 Ionică Bizău <bizauionica@gmail.com> (https://ionicabizau.net)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ansi-escape-sequences@4.1.0

From https://github.com/75lb/ansi-escape-sequences.

**MIT**:

Copyright: Copyright (c) 2014-19 Lloyd Brookes <75pound@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ansi-escapes@4.3.2

From https://github.com/sindresorhus/ansi-escapes.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ansi-fragments@0.2.1

From https://github.com/zamotany/ansi-fragments.

**MIT**:


````
# ansi-fragments

[![Version][version]][package]   

[![PRs Welcome][prs-welcome-badge]][prs-welcome]
[![MIT License][license-badge]][license]
[![Chat][chat-badge]][chat]
[![Code of Conduct][coc-badge]][coc]

A tiny library with builders to help making logs/CLI pretty with a nice DX.

- [ansi-fragments](#ansi-fragments)
  - [Installation](#installation)
  - [Usage](#usage)
  - [API](#api)
      - [`color`](#color)
      - [`modifier`](#modifier)
      - [`container`](#container)
      - [`pad`](#pad)
      - [`fixed`](#fixed)
      - [`ifElse`](#ifElse)
      - [`provide`](#provide)

## Installation

```bash
yarn add ansi-fragments
```

## Usage

```js
import { color, modifier, pad, container } from 'ansi-fragments';

const prettyLog = (level, message) => container(
  color('green', modifier('italic', level)),
  pad(1),
  message
).build();

console.log(prettyLog('success', 'Yay!'));
```

## API

Each fragment implements `IFragment` interface:

```ts
interface IFragment {
  build(): string;
}
```

The `build` method is responsible for traversing the tree of fragments and create a string representation with ANSI escape codes.


#### `color`

```ts
color(
  ansiColor: AnsiColor,
  ...children: Array<string | IFragment>
): IFragment
```

Creates fragment for standard ANSI [colors](./src/fragments/Color.ts).

```js
color('red', 'Oh no');
color('bgBlue', color('brightBlue', 'Hey'));
color('green', modifier('bold', 'Sup!'));
```

#### `modifier`

```ts
modifier(
  ansiModifier: AnsiModifier,
  ...children: Array<string | IFragment>
): IFragment
```

Creates fragment for standard ANSI [modifiers](./src/fragments/Modifier.ts): `dim`, `bold`, `hidden`, `italic`, `underline`, `strikethrough`.

```js
modifier('underline', 'Hello', 'World');
modifier('italic', modifier('bold', 'Hey'));
modifier('bold', color('green', 'Sup!'));
```

#### `container`

```ts
container(...children: Array<string | IFragment>): IFragment
```

Creates fragment, which sole purpose is to hold and build nested fragments.

```js
container(
  color('gray', '[08/01/18 12:00]'),
  pad(1),
  color('green', 'success'),
  pad(1),
  'Some message'
)
```

#### `pad`

```ts
pad(count: number, separator?: string): IFragment
```

Creates fragment, which repeats given separator (default: ` `) given number of times.

```js
pad(1);
pad(2, '#')
pad(1, '\n')
```

#### `fixed`

```ts
fixed(
  value: number,
  bias: 'start' | 'end',
  ...children: Array<string | IFragment>
): IFragment
```

Creates fragment, which makes sure the children will always build to given number of non-ANSI characters. It will either trim the results or add necessary amount of spaces. The `bias` control if trimming/padding should be done at the start of the string representing built children or at the end.

```js
fixed(5, 'start', 'ERR'); // => '  ERR'
fixed(8, 'end', color('green', 'success')); // equals to color('green', 'success') + ' '
fixed(10, 'end', 'Hello', pad(2), 'World') // => 'Hello  Wor'
```

#### `ifElse`

```ts
ifElse(
  condition: Condition,
  ifTrueFragment: string | IFragment,
  elseFragment: string | IFragment
): IFragment

type ConditionValue = boolean | string | number | null | undefined;
type Condition = ConditionValue | (() => ConditionValue);
```

Change the output based on condition. Condition can ba a primitive value, which can be casted to boolean or a function. If conation or return value of condition is evaluated to `true`, the first argument - `ifTrueFragment` will be used, otherwise `elseFragment`.

```js
let condition = getConditionValue()
ifElse(
  () => condition,
  color('red', 'ERROR'),
  color('yellow', 'WARNING')
)
```

#### `provide`

```ts
provide<T>(
  value: T,
  builder: (value: T) => string | IFragment
): IFragment
```

Provides given value to a builder function, which should return `string` or fragment. Useful in situations when the output is connected with some calculated value - using `provide` you only need to calculate final value once and forward it to custom styling logic.

```js
provide(getMessageFromSomewhere(), value => {
  switch (value.level) {
    case 'error':
      return container(
        color('red', modifier('bold', value.level.toUpperCase())),
        pad(2),
        value.log
      );
    case 'info':
      return container(
        color('blue', value.level.toUpperCase()),
        pad(2),
        value.log
      );
    default:
      return container(value.level.toUpperCase(), pad(2), value.log);
  }
})
```


<!-- badges (common) -->

[license-badge]: https://img.shields.io/npm/l/ansi-fragments.svg?style=flat-square
[license]: https://opensource.org/licenses/MIT
[prs-welcome-badge]: https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square
[prs-welcome]: http://makeapullrequest.com
[coc-badge]: https://img.shields.io/badge/code%20of-conduct-ff69b4.svg?style=flat-square
[coc]: https://github.com/zamotany/ansi-fragments/blob/master/CODE_OF_CONDUCT.md
[chat-badge]: https://img.shields.io/badge/chat-discord-brightgreen.svg?style=flat-square&colorB=7289DA&logo=discord
[chat]: https://discord.gg/zwR2Cdh

[version]: https://img.shields.io/npm/v/ansi-fragments.svg?style=flat-square
[package]: https://www.npmjs.com/package/ansi-fragments


````

### ansi-regex@3.0.0, ansi-regex@4.1.0, ansi-regex@5.0.1, ansi-regex@6.0.1, ansi-regex@2.1.1

From https://github.com/chalk/ansi-regex.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ansi-styles@3.2.1, ansi-styles@4.3.0, ansi-styles@5.2.0, ansi-styles@6.1.0, ansi-styles@2.2.1

From https://github.com/chalk/ansi-styles.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### any-promise@1.3.0

From https://github.com/kevinbeaty/any-promise.

**MIT**:

Copyright: Copyright (C) 2014-2016 Kevin Beaty

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### anymatch@3.1.2

From https://github.com/micromatch/anymatch.

**ISC**:

```
The ISC License

Copyright (c) 2019 Elan Shanker, Paul Miller (https://paulmillr.com)

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### appdirsjs@1.2.6

From https://github.com/codingjerk/appdirsjs.

**MIT**:


````
# appdirsjs

[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/codingjerk/appdirsjs/ci)](https://github.com/codingjerk/appdirsjs/actions)
[![Codecov](https://img.shields.io/codecov/c/gh/codingjerk/appdirsjs)](https://codecov.io/gh/codingjerk/appdirsjs)
[![npm](https://img.shields.io/npm/v/appdirsjs)](https://www.npmjs.com/package/appdirsjs)
[![npm bundle size](https://img.shields.io/bundlephobia/min/appdirsjs)](https://www.npmjs.com/package/appdirsjs)
[![GitHub](https://img.shields.io/github/license/codingjerk/appdirsjs)](https://github.com/codingjerk/appdirsjs/blob/master/LICENSE.md)

A node.js library to get paths to directories to store configs, caches and data according to OS standarts.

## Installation

```sh
npm install appdirsjs
```

or

```sh
yarn install appdirsjs
```

if you're using yarn.

## Usage

```javascript
import appDirs from "appdirsjs";

const dirs = appDirs({ appName: "expo" });

console.log(dirs.cache);
// /home/user/.cache/expo on Linux
// /Users/User/Library/Caches/expo on MacOS
// C:\Users\User\AppData\Local\Temp\expo on Windows

console.log(dirs.config);
// /home/user/.config/expo on Linux
// /Users/User/Library/Preferences/expo on MacOS
// C:\Users\User\AppData\Roaming\expo

console.log(dirs.data);
// /home/user/.local/share/expo on Linux
// /Users/User/Library/Application Support/expo on MacOS
// C:\Users\User\AppData\Local\expo
```

### Keep backward compability

Then switching from old-style dotfile directory,
such as `~/.myapp` to new, like `~/.config/myapp`,
you can pass `legacyPath` parameter
to keep using old directory if it exists:

```javascript
import * as path from "path";
import appDirs from "appdirsjs";

const dirs = appDirs({
  appName: "expo",
  // Notice usage of full path
  legacyPath: path.join(os.homedir(), ".expo"),
});

console.log(dirs.config);
// /home/user/.expo
```

## TODO

- [ ] Android support
- [ ] XDG on BSD support


````

### aproba@2.0.0

From https://github.com/iarna/aproba.

**ISC**:

```
Copyright (c) 2015, Rebecca Turner <me@re-becca.org>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


```

### are-we-there-yet@2.0.0

From https://github.com/npm/are-we-there-yet.

**ISC**:

```
ISC License

Copyright npm, Inc.

Permission to use, copy, modify, and/or distribute this
software for any purpose with or without fee is hereby
granted, provided that the above copyright notice and this
permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND NPM DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
EVENT SHALL NPM BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.

```

### arg@5.0.2

From https://github.com/vercel/arg.

**MIT**:

Copyright: Copyright (c) 2021 Vercel, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### argparse@1.0.10

From https://github.com/nodeca/argparse.

**MIT**:

Copyright: Copyright (C) 2012 by Vitaly Puzrin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### argparse@2.0.1

From https://github.com/nodeca/argparse.

**Python-2.0**:

```
A. HISTORY OF THE SOFTWARE
==========================

Python was created in the early 1990s by Guido van Rossum at Stichting
Mathematisch Centrum (CWI, see http://www.cwi.nl) in the Netherlands
as a successor of a language called ABC.  Guido remains Python's
principal author, although it includes many contributions from others.

In 1995, Guido continued his work on Python at the Corporation for
National Research Initiatives (CNRI, see http://www.cnri.reston.va.us)
in Reston, Virginia where he released several versions of the
software.

In May 2000, Guido and the Python core development team moved to
BeOpen.com to form the BeOpen PythonLabs team.  In October of the same
year, the PythonLabs team moved to Digital Creations, which became
Zope Corporation.  In 2001, the Python Software Foundation (PSF, see
https://www.python.org/psf/) was formed, a non-profit organization
created specifically to own Python-related Intellectual Property.
Zope Corporation was a sponsoring member of the PSF.

All Python releases are Open Source (see http://www.opensource.org for
the Open Source Definition).  Historically, most, but not all, Python
releases have also been GPL-compatible; the table below summarizes
the various releases.

    Release         Derived     Year        Owner       GPL-
                    from                                compatible? (1)

    0.9.0 thru 1.2              1991-1995   CWI         yes
    1.3 thru 1.5.2  1.2         1995-1999   CNRI        yes
    1.6             1.5.2       2000        CNRI        no
    2.0             1.6         2000        BeOpen.com  no
    1.6.1           1.6         2001        CNRI        yes (2)
    2.1             2.0+1.6.1   2001        PSF         no
    2.0.1           2.0+1.6.1   2001        PSF         yes
    2.1.1           2.1+2.0.1   2001        PSF         yes
    2.1.2           2.1.1       2002        PSF         yes
    2.1.3           2.1.2       2002        PSF         yes
    2.2 and above   2.1.1       2001-now    PSF         yes

Footnotes:

(1) GPL-compatible doesn't mean that we're distributing Python under
    the GPL.  All Python licenses, unlike the GPL, let you distribute
    a modified version without making your changes open source.  The
    GPL-compatible licenses make it possible to combine Python with
    other software that is released under the GPL; the others don't.

(2) According to Richard Stallman, 1.6.1 is not GPL-compatible,
    because its license has a choice of law clause.  According to
    CNRI, however, Stallman's lawyer has told CNRI's lawyer that 1.6.1
    is "not incompatible" with the GPL.

Thanks to the many outside volunteers who have worked under Guido's
direction to make these releases possible.


B. TERMS AND CONDITIONS FOR ACCESSING OR OTHERWISE USING PYTHON
===============================================================

PYTHON SOFTWARE FOUNDATION LICENSE VERSION 2
--------------------------------------------

1. This LICENSE AGREEMENT is between the Python Software Foundation
("PSF"), and the Individual or Organization ("Licensee") accessing and
otherwise using this software ("Python") in source or binary form and
its associated documentation.

2. Subject to the terms and conditions of this License Agreement, PSF hereby
grants Licensee a nonexclusive, royalty-free, world-wide license to reproduce,
analyze, test, perform and/or display publicly, prepare derivative works,
distribute, and otherwise use Python alone or in any derivative version,
provided, however, that PSF's License Agreement and PSF's notice of copyright,
i.e., "Copyright (c) 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Python Software Foundation;
All Rights Reserved" are retained in Python alone or in any derivative version
prepared by Licensee.

3. In the event Licensee prepares a derivative work that is based on
or incorporates Python or any part thereof, and wants to make
the derivative work available to others as provided herein, then
Licensee hereby agrees to include in any such work a brief summary of
the changes made to Python.

4. PSF is making Python available to Licensee on an "AS IS"
basis.  PSF MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR
IMPLIED.  BY WAY OF EXAMPLE, BUT NOT LIMITATION, PSF MAKES NO AND
DISCLAIMS ANY REPRESENTATION OR WARRANTY OF MERCHANTABILITY OR FITNESS
FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF PYTHON WILL NOT
INFRINGE ANY THIRD PARTY RIGHTS.

5. PSF SHALL NOT BE LIABLE TO LICENSEE OR ANY OTHER USERS OF PYTHON
FOR ANY INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES OR LOSS AS
A RESULT OF MODIFYING, DISTRIBUTING, OR OTHERWISE USING PYTHON,
OR ANY DERIVATIVE THEREOF, EVEN IF ADVISED OF THE POSSIBILITY THEREOF.

6. This License Agreement will automatically terminate upon a material
breach of its terms and conditions.

7. Nothing in this License Agreement shall be deemed to create any
relationship of agency, partnership, or joint venture between PSF and
Licensee.  This License Agreement does not grant permission to use PSF
trademarks or trade name in a trademark sense to endorse or promote
products or services of Licensee, or any third party.

8. By copying, installing or otherwise using Python, Licensee
agrees to be bound by the terms and conditions of this License
Agreement.


BEOPEN.COM LICENSE AGREEMENT FOR PYTHON 2.0
-------------------------------------------

BEOPEN PYTHON OPEN SOURCE LICENSE AGREEMENT VERSION 1

1. This LICENSE AGREEMENT is between BeOpen.com ("BeOpen"), having an
office at 160 Saratoga Avenue, Santa Clara, CA 95051, and the
Individual or Organization ("Licensee") accessing and otherwise using
this software in source or binary form and its associated
documentation ("the Software").

2. Subject to the terms and conditions of this BeOpen Python License
Agreement, BeOpen hereby grants Licensee a non-exclusive,
royalty-free, world-wide license to reproduce, analyze, test, perform
and/or display publicly, prepare derivative works, distribute, and
otherwise use the Software alone or in any derivative version,
provided, however, that the BeOpen Python License is retained in the
Software, alone or in any derivative version prepared by Licensee.

3. BeOpen is making the Software available to Licensee on an "AS IS"
basis.  BEOPEN MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR
IMPLIED.  BY WAY OF EXAMPLE, BUT NOT LIMITATION, BEOPEN MAKES NO AND
DISCLAIMS ANY REPRESENTATION OR WARRANTY OF MERCHANTABILITY OR FITNESS
FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE WILL NOT
INFRINGE ANY THIRD PARTY RIGHTS.

4. BEOPEN SHALL NOT BE LIABLE TO LICENSEE OR ANY OTHER USERS OF THE
SOFTWARE FOR ANY INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES OR LOSS
AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THE SOFTWARE, OR ANY
DERIVATIVE THEREOF, EVEN IF ADVISED OF THE POSSIBILITY THEREOF.

5. This License Agreement will automatically terminate upon a material
breach of its terms and conditions.

6. This License Agreement shall be governed by and interpreted in all
respects by the law of the State of California, excluding conflict of
law provisions.  Nothing in this License Agreement shall be deemed to
create any relationship of agency, partnership, or joint venture
between BeOpen and Licensee.  This License Agreement does not grant
permission to use BeOpen trademarks or trade names in a trademark
sense to endorse or promote products or services of Licensee, or any
third party.  As an exception, the "BeOpen Python" logos available at
http://www.pythonlabs.com/logos.html may be used according to the
permissions granted on that web page.

7. By copying, installing or otherwise using the software, Licensee
agrees to be bound by the terms and conditions of this License
Agreement.


CNRI LICENSE AGREEMENT FOR PYTHON 1.6.1
---------------------------------------

1. This LICENSE AGREEMENT is between the Corporation for National
Research Initiatives, having an office at 1895 Preston White Drive,
Reston, VA 20191 ("CNRI"), and the Individual or Organization
("Licensee") accessing and otherwise using Python 1.6.1 software in
source or binary form and its associated documentation.

2. Subject to the terms and conditions of this License Agreement, CNRI
hereby grants Licensee a nonexclusive, royalty-free, world-wide
license to reproduce, analyze, test, perform and/or display publicly,
prepare derivative works, distribute, and otherwise use Python 1.6.1
alone or in any derivative version, provided, however, that CNRI's
License Agreement and CNRI's notice of copyright, i.e., "Copyright (c)
1995-2001 Corporation for National Research Initiatives; All Rights
Reserved" are retained in Python 1.6.1 alone or in any derivative
version prepared by Licensee.  Alternately, in lieu of CNRI's License
Agreement, Licensee may substitute the following text (omitting the
quotes): "Python 1.6.1 is made available subject to the terms and
conditions in CNRI's License Agreement.  This Agreement together with
Python 1.6.1 may be located on the Internet using the following
unique, persistent identifier (known as a handle): 1895.22/1013.  This
Agreement may also be obtained from a proxy server on the Internet
using the following URL: http://hdl.handle.net/1895.22/1013".

3. In the event Licensee prepares a derivative work that is based on
or incorporates Python 1.6.1 or any part thereof, and wants to make
the derivative work available to others as provided herein, then
Licensee hereby agrees to include in any such work a brief summary of
the changes made to Python 1.6.1.

4. CNRI is making Python 1.6.1 available to Licensee on an "AS IS"
basis.  CNRI MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR
IMPLIED.  BY WAY OF EXAMPLE, BUT NOT LIMITATION, CNRI MAKES NO AND
DISCLAIMS ANY REPRESENTATION OR WARRANTY OF MERCHANTABILITY OR FITNESS
FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF PYTHON 1.6.1 WILL NOT
INFRINGE ANY THIRD PARTY RIGHTS.

5. CNRI SHALL NOT BE LIABLE TO LICENSEE OR ANY OTHER USERS OF PYTHON
1.6.1 FOR ANY INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES OR LOSS AS
A RESULT OF MODIFYING, DISTRIBUTING, OR OTHERWISE USING PYTHON 1.6.1,
OR ANY DERIVATIVE THEREOF, EVEN IF ADVISED OF THE POSSIBILITY THEREOF.

6. This License Agreement will automatically terminate upon a material
breach of its terms and conditions.

7. This License Agreement shall be governed by the federal
intellectual property law of the United States, including without
limitation the federal copyright law, and, to the extent such
U.S. federal law does not apply, by the law of the Commonwealth of
Virginia, excluding Virginia's conflict of law provisions.
Notwithstanding the foregoing, with regard to derivative works based
on Python 1.6.1 that incorporate non-separable material that was
previously distributed under the GNU General Public License (GPL), the
law of the Commonwealth of Virginia shall govern this License
Agreement only as to issues arising under or with respect to
Paragraphs 4, 5, and 7 of this License Agreement.  Nothing in this
License Agreement shall be deemed to create any relationship of
agency, partnership, or joint venture between CNRI and Licensee.  This
License Agreement does not grant permission to use CNRI trademarks or
trade name in a trademark sense to endorse or promote products or
services of Licensee, or any third party.

8. By clicking on the "ACCEPT" button where indicated, or by copying,
installing or otherwise using Python 1.6.1, Licensee agrees to be
bound by the terms and conditions of this License Agreement.

        ACCEPT


CWI LICENSE AGREEMENT FOR PYTHON 0.9.0 THROUGH 1.2
--------------------------------------------------

Copyright (c) 1991 - 1995, Stichting Mathematisch Centrum Amsterdam,
The Netherlands.  All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### arr-diff@4.0.0

From https://github.com/jonschlinkert/arr-diff.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### arr-flatten@1.1.0

From https://github.com/jonschlinkert/arr-flatten.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### arr-union@3.1.0

From https://github.com/jonschlinkert/arr-union.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### array-back@2.0.0, array-back@3.1.0

From https://github.com/75lb/array-back.

**MIT**:

Copyright: Copyright (c) 2015-17 Lloyd Brookes <75pound@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### array-unique@0.3.2

From https://github.com/jonschlinkert/array-unique.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### asap@2.0.6

From https://github.com/kriskowal/asap.

**MIT**:

Copyright: Copyright 2009–2014 Contributors. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### asn1.js@4.10.1, asn1.js@5.4.1

From https://github.com/indutny/asn1.js.

**MIT**:

Copyright: Copyright (c) 2017 Fedor Indutny

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### asn1@0.2.6

From https://github.com/joyent/node-asn1.

**MIT**:

```
Copyright (c) 2011 Mark Cavage, All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE

```

### assert-browserify@2.0.0

From https://github.com/browserify/commonjs-assert.

**MIT**:

Copyright: Copyright Joyent, Inc. and other Node contributors. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### assert-plus@1.0.0

From https://github.com/mcavage/node-assert-plus.

**MIT**:

Copyright: Copyright (c) 2018, Joyent, Inc. and assert-plus authors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### assign-symbols@1.0.0

From https://github.com/jonschlinkert/assign-symbols.

**MIT**:

Copyright: Copyright (c) 2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ast-types@0.14.2

From https://github.com/benjamn/ast-types.

**MIT**:

Copyright: Copyright (c) 2013 Ben Newman <bn@cs.stanford.edu>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### astral-regex@1.0.0

From https://github.com/kevva/astral-regex.

**MIT**:

Copyright: Copyright (c) Kevin Mårtensson <kevinmartensson@gmail.com> (github.com/kevva)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### async-limiter@1.0.1

From https://github.com/strml/async-limiter.

**MIT**:

Copyright: Copyright (c) 2017 Samuel Reed <samuel.trace.reed@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### async-mutex@0.5.0

From https://github.com/DirtyHairy/async-mutex.

**MIT**:

Copyright: Copyright (c) 2016 Christian Speckner <cnspeckn@googlemail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### async@3.2.4

From https://github.com/caolan/async.

**MIT**:

Copyright: Copyright (c) 2010-2018 Caolan McMahon

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### asynckit@0.4.0

From https://github.com/alexindigo/asynckit.

**MIT**:

Copyright: Copyright (c) 2016 Alex Indigo

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### atob@2.1.2

From git://git.coolaj86.com/coolaj86/atob.js.

**(MIT OR Apache-2.0)**:

```
At your option you may choose either of the following licenses:

  * The MIT License (MIT)
  * The Apache License 2.0 (Apache-2.0)


The MIT License (MIT)

Copyright (c) 2015 AJ ONeal

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.


                                 Apache License
                           Version 2.0, January 2004
                        http://www.apache.org/licenses/

   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

   1. Definitions.

      "License" shall mean the terms and conditions for use, reproduction,
      and distribution as defined by Sections 1 through 9 of this document.

      "Licensor" shall mean the copyright owner or entity authorized by
      the copyright owner that is granting the License.

      "Legal Entity" shall mean the union of the acting entity and all
      other entities that control, are controlled by, or are under common
      control with that entity. For the purposes of this definition,
      "control" means (i) the power, direct or indirect, to cause the
      direction or management of such entity, whether by contract or
      otherwise, or (ii) ownership of fifty percent (50%) or more of the
      outstanding shares, or (iii) beneficial ownership of such entity.

      "You" (or "Your") shall mean an individual or Legal Entity
      exercising permissions granted by this License.

      "Source" form shall mean the preferred form for making modifications,
      including but not limited to software source code, documentation
      source, and configuration files.

      "Object" form shall mean any form resulting from mechanical
      transformation or translation of a Source form, including but
      not limited to compiled object code, generated documentation,
      and conversions to other media types.

      "Work" shall mean the work of authorship, whether in Source or
      Object form, made available under the License, as indicated by a
      copyright notice that is included in or attached to the work
      (an example is provided in the Appendix below).

      "Derivative Works" shall mean any work, whether in Source or Object
      form, that is based on (or derived from) the Work and for which the
      editorial revisions, annotations, elaborations, or other modifications
      represent, as a whole, an original work of authorship. For the purposes
      of this License, Derivative Works shall not include works that remain
      separable from, or merely link (or bind by name) to the interfaces of,
      the Work and Derivative Works thereof.

      "Contribution" shall mean any work of authorship, including
      the original version of the Work and any modifications or additions
      to that Work or Derivative Works thereof, that is intentionally
      submitted to Licensor for inclusion in the Work by the copyright owner
      or by an individual or Legal Entity authorized to submit on behalf of
      the copyright owner. For the purposes of this definition, "submitted"
      means any form of electronic, verbal, or written communication sent
      to the Licensor or its representatives, including but not limited to
      communication on electronic mailing lists, source code control systems,
      and issue tracking systems that are managed by, or on behalf of, the
      Licensor for the purpose of discussing and improving the Work, but
      excluding communication that is conspicuously marked or otherwise
      designated in writing by the copyright owner as "Not a Contribution."

      "Contributor" shall mean Licensor and any individual or Legal Entity
      on behalf of whom a Contribution has been received by Licensor and
      subsequently incorporated within the Work.

   2. Grant of Copyright License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      copyright license to reproduce, prepare Derivative Works of,
      publicly display, publicly perform, sublicense, and distribute the
      Work and such Derivative Works in Source or Object form.

   3. Grant of Patent License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      (except as stated in this section) patent license to make, have made,
      use, offer to sell, sell, import, and otherwise transfer the Work,
      where such license applies only to those patent claims licensable
      by such Contributor that are necessarily infringed by their
      Contribution(s) alone or by combination of their Contribution(s)
      with the Work to which such Contribution(s) was submitted. If You
      institute patent litigation against any entity (including a
      cross-claim or counterclaim in a lawsuit) alleging that the Work
      or a Contribution incorporated within the Work constitutes direct
      or contributory patent infringement, then any patent licenses
      granted to You under this License for that Work shall terminate
      as of the date such litigation is filed.

   4. Redistribution. You may reproduce and distribute copies of the
      Work or Derivative Works thereof in any medium, with or without
      modifications, and in Source or Object form, provided that You
      meet the following conditions:

      (a) You must give any other recipients of the Work or
          Derivative Works a copy of this License; and

      (b) You must cause any modified files to carry prominent notices
          stating that You changed the files; and

      (c) You must retain, in the Source form of any Derivative Works
          that You distribute, all copyright, patent, trademark, and
          attribution notices from the Source form of the Work,
          excluding those notices that do not pertain to any part of
          the Derivative Works; and

      (d) If the Work includes a "NOTICE" text file as part of its
          distribution, then any Derivative Works that You distribute must
          include a readable copy of the attribution notices contained
          within such NOTICE file, excluding those notices that do not
          pertain to any part of the Derivative Works, in at least one
          of the following places: within a NOTICE text file distributed
          as part of the Derivative Works; within the Source form or
          documentation, if provided along with the Derivative Works; or,
          within a display generated by the Derivative Works, if and
          wherever such third-party notices normally appear. The contents
          of the NOTICE file are for informational purposes only and
          do not modify the License. You may add Your own attribution
          notices within Derivative Works that You distribute, alongside
          or as an addendum to the NOTICE text from the Work, provided
          that such additional attribution notices cannot be construed
          as modifying the License.

      You may add Your own copyright statement to Your modifications and
      may provide additional or different license terms and conditions
      for use, reproduction, or distribution of Your modifications, or
      for any such Derivative Works as a whole, provided Your use,
      reproduction, and distribution of the Work otherwise complies with
      the conditions stated in this License.

   5. Submission of Contributions. Unless You explicitly state otherwise,
      any Contribution intentionally submitted for inclusion in the Work
      by You to the Licensor shall be under the terms and conditions of
      this License, without any additional terms or conditions.
      Notwithstanding the above, nothing herein shall supersede or modify
      the terms of any separate license agreement you may have executed
      with Licensor regarding such Contributions.

   6. Trademarks. This License does not grant permission to use the trade
      names, trademarks, service marks, or product names of the Licensor,
      except as required for reasonable and customary use in describing the
      origin of the Work and reproducing the content of the NOTICE file.

   7. Disclaimer of Warranty. Unless required by applicable law or
      agreed to in writing, Licensor provides the Work (and each
      Contributor provides its Contributions) on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
      implied, including, without limitation, any warranties or conditions
      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
      PARTICULAR PURPOSE. You are solely responsible for determining the
      appropriateness of using or redistributing the Work and assume any
      risks associated with Your exercise of permissions under this License.

   8. Limitation of Liability. In no event and under no legal theory,
      whether in tort (including negligence), contract, or otherwise,
      unless required by applicable law (such as deliberate and grossly
      negligent acts) or agreed to in writing, shall any Contributor be
      liable to You for damages, including any direct, indirect, special,
      incidental, or consequential damages of any character arising as a
      result of this License or out of the use or inability to use the
      Work (including but not limited to damages for loss of goodwill,
      work stoppage, computer failure or malfunction, or any and all
      other commercial damages or losses), even if such Contributor
      has been advised of the possibility of such damages.

   9. Accepting Warranty or Additional Liability. While redistributing
      the Work or Derivative Works thereof, You may choose to offer,
      and charge a fee for, acceptance of support, warranty, indemnity,
      or other liability obligations and/or rights consistent with this
      License. However, in accepting such obligations, You may act only
      on Your own behalf and on Your sole responsibility, not on behalf
      of any other Contributor, and only if You agree to indemnify,
      defend, and hold each Contributor harmless for any liability
      incurred by, or claims asserted against, such Contributor by reason
      of your accepting any such warranty or additional liability.

   END OF TERMS AND CONDITIONS

   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "{}"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright 2015 AJ ONeal

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### available-typed-arrays@1.0.5

From https://github.com/inspect-js/available-typed-arrays.

**MIT**:

Copyright: Copyright (c) 2020 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### aws-sign2@0.7.0

From https://github.com/mikeal/aws-sign.

**Apache-2.0**:

```
Apache License

Version 2.0, January 2004

http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.

"Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.

2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.

3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.

4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of this License; and

You must cause any modified files to carry prominent notices stating that You changed the files; and

You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and

If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.

5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.

7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.

8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS
```

### aws4@1.11.0

From https://github.com/mhart/aws4.

**MIT**:

Copyright: Copyright 2013 Michael Hart (michael.hart.au@gmail.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### b4a@1.6.4

From https://github.com/holepunchto/b4a.

**ISC**:

```
ISC License

Copyright (c) 2021 Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

```

### babel-plugin-istanbul@6.1.1

From https://github.com/istanbuljs/babel-plugin-istanbul.

**BSD-3-Clause**:

```
Copyright (c) 2016, Istanbul Code Coverage
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of babel-plugin-istanbul nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### babel-plugin-react-native-web@0.19.13, react-native-web@0.20.0

From https://github.com/necolas/react-native-web.

**MIT**:

Copyright: Copyright (c) Nicolas Gallagher.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### babel-plugin-syntax-hermes-parser@0.25.1, hermes-estree@0.25.1, hermes-estree@0.28.1, hermes-estree@0.8.0, hermes-parser@0.25.1, hermes-parser@0.28.1, hermes-parser@0.8.0

From https://github.com/facebook/hermes.

**MIT**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### babel-plugin-transform-flow-enums@0.0.2, flow-enums-runtime@0.0.6, flow-parser@0.121.0, flow-parser@0.166.1

From https://github.com/facebook/flow.

**MIT**:

Copyright: Copyright (c) Facebook, Inc. and its affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### babel-preset-current-node-syntax@1.0.1

From https://github.com/nicolo-ribaudo/babel-preset-current-node-syntax.

**MIT**:

Copyright: Copyright (c) 2020 Nicolò Ribaudo and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### babel-preset-fbjs@3.4.0, fbjs-css-vars@1.0.2, fbjs@3.0.5

From https://github.com/facebook/fbjs.

**MIT**:

Copyright: Copyright (c) 2013-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### balanced-match@1.0.2

From https://github.com/juliangruber/balanced-match.

**MIT**:

```
(MIT)

Copyright (c) 2013 Julian Gruber &lt;julian@juliangruber.com&gt;

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### base-64@0.1.0, base-64@1.0.0

From https://github.com/mathiasbynens/base64.

**MIT**:

Copyright: Copyright Mathias Bynens <http://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### base64-js@1.5.1

From https://github.com/beatgammit/base64-js.

**MIT**:

Copyright: Copyright (c) 2014 Jameson Little

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### base64-stream@1.0.0

From https://github.com/mazira/base64-stream.

**MIT**:

```
# License
MIT

```

### base@0.11.2

From https://github.com/node-base/base.

**MIT**:

Copyright: Copyright (c) 2015-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### bcrypt-pbkdf@1.0.2

From https://github.com/joyent/node-bcrypt-pbkdf.

**BSD-3-Clause**:

```
The Blowfish portions are under the following license:

Blowfish block cipher for OpenBSD
Copyright 1997 Niels Provos <provos@physnet.uni-hamburg.de>
All rights reserved.

Implementation advice by David Mazieres <dm@lcs.mit.edu>.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



The bcrypt_pbkdf portions are under the following license:

Copyright (c) 2013 Ted Unangst <tedu@openbsd.org>

Permission to use, copy, modify, and distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.



Performance improvements (Javascript-specific):

Copyright 2016, Joyent Inc
Author: Alex Wilson <alex.wilson@joyent.com>

Permission to use, copy, modify, and distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### better-opn@3.0.2

From https://github.com/ExiaSR/better-opn.

**MIT**:

Copyright: Copyright 2018 Michael Lin <linzichunzf@hotmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### big-integer@1.6.52

From https://github.com/peterolson/BigInteger.js.

**Unlicense**:

```
This is free and unencumbered software released into the public domain.

Anyone is free to copy, modify, publish, use, compile, sell, or
distribute this software, either in source code form or as a compiled
binary, for any purpose, commercial or non-commercial, and by any
means.

In jurisdictions that recognize copyright laws, the author or authors
of this software dedicate any and all copyright interest in the
software to the public domain. We make this dedication for the benefit
of the public at large and to the detriment of our heirs and
successors. We intend this dedication to be an overt act of
relinquishment in perpetuity of all present and future rights to this
software under copyright law.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

For more information, please refer to <http://unlicense.org>

```

### binary-extensions@2.2.0

From https://github.com/sindresorhus/binary-extensions.

**MIT**:

Copyright: Copyright (c) 2019 Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com), Paul Miller (https://paulmillr.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### bl@4.1.0

From https://github.com/rvagg/bl.

**MIT**:

```
The MIT License (MIT)
=====================

Copyright (c) 2013-2019 bl contributors
----------------------------------

*bl contributors listed at <https://github.com/rvagg/bl#contributors>*

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### bn.js@4.12.0, bn.js@5.2.0, bn.js@5.2.2

From https://github.com/indutny/bn.js.

**MIT**:

Copyright: Copyright Fedor Indutny, 2015.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### boolbase@1.0.0

From https://github.com/fb55/boolbase.

**ISC**:

```
Copyright (c) 2014-2015, Felix Boehm <me@feedic.com>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### bowser@2.11.0

From https://github.com/lancedikson/bowser.

**MIT**:

```
Copyright 2015, Dustin Diaz (the "Original Author")
All rights reserved.

MIT License

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

Distributions of all or part of the Software intended to be used
by the recipients as they would use the unmodified Software,
containing modifications that substantially alter, remove, or
disable functionality of the Software, outside of the documented
configuration mechanisms provided by the Software, shall be
modified such that the Original Author's bug reporting email
addresses and urls are either replaced with the contact information
of the parties responsible for the changes, or removed entirely.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.


Except where noted, this license applies to any and all software
programs and associated documentation files created by the
Original Author, when distributed with the Software.

```

### bplist-creator@0.1.0, bplist-creator@0.1.1

From https://github.com/nearinfinity/node-bplist-creator.

**MIT**:

Copyright: Copyright (c) 2012 Near Infinity Corporation

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### bplist-parser@0.3.2

From https://github.com/nearinfinity/node-bplist-parser.

**MIT**:

```
## License

(The MIT License)

Copyright (c) 2012 Near Infinity Corporation

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### brace-expansion@1.1.11, brace-expansion@2.0.1

From https://github.com/juliangruber/brace-expansion.

**MIT**:

Copyright: Copyright (c) 2013 Julian Gruber <julian@juliangruber.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### braces@2.3.2, braces@3.0.2

From https://github.com/micromatch/braces.

**MIT**:

Copyright: Copyright (c) 2014-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### brorand@1.1.0

From https://github.com/indutny/brorand.

**MIT**:

```
#### LICENSE

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2014.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### browserify-aes@1.2.0

From https://github.com/crypto-browserify/browserify-aes.

**MIT**:

Copyright: Copyright (c) 2014-2017 browserify-aes contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### browserify-cipher@1.0.1

From https://github.com/crypto-browserify/browserify-cipher.

**MIT**:

Copyright: Copyright (c) 2014-2017 Calvin Metcalf & contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### browserify-des@1.0.2

From https://github.com/crypto-browserify/browserify-des.

**MIT**:

Copyright: Copyright (c) 2014-2017 Calvin Metcalf, Fedor Indutny & contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### browserify-rsa@4.1.0, browserify-rsa@4.1.1

From https://github.com/crypto-browserify/browserify-rsa.

**MIT**:

Copyright: Copyright (c) 2014-2016 Calvin Metcalf & contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### browserify-sign@4.2.3

From https://github.com/crypto-browserify/browserify-sign.

**ISC**:

```
Copyright (c) 2014-2015 Calvin Metcalf and browserify-sign contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### browserslist@4.18.1, browserslist@4.21.4, browserslist@4.22.1, browserslist@4.23.1, browserslist@4.24.4

From https://github.com/browserslist/browserslist.

**MIT**:

Copyright: Copyright 2014 Andrey Sitnik <andrey@sitnik.ru> and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### bser@2.1.1, fb-watchman@2.0.1

From https://github.com/facebook/watchman.

**Apache-2.0**:

Copyright: Copyright (c) Meta Platforms, Inc. and its affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### buffer-from@1.1.2

From https://github.com/LinusU/buffer-from.

**MIT**:

Copyright: Copyright (c) 2016, 2018 Linus Unnebäck

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### buffer-xor@1.0.3

From https://github.com/crypto-browserify/buffer-xor.

**MIT**:

Copyright: Copyright (c) 2015 Daniel Cousens

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### buffer@5.7.1, buffer@6.0.3, buffer@4.9.2

From https://github.com/feross/buffer.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh, and other contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### builtin-modules@3.3.0

From https://github.com/sindresorhus/builtin-modules.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### builtins@5.0.1

From https://github.com/juliangruber/builtins.

**MIT**:

Copyright: Copyright (c) 2015 Julian Gruber <julian@juliangruber.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### bytes@3.0.0, bytes@3.1.2

From https://github.com/visionmedia/bytes.js.

**MIT**:

Copyright: Copyright (c) 2015 Jed Watson <jed.watson@me.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cacache@15.3.0

From https://github.com/npm/cacache.

**ISC**:

```
ISC License

Copyright (c) npm, Inc.

Permission to use, copy, modify, and/or distribute this software for
any purpose with or without fee is hereby granted, provided that the
above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE COPYRIGHT HOLDER DISCLAIMS
ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.

```

### cache-base@1.0.1

From https://github.com/jonschlinkert/cache-base.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### call-bind-apply-helpers@1.0.2

From https://github.com/ljharb/call-bind-apply-helpers.

**MIT**:

Copyright: Copyright (c) 2024 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### call-bind@1.0.2, call-bind@1.0.7

From https://github.com/ljharb/call-bind.

**MIT**:

Copyright: Copyright (c) 2020 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### caller-callsite@2.0.0

From https://github.com/sindresorhus/caller-callsite.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### caller-path@2.0.0

From https://github.com/sindresorhus/caller-path.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### callsites@2.0.0, callsites@3.1.0

From https://github.com/sindresorhus/callsites.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### camel-case@3.0.0

From https://github.com/blakeembrey/camel-case.

**MIT**:

Copyright: Copyright (c) 2014 Blake Embrey (hello@blakeembrey.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### camelcase@4.1.0, camelcase@5.3.1, camelcase@6.2.1

From https://github.com/sindresorhus/camelcase.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### caniuse-lite@1.0.30001362, caniuse-lite@1.0.30001431, caniuse-lite@1.0.30001553, caniuse-lite@1.0.30001636, caniuse-lite@1.0.30001692

From https://github.com/browserslist/caniuse-lite.

**CC-BY-4.0**:

```
Attribution 4.0 International

=======================================================================

Creative Commons Corporation ("Creative Commons") is not a law firm and
does not provide legal services or legal advice. Distribution of
Creative Commons public licenses does not create a lawyer-client or
other relationship. Creative Commons makes its licenses and related
information available on an "as-is" basis. Creative Commons gives no
warranties regarding its licenses, any material licensed under their
terms and conditions, or any related information. Creative Commons
disclaims all liability for damages resulting from their use to the
fullest extent possible.

Using Creative Commons Public Licenses

Creative Commons public licenses provide a standard set of terms and
conditions that creators and other rights holders may use to share
original works of authorship and other material subject to copyright
and certain other rights specified in the public license below. The
following considerations are for informational purposes only, are not
exhaustive, and do not form part of our licenses.

     Considerations for licensors: Our public licenses are
     intended for use by those authorized to give the public
     permission to use material in ways otherwise restricted by
     copyright and certain other rights. Our licenses are
     irrevocable. Licensors should read and understand the terms
     and conditions of the license they choose before applying it.
     Licensors should also secure all rights necessary before
     applying our licenses so that the public can reuse the
     material as expected. Licensors should clearly mark any
     material not subject to the license. This includes other CC-
     licensed material, or material used under an exception or
     limitation to copyright. More considerations for licensors:
	wiki.creativecommons.org/Considerations_for_licensors

     Considerations for the public: By using one of our public
     licenses, a licensor grants the public permission to use the
     licensed material under specified terms and conditions. If
     the licensor's permission is not necessary for any reason--for
     example, because of any applicable exception or limitation to
     copyright--then that use is not regulated by the license. Our
     licenses grant only permissions under copyright and certain
     other rights that a licensor has authority to grant. Use of
     the licensed material may still be restricted for other
     reasons, including because others have copyright or other
     rights in the material. A licensor may make special requests,
     such as asking that all changes be marked or described.
     Although not required by our licenses, you are encouraged to
     respect those requests where reasonable. More_considerations
     for the public: 
	wiki.creativecommons.org/Considerations_for_licensees

=======================================================================

Creative Commons Attribution 4.0 International Public License

By exercising the Licensed Rights (defined below), You accept and agree
to be bound by the terms and conditions of this Creative Commons
Attribution 4.0 International Public License ("Public License"). To the
extent this Public License may be interpreted as a contract, You are
granted the Licensed Rights in consideration of Your acceptance of
these terms and conditions, and the Licensor grants You such rights in
consideration of benefits the Licensor receives from making the
Licensed Material available under these terms and conditions.


Section 1 -- Definitions.

  a. Adapted Material means material subject to Copyright and Similar
     Rights that is derived from or based upon the Licensed Material
     and in which the Licensed Material is translated, altered,
     arranged, transformed, or otherwise modified in a manner requiring
     permission under the Copyright and Similar Rights held by the
     Licensor. For purposes of this Public License, where the Licensed
     Material is a musical work, performance, or sound recording,
     Adapted Material is always produced where the Licensed Material is
     synched in timed relation with a moving image.

  b. Adapter's License means the license You apply to Your Copyright
     and Similar Rights in Your contributions to Adapted Material in
     accordance with the terms and conditions of this Public License.

  c. Copyright and Similar Rights means copyright and/or similar rights
     closely related to copyright including, without limitation,
     performance, broadcast, sound recording, and Sui Generis Database
     Rights, without regard to how the rights are labeled or
     categorized. For purposes of this Public License, the rights
     specified in Section 2(b)(1)-(2) are not Copyright and Similar
     Rights.

  d. Effective Technological Measures means those measures that, in the
     absence of proper authority, may not be circumvented under laws
     fulfilling obligations under Article 11 of the WIPO Copyright
     Treaty adopted on December 20, 1996, and/or similar international
     agreements.

  e. Exceptions and Limitations means fair use, fair dealing, and/or
     any other exception or limitation to Copyright and Similar Rights
     that applies to Your use of the Licensed Material.

  f. Licensed Material means the artistic or literary work, database,
     or other material to which the Licensor applied this Public
     License.

  g. Licensed Rights means the rights granted to You subject to the
     terms and conditions of this Public License, which are limited to
     all Copyright and Similar Rights that apply to Your use of the
     Licensed Material and that the Licensor has authority to license.

  h. Licensor means the individual(s) or entity(ies) granting rights
     under this Public License.

  i. Share means to provide material to the public by any means or
     process that requires permission under the Licensed Rights, such
     as reproduction, public display, public performance, distribution,
     dissemination, communication, or importation, and to make material
     available to the public including in ways that members of the
     public may access the material from a place and at a time
     individually chosen by them.

  j. Sui Generis Database Rights means rights other than copyright
     resulting from Directive 96/9/EC of the European Parliament and of
     the Council of 11 March 1996 on the legal protection of databases,
     as amended and/or succeeded, as well as other essentially
     equivalent rights anywhere in the world.

  k. You means the individual or entity exercising the Licensed Rights
     under this Public License. Your has a corresponding meaning.


Section 2 -- Scope.

  a. License grant.

       1. Subject to the terms and conditions of this Public License,
          the Licensor hereby grants You a worldwide, royalty-free,
          non-sublicensable, non-exclusive, irrevocable license to
          exercise the Licensed Rights in the Licensed Material to:

            a. reproduce and Share the Licensed Material, in whole or
               in part; and

            b. produce, reproduce, and Share Adapted Material.

       2. Exceptions and Limitations. For the avoidance of doubt, where
          Exceptions and Limitations apply to Your use, this Public
          License does not apply, and You do not need to comply with
          its terms and conditions.

       3. Term. The term of this Public License is specified in Section
          6(a).

       4. Media and formats; technical modifications allowed. The
          Licensor authorizes You to exercise the Licensed Rights in
          all media and formats whether now known or hereafter created,
          and to make technical modifications necessary to do so. The
          Licensor waives and/or agrees not to assert any right or
          authority to forbid You from making technical modifications
          necessary to exercise the Licensed Rights, including
          technical modifications necessary to circumvent Effective
          Technological Measures. For purposes of this Public License,
          simply making modifications authorized by this Section 2(a)
          (4) never produces Adapted Material.

       5. Downstream recipients.

            a. Offer from the Licensor -- Licensed Material. Every
               recipient of the Licensed Material automatically
               receives an offer from the Licensor to exercise the
               Licensed Rights under the terms and conditions of this
               Public License.

            b. No downstream restrictions. You may not offer or impose
               any additional or different terms or conditions on, or
               apply any Effective Technological Measures to, the
               Licensed Material if doing so restricts exercise of the
               Licensed Rights by any recipient of the Licensed
               Material.

       6. No endorsement. Nothing in this Public License constitutes or
          may be construed as permission to assert or imply that You
          are, or that Your use of the Licensed Material is, connected
          with, or sponsored, endorsed, or granted official status by,
          the Licensor or others designated to receive attribution as
          provided in Section 3(a)(1)(A)(i).

  b. Other rights.

       1. Moral rights, such as the right of integrity, are not
          licensed under this Public License, nor are publicity,
          privacy, and/or other similar personality rights; however, to
          the extent possible, the Licensor waives and/or agrees not to
          assert any such rights held by the Licensor to the limited
          extent necessary to allow You to exercise the Licensed
          Rights, but not otherwise.

       2. Patent and trademark rights are not licensed under this
          Public License.

       3. To the extent possible, the Licensor waives any right to
          collect royalties from You for the exercise of the Licensed
          Rights, whether directly or through a collecting society
          under any voluntary or waivable statutory or compulsory
          licensing scheme. In all other cases the Licensor expressly
          reserves any right to collect such royalties.


Section 3 -- License Conditions.

Your exercise of the Licensed Rights is expressly made subject to the
following conditions.

  a. Attribution.

       1. If You Share the Licensed Material (including in modified
          form), You must:

            a. retain the following if it is supplied by the Licensor
               with the Licensed Material:

                 i. identification of the creator(s) of the Licensed
                    Material and any others designated to receive
                    attribution, in any reasonable manner requested by
                    the Licensor (including by pseudonym if
                    designated);

                ii. a copyright notice;

               iii. a notice that refers to this Public License;

                iv. a notice that refers to the disclaimer of
                    warranties;

                 v. a URI or hyperlink to the Licensed Material to the
                    extent reasonably practicable;

            b. indicate if You modified the Licensed Material and
               retain an indication of any previous modifications; and

            c. indicate the Licensed Material is licensed under this
               Public License, and include the text of, or the URI or
               hyperlink to, this Public License.

       2. You may satisfy the conditions in Section 3(a)(1) in any
          reasonable manner based on the medium, means, and context in
          which You Share the Licensed Material. For example, it may be
          reasonable to satisfy the conditions by providing a URI or
          hyperlink to a resource that includes the required
          information.

       3. If requested by the Licensor, You must remove any of the
          information required by Section 3(a)(1)(A) to the extent
          reasonably practicable.

       4. If You Share Adapted Material You produce, the Adapter's
          License You apply must not prevent recipients of the Adapted
          Material from complying with this Public License.


Section 4 -- Sui Generis Database Rights.

Where the Licensed Rights include Sui Generis Database Rights that
apply to Your use of the Licensed Material:

  a. for the avoidance of doubt, Section 2(a)(1) grants You the right
     to extract, reuse, reproduce, and Share all or a substantial
     portion of the contents of the database;

  b. if You include all or a substantial portion of the database
     contents in a database in which You have Sui Generis Database
     Rights, then the database in which You have Sui Generis Database
     Rights (but not its individual contents) is Adapted Material; and

  c. You must comply with the conditions in Section 3(a) if You Share
     all or a substantial portion of the contents of the database.

For the avoidance of doubt, this Section 4 supplements and does not
replace Your obligations under this Public License where the Licensed
Rights include other Copyright and Similar Rights.


Section 5 -- Disclaimer of Warranties and Limitation of Liability.

  a. UNLESS OTHERWISE SEPARATELY UNDERTAKEN BY THE LICENSOR, TO THE
     EXTENT POSSIBLE, THE LICENSOR OFFERS THE LICENSED MATERIAL AS-IS
     AND AS-AVAILABLE, AND MAKES NO REPRESENTATIONS OR WARRANTIES OF
     ANY KIND CONCERNING THE LICENSED MATERIAL, WHETHER EXPRESS,
     IMPLIED, STATUTORY, OR OTHER. THIS INCLUDES, WITHOUT LIMITATION,
     WARRANTIES OF TITLE, MERCHANTABILITY, FITNESS FOR A PARTICULAR
     PURPOSE, NON-INFRINGEMENT, ABSENCE OF LATENT OR OTHER DEFECTS,
     ACCURACY, OR THE PRESENCE OR ABSENCE OF ERRORS, WHETHER OR NOT
     KNOWN OR DISCOVERABLE. WHERE DISCLAIMERS OF WARRANTIES ARE NOT
     ALLOWED IN FULL OR IN PART, THIS DISCLAIMER MAY NOT APPLY TO YOU.

  b. TO THE EXTENT POSSIBLE, IN NO EVENT WILL THE LICENSOR BE LIABLE
     TO YOU ON ANY LEGAL THEORY (INCLUDING, WITHOUT LIMITATION,
     NEGLIGENCE) OR OTHERWISE FOR ANY DIRECT, SPECIAL, INDIRECT,
     INCIDENTAL, CONSEQUENTIAL, PUNITIVE, EXEMPLARY, OR OTHER LOSSES,
     COSTS, EXPENSES, OR DAMAGES ARISING OUT OF THIS PUBLIC LICENSE OR
     USE OF THE LICENSED MATERIAL, EVEN IF THE LICENSOR HAS BEEN
     ADVISED OF THE POSSIBILITY OF SUCH LOSSES, COSTS, EXPENSES, OR
     DAMAGES. WHERE A LIMITATION OF LIABILITY IS NOT ALLOWED IN FULL OR
     IN PART, THIS LIMITATION MAY NOT APPLY TO YOU.

  c. The disclaimer of warranties and limitation of liability provided
     above shall be interpreted in a manner that, to the extent
     possible, most closely approximates an absolute disclaimer and
     waiver of all liability.


Section 6 -- Term and Termination.

  a. This Public License applies for the term of the Copyright and
     Similar Rights licensed here. However, if You fail to comply with
     this Public License, then Your rights under this Public License
     terminate automatically.

  b. Where Your right to use the Licensed Material has terminated under
     Section 6(a), it reinstates:

       1. automatically as of the date the violation is cured, provided
          it is cured within 30 days of Your discovery of the
          violation; or

       2. upon express reinstatement by the Licensor.

     For the avoidance of doubt, this Section 6(b) does not affect any
     right the Licensor may have to seek remedies for Your violations
     of this Public License.

  c. For the avoidance of doubt, the Licensor may also offer the
     Licensed Material under separate terms or conditions or stop
     distributing the Licensed Material at any time; however, doing so
     will not terminate this Public License.

  d. Sections 1, 5, 6, 7, and 8 survive termination of this Public
     License.


Section 7 -- Other Terms and Conditions.

  a. The Licensor shall not be bound by any additional or different
     terms or conditions communicated by You unless expressly agreed.

  b. Any arrangements, understandings, or agreements regarding the
     Licensed Material not stated herein are separate from and
     independent of the terms and conditions of this Public License.


Section 8 -- Interpretation.

  a. For the avoidance of doubt, this Public License does not, and
     shall not be interpreted to, reduce, limit, restrict, or impose
     conditions on any use of the Licensed Material that could lawfully
     be made without permission under this Public License.

  b. To the extent possible, if any provision of this Public License is
     deemed unenforceable, it shall be automatically reformed to the
     minimum extent necessary to make it enforceable. If the provision
     cannot be reformed, it shall be severed from this Public License
     without affecting the enforceability of the remaining terms and
     conditions.

  c. No term or condition of this Public License will be waived and no
     failure to comply consented to unless expressly agreed to by the
     Licensor.

  d. Nothing in this Public License constitutes or may be interpreted
     as a limitation upon, or waiver of, any privileges and immunities
     that apply to the Licensor or You, including from the legal
     processes of any jurisdiction or authority.


=======================================================================

Creative Commons is not a party to its public
licenses. Notwithstanding, Creative Commons may elect to apply one of
its public licenses to material it publishes and in those instances
will be considered the “Licensor.” The text of the Creative Commons
public licenses is dedicated to the public domain under the CC0 Public
Domain Dedication. Except for the limited purpose of indicating that
material is shared under a Creative Commons public license or as
otherwise permitted by the Creative Commons policies published at
creativecommons.org/policies, Creative Commons does not authorize the
use of the trademark "Creative Commons" or any other trademark or logo
of Creative Commons without its prior written consent including,
without limitation, in connection with any unauthorized modifications
to any of its public licenses or any other arrangements,
understandings, or agreements concerning use of licensed material. For
the avoidance of doubt, this paragraph does not form part of the
public licenses.

Creative Commons may be contacted at creativecommons.org.

```

### caseless@0.12.0

From https://github.com/mikeal/caseless.

**Apache-2.0**:

```
Apache License
Version 2.0, January 2004
http://www.apache.org/licenses/
TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
1. Definitions.
"License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.
"Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.
"Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.
"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.
"Source" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.
"Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.
"Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).
"Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.
"Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a Contribution."
"Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.
2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.
3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.
4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:
You must give any other recipients of the Work or Derivative Works a copy of this License; and
You must cause any modified files to carry prominent notices stating that You changed the files; and
You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and
If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.
5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.
6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.
7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.
8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.
9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.
END OF TERMS AND CONDITIONS
```

### chalk@2.4.2, chalk@4.1.2, chalk@1.1.3

From https://github.com/chalk/chalk.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### charenc@0.0.2

From https://github.com/pvorb/node-charenc.

**BSD-3-Clause**:

```
Copyright © 2011, Paul Vorbach. All rights reserved.
Copyright © 2009, Jeff Mott. All rights reserved.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name Crypto-JS nor the names of its contributors may be used to
  endorse or promote products derived from this software without specific prior
  written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### chokidar@3.6.0, chokidar@3.5.2

From https://github.com/paulmillr/chokidar.

**MIT**:

```
The MIT License (MIT)

Copyright (c) 2012-2019 Paul Miller (https://paulmillr.com), Elan Shanker

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the “Software”), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### chownr@2.0.0

From https://github.com/isaacs/chownr.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### chownr@3.0.0

From https://github.com/isaacs/chownr.

**BlueOak-1.0.0**:

```
All packages under `src/` are licensed according to the terms in
their respective `LICENSE` or `LICENSE.md` files.

The remainder of this project is licensed under the Blue Oak
Model License, as follows:

-----

# Blue Oak Model License

Version 1.0.0

## Purpose

This license gives everyone as much permission to work with
this software as possible, while protecting contributors
from liability.

## Acceptance

In order to receive this license, you must agree to its
rules.  The rules of this license are both obligations
under that agreement and conditions to your license.
You must not do anything with this software that triggers
a rule that you cannot or will not follow.

## Copyright

Each contributor licenses you to do everything with this
software that would otherwise infringe that contributor's
copyright in it.

## Notices

You must ensure that everyone who gets a copy of
any part of this software from you, with or without
changes, also gets the text of this license or a link to
<https://blueoakcouncil.org/license/1.0.0>.

## Excuse

If anyone notifies you in writing that you have not
complied with [Notices](#notices), you can keep your
license by taking all practical steps to comply within 30
days after the notice.  If you do not do so, your license
ends immediately.

## Patent

Each contributor licenses you to do everything with this
software that would otherwise infringe any patent claims
they can license or become able to license.

## Reliability

No contributor can revoke this license.

## No Liability

***As far as the law allows, this software comes as is,
without any warranty or condition, and no contributor
will be liable to anyone for any damages related to this
software or this license, under any kind of legal claim.***

```

### chownr@1.1.4

From https://github.com/isaacs/chownr.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### chrome-launcher@0.15.2

From https://github.com/GoogleChrome/chrome-launcher.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright 2014 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### chromium-edge-launcher@0.2.0

From https://github.com/cezaraugusto/chromium-edge-launcher.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright 2014 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### ci-info@2.0.0, ci-info@3.3.0, ci-info@3.9.0

From https://github.com/watson/ci-info.

**MIT**:

Copyright: Copyright (c) 2016-2018 Thomas Watson Steen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cipher-base@1.0.4

From https://github.com/crypto-browserify/cipher-base.

**MIT**:

Copyright: Copyright (c) 2017 crypto-browserify contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### class-utils@0.3.6

From https://github.com/jonschlinkert/class-utils.

**MIT**:

Copyright: Copyright (c) 2015, 2017-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### clean-css@4.2.4

From https://github.com/jakubpawlowicz/clean-css.

**MIT**:

Copyright: Copyright (C) 2017 JakubPawlowicz.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### clean-stack@2.2.0

From https://github.com/sindresorhus/clean-stack.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cli-cursor@2.1.0, cli-cursor@3.1.0

From https://github.com/sindresorhus/cli-cursor.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cli-spinners@2.6.1, cli-spinners@2.9.2

From https://github.com/sindresorhus/cli-spinners.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cliss@0.0.2

From https://github.com/DiegoZoracKy/cliss.

**ISC**:


````
# CLIss

[![Build Status](https://api.travis-ci.org/DiegoZoracKy/cliss.svg)](https://travis-ci.org/DiegoZoracKy/cliss) [![npm](https://img.shields.io/npm/v/cliss.svg)]() [![npm](https://img.shields.io/npm/l/cliss.svg)]()

CLI Simple, Stupid. Automatic discovery of parameters names and support to subcommands down to N levels. Provides an easy and minimal setup by passing in only a function reference without the need of declaring all expected options names or create a help section by hand.

## Goals

 * Simple and easy API
 * Easy minimal setup, extracting options names from functions parameters
 * Out of the box support to sync or async (Promise) functions
 * Subcommands down to N levels
 * Automatic Help section generation, that can be improved only when needed

## Installation

```bash
$ npm install cliss
```

## Usage

Through this section we'll be going from the most minimal usage of the module, where options names are extracted from functions parameters:
```javascript
const func = (param1, param2) => `${param1}_${param2}`;
cliss(func);
```

to a version using all the possible options it provides:

```javascript
const cliSpec = {
	name,
	description,
	version,
	options: [{
		name,
		description,
		required,
		type
	}],
	pipe: {
		stdin: (stdinValue, args, positionalArgs, argsAfterEndOfOptions) => {},
		before: (args, positionalArgs, argsAfterEndOfOptions) => {},
		after: (result, parsedArgs, positionalArgs, argsAfterEndOfOptions) => {}
	},
	action: () => {},
	commands: [{}]
};

const clissOptions = {
	command: {
		subcommandsDelimiter
	},
	options: {
		validateRequiredParameters
	},
	version: {
		option
	},
	help: {
		option,
		stripAnsi
	},
	pipe: {
		stdin: (stdinValue, args, positionalArgs, argsAfterEndOfOptions) => {},
		before: (args, positionalArgs, argsAfterEndOfOptions) => {},
		after: (result, parsedArgs, positionalArgs, argsAfterEndOfOptions) => {}
	}
};

cliss(cliSpec, clissOptions);
```

### A CLI for a function (the most simple and minimal use case)
`cliss(functionReference)`

Creating a CLI for a function by doing nothing more than passing it as a parameter to cliss. The options names will be the same as the parameters expected by the function.

```javascript
'use strict';
const cliss = require('cliss');

const aFunctionWithWeirdParametersDefinition = (param1, param2, { someProp: [[ param3 ]] = [[]] } = {}, ...args) => {
	let result = `param1: ${param1} \n`;
	result += `param2: ${param2} \n`;
	result += `param3: ${param3} \n`;
	result += `args: ${args.join(',')}`;

	return result;Run the program passing with the following options:


};

cliss(aFunctionWithWeirdParametersDefinition);
```
Calling it via CLI with `--help` will give you:

```bash
Options:

  --param1
  --param2
  --param3
  --args
```

Passing in the options:
`node cli.js --param2=PARAM2 --param1=PARAM1 --param3=PARAM3 --args=a --args=r --args=g --args=s`

Or passing options + arguments (arguments for the "...args" parameter in this case):
`node cli.js --param2=PARAM2 --param1=PARAM1 --param3=PARAM3 a r g s`

Will result in:

```bash
param1: PARAM1
param2: PARAM2
param3: PARAM3
args: a,r,g,s
```
Note that the order of the options doesn't need to match the order of the parameters.

### Improving the help section
`cliss(cliSpec)`

Great, but probably one would like to improve a bit the `--help` section of the module, by providing to the end user the **name** (the command's name for calling it via CLI), **description** and **version** of the module. In this case a *Object Literal* will be used instead of just a function reference.

```javascript
'use strict';
const cliss = require('../');

cliss({
	name: 'some-command',
	description: 'Just an example that will do nothing but concat all the parameters.',
	version: '1.0.0',
	action: (param1, param2, { someProp: [[ param3 ]] = [[]] } = {}, ...args) => {
		let result = `param1: ${param1} \n`;
		result += `param2: ${param2} \n`;
		result += `param3: ${param3} \n`;
		result += `args: ${args.join(',')}`;

		return result;
	}
});
```

Now, when calling it with `--help`, a better help section will be shown:

```bash
Description:

  Just an example that will do nothing but concat all the parameters.

Usage:

  $ some-command  [options] [args...]

Options:

  --param1
  --param2
  --param3
  --args
```

### Providing more information about the expected options
`cliss(cliSpec)`

The options were effortlessly extracted from the parameters names, but **cliss** provides a way for one to provide more information about each of them. The *Object Literal* passed in the *cliSpec* parameter can have a property named **options**, which expects an *Array* of objects, containing the **name** of the option plus some of the following properties:

* **required**
To tell if the parameter is required.

* **description**
To give hints or explain what the option is about.

* **type**
To define how the parser should treat the option (Array, Object, String, Number, etc.). Check [yargs-parser](https://github.com/yargs/yargs-parser) for instructions about *type*, as it is the engine being used to parse the options.

* **alias**
To define an alias for the option.

Following the last example, let's improve it to:
 * give more information about **param1**
 * check **args** as required

```javascript
cliss({
	name: 'some-command',
	description: 'Just an example that will do nothing but concat all the parameters.',
	version: '1.0.0',
	options: [{
		name: 'param1',
		description: 'This param is the base value to compute everything else.',
		required: true,
		type: 'String'
	}, {
		name: 'args',
		required: true
	}],
	action: (param1, param2, { someProp: [[ param3 ]] = [[]] } = {}, ...args) => {
		let result = `param1: ${param1} \n`;
		result += `param2: ${param2} \n`;
		result += `param3: ${param3} \n`;
		result += `args: ${args.join(',')}`;

		return result;
	}
});
```

Call `--help`, and note that the *Usage* section will also be affected. Now *[options] [args...]* will be shown as *<options> <args...>*, because both of them are required.

```bash
Description:

  Just an example that will do nothing but logging all the parameters.

Usage:

  $ some-command  <options> <args...>

Options:

  --param1 String   Required - This param is the base value to compute
                    everything else.
  --param2
  --param3
  --args            Required
```

Run the program with the following options:
`node cli.js --param1=001 --param2=002 --param3=PARAM3 a r g s`

And check the result to see how *param1* was indeed treated as a string, while *param2* was parsed as a number:

```bash
param1: 001
param2: 2
param3: PARAM3
args: a,r,g,s
```

### Pipe: STDIN, Before and After
`cliss(cliSpec)`

A property named **pipe** can also be defined on *cliSpec* in order to handle **stdin** and also, some steps of the execution flow (**before** and **after**). To define a single handle for all the commands, the **pipe** option can be defined on [Cliss options](#cliss-options) as will be shown later on the documentation. The pipeline execution of a command is:

**stdin** *(command.pipe.stdin || clissOptions.pipe.stdin)* =>
=> **clissOptions.pipe.before** =>
=> **command.pipe.before** =>
=> **command.action** =>
=> **command.pipe.after** =>
=> **clissOptions.pipe.after**
=> **stdout**

Where each of these steps can be handled if needed.

The properties expected by **pipe** are:

* **stdin**
`(stdinValue, args, positionalArgs, argsAfterEndOfOptions)`

* **before**
`(args, positionalArgs, argsAfterEndOfOptions)`
To transform the data being input, before it is passed in to the main command action.

* **after**
`(result, parsedArgs, positionalArgs, argsAfterEndOfOptions)`
To transform the *output* (for example, to JSON.stringify an *Object Literal*)

Note: **stdin** and **before** must always return *args*, and **after** must always return *result*, as these values will be passed in for the next function in the pipeline.

To better explain with an example, let's modify the previous one to:

* get *param3* from **stdin**
* use **before** to reverse *...args* array
* use **after** to decorate the output

Check the *pipe* property on the following code:

```javascript
cliss({
	name: 'some-command',
	description: 'Just an example that will do nothing but concat all the parameters.',
	version: '1.0.0',
	options: [{
		name: 'param1',
		description: 'This param is needed to compute everything else.',
		required: true,
		type: 'String'
	}, {
		name: 'args',
		required: true
	}],
	pipe: {
		stdin: (stdinValue, args, positionalArgs, argsAfterEndOfOptions) => {
			args.param3 = stdinValue;
			return args;
		},
		before: (args, positionalArgs, argsAfterEndOfOptions) => {
			positionalArgs.reverse();
			return args;
		},
		after: (result, parsedArgs, positionalArgs, argsAfterEndOfOptions) => {
			return `======\n${result}\n======`;
		}
	},
	action: (param1, param2, { someProp: [[ param3 ]] = [[]] } = {}, ...args) => {
		let result = `param1: ${param1} \n`;
		result += `param2: ${param2} \n`;
		result += `param3: ${param3} \n`;
		result += `args: ${args.join(',')}`;

		return result;
	}
});
```

Calling it as:
`echo "fromSTDIN" | node cli.js --param1=001 --param2=002 a r g s`

Will result in:

```bash
=======
param1: 001
param2: 2
param3: fromSTDIN
args: s,g,r,a
=======
```

### Subcommands

Subcommands can be defined in a very simple way. Thinking naturally, a subcommand should be just a command that comes nested into another one, and it is exactly how it's done.

Here one more property of the *cliSpec* is introduced: **commands**. It is an *Array* that can contains N commands, including the **commands** property (commands can be nested down to N levels).

As each subcommand is a command itself, they also counts with its own `--help` section, and possibly its own `--version` (if it is not defined for a subcommand, the one defined for the root will be shown).

The following example will introduce:

* 1 subcommand, thas has no action, and contains more 2 subcommands
* 1 subcommand that contains an action

```javascript
cliss({
	name: 'some-command',
	description: 'Just an example that will do nothing but concat all the parameters.',
	version: '1.0.0',
	options: [{
		name: 'param1',
		description: 'This param is the base value to compute everything else.',
		required: true,
		type: 'String'
	}, {
		name: 'args',
		required: true
	}],
	pipe: {
		stdin: (stdinValue, args, positionalArgs, argsAfterEndOfOptions) => {
			args.param3 = stdinValue;
			return args;
		},
		before: (args, positionalArgs, argsAfterEndOfOptions) => {
			positionalArgs.reverse();
			return args;
		},
		after: (result, parsedArgs, positionalArgs, argsAfterEndOfOptions) => {
			return `======\n${result}\n======`;
		}
	},
	action: (param1, param2, { someProp: [[ param3 ]] = [[]] } = {}, ...args) => {
		let result = `param1: ${param1} \n`;
		result += `param2: ${param2} \n`;
		result += `param3: ${param3} \n`;
		result += `args: ${args.join(',')}`;

		return result;
	},
	commands: [{
		name: 'subcommand1',
		commands: [{
			name: 'action1',
			options: [{
				name: 'param',
				required: true
			}],
			action: param => `subcommand1 action1 param: ${param}`
		}, {
			name: 'action2',
			action: () => 'subcommand1 action2'
		}]
	}, {
		name: 'subcommand2',
		action: () => console.log('subcommand2')
	}]
});
```

Call `--help` to see that a new section *Commands:* is presented:

```bash
Description:

  Just an example that will do nothing but concat all the parameters.

Usage:

  $ some-command  <options> <args...>
  $ some-command  [command]

Options:

  --param1 String   Required - This param is needed to compute
                    everything else.
  --param2
  --param3
  --args            Required

Commands:

  subcommand1
  subcommand2
```

Each subcomand has its own help section, check:
`node cli.js subcommand1 --help`

```bash
Usage:

  $ some-command subcommand1
```

`node cli.js subcommand2 --help`:

```bash
Usage:

  $ some-command subcommand2 <command>

Commands:

  action1
  action2
```

Just call the commands names separated by space:
`node cli.js subcommand2 action1 --param=VALUE`

Result:

```bash
subcommand2 action1 param: VALUE
```

### Cliss options
`cliss(cliSpec, clissOptions)`

An `Object Literal` with the following options can be passed in as the second parameter to cliss:

* **command**

  * **subcommandsDelimiter**
  To define a delimiter for a subcommand to be used instead of a white space. For example, if `'-'` is passed in, the subcommands should be called as `subcommand1-action1` instead of `subcommand1 action1`.

* **options**

  * **validateRequiredParameters**
  If set to `true`, the required parameters will be checked before the command action is called, and the help section will be shown in case a required parameter is missing.

* **help**
  * **option**
  	To define a different option name to show the help section. For example, if `'helpsection'` is passed in, `--helpsection` must be used instead of `--help`.

  * **stripAnsi**
  	Set to `true` to strip all ansi escape codes (colors, underline, etc.) and output just a raw text.

* **version**
  * **option**
  To define a different option name to show the version. For example, if `'moduleversion'` is passed in, `--moduleversion` must be used instead of `--version`.

* **pipe**
As it is defined on *cliSpec* for each command, **pipe** can also be defined in *clissOptions* to implement for all commands a unique way to handle **stdin** and also, some steps of the execution flow (**before** and **after**) in case it is needed. The pipeline execution of a command is:
**stdin** *(command.pipe.stdin || clissOptions.pipe.stdin)* =>
=> **clissOptions.pipe.before** =>
=> **command.pipe.before** =>
=> **command.action** =>
=> **command.pipe.after** =>
=> **clissOptions.pipe.after**
=> **stdout**
The properties expected by **pipe** are:

  * **stdin**
`(stdinValue, args, positionalArgs, argsAfterEndOfOptions)`

  * **before**
`(args, positionalArgs, argsAfterEndOfOptions)`
To transform the data being input, before it is passed in to the main command action.

  * **after**
`(result, parsedArgs, positionalArgs, argsAfterEndOfOptions)`
To transform the *output* (for example, to JSON.stringify an *Object Literal*)

Note: **stdin** and **before** must always return *args*, and **after** must always return *result*, as these values will be passed in for the next function in the pipeline.

````

### clone-deep@4.0.1

From https://github.com/jonschlinkert/clone-deep.

**MIT**:

Copyright: Copyright (c) 2014-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### clone@1.0.4

From https://github.com/pvorb/node-clone.

**MIT**:

```
Copyright © 2011-2015 Paul Vorbach <paul@vorba.ch>

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the “Software”), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### collection-visit@1.0.0

From https://github.com/jonschlinkert/collection-visit.

**MIT**:

Copyright: Copyright (c) 2015, 2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### color-convert@1.9.3, color-convert@2.0.1

From https://github.com/Qix-/color-convert.

**MIT**:

Copyright: Copyright (c) 2011-2016 Heather Arthur <fayearthur@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### color-name@1.1.3

From https://github.com/dfcreative/color-name.

**MIT**:

```
The MIT License (MIT)
Copyright (c) 2015 Dmitry Ivanov

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

### color-name@1.1.4

From https://github.com/colorjs/color-name.

**MIT**:

```
The MIT License (MIT)
Copyright (c) 2015 Dmitry Ivanov

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

### color-string@1.9.0, color-string@1.9.1

From https://github.com/Qix-/color-string.

**MIT**:

Copyright: Copyright (c) 2011 Heather Arthur <fayearthur@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### color-support@1.1.3

From https://github.com/isaacs/color-support.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### color@3.2.1, color@4.2.3

From https://github.com/Qix-/color.

**MIT**:

Copyright: Copyright (c) 2012 Heather Arthur

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### colorette@1.4.0, colorette@2.0.19

From https://github.com/jorgebucaran/colorette.

**MIT**:

Copyright: Copyright © Jorge Bucaran <<https://jorgebucaran.com>>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### combined-stream@1.0.8

From https://github.com/felixge/node-combined-stream.

**MIT**:

Copyright: Copyright (c) 2011 Debuggable Limited <felix@debuggable.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### command-exists@1.2.9

From https://github.com/mathisonian/command-exists.

**MIT**:

Copyright: Copyright (c) 2014 Matthew Conlen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### command-line-usage@4.1.0

From https://github.com/75lb/command-line-usage.

**MIT**:

Copyright: Copyright (c) 2015-18 Lloyd Brookes <75pound@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### commander@12.1.0, commander@2.14.1, commander@2.20.3, commander@4.1.1, commander@7.2.0, commander@8.3.0, commander@9.5.0, commander@10.0.0

From https://github.com/tj/commander.js.

**MIT**:

Copyright: Copyright (c) 2011 TJ Holowaychuk <tj@vision-media.ca>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### commondir@1.0.1

From https://github.com/substack/node-commondir.

**MIT**:

Copyright: Copyright (c) 2013 James Halliday (mail@substack.net)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### compare-versions@6.1.1

From https://github.com/omichelsen/compare-versions.

**MIT**:

Copyright: Copyright (c) 2015-2021 Ole Michelsen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### component-emitter@1.3.0

From https://github.com/component/emitter.

**MIT**:

```
(The MIT License)

Copyright (c) 2014 Component contributors <dev@component.io>

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

```

### component-emitter@2.0.0

From https://github.com/sindresorhus/component-emitter.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### compressible@2.0.18

From https://github.com/jshttp/compressible.

**MIT**:

Copyright: Copyright (c) 2015 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### compression@1.7.4

From https://github.com/expressjs/compression.

**MIT**:

Copyright: Copyright (c) 2014-2015 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### concat-map@0.0.1

From https://github.com/substack/node-concat-map.

**MIT**:

```
This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### connect@3.7.0

From https://github.com/senchalabs/connect.

**MIT**:

Copyright: Copyright (c) 2015 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### console-control-strings@1.1.0

From https://github.com/iarna/console-control-strings.

**ISC**:

```
Copyright (c) 2014, Rebecca Turner <me@re-becca.org>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### constants-browserify@1.0.0

From https://github.com/juliangruber/constants-browserify.

**MIT**:

Copyright: Copyright (c) 2013 Julian Gruber <julian@juliangruber.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### convert-source-map@1.8.0, convert-source-map@2.0.0

From https://github.com/thlorenz/convert-source-map.

**MIT**:

Copyright: Copyright 2013 Thorsten Lorenz. 

All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### copy-descriptor@0.1.1

From https://github.com/jonschlinkert/copy-descriptor.

**MIT**:

Copyright: Copyright (c) 2015-2016, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### core-js-compat@3.19.3, core-js-compat@3.41.0

From https://github.com/zloirock/core-js.

**MIT**:

Copyright: Copyright (c) 2014-2021 Denis Pushkarev

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### core-util-is@1.0.2, core-util-is@1.0.3

From https://github.com/isaacs/core-util-is.

**MIT**:

Copyright: Copyright Node.js contributors. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cosmiconfig@5.2.1

From https://github.com/davidtheclark/cosmiconfig.

**MIT**:

Copyright: Copyright (c) 2015 David Clark

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cosmiconfig@9.0.0

From https://github.com/cosmiconfig/cosmiconfig.

**MIT**:

Copyright: Copyright (c) 2015 David Clark

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### create-ecdh@4.0.4

From https://github.com/crypto-browserify/createECDH.

**MIT**:

Copyright: Copyright (c) 2014-2017 createECDH contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### create-hash@1.2.0

From https://github.com/crypto-browserify/createHash.

**MIT**:

Copyright: Copyright (c) 2017 crypto-browserify contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### create-hmac@1.1.7

From https://github.com/crypto-browserify/createHmac.

**MIT**:

Copyright: Copyright (c) 2017 crypto-browserify contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### crelt@1.0.5, crelt@1.0.6

From https://github.com/marijnh/crelt.

**MIT**:

Copyright: Copyright (C) 2020 by Marijn Haverbeke <marijnh@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cross-fetch@3.1.8

From https://github.com/lquixada/cross-fetch.

**MIT**:

Copyright: Copyright (c) 2017 Leonardo Quixadá

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cross-spawn@6.0.5, cross-spawn@7.0.3, cross-spawn@7.0.6

From https://github.com/moxystudio/node-cross-spawn.

**MIT**:

Copyright: Copyright (c) 2018 Made With MOXY Lda <hello@moxy.studio>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### crypt@0.0.2

From https://github.com/pvorb/node-crypt.

**BSD-3-Clause**:

```
Copyright © 2011, Paul Vorbach. All rights reserved.
Copyright © 2009, Jeff Mott. All rights reserved.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name Crypto-JS nor the names of its contributors may be used to
  endorse or promote products derived from this software without specific prior
  written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### crypto-browserify@3.12.1

From https://github.com/browserify/crypto-browserify.

**MIT**:

Copyright: Copyright (c) 2013 Dominic Tarr

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### crypto-random-string@2.0.0

From https://github.com/sindresorhus/crypto-random-string.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### css-in-js-utils@3.1.0

From https://github.com/robinweser/css-in-js-utils.

**MIT**:

Copyright: Copyright (c) 2017 Robin Frischmann

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### css-select@5.1.0

From https://github.com/fb55/css-select.

**BSD-2-Clause**:

```
Copyright (c) Felix Böhm
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### css-tree@1.1.3

From https://github.com/csstree/csstree.

**MIT**:

Copyright: Copyright (C) 2016-2019 by Roman Dvornov

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### css-what@6.1.0

From https://github.com/fb55/css-what.

**BSD-2-Clause**:

```
Copyright (c) Felix Böhm
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### cssstyle@4.6.0

From https://github.com/jsdom/cssstyle.

**MIT**:

Copyright: Copyright (c) Chad Walker

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### csstype@3.0.10

From https://github.com/frenic/csstype.

**MIT**:

```
Copyright (c) 2017-2018 Fredrik Nicol

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### dashdash@1.14.1

From https://github.com/trentm/node-dashdash.

**MIT**:

```
# This is the MIT license

Copyright (c) 2013 Trent Mick. All rights reserved.
Copyright (c) 2013 Joyent Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


```

### data-urls@5.0.0

From https://github.com/jsdom/data-urls.

**MIT**:

Copyright: Copyright © Domenic Denicola <d@domenic.me>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### datauri@4.1.0

From https://github.com/data-uri/datauri.

**MIT**:


````
<h1 align="center">
  <br>
  <img width="365" src="https://cdn.rawgit.com/data-uri/datauri/master/media/datauri.svg" alt="datauri">
  <br>
  <br>
  <br>
</h1>

Node.js [Module](#module) and [CLI](http://npm.im/datauri-cli) to generate [Data URI scheme](http://en.wikipedia.org/wiki/Data_URI_scheme).

> The data URI scheme is a uniform resource identifier (URI) scheme that provides a way to include data in-line in web pages as if they were external resources.

from: [Wikipedia](http://en.wikipedia.org/wiki/Data_URI_scheme)

## MODULE [![Build Status](https://github.com/data-uri/datauri/actions/workflows/main.yml/badge.svg?branch=main)](https://github.com/data-uri/datauri/actions/workflows/main.yml?query=branch%3Amain)

`npm install datauri`

### Getting started

By default, datauri module returns a promise, which is resolved with `data:uri` string or rejected with read file error:

```js
const datauri = require('datauri');

const content = await datauri('test/myfile.png');

console.log(content);
//=> "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAA..."
```

### Callback style and meta data

```js
const datauri = require('datauri');

datauri('test/myfile.png', (err, content, meta) => {
  if (err) {
    throw err;
  }

  console.log(content); //=> "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAA..."

  console.log(meta.mimetype); //=> "image/png"
  console.log(meta.base64); //=> "iVBORw0KGgoAAAANSUhEUgAA..."
  console.log(meta.buffer); //=> file buffer
});
```

### CSS parser

```js
const datauriCSS = require('datauri/css');

await datauriCSS('test/myfile.png');
//=> "\n.case {\n    background-image: url('data:image/png; base64,iVBORw..."

await datauriCSS('test/myfile.png', {
  className: 'myClass',
  width: true,
  height: true
});
//=> adds image width and height and custom class name
```

### Synchronous calls

```js
const Datauri = require('datauri/sync');
const meta = Datauri('test/myfile.png');

console.log(meta.content); //=> "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAA..."
console.log(meta.mimetype); //=> "image/png"
console.log(meta.base64); //=> "iVBORw0KGgoAAAANSUhEUgAA..."
console.log(meta.buffer); //=> file buffer
```

### From a Buffer

If you already have a file Buffer, that's the way to go:

```js
const DatauriParser = require('datauri/parser');
const parser = new DatauriParser();

const buffer = fs.readFileSync('./hello');

parser.format('.png', buffer); //=> "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAA..."
```

### From a string

```js
const DatauriParser = require('datauri/parser');
const parser = new DatauriParser();

parser.format('.png', 'xkcd'); //=> "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAA..."
```

## Contribute

```CLI
$ npm install
```

To run test specs

```CLI
$ npm test
```

## [ChangeLog](https://github.com/data-uri/datauri/releases)

## Requirements

Node.js 10+

### Previous Node versions and deprecated features:

Node.js 8
`npm install --save datauri@3`
docs: https://github.com/data-uri/datauri/blob/v3.0.0/docs/datauri.md

Node.js 4+
`npm install --save datauri@2`
docs: https://github.com/data-uri/datauri/blob/v2.0.0/docs/datauri.md

## License

MIT License

(c) [Data-URI.js](https://github.com/data-uri)

(c) [Helder Santana](https://heldr.com)


````

### dayjs@1.10.7, dayjs@1.11.13

From https://github.com/iamkun/dayjs.

**MIT**:

Copyright: Copyright (c) 2018-present, iamkun

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### debug@2.6.9, debug@3.2.7, debug@4.3.1

From https://github.com/visionmedia/debug.

**MIT**:

Copyright: Copyright (c) 2014 TJ Holowaychuk <tj@vision-media.ca>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### debug@4.3.3, debug@4.3.4, debug@4.4.0, debug@4.4.1

From https://github.com/debug-js/debug.

**MIT**:

Copyright: Copyright (c) 2018-2021 Josh Junon

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### decamelize@1.2.0

From https://github.com/sindresorhus/decamelize.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### decimal.js@10.6.0

From https://github.com/MikeMcl/decimal.js.

**MIT**:

```
The MIT Licence.

Copyright (c) 2025 Michael Mclaughlin

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


```

### decode-uri-component@0.2.0, decode-uri-component@0.2.2

From https://github.com/SamVerschueren/decode-uri-component.

**MIT**:

Copyright: Copyright (c) Sam Verschueren <sam.verschueren@gmail.com> (github.com/SamVerschueren)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### deep-extend@0.6.0

From https://github.com/unclechu/node-deep-extend.

**MIT**:

Copyright: Copyright (c) 2013-2018, Viacheslav Lotsmanov

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### deep-is@0.1.4

From https://github.com/thlorenz/deep-is.

**MIT**:

```
Copyright (c) 2012, 2013 Thorsten Lorenz <thlorenz@gmx.de>
Copyright (c) 2012 James Halliday <mail@substack.net>
Copyright (c) 2009 Thomas Robinson <280north.com>

This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### deepmerge@2.2.1

From https://github.com/KyleAMathews/deepmerge.

**MIT**:

Copyright: Copyright (c) 2012 Nicholas Fisher

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### deepmerge@3.3.0, deepmerge@4.3.1

From https://github.com/TehShrike/deepmerge.

**MIT**:

Copyright: Copyright (c) 2012 James Halliday, Josh Duff, and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### defaults@1.0.3

From https://github.com/tmpvar/defaults.

**MIT**:

Copyright: Copyright (c) 2015 Elijah Insua

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### define-data-property@1.1.4

From https://github.com/ljharb/define-data-property.

**MIT**:

Copyright: Copyright (c) 2023 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### define-lazy-prop@2.0.0

From https://github.com/sindresorhus/define-lazy-prop.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### define-properties@1.1.3

From https://github.com/ljharb/define-properties.

**MIT**:

Copyright: Copyright (C) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### define-property@0.2.5, define-property@1.0.0, define-property@2.0.2

From https://github.com/jonschlinkert/define-property.

**MIT**:

Copyright: Copyright (c) 2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### delayed-stream@1.0.0

From https://github.com/felixge/node-delayed-stream.

**MIT**:

Copyright: Copyright (c) 2011 Debuggable Limited <felix@debuggable.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### delegates@1.0.0

From https://github.com/visionmedia/node-delegates.

**MIT**:

Copyright: Copyright (c) 2015 TJ Holowaychuk <tj@vision-media.ca>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### denodeify@1.2.1

From https://github.com/matthew-andrews/denodeify.

**MIT**:


````
denodeify [ ![Codeship Status for matthew-andrews/denodeify](https://codeship.io/projects/02ac77d0-1a58-0132-bf86-4a07366ee29d/status)](https://codeship.io/projects/34622)
=========

Tool to turn functions with Node-style callback APIs into functions that return [Promises](https://github.com/jakearchibald/es6-promise).

Inspired by and adapted from Q's [`Q.denodeify`/`Q.nfcall` function](https://github.com/kriskowal/q/wiki/API-Reference#qnfbindnodefunc-args).

Warning: This micro-library doesn't force you to use any particular Promise implementation by using whatever `Promise` has been defined as globally.  This is so that you may use any ES6 standard Promise compliant library - or, of course, native ES6 Promises.

If you're running the code on a browser or node version that doesn't include native promises you will need to include a polyfill.  The following polyfills are tested as part of this module's test suite:-
- [Jake Archibald](https://twitter.com/jaffathecake)'s [ES6 Promise library](https://github.com/jakearchibald/es6-promise) (which is actually adapted from [Stefan Penner](https://twitter.com/stefanpenner)'s [RSVP.js](https://github.com/tildeio/rsvp.js)). -  `require('es6-promise').polyfill();`
- [Getify](https://twitter.com/getify)'s [Native Promise Only library](https://github.com/getify/native-promise-only) - `require('native-promise-only');`
- [ES6 Shim](https://github.com/es-shims/es6-shim) - `require('es6-shim');`
- [Calvin Metcalf](https://twitter.com/CWMma)'s [Lie](https://github.com/calvinmetcalf/lie) - `global.Promise = global.Promise || require('lie');`

Note: as of v1.2.0 you can use **denodeify** in the front end.  Pull it in via CommonJS, AMD or simply add to your webpage and it'll be available on `window.denodeify`. 

## Installation

```
npm install denodeify --save
```

Or:-

```
bower install denodeify --save
```

## Examples

Simple example with [`readFile`](https://www.npmjs.org/package/read-file):-

```js
require('es6-promise').polyfill();

var denodeify = require('denodeify');
var readFile = denodeify(require('fs').readFile);

readFile('my-file.txt', { encoding: 'UTF-8' })
  .then(function(text) {
    console.log("My file's contents is: " + text);
  });
```

(Note: you will need to also install [es6-promise](https://github.com/jakearchibald/es6-promise) with `npm install es6-promise` for this code sample to work within node versions that don't have `Promise` natively available)

More complex example with `exec`:-

## Advanced usage

You can also pass in a function as a second argument of `denodeify` that allows you to manipulate the data returned by the wrapped function before it gets passed to the Promise's `reject` or `resolve` functions, for example:-

```js
require('es6-promise').polyfill();

var denodeify = require('denodeify');
var exec = denodeify(require('child_process').exec, function(err, stdout, stderr) {

  // Throw away stderr data
  return [err, stdout];
});

exec('hostname')
  .then(function(host) {
    console.log("My hostname is: " + host.replace('\n', ''));
  });
```

Or,

```js
require('es6-promise').polyfill();

var denodeify = require('denodeify');
var exec = denodeify(require('child_process').exec, function(err, stdout, stderr) {
  return [err, [stdout, stderr]];
});

exec('my-command')
  .then(function(results) {
    console.log("stdout is: " + results[0]);
    console.log("stderr is: " + results[1]);
  });
```

Useful for functions that return multiple arguments, for example [`child_process#exec`](http://nodejs.org/api/child_process.html#child_process_child_process_exec_command_options_callback).

## Credits and collaboration ##

The lead developer of **denodeify** is [Matt Andrews](http://twitter.com/andrewsmatt) at FT Labs with much help and support from [Kornel Lesiński](https://twitter.com/pornelski). All open source code released by FT Labs is licenced under the MIT licence. We welcome comments, feedback and suggestions.  Please feel free to raise an issue or pull request.


````

### depd@2.0.0

From https://github.com/dougwilson/nodejs-depd.

**MIT**:

Copyright: Copyright (c) 2014-2018 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### deprecated-react-native-prop-types@5.0.0

From https://github.com/facebook/react-native-deprecated-modules.

**MIT**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### des.js@1.0.1

From https://github.com/indutny/des.js.

**MIT**:

```
## LICENSE

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2015.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### destroy@1.0.4, destroy@1.2.0

From https://github.com/stream-utils/destroy.

**MIT**:

Copyright: Copyright (c) 2014 Jonathan Ong me@jongleberry.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### detect-libc@1.0.3, detect-libc@2.0.1, detect-libc@2.0.4

From https://github.com/lovell/detect-libc.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "{}"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright {yyyy} {name of copyright owner}

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### diff-match-patch@1.0.5

From https://github.com/JackuB/diff-match-patch.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
```

### diffie-hellman@5.0.3

From https://github.com/crypto-browserify/diffie-hellman.

**MIT**:

Copyright: Copyright (c) 2017 Calvin Metcalf

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### dom-serializer@2.0.0

From https://github.com/cheeriojs/dom-serializer.

**MIT**:

```
License

(The MIT License)

Copyright (c) 2014 The cheeriojs contributors

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 'Software'), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### domelementtype@2.3.0

From https://github.com/fb55/domelementtype.

**BSD-2-Clause**:

```
Copyright (c) Felix Böhm
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### domhandler@5.0.3

From https://github.com/fb55/domhandler.

**BSD-2-Clause**:

```
Copyright (c) Felix Böhm
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### dompurify@3.2.6

From https://github.com/cure53/DOMPurify.

**(MPL-2.0 OR Apache-2.0)**:

```
DOMPurify
Copyright 2025 Dr.-Ing. Mario Heiderich, Cure53

DOMPurify is free software; you can redistribute it and/or modify it under the
terms of either:

a) the Apache License Version 2.0, or
b) the Mozilla Public License Version 2.0

-----------------------------------------------------------------------------

                                 Apache License
                           Version 2.0, January 2004
                        http://www.apache.org/licenses/

   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

   1. Definitions.

      "License" shall mean the terms and conditions for use, reproduction,
      and distribution as defined by Sections 1 through 9 of this document.

      "Licensor" shall mean the copyright owner or entity authorized by
      the copyright owner that is granting the License.

      "Legal Entity" shall mean the union of the acting entity and all
      other entities that control, are controlled by, or are under common
      control with that entity. For the purposes of this definition,
      "control" means (i) the power, direct or indirect, to cause the
      direction or management of such entity, whether by contract or
      otherwise, or (ii) ownership of fifty percent (50%) or more of the
      outstanding shares, or (iii) beneficial ownership of such entity.

      "You" (or "Your") shall mean an individual or Legal Entity
      exercising permissions granted by this License.

      "Source" form shall mean the preferred form for making modifications,
      including but not limited to software source code, documentation
      source, and configuration files.

      "Object" form shall mean any form resulting from mechanical
      transformation or translation of a Source form, including but
      not limited to compiled object code, generated documentation,
      and conversions to other media types.

      "Work" shall mean the work of authorship, whether in Source or
      Object form, made available under the License, as indicated by a
      copyright notice that is included in or attached to the work
      (an example is provided in the Appendix below).

      "Derivative Works" shall mean any work, whether in Source or Object
      form, that is based on (or derived from) the Work and for which the
      editorial revisions, annotations, elaborations, or other modifications
      represent, as a whole, an original work of authorship. For the purposes
      of this License, Derivative Works shall not include works that remain
      separable from, or merely link (or bind by name) to the interfaces of,
      the Work and Derivative Works thereof.

      "Contribution" shall mean any work of authorship, including
      the original version of the Work and any modifications or additions
      to that Work or Derivative Works thereof, that is intentionally
      submitted to Licensor for inclusion in the Work by the copyright owner
      or by an individual or Legal Entity authorized to submit on behalf of
      the copyright owner. For the purposes of this definition, "submitted"
      means any form of electronic, verbal, or written communication sent
      to the Licensor or its representatives, including but not limited to
      communication on electronic mailing lists, source code control systems,
      and issue tracking systems that are managed by, or on behalf of, the
      Licensor for the purpose of discussing and improving the Work, but
      excluding communication that is conspicuously marked or otherwise
      designated in writing by the copyright owner as "Not a Contribution."

      "Contributor" shall mean Licensor and any individual or Legal Entity
      on behalf of whom a Contribution has been received by Licensor and
      subsequently incorporated within the Work.

   2. Grant of Copyright License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      copyright license to reproduce, prepare Derivative Works of,
      publicly display, publicly perform, sublicense, and distribute the
      Work and such Derivative Works in Source or Object form.

   3. Grant of Patent License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      (except as stated in this section) patent license to make, have made,
      use, offer to sell, sell, import, and otherwise transfer the Work,
      where such license applies only to those patent claims licensable
      by such Contributor that are necessarily infringed by their
      Contribution(s) alone or by combination of their Contribution(s)
      with the Work to which such Contribution(s) was submitted. If You
      institute patent litigation against any entity (including a
      cross-claim or counterclaim in a lawsuit) alleging that the Work
      or a Contribution incorporated within the Work constitutes direct
      or contributory patent infringement, then any patent licenses
      granted to You under this License for that Work shall terminate
      as of the date such litigation is filed.

   4. Redistribution. You may reproduce and distribute copies of the
      Work or Derivative Works thereof in any medium, with or without
      modifications, and in Source or Object form, provided that You
      meet the following conditions:

      (a) You must give any other recipients of the Work or
          Derivative Works a copy of this License; and

      (b) You must cause any modified files to carry prominent notices
          stating that You changed the files; and

      (c) You must retain, in the Source form of any Derivative Works
          that You distribute, all copyright, patent, trademark, and
          attribution notices from the Source form of the Work,
          excluding those notices that do not pertain to any part of
          the Derivative Works; and

      (d) If the Work includes a "NOTICE" text file as part of its
          distribution, then any Derivative Works that You distribute must
          include a readable copy of the attribution notices contained
          within such NOTICE file, excluding those notices that do not
          pertain to any part of the Derivative Works, in at least one
          of the following places: within a NOTICE text file distributed
          as part of the Derivative Works; within the Source form or
          documentation, if provided along with the Derivative Works; or,
          within a display generated by the Derivative Works, if and
          wherever such third-party notices normally appear. The contents
          of the NOTICE file are for informational purposes only and
          do not modify the License. You may add Your own attribution
          notices within Derivative Works that You distribute, alongside
          or as an addendum to the NOTICE text from the Work, provided
          that such additional attribution notices cannot be construed
          as modifying the License.

      You may add Your own copyright statement to Your modifications and
      may provide additional or different license terms and conditions
      for use, reproduction, or distribution of Your modifications, or
      for any such Derivative Works as a whole, provided Your use,
      reproduction, and distribution of the Work otherwise complies with
      the conditions stated in this License.

   5. Submission of Contributions. Unless You explicitly state otherwise,
      any Contribution intentionally submitted for inclusion in the Work
      by You to the Licensor shall be under the terms and conditions of
      this License, without any additional terms or conditions.
      Notwithstanding the above, nothing herein shall supersede or modify
      the terms of any separate license agreement you may have executed
      with Licensor regarding such Contributions.

   6. Trademarks. This License does not grant permission to use the trade
      names, trademarks, service marks, or product names of the Licensor,
      except as required for reasonable and customary use in describing the
      origin of the Work and reproducing the content of the NOTICE file.

   7. Disclaimer of Warranty. Unless required by applicable law or
      agreed to in writing, Licensor provides the Work (and each
      Contributor provides its Contributions) on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
      implied, including, without limitation, any warranties or conditions
      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
      PARTICULAR PURPOSE. You are solely responsible for determining the
      appropriateness of using or redistributing the Work and assume any
      risks associated with Your exercise of permissions under this License.

   8. Limitation of Liability. In no event and under no legal theory,
      whether in tort (including negligence), contract, or otherwise,
      unless required by applicable law (such as deliberate and grossly
      negligent acts) or agreed to in writing, shall any Contributor be
      liable to You for damages, including any direct, indirect, special,
      incidental, or consequential damages of any character arising as a
      result of this License or out of the use or inability to use the
      Work (including but not limited to damages for loss of goodwill,
      work stoppage, computer failure or malfunction, or any and all
      other commercial damages or losses), even if such Contributor
      has been advised of the possibility of such damages.

   9. Accepting Warranty or Additional Liability. While redistributing
      the Work or Derivative Works thereof, You may choose to offer,
      and charge a fee for, acceptance of support, warranty, indemnity,
      or other liability obligations and/or rights consistent with this
      License. However, in accepting such obligations, You may act only
      on Your own behalf and on Your sole responsibility, not on behalf
      of any other Contributor, and only if You agree to indemnify,
      defend, and hold each Contributor harmless for any liability
      incurred by, or claims asserted against, such Contributor by reason
      of your accepting any such warranty or additional liability.

   END OF TERMS AND CONDITIONS

   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

-----------------------------------------------------------------------------
Mozilla Public License, version 2.0

1. Definitions

1.1. “Contributor”

     means each individual or legal entity that creates, contributes to the
     creation of, or owns Covered Software.

1.2. “Contributor Version”

     means the combination of the Contributions of others (if any) used by a
     Contributor and that particular Contributor’s Contribution.

1.3. “Contribution”

     means Covered Software of a particular Contributor.

1.4. “Covered Software”

     means Source Code Form to which the initial Contributor has attached the
     notice in Exhibit A, the Executable Form of such Source Code Form, and
     Modifications of such Source Code Form, in each case including portions
     thereof.

1.5. “Incompatible With Secondary Licenses”
     means

     a. that the initial Contributor has attached the notice described in
        Exhibit B to the Covered Software; or

     b. that the Covered Software was made available under the terms of version
        1.1 or earlier of the License, but not also under the terms of a
        Secondary License.

1.6. “Executable Form”

     means any form of the work other than Source Code Form.

1.7. “Larger Work”

     means a work that combines Covered Software with other material, in a separate
     file or files, that is not Covered Software.

1.8. “License”

     means this document.

1.9. “Licensable”

     means having the right to grant, to the maximum extent possible, whether at the
     time of the initial grant or subsequently, any and all of the rights conveyed by
     this License.

1.10. “Modifications”

     means any of the following:

     a. any file in Source Code Form that results from an addition to, deletion
        from, or modification of the contents of Covered Software; or

     b. any new file in Source Code Form that contains any Covered Software.

1.11. “Patent Claims” of a Contributor

      means any patent claim(s), including without limitation, method, process,
      and apparatus claims, in any patent Licensable by such Contributor that
      would be infringed, but for the grant of the License, by the making,
      using, selling, offering for sale, having made, import, or transfer of
      either its Contributions or its Contributor Version.

1.12. “Secondary License”

      means either the GNU General Public License, Version 2.0, the GNU Lesser
      General Public License, Version 2.1, the GNU Affero General Public
      License, Version 3.0, or any later versions of those licenses.

1.13. “Source Code Form”

      means the form of the work preferred for making modifications.

1.14. “You” (or “Your”)

      means an individual or a legal entity exercising rights under this
      License. For legal entities, “You” includes any entity that controls, is
      controlled by, or is under common control with You. For purposes of this
      definition, “control” means (a) the power, direct or indirect, to cause
      the direction or management of such entity, whether by contract or
      otherwise, or (b) ownership of more than fifty percent (50%) of the
      outstanding shares or beneficial ownership of such entity.


2. License Grants and Conditions

2.1. Grants

     Each Contributor hereby grants You a world-wide, royalty-free,
     non-exclusive license:

     a. under intellectual property rights (other than patent or trademark)
        Licensable by such Contributor to use, reproduce, make available,
        modify, display, perform, distribute, and otherwise exploit its
        Contributions, either on an unmodified basis, with Modifications, or as
        part of a Larger Work; and

     b. under Patent Claims of such Contributor to make, use, sell, offer for
        sale, have made, import, and otherwise transfer either its Contributions
        or its Contributor Version.

2.2. Effective Date

     The licenses granted in Section 2.1 with respect to any Contribution become
     effective for each Contribution on the date the Contributor first distributes
     such Contribution.

2.3. Limitations on Grant Scope

     The licenses granted in this Section 2 are the only rights granted under this
     License. No additional rights or licenses will be implied from the distribution
     or licensing of Covered Software under this License. Notwithstanding Section
     2.1(b) above, no patent license is granted by a Contributor:

     a. for any code that a Contributor has removed from Covered Software; or

     b. for infringements caused by: (i) Your and any other third party’s
        modifications of Covered Software, or (ii) the combination of its
        Contributions with other software (except as part of its Contributor
        Version); or

     c. under Patent Claims infringed by Covered Software in the absence of its
        Contributions.

     This License does not grant any rights in the trademarks, service marks, or
     logos of any Contributor (except as may be necessary to comply with the
     notice requirements in Section 3.4).

2.4. Subsequent Licenses

     No Contributor makes additional grants as a result of Your choice to
     distribute the Covered Software under a subsequent version of this License
     (see Section 10.2) or under the terms of a Secondary License (if permitted
     under the terms of Section 3.3).

2.5. Representation

     Each Contributor represents that the Contributor believes its Contributions
     are its original creation(s) or it has sufficient rights to grant the
     rights to its Contributions conveyed by this License.

2.6. Fair Use

     This License is not intended to limit any rights You have under applicable
     copyright doctrines of fair use, fair dealing, or other equivalents.

2.7. Conditions

     Sections 3.1, 3.2, 3.3, and 3.4 are conditions of the licenses granted in
     Section 2.1.


3. Responsibilities

3.1. Distribution of Source Form

     All distribution of Covered Software in Source Code Form, including any
     Modifications that You create or to which You contribute, must be under the
     terms of this License. You must inform recipients that the Source Code Form
     of the Covered Software is governed by the terms of this License, and how
     they can obtain a copy of this License. You may not attempt to alter or
     restrict the recipients’ rights in the Source Code Form.

3.2. Distribution of Executable Form

     If You distribute Covered Software in Executable Form then:

     a. such Covered Software must also be made available in Source Code Form,
        as described in Section 3.1, and You must inform recipients of the
        Executable Form how they can obtain a copy of such Source Code Form by
        reasonable means in a timely manner, at a charge no more than the cost
        of distribution to the recipient; and

     b. You may distribute such Executable Form under the terms of this License,
        or sublicense it under different terms, provided that the license for
        the Executable Form does not attempt to limit or alter the recipients’
        rights in the Source Code Form under this License.

3.3. Distribution of a Larger Work

     You may create and distribute a Larger Work under terms of Your choice,
     provided that You also comply with the requirements of this License for the
     Covered Software. If the Larger Work is a combination of Covered Software
     with a work governed by one or more Secondary Licenses, and the Covered
     Software is not Incompatible With Secondary Licenses, this License permits
     You to additionally distribute such Covered Software under the terms of
     such Secondary License(s), so that the recipient of the Larger Work may, at
     their option, further distribute the Covered Software under the terms of
     either this License or such Secondary License(s).

3.4. Notices

     You may not remove or alter the substance of any license notices (including
     copyright notices, patent notices, disclaimers of warranty, or limitations
     of liability) contained within the Source Code Form of the Covered
     Software, except that You may alter any license notices to the extent
     required to remedy known factual inaccuracies.

3.5. Application of Additional Terms

     You may choose to offer, and to charge a fee for, warranty, support,
     indemnity or liability obligations to one or more recipients of Covered
     Software. However, You may do so only on Your own behalf, and not on behalf
     of any Contributor. You must make it absolutely clear that any such
     warranty, support, indemnity, or liability obligation is offered by You
     alone, and You hereby agree to indemnify every Contributor for any
     liability incurred by such Contributor as a result of warranty, support,
     indemnity or liability terms You offer. You may include additional
     disclaimers of warranty and limitations of liability specific to any
     jurisdiction.

4. Inability to Comply Due to Statute or Regulation

   If it is impossible for You to comply with any of the terms of this License
   with respect to some or all of the Covered Software due to statute, judicial
   order, or regulation then You must: (a) comply with the terms of this License
   to the maximum extent possible; and (b) describe the limitations and the code
   they affect. Such description must be placed in a text file included with all
   distributions of the Covered Software under this License. Except to the
   extent prohibited by statute or regulation, such description must be
   sufficiently detailed for a recipient of ordinary skill to be able to
   understand it.

5. Termination

5.1. The rights granted under this License will terminate automatically if You
     fail to comply with any of its terms. However, if You become compliant,
     then the rights granted under this License from a particular Contributor
     are reinstated (a) provisionally, unless and until such Contributor
     explicitly and finally terminates Your grants, and (b) on an ongoing basis,
     if such Contributor fails to notify You of the non-compliance by some
     reasonable means prior to 60 days after You have come back into compliance.
     Moreover, Your grants from a particular Contributor are reinstated on an
     ongoing basis if such Contributor notifies You of the non-compliance by
     some reasonable means, this is the first time You have received notice of
     non-compliance with this License from such Contributor, and You become
     compliant prior to 30 days after Your receipt of the notice.

5.2. If You initiate litigation against any entity by asserting a patent
     infringement claim (excluding declaratory judgment actions, counter-claims,
     and cross-claims) alleging that a Contributor Version directly or
     indirectly infringes any patent, then the rights granted to You by any and
     all Contributors for the Covered Software under Section 2.1 of this License
     shall terminate.

5.3. In the event of termination under Sections 5.1 or 5.2 above, all end user
     license agreements (excluding distributors and resellers) which have been
     validly granted by You or Your distributors under this License prior to
     termination shall survive termination.

6. Disclaimer of Warranty

   Covered Software is provided under this License on an “as is” basis, without
   warranty of any kind, either expressed, implied, or statutory, including,
   without limitation, warranties that the Covered Software is free of defects,
   merchantable, fit for a particular purpose or non-infringing. The entire
   risk as to the quality and performance of the Covered Software is with You.
   Should any Covered Software prove defective in any respect, You (not any
   Contributor) assume the cost of any necessary servicing, repair, or
   correction. This disclaimer of warranty constitutes an essential part of this
   License. No use of  any Covered Software is authorized under this License
   except under this disclaimer.

7. Limitation of Liability

   Under no circumstances and under no legal theory, whether tort (including
   negligence), contract, or otherwise, shall any Contributor, or anyone who
   distributes Covered Software as permitted above, be liable to You for any
   direct, indirect, special, incidental, or consequential damages of any
   character including, without limitation, damages for lost profits, loss of
   goodwill, work stoppage, computer failure or malfunction, or any and all
   other commercial damages or losses, even if such party shall have been
   informed of the possibility of such damages. This limitation of liability
   shall not apply to liability for death or personal injury resulting from such
   party’s negligence to the extent applicable law prohibits such limitation.
   Some jurisdictions do not allow the exclusion or limitation of incidental or
   consequential damages, so this exclusion and limitation may not apply to You.

8. Litigation

   Any litigation relating to this License may be brought only in the courts of
   a jurisdiction where the defendant maintains its principal place of business
   and such litigation shall be governed by laws of that jurisdiction, without
   reference to its conflict-of-law provisions. Nothing in this Section shall
   prevent a party’s ability to bring cross-claims or counter-claims.

9. Miscellaneous

   This License represents the complete agreement concerning the subject matter
   hereof. If any provision of this License is held to be unenforceable, such
   provision shall be reformed only to the extent necessary to make it
   enforceable. Any law or regulation which provides that the language of a
   contract shall be construed against the drafter shall not be used to construe
   this License against a Contributor.


10. Versions of the License

10.1. New Versions

      Mozilla Foundation is the license steward. Except as provided in Section
      10.3, no one other than the license steward has the right to modify or
      publish new versions of this License. Each version will be given a
      distinguishing version number.

10.2. Effect of New Versions

      You may distribute the Covered Software under the terms of the version of
      the License under which You originally received the Covered Software, or
      under the terms of any subsequent version published by the license
      steward.

10.3. Modified Versions

      If you create software not governed by this License, and you want to
      create a new license for such software, you may create and use a modified
      version of this License if you rename the license and remove any
      references to the name of the license steward (except to note that such
      modified license differs from this License).

10.4. Distributing Source Code Form that is Incompatible With Secondary Licenses
      If You choose to distribute Source Code Form that is Incompatible With
      Secondary Licenses under the terms of this version of the License, the
      notice described in Exhibit B of this License must be attached.

Exhibit A - Source Code Form License Notice

      This Source Code Form is subject to the
      terms of the Mozilla Public License, v.
      2.0. If a copy of the MPL was not
      distributed with this file, You can
      obtain one at
      http://mozilla.org/MPL/2.0/.

If it is not possible or desirable to put the notice in a particular file, then
You may include the notice in a location (such as a LICENSE file in a relevant
directory) where a recipient would be likely to look for such a notice.

You may add additional accurate notices of copyright ownership.

Exhibit B - “Incompatible With Secondary Licenses” Notice

      This Source Code Form is “Incompatible
      With Secondary Licenses”, as defined by
      the Mozilla Public License, v. 2.0.


```

### domutils@3.1.0, domutils@3.2.2

From https://github.com/fb55/domutils.

**BSD-2-Clause**:

```
Copyright (c) Felix Böhm
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### dotenv-expand@11.0.6

From https://github.com/motdotla/dotenv-expand.

**BSD-2-Clause**:

```
Copyright (c) 2016, Scott Motte
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


```

### dotenv@16.4.5

From https://github.com/motdotla/dotenv.

**BSD-2-Clause**:

```
Copyright (c) 2015, Scott Motte
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### dunder-proto@1.0.1

From https://github.com/es-shims/dunder-proto.

**MIT**:

Copyright: Copyright (c) 2024 ECMAScript Shims

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### eastasianwidth@0.2.0

From https://github.com/komagata/eastasianwidth.

**MIT**:

Copyright: Copyright komagata

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ecc-jsbn@0.1.2

From https://github.com/quartzjer/ecc-jsbn.

**MIT**:

Copyright: Copyright (c) 2014 Jeremie Miller

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ee-first@1.1.1

From https://github.com/jonathanong/ee-first.

**MIT**:

Copyright: Copyright (c) 2014 Jonathan Ong me@jongleberry.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### electron-to-chromium@1.4.11, electron-to-chromium@1.4.284, electron-to-chromium@1.4.565, electron-to-chromium@1.5.4, electron-to-chromium@1.5.83

From https://github.com/kilian/electron-to-chromium.

**ISC**:

```
Copyright 2018 Kilian Valkhof

Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### elliptic@6.5.4, elliptic@6.6.1

From https://github.com/indutny/elliptic.

**MIT**:

```
#### LICENSE

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2014.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

[0]: http://tools.ietf.org/html/rfc6979
[1]: https://github.com/indutny/bn.js
[2]: https://github.com/indutny/hash.js
[3]: https://github.com/bitchan/eccrypto
[4]: https://github.com/wanderer/secp256k1-node

```

### emoji-regex@8.0.0, emoji-regex@9.2.2

From https://github.com/mathiasbynens/emoji-regex.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### encodeurl@1.0.2, encodeurl@2.0.0

From https://github.com/pillarjs/encodeurl.

**MIT**:

Copyright: Copyright (c) 2016 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### encoding@0.1.13

From https://github.com/andris9/encoding.

**MIT**:

```
Copyright (c) 2012-2014 Andris Reinman

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### end-of-stream@1.4.4

From https://github.com/mafintosh/end-of-stream.

**MIT**:

Copyright: Copyright (c) 2014 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### entities@2.2.0, entities@3.0.1, entities@4.4.0, entities@6.0.1

From https://github.com/fb55/entities.

**BSD-2-Clause**:

```
Copyright (c) Felix Böhm
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### env-editor@0.4.2

From https://github.com/sindresorhus/env-editor.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### env-paths@2.2.1

From https://github.com/sindresorhus/env-paths.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### envinfo@7.14.0, envinfo@7.8.1

From https://github.com/tabrindle/envinfo.

**MIT**:

Copyright: Copyright (c) 2018 Trevor Brindle

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### err-code@2.0.3

From https://github.com/IndigoUnited/js-err-code.

**MIT**:

```
## License

Released under the [MIT License](http://www.opensource.org/licenses/mit-license.php).

```

### error-ex@1.3.2

From https://github.com/qix-/node-error-ex.

**MIT**:

Copyright: Copyright (c) 2015 JD Ballard

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### error-stack-parser@2.0.6

From https://github.com/stacktracejs/error-stack-parser.

**MIT**:

Copyright: Copyright (c) 2017 Eric Wendelin and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### errorhandler@1.5.1

From https://github.com/expressjs/errorhandler.

**MIT**:

Copyright: Copyright (c) 2014-2015 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es-abstract@1.19.1

From https://github.com/ljharb/es-abstract.

**MIT**:

Copyright: Copyright (C) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es-define-property@1.0.0, es-define-property@1.0.1

From https://github.com/ljharb/es-define-property.

**MIT**:

Copyright: Copyright (c) 2024 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es-errors@1.3.0

From https://github.com/ljharb/es-errors.

**MIT**:

Copyright: Copyright (c) 2024 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es-object-atoms@1.0.0, es-object-atoms@1.1.1

From https://github.com/ljharb/es-object-atoms.

**MIT**:

Copyright: Copyright (c) 2024 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es-set-tostringtag@2.1.0

From https://github.com/es-shims/es-set-tostringtag.

**MIT**:

Copyright: Copyright (c) 2022 ECMAScript Shims

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es-to-primitive@1.2.1

From https://github.com/ljharb/es-to-primitive.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es6-object-assign@1.1.0

From https://github.com/rubennorte/es6-object-assign.

**MIT**:

```
Copyright (c) 2015-2017 Rubén Norte <rubennorte@gmail.com>

MIT License

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### escalade@3.1.1, escalade@3.1.2, escalade@3.2.0

From https://github.com/lukeed/escalade.

**MIT**:

Copyright: Copyright (c) Luke Edwards <luke.edwards05@gmail.com> (lukeed.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### escape-html@1.0.3

From https://github.com/component/escape-html.

**MIT**:

Copyright: Copyright (c) 2015 Tiancheng "Timothy" Gu

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### escape-string-regexp@1.0.5, escape-string-regexp@2.0.0, escape-string-regexp@4.0.0

From https://github.com/sindresorhus/escape-string-regexp.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### esprima@4.0.1

From https://github.com/jquery/esprima.

**BSD-2-Clause**:

```
Copyright JS Foundation and other contributors, https://js.foundation/

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### etag@1.8.1

From https://github.com/jshttp/etag.

**MIT**:

Copyright: Copyright (c) 2014-2016 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### event-target-shim@5.0.1

From https://github.com/mysticatea/event-target-shim.

**MIT**:

Copyright: Copyright (c) 2015 Toru Nagashima

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### events@3.3.0, events@1.1.1

From https://github.com/Gozala/events.

**MIT**:

```
MIT

Copyright Joyent, Inc. and other Node contributors.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### evp_bytestokey@1.0.3

From https://github.com/crypto-browserify/EVP_BytesToKey.

**MIT**:

Copyright: Copyright (c) 2017 crypto-browserify contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### exec-async@2.2.0

From https://github.com/ccheever/exec-async.

**MIT**:

Copyright: Copyright (c) 2015 Charlie Cheever

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### execa@1.0.0, execa@5.1.1

From https://github.com/sindresorhus/execa.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### expand-brackets@2.1.4

From https://github.com/jonschlinkert/expand-brackets.

**MIT**:

Copyright: Copyright (c) 2015-2016, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### exponential-backoff@3.1.1

From https://github.com/coveo/exponential-backoff.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
```

### extend-shallow@2.0.1, extend-shallow@3.0.2

From https://github.com/jonschlinkert/extend-shallow.

**MIT**:

Copyright: Copyright (c) 2014-2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### extend@3.0.2

From https://github.com/justmoon/node-extend.

**MIT**:

Copyright: Copyright (c) 2014 Stefan Thomas

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### extglob@2.0.4

From https://github.com/micromatch/extglob.

**MIT**:

Copyright: Copyright (c) 2015-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### extsprintf@1.3.0, extsprintf@1.4.1

From https://github.com/davepacheco/node-extsprintf.

**MIT**:

```
Copyright (c) 2012, Joyent, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE

```

### fast-base64-decode@1.0.0

From https://github.com/LinusU/fast-base64-decode.

**MIT**:


````
# Fast Base64 Decoding

A fast Base64 decoder with a low level API. If you want a high level API, look at [base64-js](https://github.com/beatgammit/base64-js).

## Installation

```sh
npm install --save fast-base64-decode
```

## Usage

```js
const base64Decode = require('fast-base64-decode')

// You need to know the length of the decoded data
const result = new Uint8Array(13)

// Pass the string to decode, and a `UInt8Array` where the bytes will be written
base64Decode('SGVsbG8sIFdvcmxkIQ==', result)
```


````

### fast-deep-equal@3.1.3

From https://github.com/epoberezkin/fast-deep-equal.

**MIT**:

Copyright: Copyright (c) 2017 Evgeny Poberezkin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fast-fifo@1.3.0

From https://github.com/mafintosh/fast-fifo.

**MIT**:

Copyright: Copyright (c) 2019 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fast-glob@3.3.2

From https://github.com/mrmlnc/fast-glob.

**MIT**:

Copyright: Copyright (c) Denis Malinochkin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fast-json-stable-stringify@2.1.0

From https://github.com/epoberezkin/fast-json-stable-stringify.

**MIT**:

Copyright: Copyright (c) 2013 James Halliday

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fast-xml-parser@3.21.1, fast-xml-parser@4.1.2, fast-xml-parser@4.5.3

From https://github.com/NaturalIntelligence/fast-xml-parser.

**MIT**:

Copyright: Copyright (c) 2017 Amit Kumar Gupta

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fastq@1.13.0

From https://github.com/mcollina/fastq.

**ISC**:

```
Copyright (c) 2015-2020, Matteo Collina <matteo.collina@gmail.com>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### file-type@16.5.4

From https://github.com/sindresorhus/file-type.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fill-range@4.0.0, fill-range@7.0.1

From https://github.com/jonschlinkert/fill-range.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### filter-obj@1.1.0

From https://github.com/sindresorhus/filter-obj.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### finalhandler@1.1.2

From https://github.com/pillarjs/finalhandler.

**MIT**:

Copyright: Copyright (c) 2014-2017 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### find-cache-dir@2.1.0

From https://github.com/avajs/find-cache-dir.

**MIT**:

Copyright: Copyright (c) James Talmage <james@talmage.io> (github.com/jamestalmage)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### find-up@2.1.0, find-up@3.0.0, find-up@4.1.0, find-up@5.0.0

From https://github.com/sindresorhus/find-up.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### follow-redirects@1.15.6

From https://github.com/follow-redirects/follow-redirects.

**MIT**:

Copyright: Copyright 2014–present Olivier Lalonde <olalonde@gmail.com>, James Talmage <james@talmage.io>, Ruben Verborgh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### font-awesome-filetypes@2.1.0

From https://github.com/spatie/font-awesome-filetypes.

**MIT**:

```
# The MIT License (MIT)

Copyright (c) Sebastian De Deyne <sebastian@spatie.be>

> Permission is hereby granted, free of charge, to any person obtaining a copy
> of this software and associated documentation files (the "Software"), to deal
> in the Software without restriction, including without limitation the rights
> to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
> copies of the Software, and to permit persons to whom the Software is
> furnished to do so, subject to the following conditions:
>
> The above copyright notice and this permission notice shall be included in
> all copies or substantial portions of the Software.
>
> THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
> IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
> FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
> AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
> LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
> OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
> THE SOFTWARE.

```

### fontfaceobserver@2.3.0

From https://github.com/bramstein/fontfaceobserver.

**BSD-2-Clause**:

```
Copyright (c) 2014 - Bram Stein

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### for-in@1.0.2

From https://github.com/jonschlinkert/for-in.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### foreach@2.0.5

From https://github.com/manuelstofer/foreach.

**MIT**:

Copyright: Copyright (c) 2013 Manuel Stofer

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### foreground-child@3.1.1, foreground-child@3.3.1

From https://github.com/tapjs/foreground-child.

**ISC**:

```
The ISC License

Copyright (c) 2015-2023 Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### forever-agent@0.6.1

From https://github.com/mikeal/forever-agent.

**Apache-2.0**:

```
Apache License

Version 2.0, January 2004

http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.

"Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.

2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.

3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.

4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of this License; and

You must cause any modified files to carry prominent notices stating that You changed the files; and

You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and

If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.

5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.

7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.

8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS
```

### form-data@2.3.3, form-data@4.0.4

From https://github.com/form-data/form-data.

**MIT**:

Copyright: Copyright (c) 2012 Felix Geisendörfer (felix@debuggable.com) and contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fragment-cache@0.2.1

From https://github.com/jonschlinkert/fragment-cache.

**MIT**:

Copyright: Copyright (c) 2016-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### freeport-async@2.0.0

From https://github.com/expo/freeport-async.

**MIT**:

Copyright: Copyright (c) 2015 650 Industries

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fresh@0.5.2

From https://github.com/jshttp/fresh.

**MIT**:

Copyright: Copyright (c) 2016-2017 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fs-extra@0.26.7, fs-extra@1.0.0, fs-extra@11.2.0, fs-extra@8.1.0

From https://github.com/jprichardson/node-fs-extra.

**MIT**:

Copyright: Copyright (c) 2011-2016 JP Richardson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fs.realpath@1.0.0

From https://github.com/isaacs/fs.realpath.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

----

This library bundles a version of the `fs.realpath` and `fs.realpathSync`
methods from Node.js v0.10 under the terms of the Node.js MIT license.

Node's license follows, also included at the header of `old.js` which contains
the licensed code:

  Copyright Joyent, Inc. and other Node contributors.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.

```

### fsevents@2.3.2

From https://github.com/fsevents/fsevents.

**MIT**:

```
MIT License
-----------

Copyright (C) 2010-2020 by Philipp Dunkel, Ben Noordhuis, Elan Shankar, Paul Miller

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### function-bind@1.1.1, function-bind@1.1.2

From https://github.com/Raynos/function-bind.

**MIT**:

Copyright: Copyright (c) 2013 Raynos.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### gauge@3.0.2

From https://github.com/iarna/gauge.

**ISC**:

```
Copyright (c) 2014, Rebecca Turner <me@re-becca.org>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### gauge@4.0.0

From https://github.com/npm/gauge.

**ISC**:

```
<!-- This file is automatically added by @npmcli/template-oss. Do not edit. -->

ISC License

Copyright npm, Inc.

Permission to use, copy, modify, and/or distribute this
software for any purpose with or without fee is hereby
granted, provided that the above copyright notice and this
permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND NPM DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
EVENT SHALL NPM BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.

```

### gensync@1.0.0-beta.2

From https://github.com/loganfsmyth/gensync.

**MIT**:

Copyright: Copyright 2018 Logan Smyth <loganfsmyth@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### get-caller-file@2.0.5

From https://github.com/stefanpenner/get-caller-file.

**ISC**:

```
ISC License (ISC)
Copyright 2018 Stefan Penner

Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### get-intrinsic@1.1.1, get-intrinsic@1.1.3, get-intrinsic@1.2.4, get-intrinsic@1.3.0

From https://github.com/ljharb/get-intrinsic.

**MIT**:

Copyright: Copyright (c) 2020 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### get-package-type@0.1.0

From https://github.com/cfware/get-package-type.

**MIT**:

Copyright: Copyright (c) 2020 CFWare, LLC

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### get-proto@1.0.1

From https://github.com/ljharb/get-proto.

**MIT**:

Copyright: Copyright (c) 2025 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### get-prototype-chain@1.0.1

From https://github.com/leahciMic/get-prototype-chain.

**ISC**:


````
# get-prototype-chain [![Build Status](https://travis-ci.org/leahciMic/get-prototype-chain.svg?branch=master)](https://travis-ci.org/leahciMic/get-prototype-chain)

Returns an array with the passed in object's prototype chain (in
ascending order).

## Install

```sh
npm install --save get-prototype-chain
```

## Usage

```js
const getPrototypeChain = require('get-prototype-chain');

class A {

}

class B extends A {

}

class C extends B {

}

var obj = new C();

getPrototypeChain(obj).map(x => x.constructor.name)

// returns ['C', 'C', 'B', 'A', 'Object']
```


````

### get-stdin@5.0.1

From https://github.com/sindresorhus/get-stdin.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### get-stream@4.1.0, get-stream@6.0.1, get-stream@5.2.0

From https://github.com/sindresorhus/get-stream.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### get-symbol-description@1.0.0

From https://github.com/inspect-js/get-symbol-description.

**MIT**:

Copyright: Copyright (c) 2021 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### get-value@2.0.6

From https://github.com/jonschlinkert/get-value.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### getenv@2.0.0

From https://github.com/ctavan/node-getenv.

**MIT**:

Copyright: Copyright (c) 2012-2019 Christoph Tavan <dev@tavan.de>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### getpass@0.1.7

From https://github.com/arekinath/node-getpass.

**MIT**:

Copyright: Copyright Joyent, Inc. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### glob-parent@5.1.2

From https://github.com/gulpjs/glob-parent.

**ISC**:

```
The ISC License

Copyright (c) 2015, 2019 Elan Shanker

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### glob@10.4.5, glob@11.0.3, glob@7.0.6, glob@7.2.0

From https://github.com/isaacs/node-glob.

**ISC**:

```
The ISC License

Copyright (c) 2009-2023 Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### globals@11.12.0

From https://github.com/sindresorhus/globals.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### gopd@1.0.1, gopd@1.2.0

From https://github.com/ljharb/gopd.

**MIT**:

Copyright: Copyright (c) 2022 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### graceful-fs@4.2.10, graceful-fs@4.2.8

From https://github.com/isaacs/node-graceful-fs.

**ISC**:

```
The ISC License

Copyright (c) 2011-2022 Isaac Z. Schlueter, Ben Noordhuis, and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### growly@1.3.0

From https://github.com/theabraham/growly.

**MIT**:


````
# Growly #

Simple zero-dependency Growl notifications using GNTP.

## Installation ##

Install growly using `npm`:

```
npm install growly
```

And then require it:

```javascript
var growly = require('growly');
```

This module uses the Growl Network Transport Protocol (GNTP) which was implemented in Growl since version 1.3, so you **must have an appropriate version of Growl installed** for Growly to work.

## Example ##

Sending a minimal Growl notification:

```javascript
var growly = require('growly');

growly.notify('This is as easy as it gets', { title: 'Hello, World!' });
```

More examples can be found in the *example/* directory.

## Usage ##

The growly module exposes only three methods: `Growly.register()`, `Growly.notify()`, and `Growly.setHost()`.

### Growly.register(appname, [appicon], [notifications], [callback]) ###

Registers a new application with Growl. Registration is completely optional since it will be performed automatically for you with sensible defaults. Useful if you want your application, with its own icon and types of notifications, to show up in Growl's prefence panel.

  - `appname` the name of the application (required.)
  - `appicon` url, file path, or Buffer instance for an application icon image.
  - `notifications` a list of defined notification types with the following properties:
    - `.label` name used to identify the type of notification being used (required.)
    - `.dispname` name users will see in Growl's preference panel (defaults to `.label`.)
    - `.enabled` whether or not notifications of this type are enabled (defaults to true.)
  - `callback` called when the registration completes; if registration fails, the first argument will be an Error object.

An example:

```javascript
growly.register('My Application', 'path/to/icon.png', [
    { label: 'success', dispname: 'Success' },
    { label: 'warning', dispname: 'Warning', enabled: false }
], function(err) {
    console.log(err || 'Registration successful!');
});
```

### Growly.notify(text, [opts], [callback]) ###

Sends a Growl notification. If an application wasn't registered beforehand with `growly.register()`, a default application will automatically be registered beforesending the notification.

  - `text` the body of the notification.
  - `opts` an object with the following properties:
    - `.title` title of the notification.
    - `.icon` url, file path, or Buffer instance for the notification's icon.
    - `.sticky` whether or not to sticky the notification (defaults to false.)
    - `.label` type of notification to use (defaults to the first registered notification type.)
    - `.priority` the priority of the notification from lowest (-2) to highest (2).
    - `.coalescingId` replace/update the matching previous notification. May be ignored.
  - `callback` called when the user has closed/clicked the notification. The callback is passed an Error object `err` as the first argument when the notification fails; otherwise, the second argument `action` is a string that'll describe which action has been taken by the user (either 'closed' or 'clicked'.)

An example:

```javascript
/* Assuming an application was registered with a notification type labeled 'warning'. */
growly.notify('Stuffs broken!', { label: 'warning' }, function(err, action) {
    console.log('Action:', action);
});
```

### Growly.setHost(host, port) ###

Set the host and port that Growl (GNTP) requests will be sent to. Using this method is optional since GNTP defaults to using host 'localhost' and port 23053.

## License ##

Copyright (C) 2014 Ibrahim Al-Rajhi <abrahamalrajhi@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


````

### har-schema@2.0.0

From https://github.com/ahmadnassri/har-schema.

**ISC**:

```
Copyright (c) 2015, Ahmad Nassri <ahmad@ahmadnassri.com>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### har-validator@5.1.5

From https://github.com/ahmadnassri/node-har-validator.

**MIT**:

Copyright: Copyright (c) 2018 Ahmad Nassri <ahmad@ahmadnassri.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-bigints@1.0.1

From https://github.com/ljharb/has-bigints.

**MIT**:

Copyright: Copyright (c) 2019 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-flag@3.0.0, has-flag@4.0.0

From https://github.com/sindresorhus/has-flag.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-property-descriptors@1.0.2

From https://github.com/inspect-js/has-property-descriptors.

**MIT**:

Copyright: Copyright (c) 2022 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-proto@1.0.1

From https://github.com/inspect-js/has-proto.

**MIT**:

Copyright: Copyright (c) 2022 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-symbols@1.0.2, has-symbols@1.0.3, has-symbols@1.1.0

From https://github.com/inspect-js/has-symbols.

**MIT**:

Copyright: Copyright (c) 2016 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-tostringtag@1.0.0, has-tostringtag@1.0.2

From https://github.com/inspect-js/has-tostringtag.

**MIT**:

Copyright: Copyright (c) 2021 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-unicode@2.0.1

From https://github.com/iarna/has-unicode.

**ISC**:

```
Copyright (c) 2014, Rebecca Turner <me@re-becca.org>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


```

### has-value@0.3.1, has-value@1.0.0

From https://github.com/jonschlinkert/has-value.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has-values@0.1.4, has-values@1.0.0

From https://github.com/jonschlinkert/has-values.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### has@1.0.3

From https://github.com/tarruda/has.

**MIT**:

Copyright: Copyright (c) 2013 Thiago de Arruda

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### hash-base@3.0.5, hash-base@3.1.0

From https://github.com/crypto-browserify/hash-base.

**MIT**:

Copyright: Copyright (c) 2016 Kirill Fomichev

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### hash.js@1.1.7

From https://github.com/indutny/hash.js.

**MIT**:

```
#### LICENSE

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2014.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### hasown@2.0.2

From https://github.com/inspect-js/hasOwn.

**MIT**:

Copyright: Copyright (c) Jordan Harband and contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### he@1.2.0

From https://github.com/mathiasbynens/he.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### hermes-profile-transformer@0.0.6

From https://github.com/MLH-Fellowship/hermes-profile-transformer.

**MIT**:

Copyright: Copyright (c) 2020 Saphal Patro and Jessie Anh Nguyen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### highlight.js@11.11.1

From https://github.com/highlightjs/highlight.js.

**BSD-3-Clause**:

```
BSD 3-Clause License

Copyright (c) 2006, Ivan Sagalaev.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### hmac-drbg@1.0.1

From https://github.com/indutny/hmac-drbg.

**MIT**:

```
#### LICENSE

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2017.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

[0]: http://csrc.nist.gov/groups/ST/toolkit/documents/rng/HashBlockCipherDRBG.pdf

```

### hoist-non-react-statics@3.3.2

From https://github.com/mridgway/hoist-non-react-statics.

**BSD-3-Clause**:

```
Software License Agreement (BSD License)
========================================

Copyright (c) 2015, Yahoo! Inc. All rights reserved.
----------------------------------------------------

Redistribution and use of this software in source and binary forms, with or
without modification, are permitted provided that the following conditions are
met:

  * Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the name of Yahoo! Inc. nor the names of YUI's contributors may be
    used to endorse or promote products derived from this software without
    specific prior written permission of Yahoo! Inc.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### hosted-git-info@7.0.2

From https://github.com/npm/hosted-git-info.

**ISC**:

```
Copyright (c) 2015, Rebecca Turner

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

```

### hpagent@1.2.0

From https://github.com/delvedor/hpagent.

**MIT**:

Copyright: Copyright (c) 2020 Tomas Della Vedova

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### html-encoding-sniffer@4.0.0

From https://github.com/jsdom/html-encoding-sniffer.

**MIT**:

Copyright: Copyright © Domenic Denicola <d@domenic.me>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### html-entities@1.4.0

From https://github.com/mdevils/node-html-entities.

**MIT**:

Copyright: Copyright (c) 2013 Dulin Marat

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### html-minifier@4.0.0

From https://github.com/kangax/html-minifier.

**MIT**:

Copyright: Copyright (c) 2010-2018 Juriy "kangax" Zaytsev

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### http-cache-semantics@4.1.0

From https://github.com/kornelski/http-cache-semantics.

**BSD-2-Clause**:

```
Copyright 2016-2018 Kornel Lesiński

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### http-errors@1.7.3, http-errors@1.8.1, http-errors@2.0.0

From https://github.com/jshttp/http-errors.

**MIT**:

Copyright: Copyright (c) 2016 Douglas Christopher Wilson doug@somethingdoug.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### http-proxy-agent@4.0.1

From https://github.com/TooTallNate/node-http-proxy-agent.

**MIT**:


````
http-proxy-agent
================
### An HTTP(s) proxy `http.Agent` implementation for HTTP
[![Build Status](https://github.com/TooTallNate/node-http-proxy-agent/workflows/Node%20CI/badge.svg)](https://github.com/TooTallNate/node-http-proxy-agent/actions?workflow=Node+CI)

This module provides an `http.Agent` implementation that connects to a specified
HTTP or HTTPS proxy server, and can be used with the built-in `http` module.

__Note:__ For HTTP proxy usage with the `https` module, check out
[`node-https-proxy-agent`](https://github.com/TooTallNate/node-https-proxy-agent).

Installation
------------

Install with `npm`:

``` bash
$ npm install http-proxy-agent
```


Example
-------

``` js
var url = require('url');
var http = require('http');
var HttpProxyAgent = require('http-proxy-agent');

// HTTP/HTTPS proxy to connect to
var proxy = process.env.http_proxy || 'http://168.63.76.32:3128';
console.log('using proxy server %j', proxy);

// HTTP endpoint for the proxy to connect to
var endpoint = process.argv[2] || 'http://nodejs.org/api/';
console.log('attempting to GET %j', endpoint);
var opts = url.parse(endpoint);

// create an instance of the `HttpProxyAgent` class with the proxy server information
var agent = new HttpProxyAgent(proxy);
opts.agent = agent;

http.get(opts, function (res) {
  console.log('"response" event!', res.headers);
  res.pipe(process.stdout);
});
```


License
-------

(The MIT License)

Copyright (c) 2013 Nathan Rajlich &lt;nathan@tootallnate.net&gt;

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


````

### http-signature@1.2.0

From https://github.com/joyent/node-http-signature.

**MIT**:

Copyright: Copyright Joyent, Inc. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### https-proxy-agent@5.0.0

From https://github.com/TooTallNate/node-https-proxy-agent.

**MIT**:


````
https-proxy-agent
================
### An HTTP(s) proxy `http.Agent` implementation for HTTPS
[![Build Status](https://github.com/TooTallNate/node-https-proxy-agent/workflows/Node%20CI/badge.svg)](https://github.com/TooTallNate/node-https-proxy-agent/actions?workflow=Node+CI)

This module provides an `http.Agent` implementation that connects to a specified
HTTP or HTTPS proxy server, and can be used with the built-in `https` module.

Specifically, this `Agent` implementation connects to an intermediary "proxy"
server and issues the [CONNECT HTTP method][CONNECT], which tells the proxy to
open a direct TCP connection to the destination server.

Since this agent implements the CONNECT HTTP method, it also works with other
protocols that use this method when connecting over proxies (i.e. WebSockets).
See the "Examples" section below for more.


Installation
------------

Install with `npm`:

``` bash
$ npm install https-proxy-agent
```


Examples
--------

#### `https` module example

``` js
var url = require('url');
var https = require('https');
var HttpsProxyAgent = require('https-proxy-agent');

// HTTP/HTTPS proxy to connect to
var proxy = process.env.http_proxy || 'http://168.63.76.32:3128';
console.log('using proxy server %j', proxy);

// HTTPS endpoint for the proxy to connect to
var endpoint = process.argv[2] || 'https://graph.facebook.com/tootallnate';
console.log('attempting to GET %j', endpoint);
var options = url.parse(endpoint);

// create an instance of the `HttpsProxyAgent` class with the proxy server information
var agent = new HttpsProxyAgent(proxy);
options.agent = agent;

https.get(options, function (res) {
  console.log('"response" event!', res.headers);
  res.pipe(process.stdout);
});
```

#### `ws` WebSocket connection example

``` js
var url = require('url');
var WebSocket = require('ws');
var HttpsProxyAgent = require('https-proxy-agent');

// HTTP/HTTPS proxy to connect to
var proxy = process.env.http_proxy || 'http://168.63.76.32:3128';
console.log('using proxy server %j', proxy);

// WebSocket endpoint for the proxy to connect to
var endpoint = process.argv[2] || 'ws://echo.websocket.org';
var parsed = url.parse(endpoint);
console.log('attempting to connect to WebSocket %j', endpoint);

// create an instance of the `HttpsProxyAgent` class with the proxy server information
var options = url.parse(proxy);

var agent = new HttpsProxyAgent(options);

// finally, initiate the WebSocket connection
var socket = new WebSocket(endpoint, { agent: agent });

socket.on('open', function () {
  console.log('"open" event!');
  socket.send('hello world');
});

socket.on('message', function (data, flags) {
  console.log('"message" event! %j %j', data, flags);
  socket.close();
});
```

API
---

### new HttpsProxyAgent(Object options)

The `HttpsProxyAgent` class implements an `http.Agent` subclass that connects
to the specified "HTTP(s) proxy server" in order to proxy HTTPS and/or WebSocket
requests. This is achieved by using the [HTTP `CONNECT` method][CONNECT].

The `options` argument may either be a string URI of the proxy server to use, or an
"options" object with more specific properties:

  * `host` - String - Proxy host to connect to (may use `hostname` as well). Required.
  * `port` - Number - Proxy port to connect to. Required.
  * `protocol` - String - If `https:`, then use TLS to connect to the proxy.
  * `headers` - Object - Additional HTTP headers to be sent on the HTTP CONNECT method.
  * Any other options given are passed to the `net.connect()`/`tls.connect()` functions.


License
-------

(The MIT License)

Copyright (c) 2013 Nathan Rajlich &lt;nathan@tootallnate.net&gt;

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

[CONNECT]: http://en.wikipedia.org/wiki/HTTP_tunnel#HTTP_CONNECT_Tunneling


````

### human-signals@2.1.0

From https://github.com/ehmicky/human-signals.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright 2019 ehmicky <ehmicky@gmail.com>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### humanize-ms@1.2.1

From https://github.com/node-modules/humanize-ms.

**MIT**:

```
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### hyphenate-style-name@1.1.0

From https://github.com/rexxars/hyphenate-style-name.

**BSD-3-Clause**:

```
BSD 3-Clause License

Copyright (c) 2015, Espen Hovlandsdal
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### iconv-lite@0.6.3

From https://github.com/ashtuchkin/iconv-lite.

**MIT**:

Copyright: Copyright (c) 2011 Alexander Shtuchkin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ieee754@1.2.1, ieee754@1.1.13

From https://github.com/feross/ieee754.

**BSD-3-Clause**:

```
Copyright 2008 Fair Oaks Labs, Inc.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### ignore@5.3.2

From https://github.com/kaelzhang/node-ignore.

**MIT**:

```
Copyright (c) 2013 Kael Zhang <i@kael.me>, contributors
http://kael.me/

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

### image-data-uri@2.0.1

From https://github.com/DiegoZoracKy/image-data-uri.

**MIT**:


````
# Image Data URI

Library to easily decode/encode Data URI images

## Installation

```bash
npm install image-data-uri
```
**CLI**
```bash
npm install image-data-uri -g
```
```bash
npx image-data-uri --help
```

## Methods

- **decode(dataURI)**
```javascript
imageDataURI.decode('data:image/png;base64,SOMEPNGDATAURI/wD/')

// RETURNS
{
    imageType: 'image/png',
    dataBase64: 'SOMEPNGDATAURI/wD/',
    dataBuffer: <Buffer 89 50 4e 47 0d 0a ...>
}
```

- **encode(data, mediaType)**
```javascript
// Expects a Buffer of a image file
let dataBuffer = new Buffer(imageData);

// PNG | GIF | etc.
let mediaType = 'PNG';

// RETURNS :: image data URI :: 'data:image/png;base64,PNGDATAURI/wD/'
imageDataURI.encode(dataBuffer, mediaType)
```

- **encodeFromURL(imageURL)**
```javascript
// Returns a Promise
imageDataURI.encodeFromURL('http://www.some-site.com/some-image.png')

    // RETURNS image data URI :: 'data:image/png;base64,PNGDATAURI/'
    .then(res => console.log(res))
```
- **encodeFromFile(filePath)**
```javascript
// Returns a Promise
imageDataURI.encodeFromFile('./some-file.png')

    // RETURNS image data URI :: 'data:image/png;base64,PNGDATAURI/'
    .then(res => console.log(res))
```
- **outputFile(dataURI, filePath)**
```javascript
// Some image data uri
let dataURI = 'data:image/png;base64,PNGDATAURI/';

// It will create the full path in case it doesn't exist
// If the extension is defined (e.g. fileName.png), it will be preserved, otherwise the lib will try to guess from the Data URI
let filePath = './out/path/fileName';

// Returns a Promise
imageDataURI.outputFile(dataURI, filePath)

    // RETURNS image path of the created file 'out/path/fileName.png'
    .then(res => console.log(res))
```


````

### image-size@0.6.3, image-size@1.0.0, image-size@1.1.1

From https://github.com/image-size/image-size.

**MIT**:

```
The MIT License (MIT)

Copyright © 2017 Aditya Yadav, http://netroy.in

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### immer@9.0.21

From https://github.com/immerjs/immer.

**MIT**:

Copyright: Copyright (c) 2017 Michel Weststrate

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### import-fresh@2.0.0, import-fresh@3.3.0

From https://github.com/sindresorhus/import-fresh.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### imurmurhash@0.1.4

From https://github.com/jensyt/imurmurhash-js.

**MIT**:

Copyright: Copyright (c) 2013 Gary Court, Jens Taylor

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### indent-string@4.0.0

From https://github.com/sindresorhus/indent-string.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### infer-owner@1.0.4

From https://github.com/npm/infer-owner.

**ISC**:

```
The ISC License

Copyright (c) npm, Inc. and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### inflight@1.0.6

From https://github.com/npm/inflight.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### inherits@2.0.4

From https://github.com/isaacs/inherits.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.


```

### ini@1.3.8

From https://github.com/isaacs/ini.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### inline-style-prefixer@7.0.1

From https://github.com/robinweser/inline-style-prefixer.

**MIT**:

Copyright: Copyright (c) 2015 Robin Frischmann

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### internal-slot@1.0.3

From https://github.com/ljharb/internal-slot.

**MIT**:

Copyright: Copyright (c) 2019 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### invariant@2.2.4

From https://github.com/zertosh/invariant.

**MIT**:

Copyright: Copyright (c) 2013-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ip-regex@4.3.0

From https://github.com/sindresorhus/ip-regex.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ip@1.1.5

From https://github.com/indutny/node-ip.

**MIT**:

```
### License

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2012.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### is-accessor-descriptor@0.1.6, is-accessor-descriptor@1.0.0

From https://github.com/jonschlinkert/is-accessor-descriptor.

**MIT**:

Copyright: Copyright (c) 2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-arguments@1.1.1

From https://github.com/inspect-js/is-arguments.

**MIT**:

Copyright: Copyright (c) 2014 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-arrayish@0.2.1, is-arrayish@0.3.2

From https://github.com/qix-/node-is-arrayish.

**MIT**:

Copyright: Copyright (c) 2015 JD Ballard

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-bigint@1.0.4

From https://github.com/inspect-js/is-bigint.

**MIT**:

Copyright: Copyright (c) 2018 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-binary-path@2.1.0

From https://github.com/sindresorhus/is-binary-path.

**MIT**:

Copyright: Copyright (c) 2019 Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com), Paul Miller (https://paulmillr.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-boolean-object@1.1.2

From https://github.com/inspect-js/is-boolean-object.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-buffer@1.1.6

From https://github.com/feross/is-buffer.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-callable@1.2.4

From https://github.com/inspect-js/is-callable.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-core-module@2.13.0, is-core-module@2.8.0

From https://github.com/inspect-js/is-core-module.

**MIT**:

Copyright: Copyright (c) 2014 Dave Justice

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-data-descriptor@0.1.4, is-data-descriptor@1.0.0

From https://github.com/jonschlinkert/is-data-descriptor.

**MIT**:

Copyright: Copyright (c) 2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-date-object@1.0.5

From https://github.com/inspect-js/is-date-object.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-descriptor@0.1.6, is-descriptor@1.0.2

From https://github.com/jonschlinkert/is-descriptor.

**MIT**:

Copyright: Copyright (c) 2015-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-directory@0.3.1

From https://github.com/jonschlinkert/is-directory.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-docker@2.2.1

From https://github.com/sindresorhus/is-docker.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-extendable@0.1.1, is-extendable@1.0.1

From https://github.com/jonschlinkert/is-extendable.

**MIT**:

Copyright: Copyright (c) 2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-extglob@2.1.1

From https://github.com/jonschlinkert/is-extglob.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-fullwidth-code-point@2.0.0, is-fullwidth-code-point@3.0.0

From https://github.com/sindresorhus/is-fullwidth-code-point.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-generator-function@1.0.10

From https://github.com/inspect-js/is-generator-function.

**MIT**:

Copyright: Copyright (c) 2014 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-glob@4.0.3

From https://github.com/micromatch/is-glob.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-interactive@1.0.0

From https://github.com/sindresorhus/is-interactive.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-lambda@1.0.1

From https://github.com/watson/is-lambda.

**MIT**:

Copyright: Copyright (c) 2016-2017 Thomas Watson Steen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-nan@1.3.2

From https://github.com/es-shims/is-nan.

**MIT**:

Copyright: Copyright (c) 2014 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-negative-zero@2.0.1

From https://github.com/inspect-js/is-negative-zero.

**MIT**:

Copyright: Copyright (c) 2014 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-number-object@1.0.6

From https://github.com/inspect-js/is-number-object.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-number@3.0.0, is-number@7.0.0

From https://github.com/jonschlinkert/is-number.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-plain-object@2.0.4

From https://github.com/jonschlinkert/is-plain-object.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-potential-custom-element-name@1.0.1

From https://github.com/mathiasbynens/is-potential-custom-element-name.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-regex@1.1.4

From https://github.com/inspect-js/is-regex.

**MIT**:

Copyright: Copyright (c) 2014 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-shared-array-buffer@1.0.1

From https://github.com/inspect-js/is-shared-array-buffer.

**MIT**:

Copyright: Copyright (c) 2021 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-stream@1.1.0, is-stream@2.0.1

From https://github.com/sindresorhus/is-stream.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-string@1.0.7

From https://github.com/ljharb/is-string.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-symbol@1.0.4

From https://github.com/inspect-js/is-symbol.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-typed-array@1.1.8

From https://github.com/inspect-js/is-typed-array.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-typedarray@1.0.0

From https://github.com/hughsk/is-typedarray.

**MIT**:

```
This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### is-unicode-supported@0.1.0

From https://github.com/sindresorhus/is-unicode-supported.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-url@1.2.4

From https://github.com/segmentio/is-url.

**MIT**:

```
MIT LICENSE

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### is-weakref@1.0.1

From https://github.com/inspect-js/is-weakref.

**MIT**:

Copyright: Copyright (c) 2020 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-windows@1.0.2

From https://github.com/jonschlinkert/is-windows.

**MIT**:

Copyright: Copyright (c) 2015-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is-wsl@1.1.0, is-wsl@2.2.0

From https://github.com/sindresorhus/is-wsl.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### is2@2.0.7

From https://github.com/stdarg/is2.

**MIT**:

Copyright: Copyright (c) 2013 Edmond Meinfelder

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### isarray@1.0.0

From https://github.com/juliangruber/isarray.

**MIT**:

Copyright: Copyright (c) 2013 Julian Gruber <julian@juliangruber.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### isexe@2.0.0

From https://github.com/isaacs/isexe.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### isobject@2.1.0, isobject@3.0.1

From https://github.com/jonschlinkert/isobject.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### isstream@0.1.2

From https://github.com/rvagg/isstream.

**MIT**:

```
The MIT License (MIT)
=====================

Copyright (c) 2015 Rod Vagg
---------------------------

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### istanbul-lib-coverage@3.2.0, istanbul-lib-instrument@5.1.0

From https://github.com/istanbuljs/istanbuljs.

**BSD-3-Clause**:

```
Copyright 2012-2015 Yahoo! Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Yahoo! Inc. nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL YAHOO! INC. BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### jackspeak@3.4.0, jackspeak@4.1.1

From https://github.com/isaacs/jackspeak.

**BlueOak-1.0.0**:

```
# Blue Oak Model License

Version 1.0.0

## Purpose

This license gives everyone as much permission to work with
this software as possible, while protecting contributors
from liability.

## Acceptance

In order to receive this license, you must agree to its
rules. The rules of this license are both obligations
under that agreement and conditions to your license.
You must not do anything with this software that triggers
a rule that you cannot or will not follow.

## Copyright

Each contributor licenses you to do everything with this
software that would otherwise infringe that contributor's
copyright in it.

## Notices

You must ensure that everyone who gets a copy of
any part of this software from you, with or without
changes, also gets the text of this license or a link to
<https://blueoakcouncil.org/license/1.0.0>.

## Excuse

If anyone notifies you in writing that you have not
complied with [Notices](#notices), you can keep your
license by taking all practical steps to comply within 30
days after the notice. If you do not do so, your license
ends immediately.

## Patent

Each contributor licenses you to do everything with this
software that would otherwise infringe any patent claims
they can license or become able to license.

## Reliability

No contributor can revoke this license.

## No Liability

**_As far as the law allows, this software comes as is,
without any warranty or condition, and no contributor
will be liable to anyone for any damages related to this
software or this license, under any kind of legal claim._**

```

### jimp-compact@0.16.1

From https://github.com/nuxt-community/jimp-compact.

**MIT**:

```
## License

MIT - Based on [Jimp](https://github.com/oliver-moran/jimp/blob/master/LICENSE)

```

### joi@17.5.0

From https://github.com/sideway/joi.

**BSD-3-Clause**:

```
Copyright (c) 2012-2020, Sideway. Inc, and project contributors.<br>
Copyright (c) 2012-2014, Walmart.<br>
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### js-tokens@4.0.0

From https://github.com/lydell/js-tokens.

**MIT**:

Copyright: Copyright (c) 2014, 2015, 2016, 2017, 2018 Simon Lydell

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### js-yaml@3.14.1, js-yaml@4.1.0

From https://github.com/nodeca/js-yaml.

**MIT**:

Copyright: Copyright (C) 2011-2015 by Vitaly Puzrin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### jsbn@0.1.1

From https://github.com/andyperlitch/jsbn.

**MIT**:

```
Licensing
---------

This software is covered under the following copyright:

/*
 * Copyright (c) 2003-2005  Tom Wu
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * In addition, the following condition applies:
 *
 * All redistributions must retain an intact copy of this copyright notice
 * and disclaimer.
 */

Address all questions regarding this license to:

  Tom Wu
  tjw@cs.Stanford.EDU
```

### jsc-android@250230.2.1

From https://github.com/react-native-community/jsc-android-buildscripts.

**BSD-2-Clause**:

```
BSD 2-Clause License

Copyright (c) 2017, Software Mansion Sp. z o. o. Sp. k. AND 650 Industries, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```

### jsc-safe-url@0.2.4

From https://github.com/robhogan/jsc-safe-url.

**0BSD**:

```
Zero-Clause BSD
=============

Permission to use, copy, modify, and/or distribute this software for
any purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED “AS IS” AND THE AUTHOR DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE
FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
```

### jscodeshift@0.13.1

From https://github.com/facebook/jscodeshift.

**MIT**:

Copyright: Copyright (c) Facebook, Inc. and its affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### jsdom@26.1.0

From https://github.com/jsdom/jsdom.

**MIT**:

Copyright: Copyright (c) 2010 Elijah Insua

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### jsesc@0.5.0, jsesc@2.5.2, jsesc@3.1.0

From https://github.com/mathiasbynens/jsesc.

**MIT**:

Copyright: Copyright Mathias Bynens <http://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### json-parse-better-errors@1.0.2

From https://github.com/zkat/json-parse-better-errors.

**MIT**:

Copyright: Copyright 2017 Kat Marchán

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### json-parse-even-better-errors@2.3.1

From https://github.com/npm/json-parse-even-better-errors.

**MIT**:

```
Copyright 2017 Kat Marchán
Copyright npm, Inc.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

---

This library is a fork of 'better-json-errors' by Kat Marchán, extended and
distributed under the terms of the MIT license above.

```

### json-schema-traverse@0.4.1

From https://github.com/epoberezkin/json-schema-traverse.

**MIT**:

Copyright: Copyright (c) 2017 Evgeny Poberezkin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### json-schema@0.4.0

From https://github.com/kriszyp/json-schema.

**(AFL-2.1 OR BSD-3-Clause)**:

```
Dojo is available under *either* the terms of the BSD 3-Clause "New" License *or* the
Academic Free License version 2.1. As a recipient of Dojo, you may choose which
license to receive this code under (except as noted in per-module LICENSE
files). Some modules may not be the copyright of the Dojo Foundation. These
modules contain explicit declarations of copyright in both the LICENSE files in
the directories in which they reside and in the code itself. No external
contributions are allowed under licenses which are fundamentally incompatible
with the AFL-2.1 OR and BSD-3-Clause licenses that Dojo is distributed under.

The text of the AFL-2.1 and BSD-3-Clause licenses is reproduced below. 

-------------------------------------------------------------------------------
BSD 3-Clause "New" License:
**********************

Copyright (c) 2005-2015, The Dojo Foundation
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the name of the Dojo Foundation nor the names of its contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

-------------------------------------------------------------------------------
The Academic Free License, v. 2.1:
**********************************

This Academic Free License (the "License") applies to any original work of
authorship (the "Original Work") whose owner (the "Licensor") has placed the
following notice immediately following the copyright notice for the Original
Work:

Licensed under the Academic Free License version 2.1

1) Grant of Copyright License. Licensor hereby grants You a world-wide,
royalty-free, non-exclusive, perpetual, sublicenseable license to do the
following:

a) to reproduce the Original Work in copies;

b) to prepare derivative works ("Derivative Works") based upon the Original
Work;

c) to distribute copies of the Original Work and Derivative Works to the
public;

d) to perform the Original Work publicly; and

e) to display the Original Work publicly.

2) Grant of Patent License. Licensor hereby grants You a world-wide,
royalty-free, non-exclusive, perpetual, sublicenseable license, under patent
claims owned or controlled by the Licensor that are embodied in the Original
Work as furnished by the Licensor, to make, use, sell and offer for sale the
Original Work and Derivative Works.

3) Grant of Source Code License. The term "Source Code" means the preferred
form of the Original Work for making modifications to it and all available
documentation describing how to modify the Original Work. Licensor hereby
agrees to provide a machine-readable copy of the Source Code of the Original
Work along with each copy of the Original Work that Licensor distributes.
Licensor reserves the right to satisfy this obligation by placing a
machine-readable copy of the Source Code in an information repository
reasonably calculated to permit inexpensive and convenient access by You for as
long as Licensor continues to distribute the Original Work, and by publishing
the address of that information repository in a notice immediately following
the copyright notice that applies to the Original Work.

4) Exclusions From License Grant. Neither the names of Licensor, nor the names
of any contributors to the Original Work, nor any of their trademarks or
service marks, may be used to endorse or promote products derived from this
Original Work without express prior written permission of the Licensor. Nothing
in this License shall be deemed to grant any rights to trademarks, copyrights,
patents, trade secrets or any other intellectual property of Licensor except as
expressly stated herein. No patent license is granted to make, use, sell or
offer to sell embodiments of any patent claims other than the licensed claims
defined in Section 2. No right is granted to the trademarks of Licensor even if
such marks are included in the Original Work. Nothing in this License shall be
interpreted to prohibit Licensor from licensing under different terms from this
License any Original Work that Licensor otherwise would have a right to
license.

5) This section intentionally omitted.

6) Attribution Rights. You must retain, in the Source Code of any Derivative
Works that You create, all copyright, patent or trademark notices from the
Source Code of the Original Work, as well as any notices of licensing and any
descriptive text identified therein as an "Attribution Notice." You must cause
the Source Code for any Derivative Works that You create to carry a prominent
Attribution Notice reasonably calculated to inform recipients that You have
modified the Original Work.

7) Warranty of Provenance and Disclaimer of Warranty. Licensor warrants that
the copyright in and to the Original Work and the patent rights granted herein
by Licensor are owned by the Licensor or are sublicensed to You under the terms
of this License with the permission of the contributor(s) of those copyrights
and patent rights. Except as expressly stated in the immediately proceeding
sentence, the Original Work is provided under this License on an "AS IS" BASIS
and WITHOUT WARRANTY, either express or implied, including, without limitation,
the warranties of NON-INFRINGEMENT, MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE. THE ENTIRE RISK AS TO THE QUALITY OF THE ORIGINAL WORK IS WITH YOU.
This DISCLAIMER OF WARRANTY constitutes an essential part of this License. No
license to Original Work is granted hereunder except under this disclaimer.

8) Limitation of Liability. Under no circumstances and under no legal theory,
whether in tort (including negligence), contract, or otherwise, shall the
Licensor be liable to any person for any direct, indirect, special, incidental,
or consequential damages of any character arising as a result of this License
or the use of the Original Work including, without limitation, damages for loss
of goodwill, work stoppage, computer failure or malfunction, or any and all
other commercial damages or losses. This limitation of liability shall not
apply to liability for death or personal injury resulting from Licensor's
negligence to the extent applicable law prohibits such limitation. Some
jurisdictions do not allow the exclusion or limitation of incidental or
consequential damages, so this exclusion and limitation may not apply to You.

9) Acceptance and Termination. If You distribute copies of the Original Work or
a Derivative Work, You must make a reasonable effort under the circumstances to
obtain the express assent of recipients to the terms of this License. Nothing
else but this License (or another written agreement between Licensor and You)
grants You permission to create Derivative Works based upon the Original Work
or to exercise any of the rights granted in Section 1 herein, and any attempt
to do so except under the terms of this License (or another written agreement
between Licensor and You) is expressly prohibited by U.S. copyright law, the
equivalent laws of other countries, and by international treaty. Therefore, by
exercising any of the rights granted to You in Section 1 herein, You indicate
Your acceptance of this License and all of its terms and conditions.

10) Termination for Patent Action. This License shall terminate automatically
and You may no longer exercise any of the rights granted to You by this License
as of the date You commence an action, including a cross-claim or counterclaim,
against Licensor or any licensee alleging that the Original Work infringes a
patent. This termination provision shall not apply for an action alleging
patent infringement by combinations of the Original Work with other software or
hardware.

11) Jurisdiction, Venue and Governing Law. Any action or suit relating to this
License may be brought only in the courts of a jurisdiction wherein the
Licensor resides or in which Licensor conducts its primary business, and under
the laws of that jurisdiction excluding its conflict-of-law provisions. The
application of the United Nations Convention on Contracts for the International
Sale of Goods is expressly excluded. Any use of the Original Work outside the
scope of this License or after its termination shall be subject to the
requirements and penalties of the U.S. Copyright Act, 17 U.S.C. Â§ 101 et
seq., the equivalent laws of other countries, and international treaty. This
section shall survive the termination of this License.

12) Attorneys Fees. In any action to enforce the terms of this License or
seeking damages relating thereto, the prevailing party shall be entitled to
recover its costs and expenses, including, without limitation, reasonable
attorneys' fees and costs incurred in connection with such action, including
any appeal of such action. This section shall survive the termination of this
License.

13) Miscellaneous. This License represents the complete agreement concerning
the subject matter hereof. If any provision of this License is held to be
unenforceable, such provision shall be reformed only to the extent necessary to
make it enforceable.

14) Definition of "You" in This License. "You" throughout this License, whether
in upper or lower case, means an individual or a legal entity exercising rights
under, and complying with all of the terms of, this License. For legal
entities, "You" includes any entity that controls, is controlled by, or is
under common control with you. For purposes of this definition, "control" means
(i) the power, direct or indirect, to cause the direction or management of such
entity, whether by contract or otherwise, or (ii) ownership of fifty percent
(50%) or more of the outstanding shares, or (iii) beneficial ownership of such
entity.

15) Right to Use. You may use the Original Work in all ways not otherwise
restricted or conditioned by this License or by law, and Licensor promises not
to interfere with or be responsible for such uses by You.

This license is Copyright (C) 2003-2004 Lawrence E. Rosen. All rights reserved.
Permission is hereby granted to copy and distribute this license without
modification. This license may not be modified without the express written
permission of its copyright owner.

```

### json-stringify-safe@5.0.1

From https://github.com/isaacs/json-stringify-safe.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### json5@2.2.3

From https://github.com/json5/json5.

**MIT**:

```
MIT License

Copyright (c) 2012-2018 Aseem Kishore, and [others].

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

[others]: https://github.com/json5/json5/contributors

```

### jsonfile@2.4.0, jsonfile@4.0.0, jsonfile@6.1.0

From https://github.com/jprichardson/node-jsonfile.

**MIT**:

Copyright: Copyright (c) 2012-2015, JP Richardson <jprichardson@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### jsprim@1.4.2

From https://github.com/joyent/node-jsprim.

**MIT**:

```
Copyright (c) 2012, Joyent, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE

```

### katex@0.16.22

From https://github.com/KaTeX/KaTeX.

**MIT**:

Copyright: Copyright (c) 2013-2020 Khan Academy and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### kind-of@3.2.2, kind-of@4.0.0, kind-of@5.1.0, kind-of@6.0.3

From https://github.com/jonschlinkert/kind-of.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### klaw@1.3.1

From https://github.com/jprichardson/node-klaw.

**MIT**:

Copyright: Copyright (c) 2015-2016 JP Richardson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### kleur@3.0.3

From https://github.com/lukeed/kleur.

**MIT**:

Copyright: Copyright (c) Luke Edwards <luke.edwards05@gmail.com> (lukeed.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lan-network@0.1.7

From https://github.com/kitten/lan-network.

**MIT**:

Copyright: Copyright (c) Shopify Inc. 2022-2024

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### leven@3.1.0

From https://github.com/sindresorhus/leven.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lightningcss-darwin-x64@1.27.0, lightningcss@1.27.0

From https://github.com/parcel-bundler/lightningcss.

**MPL-2.0**:

```
 Mozilla Public License Version 2.0
==================================

1. Definitions
--------------

1.1. "Contributor"
means each individual or legal entity that creates, contributes to
the creation of, or owns Covered Software.

1.2. "Contributor Version"
means the combination of the Contributions of others (if any) used
by a Contributor and that particular Contributor's Contribution.

1.3. "Contribution"
means Covered Software of a particular Contributor.

1.4. "Covered Software"
means Source Code Form to which the initial Contributor has attached
the notice in Exhibit A, the Executable Form of such Source Code
Form, and Modifications of such Source Code Form, in each case
including portions thereof.

1.5. "Incompatible With Secondary Licenses"
means

(a) that the initial Contributor has attached the notice described
in Exhibit B to the Covered Software; or

(b) that the Covered Software was made available under the terms of
version 1.1 or earlier of the License, but not also under the
terms of a Secondary License.

1.6. "Executable Form"
means any form of the work other than Source Code Form.

1.7. "Larger Work"
means a work that combines Covered Software with other material, in
a separate file or files, that is not Covered Software.

1.8. "License"
means this document.

1.9. "Licensable"
means having the right to grant, to the maximum extent possible,
whether at the time of the initial grant or subsequently, any and
all of the rights conveyed by this License.

1.10. "Modifications"
means any of the following:

(a) any file in Source Code Form that results from an addition to,
deletion from, or modification of the contents of Covered
Software; or

(b) any new file in Source Code Form that contains any Covered
Software.

1.11. "Patent Claims" of a Contributor
means any patent claim(s), including without limitation, method,
process, and apparatus claims, in any patent Licensable by such
Contributor that would be infringed, but for the grant of the
License, by the making, using, selling, offering for sale, having
made, import, or transfer of either its Contributions or its
Contributor Version.

1.12. "Secondary License"
means either the GNU General Public License, Version 2.0, the GNU
Lesser General Public License, Version 2.1, the GNU Affero General
Public License, Version 3.0, or any later versions of those
licenses.

1.13. "Source Code Form"
means the form of the work preferred for making modifications.

1.14. "You" (or "Your")
means an individual or a legal entity exercising rights under this
License. For legal entities, "You" includes any entity that
controls, is controlled by, or is under common control with You. For
purposes of this definition, "control" means (a) the power, direct
or indirect, to cause the direction or management of such entity,
whether by contract or otherwise, or (b) ownership of more than
fifty percent (50%) of the outstanding shares or beneficial
ownership of such entity.

2. License Grants and Conditions
--------------------------------

2.1. Grants

Each Contributor hereby grants You a world-wide, royalty-free,
non-exclusive license:

(a) under intellectual property rights (other than patent or trademark)
Licensable by such Contributor to use, reproduce, make available,
modify, display, perform, distribute, and otherwise exploit its
Contributions, either on an unmodified basis, with Modifications, or
as part of a Larger Work; and

(b) under Patent Claims of such Contributor to make, use, sell, offer
for sale, have made, import, and otherwise transfer either its
Contributions or its Contributor Version.

2.2. Effective Date

The licenses granted in Section 2.1 with respect to any Contribution
become effective for each Contribution on the date the Contributor first
distributes such Contribution.

2.3. Limitations on Grant Scope

The licenses granted in this Section 2 are the only rights granted under
this License. No additional rights or licenses will be implied from the
distribution or licensing of Covered Software under this License.
Notwithstanding Section 2.1(b) above, no patent license is granted by a
Contributor:

(a) for any code that a Contributor has removed from Covered Software;
or

(b) for infringements caused by: (i) Your and any other third party's
modifications of Covered Software, or (ii) the combination of its
Contributions with other software (except as part of its Contributor
Version); or

(c) under Patent Claims infringed by Covered Software in the absence of
its Contributions.

This License does not grant any rights in the trademarks, service marks,
or logos of any Contributor (except as may be necessary to comply with
the notice requirements in Section 3.4).

2.4. Subsequent Licenses

No Contributor makes additional grants as a result of Your choice to
distribute the Covered Software under a subsequent version of this
License (see Section 10.2) or under the terms of a Secondary License (if
permitted under the terms of Section 3.3).

2.5. Representation

Each Contributor represents that the Contributor believes its
Contributions are its original creation(s) or it has sufficient rights
to grant the rights to its Contributions conveyed by this License.

2.6. Fair Use

This License is not intended to limit any rights You have under
applicable copyright doctrines of fair use, fair dealing, or other
equivalents.

2.7. Conditions

Sections 3.1, 3.2, 3.3, and 3.4 are conditions of the licenses granted
in Section 2.1.

3. Responsibilities
-------------------

3.1. Distribution of Source Form

All distribution of Covered Software in Source Code Form, including any
Modifications that You create or to which You contribute, must be under
the terms of this License. You must inform recipients that the Source
Code Form of the Covered Software is governed by the terms of this
License, and how they can obtain a copy of this License. You may not
attempt to alter or restrict the recipients' rights in the Source Code
Form.

3.2. Distribution of Executable Form

If You distribute Covered Software in Executable Form then:

(a) such Covered Software must also be made available in Source Code
Form, as described in Section 3.1, and You must inform recipients of
the Executable Form how they can obtain a copy of such Source Code
Form by reasonable means in a timely manner, at a charge no more
than the cost of distribution to the recipient; and

(b) You may distribute such Executable Form under the terms of this
License, or sublicense it under different terms, provided that the
license for the Executable Form does not attempt to limit or alter
the recipients' rights in the Source Code Form under this License.

3.3. Distribution of a Larger Work

You may create and distribute a Larger Work under terms of Your choice,
provided that You also comply with the requirements of this License for
the Covered Software. If the Larger Work is a combination of Covered
Software with a work governed by one or more Secondary Licenses, and the
Covered Software is not Incompatible With Secondary Licenses, this
License permits You to additionally distribute such Covered Software
under the terms of such Secondary License(s), so that the recipient of
the Larger Work may, at their option, further distribute the Covered
Software under the terms of either this License or such Secondary
License(s).

3.4. Notices

You may not remove or alter the substance of any license notices
(including copyright notices, patent notices, disclaimers of warranty,
or limitations of liability) contained within the Source Code Form of
the Covered Software, except that You may alter any license notices to
the extent required to remedy known factual inaccuracies.

3.5. Application of Additional Terms

You may choose to offer, and to charge a fee for, warranty, support,
indemnity or liability obligations to one or more recipients of Covered
Software. However, You may do so only on Your own behalf, and not on
behalf of any Contributor. You must make it absolutely clear that any
such warranty, support, indemnity, or liability obligation is offered by
You alone, and You hereby agree to indemnify every Contributor for any
liability incurred by such Contributor as a result of warranty, support,
indemnity or liability terms You offer. You may include additional
disclaimers of warranty and limitations of liability specific to any
jurisdiction.

4. Inability to Comply Due to Statute or Regulation
---------------------------------------------------

If it is impossible for You to comply with any of the terms of this
License with respect to some or all of the Covered Software due to
statute, judicial order, or regulation then You must: (a) comply with
the terms of this License to the maximum extent possible; and (b)
describe the limitations and the code they affect. Such description must
be placed in a text file included with all distributions of the Covered
Software under this License. Except to the extent prohibited by statute
or regulation, such description must be sufficiently detailed for a
recipient of ordinary skill to be able to understand it.

5. Termination
--------------

5.1. The rights granted under this License will terminate automatically
if You fail to comply with any of its terms. However, if You become
compliant, then the rights granted under this License from a particular
Contributor are reinstated (a) provisionally, unless and until such
Contributor explicitly and finally terminates Your grants, and (b) on an
ongoing basis, if such Contributor fails to notify You of the
non-compliance by some reasonable means prior to 60 days after You have
come back into compliance. Moreover, Your grants from a particular
Contributor are reinstated on an ongoing basis if such Contributor
notifies You of the non-compliance by some reasonable means, this is the
first time You have received notice of non-compliance with this License
from such Contributor, and You become compliant prior to 30 days after
Your receipt of the notice.

5.2. If You initiate litigation against any entity by asserting a patent
infringement claim (excluding declaratory judgment actions,
counter-claims, and cross-claims) alleging that a Contributor Version
directly or indirectly infringes any patent, then the rights granted to
You by any and all Contributors for the Covered Software under Section
2.1 of this License shall terminate.

5.3. In the event of termination under Sections 5.1 or 5.2 above, all
end user license agreements (excluding distributors and resellers) which
have been validly granted by You or Your distributors under this License
prior to termination shall survive termination.

************************************************************************
* *
* 6. Disclaimer of Warranty *
* ------------------------- *
* *
* Covered Software is provided under this License on an "as is" *
* basis, without warranty of any kind, either expressed, implied, or *
* statutory, including, without limitation, warranties that the *
* Covered Software is free of defects, merchantable, fit for a *
* particular purpose or non-infringing. The entire risk as to the *
* quality and performance of the Covered Software is with You. *
* Should any Covered Software prove defective in any respect, You *
* (not any Contributor) assume the cost of any necessary servicing, *
* repair, or correction. This disclaimer of warranty constitutes an *
* essential part of this License. No use of any Covered Software is *
* authorized under this License except under this disclaimer. *
* *
************************************************************************

************************************************************************
* *
* 7. Limitation of Liability *
* -------------------------- *
* *
* Under no circumstances and under no legal theory, whether tort *
* (including negligence), contract, or otherwise, shall any *
* Contributor, or anyone who distributes Covered Software as *
* permitted above, be liable to You for any direct, indirect, *
* special, incidental, or consequential damages of any character *
* including, without limitation, damages for lost profits, loss of *
* goodwill, work stoppage, computer failure or malfunction, or any *
* and all other commercial damages or losses, even if such party *
* shall have been informed of the possibility of such damages. This *
* limitation of liability shall not apply to liability for death or *
* personal injury resulting from such party's negligence to the *
* extent applicable law prohibits such limitation. Some *
* jurisdictions do not allow the exclusion or limitation of *
* incidental or consequential damages, so this exclusion and *
* limitation may not apply to You. *
* *
************************************************************************

8. Litigation
-------------

Any litigation relating to this License may be brought only in the
courts of a jurisdiction where the defendant maintains its principal
place of business and such litigation shall be governed by laws of that
jurisdiction, without reference to its conflict-of-law provisions.
Nothing in this Section shall prevent a party's ability to bring
cross-claims or counter-claims.

9. Miscellaneous
----------------

This License represents the complete agreement concerning the subject
matter hereof. If any provision of this License is held to be
unenforceable, such provision shall be reformed only to the extent
necessary to make it enforceable. Any law or regulation which provides
that the language of a contract shall be construed against the drafter
shall not be used to construe this License against a Contributor.

10. Versions of the License
---------------------------

10.1. New Versions

Mozilla Foundation is the license steward. Except as provided in Section
10.3, no one other than the license steward has the right to modify or
publish new versions of this License. Each version will be given a
distinguishing version number.

10.2. Effect of New Versions

You may distribute the Covered Software under the terms of the version
of the License under which You originally received the Covered Software,
or under the terms of any subsequent version published by the license
steward.

10.3. Modified Versions

If you create software not governed by this License, and you want to
create a new license for such software, you may create and use a
modified version of this License if you rename the license and remove
any references to the name of the license steward (except to note that
such modified license differs from this License).

10.4. Distributing Source Code Form that is Incompatible With Secondary
Licenses

If You choose to distribute Source Code Form that is Incompatible With
Secondary Licenses under the terms of this version of the License, the
notice described in Exhibit B of this License must be attached.

Exhibit A - Source Code Form License Notice
-------------------------------------------

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at https://mozilla.org/MPL/2.0/.

If it is not possible or desirable to put the notice in a particular
file, then You may include the notice in a location (such as a LICENSE
file in a relevant directory) where a recipient would be likely to look
for such a notice.

You may add additional accurate notices of copyright ownership.

Exhibit B - "Incompatible With Secondary Licenses" Notice
---------------------------------------------------------

This Source Code Form is "Incompatible With Secondary Licenses", as
defined by the Mozilla Public License, v. 2.0.

```

### lines-and-columns@1.2.4

From https://github.com/eventualbuddha/lines-and-columns.

**MIT**:

Copyright: Copyright (c) 2015 Brian Donovan

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### linkify-it@4.0.1

From https://github.com/markdown-it/linkify-it.

**MIT**:

Copyright: Copyright (c) 2015 Vitaly Puzrin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### locate-path@2.0.0, locate-path@3.0.0, locate-path@5.0.0, locate-path@6.0.0

From https://github.com/sindresorhus/locate-path.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lodash.debounce@4.0.8, lodash.padend@4.6.1, lodash.repeat@4.1.0, lodash.throttle@4.1.1, lodash@4.17.21

From https://github.com/lodash/lodash.

**MIT**:

```
Copyright jQuery Foundation and other contributors <https://jquery.org/>

Based on Underscore.js, copyright Jeremy Ashkenas,
DocumentCloud and Investigative Reporters & Editors <http://underscorejs.org/>

This software consists of voluntary contributions made by many
individuals. For exact contribution history, see the revision history
available at https://github.com/lodash/lodash

The following license applies to all parts of this software except as
documented below:

====

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

====

Copyright and related rights for sample code are waived via CC0. Sample
code is defined as all source code displayed within the prose of the
documentation.

CC0: http://creativecommons.org/publicdomain/zero/1.0/

====

Files located in the node_modules and vendor directories are externally
maintained libraries used by this software which have their own
licenses; we recommend you read them, as their terms may differ from the
terms above.

```

### log-symbols@2.2.0, log-symbols@4.1.0

From https://github.com/sindresorhus/log-symbols.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### logkitty@0.7.1

From https://github.com/zamotany/logkitty.

**MIT**:

Copyright: Copyright (c) 2019 Paweł Trysła

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### loose-envify@1.4.0

From https://github.com/zertosh/loose-envify.

**MIT**:

Copyright: Copyright (c) 2015 Andres Suarez <zertosh@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lower-case@1.1.4

From https://github.com/blakeembrey/lower-case.

**MIT**:

Copyright: Copyright (c) 2014 Blake Embrey (hello@blakeembrey.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lru-cache@10.3.1, lru-cache@10.4.3, lru-cache@11.1.0, lru-cache@5.1.1, lru-cache@6.0.0

From https://github.com/isaacs/node-lru-cache.

**ISC**:

```
The ISC License

Copyright (c) 2010-2023 Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### magicli@0.0.8

From https://github.com/DiegoZoracKy/magicli.

**MIT**:


````
# MagiCLI

[![Build Status](https://api.travis-ci.org/DiegoZoracKy/magicli.svg)](https://travis-ci.org/DiegoZoracKy/magicli) [![npm](https://img.shields.io/npm/v/magicli.svg)]() [![npm](https://img.shields.io/npm/l/magicli.svg)]()

Automagically generates command-line interfaces (CLI), for any module.
Just `require('magicli')();` and your module is ready to be executed via CLI.

The main goal is to have any module prepared to be executed via CLI (installed globally with `-g`, or by using **npx**):

## Goals

 * Minimal setup (*one line*)
 * Automatic options names based on functions parameters
 * Out of the box support to async functions (`Promises`, or any *thenable* lib)
 * A specific help section for each nested property (*"subcommands"*)
 * *Name*, *Description* and *Version* extracted from package.json
 * Simple API to hook into the execution flow (*stdin*, *before*, *after*)
 * Cover all possible cases of module.exports (*Function*, *Object* with nested properties, Destructuring parameters)

## Usage (the most simple and minimal way)

 * `npm install magicli`
 * Add the property **bin** to your package.json containing the value **./bin/magicli.js**
 * Create the file **./bin/magicli.js** with the following content:

```javascript
#!/usr/bin/env node

require('magicli')();
```

**Done!** Install your module with `-g`, or use it via **[npx](http://blog.npmjs.org/post/162869356040/introducing-npx-an-npm-package-runner)**, and run it with `--help` to see the result. The `--version` option will show the same value found at *package.json*. In the same way you can just run `node ./bin/magicli.js --help` to test it quickly, without installing it.

Let's suppose that **your-module** exports the function:

```javascript
module.exports = function(param1, param2) {
    return param1 + param2;
}
```

When calling it via CLI, with `--help`, you will get:

```bash
Description:

  Same description found at package.json

Usage:

  $ your-module [options]

Options:

  --param1
  --param2
```

The program will be expecting options with the same name as the parameters declared at the exported function, and it doesn't need to follow the same order. Example:

`$ your-module --param2="K" --param1="Z"` would result in: `ZK`.

### How it works

MagiCLI is capable of handling many styles of `exports`, like:

 * Functions
 * Object Literal
 * Nested properties
 * Class with static methods

And also any kind of parameters declaration (*Destructuring Parameters*, *Rest Parameters*).

If **your-module** were like this:
```javascript
// An Arrow function with Destructuring assignment and Default values
const mainMethod = ([p1, [p2]] = ['p1Default', ['p2Default']], { p3 = 'p3Default' } = {}) => `${p1}-${p2}-${p3}`;

// Object Literal containing a nested method
module.exports = {
	mainMethod,
	nested: {
		method: param => `nested method param value is: "${param}`
	}
};
```

`$ your-module --help` would result in:

```bash
Description:

  Same description found at package.json

Usage:

  $ your-module <command>

Commands:

  mainMethod
  nested-method
```

`$ your-module mainMethod --help` would be:

```bash
Usage:

  $ your-module mainMethod [options]

Options:

  --p1
  --p2
  --p3
```

`$ your-module nested-method --help` returns:

```bash
Usage:

  $ your-module nested-method [options]

Options:

  --param
```

Calling *mainMethod* without any parameter:
`$ your-module mainMethod`

results in:
` p1Default-p2Default-p3Default`

While defining the parameter for *nested-method*:
`$ your-module mainMethod nested-method --param=paramValue`

would return:
` nested method param value is: "paramValue"`

Note: Nested methods/properties will be turned into commands separated by `-`, and it can be configurable via options (`subcommandDelimiter`).

## Usage Options
`magicli({ commands = {}, validateRequiredParameters = false, help = {}, version = {}, pipe = {}, enumerability = 'enumerable', subcommandDelimiter = '-'})`

Options are provided to add more information about commands and its options, and also to support a better control of a command execution flow, without the need to change the source code of the module itself (for example, to `JSON.stringify` an `Object Literal` that is returned).



### enumerability

By default, only the enumerable nested properties will be considered. The possible values are: `'enumerable'` (default), `'nonenumerable'` or `'all'`.

### validateRequiredParameters
MagiCLI can validate the required parameters for a command and show the help in case some of them are missing. The default value is `false`.

### help

**help.option**
To define a different option name to show the help section. For example, if `'modulehelp'` is chosen, `--modulehelp` must be used instead of `--help` to show the help section.

**help.stripAnsi**
	Set to `true` to strip all ansi escape codes (colors, underline, etc.) and output just a raw text.



### version
**version.option**
To define a different option name to show the version. For example, if `'moduleversion'` is chosen, `--moduleversion` must be used instead of `--version` to show the version number.

### pipe (stdin, before and after)

The pipeline of a command execution is:

**stdin** (command.pipe.stdin || magicliOptions.pipe.stdin) =>

**magicliOptions.pipe.before** =>

**command.pipe.before** =>

**command.action** (the method in case) =>

**command.pipe.after** =>

**magicliOptions.pipe.after** =>

**stdout**

Where each of these steps can be handled if needed.

As it can be defined on *commands* option, for each command, **pipe** can also be defined in *options* to implement a common handler for all commands. The expected properties are:

**pipe.stdin**
`(stdinValue, args, positionalArgs, argsAfterEndOfOptions)`

Useful to get a value from *stdin* and set it to one of the expected *args*.

**pipe.before**
`(args, positionalArgs, argsAfterEndOfOptions)`

To transform the data being input, before it is passed in to the main command action.

**pipe.after**
`(result, parsedArgs, positionalArgs, argsAfterEndOfOptions)`

Note: **stdin** and **before** must always return *args*, and **after** must always return *result*, as these values will be passed in for the next function in the pipeline.

### commands
The options are effortlessly extracted from the parameters names, however it is possible to give more information about a command and its options, and also give instructions to the options parser.

**commands** expects an `Object Literal` where each key is the command name. It would be the module's name for the main function that is exported, and the command's name as it is shown at the *Commands:* section of `--help`. For example:
```javascript
commands: {
    'mainmodulename': {},
    'some-nested-method': {}
}
```

For each command the following properties can be configurable:

#### options
Is an *Array* of *Objects*, where each contains:

**name** (*required*)
The name of the parameter that will be described

**required**
To tell if the parameter is required.

**description**
To give hints or explain what the option is about.

**type**
To define how the parser should treat the option (Array, Object, String, Number, etc.).  Check [yargs-parser](https://github.com/yargs/yargs-parser) for instructions about *type*, as it is the engine being used to parse the options.

**alias**
To define an alias for the option.

#### pipe (stdin, before and after)

The pipeline of a command execution is:

**stdin** (command.pipe.stdin || magicliOptions.pipe.stdin) =>

**magicliOptions.pipe.before** =>

**command.pipe.before** =>

**command.action** (the method in case) =>

**command.pipe.after** =>

**magicliOptions.pipe.after** =>

**stdout**

Where each of these steps can be handled if needed.

As it can be defined on *options* to implement a common handler for all commands, **pipe** can also be defined for each command.

**pipe.stdin**
`(stdinValue, args, positionalArgs, argsAfterEndOfOptions)`

Useful to get a value from *stdin* and set it to one of the expected *args*.

**pipe.before**
`(args, positionalArgs, argsAfterEndOfOptions)`

To transform the data being input, before it is passed in to the main command action.

**pipe.after**
`(result, parsedArgs, positionalArgs, argsAfterEndOfOptions)`

Note: **stdin** and **before** must always return *args*, and **after** must always return *result*, as these values will be passed in for the next function in the pipeline.

If needed, a more thorough guide about this section can be found at [cliss](https://github.com/DiegoZoracKy/cliss) (as this is the module under the hood to handle that)

A full featured use of the module would look like:

```javascript
magicli({
	commands,
	enumerability,
	subcommandDelimiter,
	validateRequiredParameters,
	help: {
		option,
		stripAnsi
	},
	version: {
		option
	},
	pipe: {
		stdin: (stdinValue, args, positionalArgs, argsAfterEndOfOptions) => {},
		before: (args, positionalArgs, argsAfterEndOfOptions) => {},
		after: (result, parsedArgs, positionalArgs, argsAfterEndOfOptions) => {}
	}
});
```

## Example

To better explain with an example, let's get the following module and configure it with MagiCLI to:

 * Define **p1** as `String` (*mainMethod*)
 * Write a description for **p2** (*mainMethod*)
 * Define **p3** as required (*mainMethod*)
 * Get **p2** from stdin (*mainMethod*)
 * Use **before** (command) to upper case **param** (*nested-method*)
 * Use **after** (command) to JSON.stringify the result of (*nested-method*)
 * Use **after** (options) to decorate all outputs (*nested-method*)

**module** ("main" property of package.json)
```javascript
'use strict';

module.exports = {
	mainMethod: (p1, p2, { p3 = 'p3Default' } = {}) => `${p1}-${p2}-${p3}`,
	nested: {
		method: param => {

			// Example of a Promise being handled
			return new Promise((resolve, reject) => {
				setTimeout(() => {
					resolve({ param });
				}, 2000);
			});
		}
	}
};
```

**magicli.js** ("bin" property of package.json)
```javascript
#!/usr/bin/env node


require('../magicli')({
	commands: {
		'mainMethod': {
			options: [{
				name: 'p1',
				description: 'Number will be converted to String',
				type: 'String'
			}, {
				name: 'p2',
				description: 'This parameter can be defined via stdin'
			}, {
				name: 'p3',
				required: true
			}],
			pipe: {
				stdin: (stdinValue, args, positionalArgs, argsAfterEndOfOptions) => {
					args.p2 = stdinValue;
					return args;
				}
			}
		},
		'nested-method': {
			options: [{
				name: 'param',
				description: 'Wait for it...'
			}],
			pipe: {
				before: (args, positionalArgs, argsAfterEndOfOptions) => {
					if (args.param) {
						args.param = args.param.toUpperCase();
					}
					return args;
				},

				after: JSON.stringify
			}
		}
	},
	pipe: {
		after: (result, positionalArgs, argsAfterEndOfOptions) => `======\n${result}\n======`
	}
});
```

## Tests

There is another repository called [MagiCLI Test Machine](https://github.com/DiegoZoracKy/magicli-test-machine), where many real published modules are being successfully tested. As the idea is to keep increasing the number of real modules tested, it made more sense to maintain a separated repository for that, instead of being constantly increasing the size of MagiCLI itself over time. I ask you to contribute with the growing numbers of those tests by adding your own module there via a pull request.

If you find some case that isn't being handled properly, please open an *issue* or feel free to create a PR ;)


````

### make-dir@2.1.0, make-dir@3.1.0

From https://github.com/sindresorhus/make-dir.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### make-fetch-happen@9.1.0

From https://github.com/npm/make-fetch-happen.

**ISC**:

```
ISC License

Copyright (c) npm, Inc.

Permission to use, copy, modify, and/or distribute this software for
any purpose with or without fee is hereby granted, provided that the
above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE COPYRIGHT HOLDER DISCLAIMS
ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.

```

### makeerror@1.0.12

From https://github.com/daaku/nodejs-makeerror.

**BSD-3-Clause**:

```
BSD License

Copyright (c) 2014, Naitik Shah. All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither the name Naitik Shah nor the names of its contributors may be used to
   endorse or promote products derived from this software without specific
   prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### map-cache@0.2.2

From https://github.com/jonschlinkert/map-cache.

**MIT**:

Copyright: Copyright (c) 2015-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### map-visit@1.0.0

From https://github.com/jonschlinkert/map-visit.

**MIT**:

Copyright: Copyright (c) 2015-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-abbr@1.0.4

From https://github.com/markdown-it/markdown-it-abbr.

**MIT**:

Copyright: Copyright (c) 2014-2015 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-anchor@5.3.0

From https://github.com/valeriangalliat/markdown-it-anchor.

**Unlicense**:


````
# markdown-it-anchor [![npm version](http://img.shields.io/npm/v/markdown-it-anchor.svg?style=flat-square)](https://www.npmjs.org/package/markdown-it-anchor)

> Header anchors for [markdown-it].

[markdown-it]: https://github.com/markdown-it/markdown-it

## Usage

```js
const md = require('markdown-it')()
  .use(require('markdown-it-anchor'), opts)
```

See a [demo as JSFiddle](https://jsfiddle.net/9ukc8dy6/).

The `opts` object can contain:

Name              | Description                                                    | Default
------------------|----------------------------------------------------------------|-----------------------------------
`level`           | Minimum level to apply anchors on or array of selected levels. | 1
`slugify`         | A custom slugification function.                               | See [`index.js`](index.js)
`permalink`       | Whether to add permalinks next to titles.                      | `false`
`renderPermalink` | A custom permalink rendering function.                         | See [`index.js`](index.js)
`permalinkClass`  | The class of the permalink anchor.                             | `header-anchor`
`permalinkSpace`  | Place space between the header text and the permalink anchor.  | `true`
`permalinkSymbol` | The symbol in the permalink anchor.                            | `¶`
`permalinkBefore` | Place the permalink before the title.                          | `false`
`permalinkHref`   | A custom permalink `href` rendering function.                  | See [`index.js`](index.js)
`permalinkAttrs`  | A custom permalink attributes rendering function.              | See [`index.js`](index.js)
`callback`        | Called with token and info after rendering.                    | `undefined`

The `renderPermalink` function takes the slug, an options object with
the above options, and then all the usual markdown-it rendering
arguments.

All headers above `level` will then have an `id` attribute with a slug
of their content. `level` can also be an array of headers levels to
apply the anchor, like `[2, 3]` to have an anchor on only level 2 and
3 headers.

If `permalink` is `true`, a `¶` symbol linking to the header itself will
be added.

You may want to use the [link symbol](http://graphemica.com/🔗) as
`permalinkSymbol`, or a symbol from your favorite web font.

The `callback` option is a function that will be called at the end of
rendering with the `token` and an `info` object.  The `info` object has
`title` and `slug` properties with the token content and the slug used
for the identifier.

## User-Friendly URLs

Starting from `v5.0.0`, `markdown-it-anchor` dropped package `string`
keeping it's core value of being an unopinionated and secure library. Yet,
users looking for backward compatibility may want the old slugify:

```sh
$ npm i -S string
```

```js
const string = require('string')
const legacySlugify = s => string(s).slugify().toString()

const md = require('markdown-it')()
const anchor = require('markdown-it-anchor', {
	slugify: legacySlugify
})
```

## Unicode Support

Unicode is supported by default. Yet, if you are looking for a "prettier"
--opinionated-- link, _i.e_ without %xx, you may want to take a look at `uslug`:

```sh
$ npm i -S uslug
```

```js
const uslug = require('uslug')
const uslugify = s => uslug(s)

const md = require('markdown-it')()
const anchor = require('markdown-it-anchor', {
	slugify: uslugify
})
```

## Table of Contents

Looking for an automatic table of contents (TOC) generator? Take a look at
[markdown-it-toc-done-right](https://www.npmjs.com/package/markdown-it-toc-done-right) it's
made from the ground to be a great companion of this plugin.


````

### markdown-it-deflist@2.1.0

From https://github.com/markdown-it/markdown-it-deflist.

**MIT**:

Copyright: Copyright (c) 2014-2015 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-emoji@2.0.2

From https://github.com/markdown-it/markdown-it-emoji.

**MIT**:

Copyright: Copyright (c) 2014 Vitaly Puzrin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-expand-tabs@1.0.13

From https://github.com/revin/markdown-it-expand-tabs.

**ISC**:

```
Copyright (c) 2016, Revin Guillen

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### markdown-it-footnote@3.0.3

From https://github.com/markdown-it/markdown-it-footnote.

**MIT**:

Copyright: Copyright (c) 2014-2015 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-ins@4.0.0

From https://github.com/markdown-it/markdown-it-ins.

**MIT**:

Copyright: Copyright (c) 2014-2015 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-mark@3.0.1

From https://github.com/markdown-it/markdown-it-mark.

**MIT**:

Copyright: Copyright (c) 2014-2015 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-multimd-table@4.2.3

From https://github.com/redbug312/markdown-it-multimd-table.

**MIT**:

Copyright: Copyright (c) 2019 RedBug312

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-sub@1.0.0

From https://github.com/markdown-it/markdown-it-sub.

**MIT**:

Copyright: Copyright (c) 2014-2015 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-sup@2.0.0

From https://github.com/markdown-it/markdown-it-sup.

**MIT**:

Copyright: Copyright (c) 2014-2015 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it-toc-done-right@4.2.0

From https://github.com/nagaozen/markdown-it-toc-done-right.

**MIT**:

Copyright: Copyright (c) 2018 Fabio Zendhi Nagao

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### markdown-it@13.0.2

From https://github.com/markdown-it/markdown-it.

**MIT**:

Copyright: Copyright (c) 2014 Vitaly Puzrin, Alex Kocharin.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### marky@1.2.5

From https://github.com/nolanlawson/marky.

**Apache-2.0**:

```
Apache License
Version 2.0, January 2004
http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

    "License" shall mean the terms and conditions for use, reproduction, and
    distribution as defined by Sections 1 through 9 of this document.

    "Licensor" shall mean the copyright owner or entity authorized by the
    copyright owner that is granting the License.

    "Legal Entity" shall mean the union of the acting entity and all other
    entities that control, are controlled by, or are under common control with
    that entity. For the purposes of this definition, "control" means (i) the
    power, direct or indirect, to cause the direction or management of such
    entity, whether by contract or otherwise, or (ii) ownership of
    fifty percent (50%) or more of the outstanding shares, or (iii) beneficial
    ownership of such entity.

    "You" (or "Your") shall mean an individual or Legal Entity exercising
    permissions granted by this License.

    "Source" form shall mean the preferred form for making modifications,
    including but not limited to software source code, documentation source,
    and configuration files.

    "Object" form shall mean any form resulting from mechanical transformation
    or translation of a Source form, including but not limited to compiled
    object code, generated documentation, and conversions to
    other media types.

    "Work" shall mean the work of authorship, whether in Source or Object
    form, made available under the License, as indicated by a copyright notice
    that is included in or attached to the work (an example is provided in the
    Appendix below).

    "Derivative Works" shall mean any work, whether in Source or Object form,
    that is based on (or derived from) the Work and for which the editorial
    revisions, annotations, elaborations, or other modifications represent,
    as a whole, an original work of authorship. For the purposes of this
    License, Derivative Works shall not include works that remain separable
    from, or merely link (or bind by name) to the interfaces of, the Work and
    Derivative Works thereof.

    "Contribution" shall mean any work of authorship, including the original
    version of the Work and any modifications or additions to that Work or
    Derivative Works thereof, that is intentionally submitted to Licensor for
    inclusion in the Work by the copyright owner or by an individual or
    Legal Entity authorized to submit on behalf of the copyright owner.
    For the purposes of this definition, "submitted" means any form of
    electronic, verbal, or written communication sent to the Licensor or its
    representatives, including but not limited to communication on electronic
    mailing lists, source code control systems, and issue tracking systems
    that are managed by, or on behalf of, the Licensor for the purpose of
    discussing and improving the Work, but excluding communication that is
    conspicuously marked or otherwise designated in writing by the copyright
    owner as "Not a Contribution."

    "Contributor" shall mean Licensor and any individual or Legal Entity on
    behalf of whom a Contribution has been received by Licensor and
    subsequently incorporated within the Work.

2. Grant of Copyright License.

    Subject to the terms and conditions of this License, each Contributor
    hereby grants to You a perpetual, worldwide, non-exclusive, no-charge,
    royalty-free, irrevocable copyright license to reproduce, prepare
    Derivative Works of, publicly display, publicly perform, sublicense,
    and distribute the Work and such Derivative Works in
    Source or Object form.

3. Grant of Patent License.

    Subject to the terms and conditions of this License, each Contributor
    hereby grants to You a perpetual, worldwide, non-exclusive, no-charge,
    royalty-free, irrevocable (except as stated in this section) patent
    license to make, have made, use, offer to sell, sell, import, and
    otherwise transfer the Work, where such license applies only to those
    patent claims licensable by such Contributor that are necessarily
    infringed by their Contribution(s) alone or by combination of their
    Contribution(s) with the Work to which such Contribution(s) was submitted.
    If You institute patent litigation against any entity (including a
    cross-claim or counterclaim in a lawsuit) alleging that the Work or a
    Contribution incorporated within the Work constitutes direct or
    contributory patent infringement, then any patent licenses granted to
    You under this License for that Work shall terminate as of the date such
    litigation is filed.

4. Redistribution.

    You may reproduce and distribute copies of the Work or Derivative Works
    thereof in any medium, with or without modifications, and in Source or
    Object form, provided that You meet the following conditions:

    1. You must give any other recipients of the Work or Derivative Works a
    copy of this License; and

    2. You must cause any modified files to carry prominent notices stating
    that You changed the files; and

    3. You must retain, in the Source form of any Derivative Works that You
    distribute, all copyright, patent, trademark, and attribution notices from
    the Source form of the Work, excluding those notices that do not pertain
    to any part of the Derivative Works; and

    4. If the Work includes a "NOTICE" text file as part of its distribution,
    then any Derivative Works that You distribute must include a readable copy
    of the attribution notices contained within such NOTICE file, excluding
    those notices that do not pertain to any part of the Derivative Works,
    in at least one of the following places: within a NOTICE text file
    distributed as part of the Derivative Works; within the Source form or
    documentation, if provided along with the Derivative Works; or, within a
    display generated by the Derivative Works, if and wherever such
    third-party notices normally appear. The contents of the NOTICE file are
    for informational purposes only and do not modify the License.
    You may add Your own attribution notices within Derivative Works that You
    distribute, alongside or as an addendum to the NOTICE text from the Work,
    provided that such additional attribution notices cannot be construed
    as modifying the License.

    You may add Your own copyright statement to Your modifications and may
    provide additional or different license terms and conditions for use,
    reproduction, or distribution of Your modifications, or for any such
    Derivative Works as a whole, provided Your use, reproduction, and
    distribution of the Work otherwise complies with the conditions
    stated in this License.

5. Submission of Contributions.

    Unless You explicitly state otherwise, any Contribution intentionally
    submitted for inclusion in the Work by You to the Licensor shall be under
    the terms and conditions of this License, without any additional
    terms or conditions. Notwithstanding the above, nothing herein shall
    supersede or modify the terms of any separate license agreement you may
    have executed with Licensor regarding such Contributions.

6. Trademarks.

    This License does not grant permission to use the trade names, trademarks,
    service marks, or product names of the Licensor, except as required for
    reasonable and customary use in describing the origin of the Work and
    reproducing the content of the NOTICE file.

7. Disclaimer of Warranty.

    Unless required by applicable law or agreed to in writing, Licensor
    provides the Work (and each Contributor provides its Contributions)
    on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
    either express or implied, including, without limitation, any warranties
    or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS
    FOR A PARTICULAR PURPOSE. You are solely responsible for determining the
    appropriateness of using or redistributing the Work and assume any risks
    associated with Your exercise of permissions under this License.

8. Limitation of Liability.

    In no event and under no legal theory, whether in tort
    (including negligence), contract, or otherwise, unless required by
    applicable law (such as deliberate and grossly negligent acts) or agreed
    to in writing, shall any Contributor be liable to You for damages,
    including any direct, indirect, special, incidental, or consequential
    damages of any character arising as a result of this License or out of
    the use or inability to use the Work (including but not limited to damages
    for loss of goodwill, work stoppage, computer failure or malfunction,
    or any and all other commercial damages or losses), even if such
    Contributor has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability.

    While redistributing the Work or Derivative Works thereof, You may choose
    to offer, and charge a fee for, acceptance of support, warranty,
    indemnity, or other liability obligations and/or rights consistent with
    this License. However, in accepting such obligations, You may act only
    on Your own behalf and on Your sole responsibility, not on behalf of any
    other Contributor, and only if You agree to indemnify, defend, and hold
    each Contributor harmless for any liability incurred by, or claims
    asserted against, such Contributor by reason of your accepting any such
    warranty or additional liability.

END OF TERMS AND CONDITIONS

APPENDIX: How to apply the Apache License to your work

    To apply the Apache License to your work, attach the following boilerplate
    notice, with the fields enclosed by brackets "[]" replaced with your own
    identifying information. (Don't include the brackets!) The text should be
    enclosed in the appropriate comment syntax for the file format. We also
    recommend that a file or class name and description of purpose be included
    on the same "printed page" as the copyright notice for easier
    identification within third-party archives.

        Copyright 2016 Nolan Lawson


        Licensed under the Apache License, Version 2.0 (the "License");
        you may not use this file except in compliance with the License.
        You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

        Unless required by applicable law or agreed to in writing, software
        distributed under the License is distributed on an "AS IS" BASIS,
        WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
        or implied. See the License for the specific language governing
        permissions and limitations under the License.


```

### math-intrinsics@1.1.0

From https://github.com/es-shims/math-intrinsics.

**MIT**:

Copyright: Copyright (c) 2024 ECMAScript Shims

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### md5-file@5.0.0

From https://github.com/roryrjb/md5-file.

**MIT**:

```
# License

The MIT License (MIT)

Copyright (c) 2015 - 2017 Rory Bradford and contributors.

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### md5.js@1.3.5

From https://github.com/crypto-browserify/md5.js.

**MIT**:

Copyright: Copyright (c) 2016 Kirill Fomichev

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### md5@2.3.0

From https://github.com/pvorb/node-md5.

**BSD-3-Clause**:

```
Copyright © 2011-2012, Paul Vorbach.
Copyright © 2009, Jeff Mott.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name Crypto-JS nor the names of its contributors may be used to
  endorse or promote products derived from this software without specific prior
  written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### mdn-data@2.0.14

From https://github.com/mdn/data.

**CC0-1.0**:

```
CC0 1.0 Universal

Statement of Purpose

The laws of most jurisdictions throughout the world automatically confer
exclusive Copyright and Related Rights (defined below) upon the creator and
subsequent owner(s) (each and all, an "owner") of an original work of
authorship and/or a database (each, a "Work").

Certain owners wish to permanently relinquish those rights to a Work for the
purpose of contributing to a commons of creative, cultural and scientific
works ("Commons") that the public can reliably and without fear of later
claims of infringement build upon, modify, incorporate in other works, reuse
and redistribute as freely as possible in any form whatsoever and for any
purposes, including without limitation commercial purposes. These owners may
contribute to the Commons to promote the ideal of a free culture and the
further production of creative, cultural and scientific works, or to gain
reputation or greater distribution for their Work in part through the use and
efforts of others.

For these and/or other purposes and motivations, and without any expectation
of additional consideration or compensation, the person associating CC0 with a
Work (the "Affirmer"), to the extent that he or she is an owner of Copyright
and Related Rights in the Work, voluntarily elects to apply CC0 to the Work
and publicly distribute the Work under its terms, with knowledge of his or her
Copyright and Related Rights in the Work and the meaning and intended legal
effect of CC0 on those rights.

1. Copyright and Related Rights. A Work made available under CC0 may be
protected by copyright and related or neighboring rights ("Copyright and
Related Rights"). Copyright and Related Rights include, but are not limited
to, the following:

  i. the right to reproduce, adapt, distribute, perform, display, communicate,
  and translate a Work;

  ii. moral rights retained by the original author(s) and/or performer(s);

  iii. publicity and privacy rights pertaining to a person's image or likeness
  depicted in a Work;

  iv. rights protecting against unfair competition in regards to a Work,
  subject to the limitations in paragraph 4(a), below;

  v. rights protecting the extraction, dissemination, use and reuse of data in
  a Work;

  vi. database rights (such as those arising under Directive 96/9/EC of the
  European Parliament and of the Council of 11 March 1996 on the legal
  protection of databases, and under any national implementation thereof,
  including any amended or successor version of such directive); and

  vii. other similar, equivalent or corresponding rights throughout the world
  based on applicable law or treaty, and any national implementations thereof.

2. Waiver. To the greatest extent permitted by, but not in contravention of,
applicable law, Affirmer hereby overtly, fully, permanently, irrevocably and
unconditionally waives, abandons, and surrenders all of Affirmer's Copyright
and Related Rights and associated claims and causes of action, whether now
known or unknown (including existing as well as future claims and causes of
action), in the Work (i) in all territories worldwide, (ii) for the maximum
duration provided by applicable law or treaty (including future time
extensions), (iii) in any current or future medium and for any number of
copies, and (iv) for any purpose whatsoever, including without limitation
commercial, advertising or promotional purposes (the "Waiver"). Affirmer makes
the Waiver for the benefit of each member of the public at large and to the
detriment of Affirmer's heirs and successors, fully intending that such Waiver
shall not be subject to revocation, rescission, cancellation, termination, or
any other legal or equitable action to disrupt the quiet enjoyment of the Work
by the public as contemplated by Affirmer's express Statement of Purpose.

3. Public License Fallback. Should any part of the Waiver for any reason be
judged legally invalid or ineffective under applicable law, then the Waiver
shall be preserved to the maximum extent permitted taking into account
Affirmer's express Statement of Purpose. In addition, to the extent the Waiver
is so judged Affirmer hereby grants to each affected person a royalty-free,
non transferable, non sublicensable, non exclusive, irrevocable and
unconditional license to exercise Affirmer's Copyright and Related Rights in
the Work (i) in all territories worldwide, (ii) for the maximum duration
provided by applicable law or treaty (including future time extensions), (iii)
in any current or future medium and for any number of copies, and (iv) for any
purpose whatsoever, including without limitation commercial, advertising or
promotional purposes (the "License"). The License shall be deemed effective as
of the date CC0 was applied by Affirmer to the Work. Should any part of the
License for any reason be judged legally invalid or ineffective under
applicable law, such partial invalidity or ineffectiveness shall not
invalidate the remainder of the License, and in such case Affirmer hereby
affirms that he or she will not (i) exercise any of his or her remaining
Copyright and Related Rights in the Work or (ii) assert any associated claims
and causes of action with respect to the Work, in either case contrary to
Affirmer's express Statement of Purpose.

4. Limitations and Disclaimers.

  a. No trademark or patent rights held by Affirmer are waived, abandoned,
  surrendered, licensed or otherwise affected by this document.

  b. Affirmer offers the Work as-is and makes no representations or warranties
  of any kind concerning the Work, express, implied, statutory or otherwise,
  including without limitation warranties of title, merchantability, fitness
  for a particular purpose, non infringement, or the absence of latent or
  other defects, accuracy, or the present or absence of errors, whether or not
  discoverable, all to the greatest extent permissible under applicable law.

  c. Affirmer disclaims responsibility for clearing rights of other persons
  that may apply to the Work or any use thereof, including without limitation
  any person's Copyright and Related Rights in the Work. Further, Affirmer
  disclaims responsibility for obtaining any necessary consents, permissions
  or other rights required for any use of the Work.

  d. Affirmer understands and acknowledges that Creative Commons is not a
  party to this document and has no duty or obligation with respect to this
  CC0 or use of the Work.

For more information, please see
<http://creativecommons.org/publicdomain/zero/1.0/>

```

### mdurl@1.0.1

From https://github.com/markdown-it/mdurl.

**MIT**:

```
Copyright (c) 2015 Vitaly Puzrin, Alex Kocharin.

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

--------------------------------------------------------------------------------

.parse() is based on Joyent's node.js `url` code:

Copyright Joyent, Inc. and other Node contributors. All rights reserved.
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

```

### memoize-one@5.2.1, memoize-one@6.0.0

From https://github.com/alexreardon/memoize-one.

**MIT**:

Copyright: Copyright (c) 2019 Alexander Reardon

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### merge-stream@2.0.0

From https://github.com/grncdr/merge-stream.

**MIT**:

Copyright: Copyright (c) Stephen Sugden <me@stephensugden.com> (stephensugden.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### merge2@1.4.1

From https://github.com/teambition/merge2.

**MIT**:

Copyright: Copyright (c) 2014-2020 Teambition

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### metro-babel-transformer@0.72.3, metro-babel-transformer@0.82.4, metro-cache-key@0.72.3, metro-cache-key@0.82.4, metro-cache@0.72.3, metro-cache@0.82.4, metro-config@0.72.3, metro-config@0.82.4, metro-core@0.72.3, metro-core@0.82.4, metro-file-map@0.72.3, metro-file-map@0.82.4, metro-hermes-compiler@0.72.3, metro-inspector-proxy@0.72.3, metro-minify-terser@0.82.4, metro-minify-uglify@0.72.3, metro-react-native-babel-preset@0.72.3, metro-react-native-babel-transformer@0.72.3, metro-resolver@0.72.3, metro-resolver@0.82.4, metro-runtime@0.72.3, metro-runtime@0.82.4, metro-source-map@0.72.3, metro-source-map@0.82.4, metro-symbolicate@0.72.3, metro-symbolicate@0.82.4, metro-transform-plugins@0.72.3, metro-transform-plugins@0.82.4, metro-transform-worker@0.72.3, metro-transform-worker@0.82.4, metro@0.72.3, metro@0.82.4, ob1@0.72.3, ob1@0.82.4

From https://github.com/facebook/metro.

**MIT**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### micromatch@3.1.10, micromatch@4.0.4

From https://github.com/micromatch/micromatch.

**MIT**:

Copyright: Copyright (c) 2014-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### miller-rabin@4.0.1

From https://github.com/indutny/miller-rabin.

**MIT**:

```
#### LICENSE

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2014.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### mime-db@1.51.0, mime-db@1.52.0

From https://github.com/jshttp/mime-db.

**MIT**:

Copyright: Copyright (c) 2014 Jonathan Ong me@jongleberry.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mime-types@2.1.34, mime-types@2.1.35

From https://github.com/jshttp/mime-types.

**MIT**:

Copyright: Copyright (c) 2015 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mime@1.6.0

From https://github.com/broofa/node-mime.

**MIT**:

Copyright: Copyright (c) 2010 Benjamin Thomas, Robert Kieffer

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mime@2.6.0

From https://github.com/broofa/mime.

**MIT**:

Copyright: Copyright (c) 2010 Benjamin Thomas, Robert Kieffer

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mimer@2.0.2

From https://github.com/heldr/mimer.

**MIT**:

```
## License

MIT License
(c) [Helder Santana](http://heldr.com)

```

### mimic-fn@1.2.0, mimic-fn@2.1.0

From https://github.com/sindresorhus/mimic-fn.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### minimalistic-assert@1.0.1

From https://github.com/calvinmetcalf/minimalistic-assert.

**ISC**:

```
Copyright 2015 Calvin Metcalf

Permission to use, copy, modify, and/or distribute this software for any purpose
with or without fee is hereby granted, provided that the above copyright notice
and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
```

### minimalistic-crypto-utils@1.0.1

From https://github.com/indutny/minimalistic-crypto-utils.

**MIT**:

```
#### LICENSE

This software is licensed under the MIT License.

Copyright Fedor Indutny, 2017.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

[0]: http://tools.ietf.org/html/rfc6979
[1]: https://github.com/indutny/bn.js
[2]: https://github.com/indutny/hash.js
[3]: https://github.com/bitchan/eccrypto
[4]: https://github.com/wanderer/secp256k1-node

```

### minimatch@10.0.3, minimatch@3.0.4, minimatch@9.0.2, minimatch@9.0.4, minimatch@3.1.2

From https://github.com/isaacs/minimatch.

**ISC**:

```
The ISC License

Copyright (c) 2011-2023 Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### minimist@1.2.5

From https://github.com/substack/minimist.

**MIT**:

```
This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### minipass-fetch@1.4.1

From https://github.com/npm/minipass-fetch.

**MIT**:

```
The MIT License (MIT)

Copyright (c) Isaac Z. Schlueter and Contributors
Copyright (c) 2016 David Frank

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

---

Note: This is a derivative work based on "node-fetch" by David Frank,
modified and distributed under the terms of the MIT license above.
https://github.com/bitinn/node-fetch

```

### minipass-flush@1.0.5

From https://github.com/isaacs/minipass-flush.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### minipass-sized@1.0.3

From https://github.com/isaacs/minipass-sized.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### minipass@3.1.5, minipass@5.0.0, minipass@7.0.2, minipass@7.1.2

From https://github.com/isaacs/minipass.

**ISC**:

```
The ISC License

Copyright (c) npm, Inc. and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### minizlib@2.1.2, minizlib@3.0.2

From https://github.com/isaacs/minizlib.

**MIT**:

```
Minizlib was created by Isaac Z. Schlueter.
It is a derivative work of the Node.js project.

"""
Copyright Isaac Z. Schlueter and Contributors
Copyright Node.js contributors. All rights reserved.
Copyright Joyent, Inc. and other Node contributors. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""

```

### mixin-deep@1.3.2

From https://github.com/jonschlinkert/mixin-deep.

**MIT**:

Copyright: Copyright (c) 2014-2015, 2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mkdirp@0.5.5

From https://github.com/substack/node-mkdirp.

**MIT**:

```
Copyright 2010 James Halliday (mail@substack.net)

This project is free software released under the MIT/X11 license:

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### mkdirp@1.0.4, mkdirp@3.0.1

From https://github.com/isaacs/node-mkdirp.

**MIT**:

```
Copyright James Halliday (mail@substack.net) and Isaac Z. Schlueter (i@izs.me)

This project is free software released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### moment@2.30.1, moment@2.29.1

From https://github.com/moment/moment.

**MIT**:

Copyright: Copyright (c) JS Foundation and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ms@2.0.0, ms@2.1.1, ms@2.1.2

From https://github.com/zeit/ms.

**MIT**:

Copyright: Copyright (c) 2016 Zeit, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ms@2.1.3

From https://github.com/vercel/ms.

**MIT**:

Copyright: Copyright (c) 2020 Vercel, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### multiparty@4.2.3

From https://github.com/pillarjs/multiparty.

**MIT**:

Copyright: Copyright (c) 2014 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mustache@4.2.0

From https://github.com/janl/mustache.js.

**MIT**:

Copyright: Copyright (c) 2010-2015 The mustache.js community

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mz@2.7.0

From https://github.com/normalize/mz.

**MIT**:

Copyright: Copyright (c) 2014-2016 Jonathan Ong me@jongleberry.com and Contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nanoid@3.3.7

From https://github.com/ai/nanoid.

**MIT**:

Copyright: Copyright 2017 Andrey Sitnik <andrey@sitnik.ru>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nanomatch@1.2.13

From https://github.com/micromatch/nanomatch.

**MIT**:

Copyright: Copyright (c) 2016-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### negotiator@0.6.2, negotiator@0.6.3

From https://github.com/jshttp/negotiator.

**MIT**:

Copyright: Copyright (c) 2014-2015 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### neo-async@2.6.2

From https://github.com/suguru03/neo-async.

**MIT**:

```
MIT License

Copyright (c) 2014-2018 Suguru Motegi
Based on Async.js, Copyright Caolan McMahon

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### nested-error-stacks@2.0.1

From https://github.com/mdlavin/nested-error-stacks.

**MIT**:

Copyright: Copyright (c) 2014 Matt Lavin <matt.lavin@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nice-try@1.0.5

From https://github.com/electerious/nice-try.

**MIT**:

Copyright: Copyright (c) 2018 Tobias Reich

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### no-case@2.3.2

From https://github.com/blakeembrey/no-case.

**MIT**:

Copyright: Copyright (c) 2014 Blake Embrey (hello@blakeembrey.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nocache@3.0.4

From https://github.com/helmetjs/nocache.

**MIT**:

Copyright: Copyright (c) 2014-2022 Evan Hahn, Adam Baldwin

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-addon-api@4.3.0

From https://github.com/nodejs/node-addon-api.

**MIT**:

```
The MIT License (MIT)
=====================

Copyright (c) 2017 Node.js API collaborators
-----------------------------------

*Node.js API collaborators listed at <https://github.com/nodejs/node-addon-api#collaborators>*

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

### node-dir@0.1.17

From https://github.com/fshost/node-dir.

**MIT**:

Copyright: Copyright (c) 2012 Nathan Cartwright <fshost@yahoo.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-emoji@1.11.0

From https://github.com/omnidan/node-emoji.

**MIT**:

Copyright: Copyright (c) 2014 Daniel Bugl

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-fetch@2.6.6, node-fetch@2.6.7, node-fetch@2.7.0

From https://github.com/bitinn/node-fetch.

**MIT**:

Copyright: Copyright (c) 2016 David Frank

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-forge@1.3.1

From https://github.com/digitalbazaar/forge.

**(BSD-3-Clause OR GPL-2.0)**:

```
You may use the Forge project under the terms of either the BSD License or the
GNU General Public License (GPL) Version 2.

The BSD License is recommended for most projects. It is simple and easy to
understand and it places almost no restrictions on what you can do with the
Forge project.

If the GPL suits your project better you are also free to use Forge under
that license.

You don't have to do anything special to choose one license or the other and
you don't have to notify anyone which license you are using. You are free to
use this project in commercial projects as long as the copyright header is
left intact.

If you are a commercial entity and use this set of libraries in your
commercial software then reasonable payment to Digital Bazaar, if you can
afford it, is not required but is expected and would be appreciated. If this
library saves you time, then it's saving you money. The cost of developing
the Forge software was on the order of several hundred hours and tens of
thousands of dollars. We are attempting to strike a balance between helping
the development community while not being taken advantage of by lucrative
commercial entities for our efforts.

-------------------------------------------------------------------------------
New BSD License (3-clause)
Copyright (c) 2010, Digital Bazaar, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Digital Bazaar, Inc. nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL DIGITAL BAZAAR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

-------------------------------------------------------------------------------
        GNU GENERAL PUBLIC LICENSE
           Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

          Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Lesser General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

        GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

          NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.


```

### node-gyp@8.4.1

From https://github.com/nodejs/node-gyp.

**MIT**:

Copyright: Copyright (c) 2012 Nathan Rajlich <nathan@tootallnate.net>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-int64@0.4.0

From https://github.com/broofa/node-int64.

**MIT**:

Copyright: Copyright (c) 2014 Robert Kieffer

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-notifier@10.0.1

From https://github.com/mikaelbr/node-notifier.

**MIT**:

Copyright: Copyright (c) 2017 Mikael Brevik

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-persist@3.1.3

From https://github.com/simonlast/node-persist.

**MIT**:

Copyright: Copyright (c) 2018 Simon Last

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-releases@2.0.1, node-releases@2.0.13, node-releases@2.0.14, node-releases@2.0.19, node-releases@2.0.6

From https://github.com/chicoxyzzy/node-releases.

**MIT**:

Copyright: Copyright (c) 2017 Sergey Rubanov (https://github.com/chicoxyzzy)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-rsa@1.1.1

From https://github.com/rzcoder/node-rsa.

**MIT**:

```
## License

Copyright (c) 2014  rzcoder<br/>

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

## Licensing for code used in rsa.js and jsbn.js

Copyright (c) 2003-2005  Tom Wu<br/>
All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

In addition, the following condition applies:

All redistributions must retain an intact copy of this copyright notice
and disclaimer.

[![Build Status](https://travis-ci.org/rzcoder/node-rsa.svg?branch=master)](https://travis-ci.org/rzcoder/node-rsa)

```

### node-stream-zip@1.15.0

From https://github.com/antelle/node-stream-zip.

**MIT**:

```
Copyright (c) 2021 Antelle https://github.com/antelle

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

== dependency license: adm-zip ==

Copyright (c) 2012 Another-D-Mention Software and other contributors, 
http://www.another-d-mention.ro/

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

### nopt@5.0.0

From https://github.com/npm/nopt.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### normalize-path@3.0.0

From https://github.com/jonschlinkert/normalize-path.

**MIT**:

Copyright: Copyright (c) 2014-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### npm-package-arg@11.0.3

From https://github.com/npm/npm-package-arg.

**ISC**:

```
The ISC License

Copyright (c) npm, Inc.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### npm-run-path@2.0.2, npm-run-path@4.0.1

From https://github.com/sindresorhus/npm-run-path.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### npmlog@5.0.1, npmlog@6.0.0

From https://github.com/npm/npmlog.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### nth-check@2.1.1

From https://github.com/fb55/nth-check.

**BSD-2-Clause**:

```
Copyright (c) Felix Böhm
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### nullthrows@1.1.1

From https://github.com/zertosh/nullthrows.

**MIT**:

Copyright: Copyright (c) 2016 Andres Suarez

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nwsapi@2.2.21

From https://github.com/dperini/nwsapi.

**MIT**:

Copyright: Copyright (c) 2007-2025 Diego Perini (http://www.iport.it/)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### oauth-sign@0.9.0

From https://github.com/mikeal/oauth-sign.

**Apache-2.0**:

```
Apache License

Version 2.0, January 2004

http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.

"Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.

2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.

3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.

4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of this License; and

You must cause any modified files to carry prominent notices stating that You changed the files; and

You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and

If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.

5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.

7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.

8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS
```

### object-assign@4.1.1

From https://github.com/sindresorhus/object-assign.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### object-copy@0.1.0

From https://github.com/jonschlinkert/object-copy.

**MIT**:

Copyright: Copyright (c) 2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### object-inspect@1.11.1, object-inspect@1.13.2

From https://github.com/inspect-js/object-inspect.

**MIT**:

Copyright: Copyright (c) 2013 James Halliday

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### object-is@1.1.5

From https://github.com/es-shims/object-is.

**MIT**:

Copyright: Copyright (c) 2014 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### object-keys@1.1.1

From https://github.com/ljharb/object-keys.

**MIT**:

Copyright: Copyright (C) 2013 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### object-visit@1.0.1

From https://github.com/jonschlinkert/object-visit.

**MIT**:

Copyright: Copyright (c) 2015, 2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### object.assign@4.1.2

From https://github.com/ljharb/object.assign.

**MIT**:

Copyright: Copyright (c) 2014 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### object.pick@1.3.0

From https://github.com/jonschlinkert/object.pick.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### on-finished@2.3.0, on-finished@2.4.1

From https://github.com/jshttp/on-finished.

**MIT**:

Copyright: Copyright (c) 2014 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### on-headers@1.0.2

From https://github.com/jshttp/on-headers.

**MIT**:

Copyright: Copyright (c) 2014 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### once@1.4.0

From https://github.com/isaacs/once.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### onetime@2.0.1, onetime@5.1.2

From https://github.com/sindresorhus/onetime.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### open@6.4.0, open@7.4.2, open@8.4.2

From https://github.com/sindresorhus/open.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ora@3.4.0, ora@5.4.1

From https://github.com/sindresorhus/ora.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### orderedmap@2.1.1

From https://github.com/marijnh/orderedmap.

**MIT**:

Copyright: Copyright (C) 2016 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### os-tmpdir@1.0.2

From https://github.com/sindresorhus/os-tmpdir.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### p-finally@1.0.0

From https://github.com/sindresorhus/p-finally.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### p-limit@1.3.0, p-limit@2.3.0, p-limit@3.1.0

From https://github.com/sindresorhus/p-limit.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### p-locate@2.0.0, p-locate@3.0.0, p-locate@4.1.0, p-locate@5.0.0

From https://github.com/sindresorhus/p-locate.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### p-map@4.0.0

From https://github.com/sindresorhus/p-map.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### p-try@1.0.0, p-try@2.2.0

From https://github.com/sindresorhus/p-try.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### package-json-from-dist@1.0.0

From https://github.com/isaacs/package-json-from-dist.

**BlueOak-1.0.0**:

```
All packages under `src/` are licensed according to the terms in
their respective `LICENSE` or `LICENSE.md` files.

The remainder of this project is licensed under the Blue Oak
Model License, as follows:

-----

# Blue Oak Model License

Version 1.0.0

## Purpose

This license gives everyone as much permission to work with
this software as possible, while protecting contributors
from liability.

## Acceptance

In order to receive this license, you must agree to its
rules.  The rules of this license are both obligations
under that agreement and conditions to your license.
You must not do anything with this software that triggers
a rule that you cannot or will not follow.

## Copyright

Each contributor licenses you to do everything with this
software that would otherwise infringe that contributor's
copyright in it.

## Notices

You must ensure that everyone who gets a copy of
any part of this software from you, with or without
changes, also gets the text of this license or a link to
<https://blueoakcouncil.org/license/1.0.0>.

## Excuse

If anyone notifies you in writing that you have not
complied with [Notices](#notices), you can keep your
license by taking all practical steps to comply within 30
days after the notice.  If you do not do so, your license
ends immediately.

## Patent

Each contributor licenses you to do everything with this
software that would otherwise infringe any patent claims
they can license or become able to license.

## Reliability

No contributor can revoke this license.

## No Liability

***As far as the law allows, this software comes as is,
without any warranty or condition, and no contributor
will be liable to anyone for any damages related to this
software or this license, under any kind of legal claim.***

```

### param-case@2.1.1

From https://github.com/blakeembrey/param-case.

**MIT**:

Copyright: Copyright (c) 2014 Blake Embrey (hello@blakeembrey.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### parent-module@1.0.1

From https://github.com/sindresorhus/parent-module.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### parse-asn1@5.1.6, parse-asn1@5.1.7

From https://github.com/crypto-browserify/parse-asn1.

**ISC**:

```
Copyright (c) 2017, crypto-browserify contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### parse-json@4.0.0, parse-json@5.2.0

From https://github.com/sindresorhus/parse-json.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### parse-png@2.1.0

From https://github.com/kevva/parse-png.

**MIT**:

Copyright: Copyright (c) Kevin Mårtensson <kevinmartensson@gmail.com> (github.com/kevva)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### parse5@7.3.0

From https://github.com/inikulin/parse5.

**MIT**:

Copyright: Copyright (c) 2013-2019 Ivan Nikulin (ifaaan@gmail.com, https://github.com/inikulin)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### parseurl@1.3.3

From https://github.com/pillarjs/parseurl.

**MIT**:

Copyright: Copyright (c) 2014-2017 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pascalcase@0.1.1

From https://github.com/jonschlinkert/pascalcase.

**MIT**:

Copyright: Copyright (c) 2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### path-browserify@1.0.1

From https://github.com/browserify/path-browserify.

**MIT**:

Copyright: Copyright (c) 2013 James Halliday

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### path-exists@3.0.0, path-exists@4.0.0

From https://github.com/sindresorhus/path-exists.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### path-is-absolute@1.0.1

From https://github.com/sindresorhus/path-is-absolute.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### path-key@2.0.1, path-key@3.1.1

From https://github.com/sindresorhus/path-key.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### path-parse@1.0.7

From https://github.com/jbgutierrez/path-parse.

**MIT**:

Copyright: Copyright (c) 2015 Javier Blanco

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### path-scurry@1.11.1, path-scurry@2.0.0

From https://github.com/isaacs/path-scurry.

**BlueOak-1.0.0**:

```
# Blue Oak Model License

Version 1.0.0

## Purpose

This license gives everyone as much permission to work with
this software as possible, while protecting contributors
from liability.

## Acceptance

In order to receive this license, you must agree to its
rules.  The rules of this license are both obligations
under that agreement and conditions to your license.
You must not do anything with this software that triggers
a rule that you cannot or will not follow.

## Copyright

Each contributor licenses you to do everything with this
software that would otherwise infringe that contributor's
copyright in it.

## Notices

You must ensure that everyone who gets a copy of
any part of this software from you, with or without
changes, also gets the text of this license or a link to
<https://blueoakcouncil.org/license/1.0.0>.

## Excuse

If anyone notifies you in writing that you have not
complied with [Notices](#notices), you can keep your
license by taking all practical steps to comply within 30
days after the notice.  If you do not do so, your license
ends immediately.

## Patent

Each contributor licenses you to do everything with this
software that would otherwise infringe any patent claims
they can license or become able to license.

## Reliability

No contributor can revoke this license.

## No Liability

***As far as the law allows, this software comes as is,
without any warranty or condition, and no contributor
will be liable to anyone for any damages related to this
software or this license, under any kind of legal claim.***

```

### pbkdf2@3.1.2

From https://github.com/crypto-browserify/pbkdf2.

**MIT**:

Copyright: Copyright (c) 2014 Daniel Cousens

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### peek-readable@4.1.0

From https://github.com/Borewit/peek-readable.

**MIT**:

```
The MIT License

Copyright (c) 2010-2017 Borewit

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### performance-now@2.1.0

From https://github.com/braveg1rl/performance-now.

**MIT**:

Copyright: Copyright (c) 2013 Braveg1rl

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### picocolors@1.0.0, picocolors@1.0.1, picocolors@1.1.0, picocolors@1.1.1

From https://github.com/alexeyraspopov/picocolors.

**ISC**:

```
ISC License

Copyright (c) 2021 Alexey Raspopov, Kostiantyn Denysov, Anton Verinov

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### picomatch@2.3.0, picomatch@3.0.1

From https://github.com/micromatch/picomatch.

**MIT**:

Copyright: Copyright (c) 2017-present, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pify@4.0.1

From https://github.com/sindresorhus/pify.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pipe-functions@1.3.0

From https://github.com/DiegoZoracKy/pipe-functions.

**MIT**:

```
The MIT License (MIT)

Copyright (c) 2015 INFOinvest http://infoinvest.com.br

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

### pirates@4.0.5, pirates@4.0.6

From https://github.com/danez/pirates.

**MIT**:

Copyright: Copyright (c) 2016-2018 Ari Porad

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pkg-dir@3.0.0

From https://github.com/sindresorhus/pkg-dir.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### plist@3.1.0

From https://github.com/TooTallNate/node-plist.

**MIT**:

Copyright: Copyright (c) 2010-2017 Nathan Rajlich <nathan@tootallnate.net>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pngjs@3.4.0

From https://github.com/lukeapage/pngjs2.

**MIT**:

```
pngjs2 original work Copyright (c) 2015 Luke Page & Original Contributors
pngjs derived work Copyright (c) 2012 Kuba Niegowski

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### posix-character-classes@0.1.1

From https://github.com/jonschlinkert/posix-character-classes.

**MIT**:

Copyright: Copyright (c) 2016-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### postcss-value-parser@4.2.0

From https://github.com/TrySound/postcss-value-parser.

**MIT**:

Copyright: Copyright (c) Bogdan Chadkin <trysound@yandex.ru>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### postcss@8.4.47

From https://github.com/postcss/postcss.

**MIT**:

Copyright: Copyright 2013 Andrey Sitnik <andrey@sitnik.ru>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pretty-bytes@5.6.0

From https://github.com/sindresorhus/pretty-bytes.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### proc-log@4.2.0

From https://github.com/npm/proc-log.

**ISC**:

```
The ISC License

Copyright (c) GitHub, Inc.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### process-nextick-args@2.0.1

From https://github.com/calvinmetcalf/process-nextick-args.

**MIT**:

```
# Copyright (c) 2015 Calvin Metcalf

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

**THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.**

```

### process@0.11.10

From https://github.com/shtylman/node-process.

**MIT**:

Copyright: Copyright (c) 2013 Roman Shtylman <shtylman@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### progress@2.0.3

From https://github.com/visionmedia/node-progress.

**MIT**:

Copyright: Copyright (c) 2017 TJ Holowaychuk <tj@vision-media.ca>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### promise-inflight@1.0.1

From https://github.com/iarna/promise-inflight.

**ISC**:

```
Copyright (c) 2017, Rebecca Turner <me@re-becca.org>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


```

### promise-retry@2.0.1

From https://github.com/IndigoUnited/node-promise-retry.

**MIT**:

Copyright: Copyright (c) 2014 IndigoUnited

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### promise@7.3.1, promise@8.3.0

From https://github.com/then/promise.

**MIT**:

Copyright: Copyright (c) 2014 Forbes Lindesay

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prompts@2.4.2

From https://github.com/terkelg/prompts.

**MIT**:

Copyright: Copyright (c) 2018 Terkel Gjervig Nielsen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prop-types@15.7.2, prop-types@15.8.1

From https://github.com/facebook/prop-types.

**MIT**:

Copyright: Copyright (c) 2013-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-commands@1.7.1

From https://github.com/prosemirror/prosemirror-commands.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-dropcursor@1.8.2

From https://github.com/prosemirror/prosemirror-dropcursor.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-example-setup@1.2.3

From https://github.com/prosemirror/prosemirror-example-setup.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-gapcursor@1.3.2

From https://github.com/prosemirror/prosemirror-gapcursor.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-history@1.4.1

From https://github.com/prosemirror/prosemirror-history.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-inputrules@1.5.0

From https://github.com/prosemirror/prosemirror-inputrules.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-keymap@1.2.3

From https://github.com/prosemirror/prosemirror-keymap.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-menu@1.2.5

From https://github.com/prosemirror/prosemirror-menu.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-model@1.25.2

From https://github.com/prosemirror/prosemirror-model.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-schema-list@1.5.1

From https://github.com/prosemirror/prosemirror-schema-list.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-search@1.1.0

From https://github.com/prosemirror/prosemirror-search.

**MIT**:

Copyright: Copyright (C) 2024 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-state@1.4.3

From https://github.com/prosemirror/prosemirror-state.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-tables@1.7.1

From https://github.com/prosemirror/prosemirror-tables.

**MIT**:

Copyright: Copyright (C) 2015-2016 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-transform@1.10.4

From https://github.com/prosemirror/prosemirror-transform.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prosemirror-view@1.40.0

From https://github.com/prosemirror/prosemirror-view.

**MIT**:

Copyright: Copyright (C) 2015-2017 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### psl@1.8.0

From https://github.com/lupomontero/psl.

**MIT**:

Copyright: Copyright (c) 2017 Lupo Montero lupomontero@gmail.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### public-encrypt@4.0.3

From https://github.com/crypto-browserify/publicEncrypt.

**MIT**:

Copyright: Copyright (c) 2017 Calvin Metcalf

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pump@3.0.0

From https://github.com/mafintosh/pump.

**MIT**:

Copyright: Copyright (c) 2014 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### punycode@1.4.1, punycode@2.1.1, punycode@1.3.2

From https://github.com/bestiejs/punycode.js.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### punycode@2.3.1

From https://github.com/mathiasbynens/punycode.js.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### qrcode-terminal@0.11.0

From https://github.com/gtanner/qrcode-terminal.

**Apache 2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

==============================================================
This product also include the following software:
==============================================================

 QRCode for JavaScript

 Copyright (c) 2009 Kazuhiko Arase

 URL: http://www.d-project.com/

 Licensed under the MIT license:
   http://www.opensource.org/licenses/mit-license.php

 The word "QR Code" is registered trademark of 
 DENSO WAVE INCORPORATED
   http://www.denso-wave.com/qrcode/faqpatent-e.html

Located in ./vendor/QRCode
- project has been modified to work in Node and some refactoring was done for code cleanup

```

### qs@6.13.0, qs@6.5.2, qs@6.11.0, qs@6.11.2

From https://github.com/ljharb/qs.

**BSD-3-Clause**:

```
BSD 3-Clause License

Copyright (c) 2014, Nathan LaFreniere and other [contributors](https://github.com/ljharb/qs/graphs/contributors)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### query-string@7.1.3

From https://github.com/sindresorhus/query-string.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (http://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### querystringify@2.2.0

From https://github.com/unshiftio/querystringify.

**MIT**:

Copyright: Copyright (c) 2015 Unshift.io, Arnout Kazemier,  the Contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### queue-microtask@1.2.3

From https://github.com/feross/queue-microtask.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### queue-tick@1.0.1

From https://github.com/mafintosh/queue-tick.

**MIT**:

Copyright: Copyright (c) 2021 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### queue@6.0.2

From https://github.com/jessetane/queue.

**MIT**:

Copyright: Copyright (c) 2014 Jesse Tane <jesse.tane@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### random-bytes@1.0.0

From https://github.com/crypto-utils/random-bytes.

**MIT**:

Copyright: Copyright (c) 2016 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### randombytes@2.1.0

From https://github.com/crypto-browserify/randombytes.

**MIT**:

Copyright: Copyright (c) 2017 crypto-browserify

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### randomfill@1.0.4

From https://github.com/crypto-browserify/randomfill.

**MIT**:

Copyright: Copyright (c) 2017 crypto-browserify

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### range-parser@1.2.1

From https://github.com/jshttp/range-parser.

**MIT**:

Copyright: Copyright (c) 2015-2016 Douglas Christopher Wilson <doug@somethingdoug.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### rc@1.2.8

From https://github.com/dominictarr/rc.

**(BSD-2-Clause OR MIT OR Apache-2.0)**:

```
Apache License, Version 2.0

Copyright (c) 2011 Dominic Tarr

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

```

### re-reselect@4.0.1

From https://github.com/toomuchdesign/re-reselect.

**MIT**:

Copyright: Copyright (c) Andrea Carraro

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-devtools-core@4.24.0, react-devtools-core@6.1.2, react-dom@19.0.0, react-is@16.13.1, react-is@17.0.2, react-is@18.2.0, react-refresh@0.14.0, react-refresh@0.14.2, react-refresh@0.4.3, react@18.3.1, react@19.0.0, scheduler@0.22.0, scheduler@0.25.0, use-sync-external-store@1.2.0

From https://github.com/facebook/react.

**MIT**:

Copyright: Copyright (c) Meta Platforms, Inc. and affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-device-info@14.0.4

From https://github.com/react-native-device-info/react-native-device-info.

**MIT**:

Copyright: Copyright (c) 2015 Rebecca Hughes

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-dropdownalert@5.1.0

From https://github.com/testshallpass/react-native-dropdownalert.

**MIT**:

Copyright: Copyright (c) 2020 testshallpass

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-edge-to-edge@1.6.0

From https://github.com/zoontek/react-native-edge-to-edge.

**MIT**:

Copyright: Copyright (c) 2024 Mathieu Acthernoene

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-exit-app@2.0.0

From https://github.com/wumke/react-native-exit-app.

**MIT**:

```
MIT License

Copyright (c) 2018 Wumke

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### react-native-file-viewer@2.1.5

From https://github.com/vinzscam/react-native-file-viewer.

**MIT**:

Copyright: Copyright (c) 2017 Vincenzo Scamporlino

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-fs@2.20.0

From https://github.com/itinance/react-native-fs.

**MIT**:

Copyright: Copyright (c) 2015 Johannes Lumpe

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-get-random-values@1.11.0

From https://github.com/LinusU/react-native-get-random-values.

**MIT**:

Copyright: Copyright (c) 2018, 2020 Linus Unnebäck

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-image-picker@8.2.1

From https://github.com/react-native-image-picker/react-native-image-picker.

**MIT**:

Copyright: Copyright (c) 2015-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-localize@3.4.2

From https://github.com/zoontek/react-native-localize.

**MIT**:

Copyright: Copyright (c) 2017-present, Mathieu Acthernoene

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-modal-datetime-picker@18.0.0

From https://github.com/mmazzarolo/react-native-modal-datetime-picker.

**MIT**:

Copyright: Copyright (c) 2017 Mazzarolo Matteo

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-paper@5.14.5

From https://github.com/callstack/react-native-paper.

**MIT**:

Copyright: Copyright (c) 2017 Callstack

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-popup-menu@0.17.0

From https://github.com/instea/react-native-popup-menu.

**ISC**:

```
ISC License

Copyright (c) 2016, instea

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### react-native-quick-actions@0.3.13

From https://github.com/jordanbyron/react-native-quick-actions.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Byron (http://github.com/jordanbyron/)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-quick-base64@2.1.2

From https://github.com/craftzdog/react-native-quick-base64.

**MIT**:

Copyright: Copyright (c) 2022 Takuya Matsuyama

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-quick-crypto@0.7.17

From https://github.com/margelo/react-native-quick-crypto.

**MIT**:

```
**react-native-quick-crypto**

MIT License

Copyright (c) 2021 Margelo GmbH

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

**NodeJS Crypto**

See https://github.com/nodejs/node/blob/main/LICENSE

```

### react-native-rsa-native@2.0.5

From https://github.com/amitaymolko/react-native-rsa-native.

**MIT**:

Copyright: Copyright (c) 2016 Sam Saffron

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-safe-area-context@5.4.1

From https://github.com/th3rdwave/react-native-safe-area-context.

**MIT**:

Copyright: Copyright (c) 2019 Th3rd Wave

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-securerandom@1.0.1

From https://github.com/robhogan/react-native-securerandom.

**MIT**:

Copyright: Copyright (c) 2017 Rob Hogan <roberthogan@blueyonder.co.uk>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-share@12.1.0

From https://github.com/react-native-community/react-native-share.

**MIT**:

Copyright: Copyright (c) 2015 Esteban Fuentealba 🇨🇱, Mateus Andrade 🇧🇷, Mike Hardy 🇪🇨, João Marins 🇧🇷

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-sqlite-storage@6.0.1

From https://github.com/andpor/react-native-sqlite-storage.

**MIT**:

Copyright: Copyright (c) 2015 andpor

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-svg@15.13.0

From https://github.com/react-native-community/react-native-svg.

**MIT**:

Copyright: Copyright (c) [2015-2016] [Horcrux]

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-url-polyfill@2.0.0

From https://github.com/charpeni/react-native-url-polyfill.

**MIT**:

Copyright: Copyright (c) 2019 Nicolas Charpentier

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-vector-icons@10.2.0

From https://github.com/oblador/react-native-vector-icons.

**MIT**:

Copyright: Copyright (c) 2015 Joel Arvidsson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-version-info@1.1.1

From https://github.com/tessus/react-native-version-info.

**MIT**:

Copyright: Copyright 2018 Helmut K. C. Tessarek <tessarek@evermeet.cx>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-webview@13.15.0

From https://github.com/react-native-webview/react-native-webview.

**MIT**:

Copyright: Copyright (c) 2015-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-native-zip-archive@7.0.2

From https://github.com/mockingbot/react-native-zip-archive.

**MIT**:

Copyright: Copyright (c) 2015 MockingBot

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### react-redux@8.1.3

From https://github.com/reduxjs/react-redux.

**MIT**:

```
The MIT License (MIT)

Copyright (c) 2015-present Dan Abramov

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### react-shallow-renderer@16.15.0

From https://github.com/NMinhNguyen/react-shallow-renderer.

**MIT**:

Copyright: Copyright (c) Facebook, Inc. and its affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### readable-stream@2.3.7, readable-stream@2.3.8, readable-stream@3.6.0, readable-stream@4.5.2

From https://github.com/nodejs/readable-stream.

**MIT**:

```
Node.js is licensed for use as follows:

"""
Copyright Node.js contributors. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
"""

This license applies to parts of Node.js originating from the
https://github.com/joyent/node repository:

"""
Copyright Joyent, Inc. and other Node contributors. All rights reserved.
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
"""

```

### readable-web-to-node-stream@3.0.2

From https://github.com/Borewit/readable-web-to-node-stream.

**MIT**:


````
![Karma CI](https://github.com/Borewit/readable-web-to-node-stream/workflows/Karma%20CI/badge.svg)
[![NPM version](https://badge.fury.io/js/readable-web-to-node-stream.svg)](https://npmjs.org/package/readable-web-to-node-stream)
[![npm downloads](http://img.shields.io/npm/dm/readable-web-to-node-stream.svg)](https://npmcharts.com/compare/readable-web-to-node-stream)
[![dependencies Status](https://david-dm.org/Borewit/readable-web-to-node-stream/status.svg)](https://david-dm.org/Borewit/readable-web-to-node-stream)
[![Known Vulnerabilities](https://snyk.io/test/github/Borewit/readable-web-to-node-stream/badge.svg?targetFile=package.json)](https://snyk.io/test/github/Borewit/readable-web-to-node-stream?targetFile=package.json)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/d4b511481b3a4634b6ca5c0724407eb9)](https://www.codacy.com/gh/Borewit/peek-readable/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=Borewit/peek-readable&amp;utm_campaign=Badge_Grade)
[![Coverage Status](https://coveralls.io/repos/github/Borewit/readable-web-to-node-stream/badge.svg?branch=master)](https://coveralls.io/github/Borewit/readable-web-to-node-stream?branch=master)
[![Minified size](https://badgen.net/bundlephobia/min/readable-web-to-node-stream)](https://bundlephobia.com/result?p=readable-web-to-node-stream)

# readable-web-to-node-stream

Converts a [Web-API readable stream](https://developer.mozilla.org/en-US/docs/Web/API/ReadableStreamDefaultReader) into a [Node.js readable stream](https://nodejs.org/api/stream.html#stream_readable_streams).

## Installation
Install via [npm](http://npmjs.org/):

```bash
npm install readable-web-to-node-stream
```
or or [yarn](https://yarnpkg.com/):
```bash
yarn add readable-web-to-node-stream
```

## Compatibility

Source is written in TypeScript and compiled to ECMAScript 2017 (ES8).

Unit tests are performed on the following browsers:

*   Google Chrome 74.0
*   Firefox 68.0
*   Safari 12.0
*   Opera 60.0
 
## Example

Import readable-web-stream-to-node in JavaScript:
```js
const {ReadableWebToNodeStream} = require('readable-web-to-node-stream');

async function download(url) {
    const response = await fetch(url);
    const readableWebStream = response.body;
    const nodeStream = new ReadableWebToNodeStream(readableWebStream);
}
```

## API

**constructor(stream: ReadableStream): Promise<void>**

`stream: ReadableStream`: the [Web-API readable stream](https://developer.mozilla.org/en-US/docs/Web/API/ReadableStreamDefaultReader).

**close(): Promise<void>**
Will cancel close the Readable-node stream, and will release Web-API-readable-stream.

**waitForReadToComplete(): Promise<void>**
If there is no unresolved read call to Web-API Readable​Stream immediately returns, otherwise it will wait until the read is resolved.

## Licence

(The MIT License)

Copyright (c) 2019 Borewit

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 'Software'), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


````

### readdirp@3.6.0

From https://github.com/paulmillr/readdirp.

**MIT**:

Copyright: Copyright (c) 2012-2019 Thorsten Lorenz, Paul Miller (https://paulmillr.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### readline@1.3.0

From https://github.com/maleck13/readline.

**BSD***:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### recast@0.20.5

From https://github.com/benjamn/recast.

**MIT**:

Copyright: Copyright (c) 2012 Ben Newman <bn@cs.stanford.edu>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### reduce-flatten@1.0.1

From https://github.com/75lb/reduce-flatten.

**MIT**:

Copyright: Copyright (c) 2016 Lloyd Brookes <75pound@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### redux@4.2.1

From https://github.com/reduxjs/redux.

**MIT**:

Copyright: Copyright (c) 2015-present Dan Abramov

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### regenerate-unicode-properties@10.1.0

From https://github.com/mathiasbynens/regenerate-unicode-properties.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### regenerate@1.4.2

From https://github.com/mathiasbynens/regenerate.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### regenerator-runtime@0.13.11, regenerator-runtime@0.14.0, regenerator-transform@0.15.2

From https://github.com/facebook/regenerator.git#main.

**MIT**:

Copyright: Copyright (c) 2014-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### regenerator-runtime@0.13.9

From https://github.com/facebook/regenerator.git#master.

**MIT**:

Copyright: Copyright (c) 2014-present, Facebook, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### regex-not@1.0.2

From https://github.com/jonschlinkert/regex-not.

**MIT**:

Copyright: Copyright (c) 2016, 2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### regexpu-core@5.3.2

From https://github.com/mathiasbynens/regexpu-core.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### regjsparser@0.9.1

From https://github.com/jviereck/regjsparser.

**BSD-2-Clause**:

```
Copyright (c) Julian Viereck and Contributors, All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### relateurl@0.2.7

From https://github.com/stevenvachon/relateurl.

**MIT**:

Copyright: Copyright (c) Steven Vachon <contact@svachon.com> (svachon.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### relative@3.0.2

From https://github.com/jonschlinkert/relative.

**MIT**:

Copyright: Copyright (c) 2014-2015, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### repeat-element@1.1.4

From https://github.com/jonschlinkert/repeat-element.

**MIT**:

Copyright: Copyright (c) 2015-present, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### repeat-string@1.6.1

From https://github.com/jonschlinkert/repeat-string.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### request@2.88.2

From https://github.com/request/request.

**Apache-2.0**:

```
Apache License

Version 2.0, January 2004

http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.

"Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.

2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.

3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.

4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of this License; and

You must cause any modified files to carry prominent notices stating that You changed the files; and

You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and

If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.

5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.

7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.

8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS
```

### require-directory@2.1.1

From https://github.com/troygoode/node-require-directory.

**MIT**:

Copyright: Copyright (c) 2011 Troy Goode <troygoode@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### require-from-string@2.0.2

From https://github.com/floatdrop/require-from-string.

**MIT**:

Copyright: Copyright (c) Vsevolod Strukchinsky <floatdrop@gmail.com> (github.com/floatdrop)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### require-main-filename@2.0.0

From https://github.com/yargs/require-main-filename.

**ISC**:

```
Copyright (c) 2016, Contributors

Permission to use, copy, modify, and/or distribute this software
for any purpose with or without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE
LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### requireg@0.2.2

From https://github.com/h2non/requireg.

**MIT**:

Copyright: Copyright 2013 Tomas Aparicio

All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### requires-port@1.0.0

From https://github.com/unshiftio/requires-port.

**MIT**:

Copyright: Copyright (c) 2015 Unshift.io, Arnout Kazemier,  the Contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### reselect@4.1.8

From https://github.com/reduxjs/reselect.

**MIT**:

```
The MIT License (MIT)

Copyright (c) 2015-2018 Reselect Contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### resolve-from@3.0.0, resolve-from@4.0.0, resolve-from@5.0.0

From https://github.com/sindresorhus/resolve-from.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### resolve-url@0.2.1

From https://github.com/lydell/resolve-url.

**MIT**:

Copyright: Copyright (c) 2013 Simon Lydell

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### resolve-workspace-root@2.0.0

From https://github.com/byCedric/resolve-workspace-root.

**MIT**:

```
# The MIT License (MIT)

Copyright (c) 2024-present Cedric van Putten <me@cedric.dev>

> Permission is hereby granted, free of charge, to any person obtaining a copy
> of this software and associated documentation files (the "Software"), to deal
> in the Software without restriction, including without limitation the rights
> to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
> copies of the Software, and to permit persons to whom the Software is
> furnished to do so, subject to the following conditions:
>
> The above copyright notice and this permission notice shall be included in
> all copies or substantial portions of the Software.
>
> THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
> IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
> FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
> AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
> LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
> OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
> THE SOFTWARE.

```

### resolve.exports@2.0.3

From https://github.com/lukeed/resolve.exports.

**MIT**:

Copyright: Copyright (c) Luke Edwards <luke.edwards05@gmail.com> (lukeed.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### resolve@1.20.0, resolve@1.22.8, resolve@1.7.1

From https://github.com/browserify/resolve.

**MIT**:

Copyright: Copyright (c) 2012 James Halliday

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### restore-cursor@2.0.0, restore-cursor@3.1.0

From https://github.com/sindresorhus/restore-cursor.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ret@0.1.15

From https://github.com/fent/ret.js.

**MIT**:

Copyright: Copyright (C) 2011 by Roly Fentanes

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### retry@0.12.0

From https://github.com/tim-kos/node-retry.

**MIT**:

```
Copyright (c) 2011:
Tim Koschützki (tim@debuggable.com)
Felix Geisendörfer (felix@debuggable.com)

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.

```

### reusify@1.0.4

From https://github.com/mcollina/reusify.

**MIT**:

Copyright: Copyright (c) 2015 Matteo Collina

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### rimraf@2.2.8

From https://github.com/isaacs/rimraf.

**MIT**:

Copyright: Copyright 2009, 2010, 2011 Isaac Z. Schlueter.

All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### rimraf@2.6.3, rimraf@2.7.1, rimraf@3.0.2

From https://github.com/isaacs/rimraf.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### ripemd160@2.0.2

From https://github.com/crypto-browserify/ripemd160.

**MIT**:

Copyright: Copyright (c) 2016 crypto-browserify

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### rn-fetch-blob@0.12.0

From https://github.com/joltup/rn-fetch-blob.

**MIT**:

Copyright: Copyright (c) 2017 xeiyan@gmail.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### rope-sequence@1.3.4

From https://github.com/marijnh/rope-sequence.

**MIT**:

Copyright: Copyright (C) 2016 by Marijn Haverbeke <marijn@haverbeke.berlin>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### rrweb-cssom@0.8.0

From https://github.com/rrweb-io/CSSOM.

**MIT**:

Copyright: Copyright (c) Nikita Vasilyev

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### run-parallel@1.2.0

From https://github.com/feross/run-parallel.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### safe-buffer@5.1.2, safe-buffer@5.2.1

From https://github.com/feross/safe-buffer.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### safe-regex@1.1.0

From https://github.com/substack/safe-regex.

**MIT**:

```
This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### safer-buffer@2.1.2

From https://github.com/ChALkeR/safer-buffer.

**MIT**:

Copyright: Copyright (c) 2018 Nikita Skovoroda <chalkerx@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### sax@1.2.4, sax@1.2.1

From https://github.com/isaacs/sax-js.

**ISC**:


``
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

====

`String.fromCodePoint` by Mathias Bynens used according to terms of MIT
License, as follows:

    Copyright Mathias Bynens <https://mathiasbynens.be/>

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


``

### saxes@6.0.0

From https://github.com/lddubeau/saxes.

**ISC**:


``
The ISC License

Copyright (c) Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

====

The following license is the one that governed sax, from which saxes
was forked. Isaac Schlueter is not *directly* involved with saxes so
don't go bugging him for saxes issues.

The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

====

`String.fromCodePoint` by Mathias Bynens is no longer used, but it can
still be found in old commits. It was once used according to terms of
MIT License, as follows:

    Copyright Mathias Bynens <https://mathiasbynens.be/>

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


``

### semver@5.7.1, semver@6.3.0, semver@6.3.1, semver@7.0.0, semver@7.3.5, semver@7.3.8, semver@7.5.4, semver@7.6.0, semver@7.6.2, semver@7.7.1, semver@7.7.2

From https://github.com/npm/node-semver.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### send@0.17.1, send@0.19.0, send@0.19.1

From https://github.com/pillarjs/send.

**MIT**:

Copyright: Copyright (c) 2014-2016 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### serialize-error@2.1.0, serialize-error@7.0.1

From https://github.com/sindresorhus/serialize-error.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### serve-static@1.14.1, serve-static@1.16.2

From https://github.com/expressjs/serve-static.

**MIT**:

Copyright: Copyright (c) 2014-2016 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### server-destroy@1.0.1

From https://github.com/isaacs/server-destroy.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### set-blocking@2.0.0

From https://github.com/yargs/set-blocking.

**ISC**:

```
Copyright (c) 2016, Contributors

Permission to use, copy, modify, and/or distribute this software
for any purpose with or without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE
LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### set-function-length@1.2.2

From https://github.com/ljharb/set-function-length.

**MIT**:

Copyright: Copyright (c) Jordan Harband and contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### set-value@2.0.1

From https://github.com/jonschlinkert/set-value.

**MIT**:

Copyright: Copyright (c) 2014-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### setimmediate@1.0.5

From https://github.com/YuzuJS/setImmediate.

**MIT**:

Copyright: Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### setprototypeof@1.1.1, setprototypeof@1.2.0

From https://github.com/wesleytodd/setprototypeof.

**ISC**:

```
Copyright (c) 2015, Wes Todd

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### sha.js@2.4.11

From https://github.com/crypto-browserify/sha.js.

**(MIT AND BSD-3-Clause)**:

```
Copyright (c) 2013-2018 sha.js contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.


Copyright (c) 1998 - 2009, Paul Johnston & Contributors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of the author nor the names of its contributors may be used to
endorse or promote products derived from this software without specific prior
written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


```

### shallow-clone@3.0.1

From https://github.com/jonschlinkert/shallow-clone.

**MIT**:

Copyright: Copyright (c) 2015-present, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### shebang-command@1.2.0, shebang-command@2.0.0

From https://github.com/kevva/shebang-command.

**MIT**:

Copyright: Copyright (c) Kevin Martensson <kevinmartensson@gmail.com> (github.com/kevva)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### shebang-regex@1.0.0, shebang-regex@3.0.0

From https://github.com/sindresorhus/shebang-regex.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### shell-quote@1.7.3

From https://github.com/substack/node-shell-quote.

**MIT**:

Copyright: Copyright (c) 2013 James Halliday (mail@substack.net)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### shell-quote@1.7.4

From https://github.com/ljharb/shell-quote.

**MIT**:

Copyright: Copyright (c) 2013 James Halliday (mail@substack.net)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### shellwords@0.1.1

From https://github.com/jimmycuadra/shellwords.

**MIT**:

Copyright: Copyright (C) 2011 by Jimmy Cuadra

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### side-channel@1.0.4, side-channel@1.0.6

From https://github.com/ljharb/side-channel.

**MIT**:

Copyright: Copyright (c) 2019 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### signal-exit@3.0.6, signal-exit@3.0.7, signal-exit@4.0.2

From https://github.com/tapjs/signal-exit.

**ISC**:

```
The ISC License

Copyright (c) 2015, Contributors

Permission to use, copy, modify, and/or distribute this software
for any purpose with or without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE
LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### simple-plist@1.4.0

From https://github.com/wollardj/simple-plist.

**MIT**:

Copyright: Copyright (c) 2013 Joe Wollard

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### simple-swizzle@0.2.2

From https://github.com/qix-/node-simple-swizzle.

**MIT**:

Copyright: Copyright (c) 2015 Josh Junon

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### sisteransi@1.0.5

From https://github.com/terkelg/sisteransi.

**MIT**:

Copyright: Copyright (c) 2018 Terkel Gjervig Nielsen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### slash@3.0.0

From https://github.com/sindresorhus/slash.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### slice-ansi@2.1.0, slice-ansi@1.0.0

From https://github.com/chalk/slice-ansi.

**MIT**:

Copyright: Copyright (c) DC <threedeecee@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### slugify@1.6.6

From https://github.com/simov/slugify.

**MIT**:

Copyright: Copyright (c) Simeon Velichkov <simeonvelichkov@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### smart-buffer@4.2.0

From https://github.com/JoshGlazebrook/smart-buffer.

**MIT**:

Copyright: Copyright (c) 2013-2017 Josh Glazebrook

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### snapdragon-node@2.1.1

From https://github.com/jonschlinkert/snapdragon-node.

**MIT**:

Copyright: Copyright (c) 2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### snapdragon-util@3.0.1

From https://github.com/jonschlinkert/snapdragon-util.

**MIT**:

Copyright: Copyright (c) 2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### snapdragon@0.8.2

From https://github.com/jonschlinkert/snapdragon.

**MIT**:

Copyright: Copyright (c) 2015-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### socks-proxy-agent@6.1.1

From https://github.com/TooTallNate/node-socks-proxy-agent.

**MIT**:


````
socks-proxy-agent
================
### A SOCKS proxy `http.Agent` implementation for HTTP and HTTPS
[![Build Status](https://github.com/TooTallNate/node-socks-proxy-agent/workflows/Node%20CI/badge.svg)](https://github.com/TooTallNate/node-socks-proxy-agent/actions?workflow=Node+CI)

This module provides an `http.Agent` implementation that connects to a
specified SOCKS proxy server, and can be used with the built-in `http`
and `https` modules.

It can also be used in conjunction with the `ws` module to establish a WebSocket
connection over a SOCKS proxy. See the "Examples" section below.

Installation
------------

Install with `npm`:

``` bash
$ npm install socks-proxy-agent
```


Examples
--------

#### TypeScript example

```ts
import https from 'https';
import { SocksProxyAgent } from 'socks-proxy-agent';

const info = {
	host: 'br41.nordvpn.com',
	userId: 'your-name@gmail.com',
	password: 'abcdef12345124'
};
const agent = new SocksProxyAgent(info);

https.get('https://jsonip.org', { agent }, (res) => {
	console.log(res.headers);
	res.pipe(process.stdout);
});
```

#### `http` module example

```js
var url = require('url');
var http = require('http');
var SocksProxyAgent = require('socks-proxy-agent');

// SOCKS proxy to connect to
var proxy = process.env.socks_proxy || 'socks://127.0.0.1:1080';
console.log('using proxy server %j', proxy);

// HTTP endpoint for the proxy to connect to
var endpoint = process.argv[2] || 'http://nodejs.org/api/';
console.log('attempting to GET %j', endpoint);
var opts = url.parse(endpoint);

// create an instance of the `SocksProxyAgent` class with the proxy server information
var agent = new SocksProxyAgent(proxy);
opts.agent = agent;

http.get(opts, function (res) {
	console.log('"response" event!', res.headers);
	res.pipe(process.stdout);
});
```

#### `https` module example

```js
var url = require('url');
var https = require('https');
var SocksProxyAgent = require('socks-proxy-agent');

// SOCKS proxy to connect to
var proxy = process.env.socks_proxy || 'socks://127.0.0.1:1080';
console.log('using proxy server %j', proxy);

// HTTP endpoint for the proxy to connect to
var endpoint = process.argv[2] || 'https://encrypted.google.com/';
console.log('attempting to GET %j', endpoint);
var opts = url.parse(endpoint);

// create an instance of the `SocksProxyAgent` class with the proxy server information
var agent = new SocksProxyAgent(proxy);
opts.agent = agent;

https.get(opts, function (res) {
	console.log('"response" event!', res.headers);
	res.pipe(process.stdout);
});
```

#### `ws` WebSocket connection example

``` js
var WebSocket = require('ws');
var SocksProxyAgent = require('socks-proxy-agent');

// SOCKS proxy to connect to
var proxy = process.env.socks_proxy || 'socks://127.0.0.1:1080';
console.log('using proxy server %j', proxy);

// WebSocket endpoint for the proxy to connect to
var endpoint = process.argv[2] || 'ws://echo.websocket.org';
console.log('attempting to connect to WebSocket %j', endpoint);

// create an instance of the `SocksProxyAgent` class with the proxy server information
var agent = new SocksProxyAgent(proxy);

// initiate the WebSocket connection
var socket = new WebSocket(endpoint, { agent: agent });

socket.on('open', function () {
	console.log('"open" event!');
	socket.send('hello world');
});

socket.on('message', function (data, flags) {
	console.log('"message" event! %j %j', data, flags);
	socket.close();
});
```

License
-------

(The MIT License)

Copyright (c) 2013 Nathan Rajlich &lt;nathan@tootallnate.net&gt;

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


````

### socks@2.6.1

From https://github.com/JoshGlazebrook/socks.

**MIT**:

Copyright: Copyright (c) 2013 Josh Glazebrook

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### source-map-js@1.2.1

From https://github.com/7rulnik/source-map-js.

**BSD-3-Clause**:

```

Copyright (c) 2009-2011, Mozilla Foundation and contributors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the names of the Mozilla Foundation nor the names of project
  contributors may be used to endorse or promote products derived from this
  software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### source-map-resolve@0.5.3

From https://github.com/lydell/source-map-resolve.

**MIT**:

Copyright: Copyright (c) 2019 ZHAO Jinxiang

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### source-map-support@0.5.21

From https://github.com/evanw/node-source-map-support.

**MIT**:

Copyright: Copyright (c) 2014 Evan Wallace

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### source-map-url@0.4.1

From https://github.com/lydell/source-map-url.

**MIT**:

Copyright: Copyright (c) 2014 Simon Lydell

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### source-map@0.5.7, source-map@0.6.1, source-map@0.7.3

From https://github.com/mozilla/source-map.

**BSD-3-Clause**:

```

Copyright (c) 2009-2011, Mozilla Foundation and contributors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the names of the Mozilla Foundation nor the names of project
  contributors may be used to endorse or promote products derived from this
  software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### split-on-first@1.1.0

From https://github.com/sindresorhus/split-on-first.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### split-string@3.1.0

From https://github.com/jonschlinkert/split-string.

**MIT**:

Copyright: Copyright (c) 2015-2017, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### sprintf-js@1.0.3, sprintf-js@1.1.3, sprintf-js@1.1.2

From https://github.com/alexei/sprintf.js.

**BSD-3-Clause**:

```
Copyright (c) 2007-2014, Alexandru Marasteanu <hello [at) alexei (dot] ro>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.
* Neither the name of this software nor the names of its contributors may be
  used to endorse or promote products derived from this software without
  specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### sqlite3@5.1.6

From https://github.com/TryGhost/node-sqlite3.

**BSD-3-Clause**:

```
Copyright (c) MapBox
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

- Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
- Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
- Neither the name "MapBox" nor the names of its contributors may be
  used to endorse or promote products derived from this software without
  specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```

### sshpk@1.16.1

From https://github.com/joyent/node-sshpk.

**MIT**:

Copyright: Copyright Joyent, Inc. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ssri@8.0.1

From https://github.com/npm/ssri.

**ISC**:

```
ISC License

Copyright (c) npm, Inc.

Permission to use, copy, modify, and/or distribute this software for
any purpose with or without fee is hereby granted, provided that the
above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE COPYRIGHT HOLDER DISCLAIMS
ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.

```

### stack-utils@2.0.5

From https://github.com/tapjs/stack-utils.

**MIT**:

Copyright: Copyright (c) Isaac Z. Schlueter <i@izs.me>, James Talmage <james@talmage.io> (github.com/jamestalmage), and Contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### stackframe@1.2.0

From https://github.com/stacktracejs/stackframe.

**MIT**:

Copyright: Copyright (c) 2017 Eric Wendelin and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### stacktrace-parser@0.1.10

From https://github.com/errwischt/stacktrace-parser.

**MIT**:

Copyright: Copyright (c) 2014-2019 Georg Tavonius

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### static-extend@0.1.2

From https://github.com/jonschlinkert/static-extend.

**MIT**:

Copyright: Copyright (c) 2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### statuses@1.5.0, statuses@2.0.1

From https://github.com/jshttp/statuses.

**MIT**:

Copyright: Copyright (c) 2016 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### stream-browserify@3.0.0

From https://github.com/browserify/stream-browserify.

**MIT**:

Copyright: Copyright (c) James Halliday

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### stream-buffers@2.2.0

From https://github.com/samcday/node-stream-buffer.

**Unlicense**:


````
# Node Stream Buffers

[![Build Status][badge-travis-img]][badge-travis-url]
[![Code Climate][badge-climate-img]][badge-climate-url]
[![Code Coverage][badge-coverage-img]][badge-coverage-url]

Simple Readable and Writable Streams that use a [Buffer][node-buffer-docs] to store received data, or for data to send out. Useful for test code, debugging, and a wide range of other utilities.

## Installation

[![NPM][badge-npm-img]][badge-npm-url]

## Usage

To use the stream buffers in your module, simply import it and away you go.

```js
var streamBuffers = require("stream-buffers");
```

### Writable StreamBuffer

Writable Stream Buffers implement the standardized writable stream interface. All write()'s to this object will accumulate in an internal Buffer. If the Buffer overflows it will be resized larger automatically. The initial size of the Buffer and the amount in which it grows can be configured in the constructor.

```js
var myWritableStreamBuffer = new streamBuffers.WritableStreamBuffer({
	initialSize: (100 * 1024),		// start as 100 kilobytes.
	incrementAmount: (10 * 1024)	// grow by 10 kilobytes each time buffer overflows.
});
```

The default initial size and increment amount are stored in the following constants:

```js
streamBuffers.DEFAULT_INITIAL_SIZE 		// (8 * 1024)
streamBuffers.DEFAULT_INCREMENT_AMOUNT	// (8 * 1024)
```

Writing is standard Stream stuff:

```js
myWritableStreamBuffer.write(myBuffer);
// - or -
myWritableStreamBuffer.write("\u00bd + \u00bc = \u00be", "utf8");
```

You can query the size of the data being held in the Buffer, and also how big the Buffer's max capacity currently is: 

```js
myWritableStreamBuffer.write("ASDF");
streamBuffers.size();			// 4.
streamBuffers.maxSize();		// Whatever was configured as initial size. In our example: (100 * 1024).
```

Retrieving the contents of the Buffer is simple:

```js
myWritableStreamBuffer.getContents();					// Gets all held data as a Buffer.
myWritableStreamBuffer.getContentsAsString("utf8");		// Gets all held data as a utf8 string.
myWritableStreamBuffer.getContents(5);					// Gets first 5 bytes as a Buffer.
myWritableStreamBuffer.getContentsAsString("utf8", 5);	// Gets first 5 bytes as a utf8 string.
```

Care should be taken when getting encoded strings from WritableStream, as it doesn't really care about the contents (multi-byte characters will not be respected).
 
Destroying or ending the WritableStream will not delete the contents of Buffer, but will disallow any further writes:

```js
myWritableStreamBuffer.write("ASDF");
myWritableStreamBuffer.destroy();

myWritableStreamBuffer.getContents();		// Returns ASDF in Buffer.
myWritableStreamBuffer.write("Yeah?");		// No effect.
```	

### Readable StreamBuffer

Readable Stream Buffers can have data inserted in them, which will then be pumped out via standard readable stream data events. The data to be sent out is held in a Buffer, which can grow in much the same way as a WritableStream Buffer does, if data is being put in Buffer faster than it's being pumped out. 

The frequency in which chunks are pumped out, and the size of the chunks themselves can be configured in the constructor. The initial size and increment amount of internal Buffer can be configured too.

```js
var myReadableStreamBuffer = new streamBuffers.ReadableStreamBuffer({
	frequency: 10,		// in milliseconds.
	chunkSize: 2048		// in bytes.
});
```

Default frequency and chunk size:

```js
streamBuffers.DEFAULT_CHUNK_SIZE 		// (1024)
streamBuffers.DEFAULT_FREQUENCY			// (1)
```

Putting data in Buffer to be pumped out is easy:

```js
myReadableStreamBuffer.put(aBuffer);
myReadableStreamBuffer.put("A String", "utf8");
```

Chunks are pumped out via standard readable stream spec: 

```js
myReadableStreamBuffer.on("data", function(data) {
	// Yup.
	assert.isTrue(data instanceof Buffer);
});
```

Chunks are pumped out by the interval that you specified in frequency. Setting the frequency to 0 will immediately stream the data (also in chunks), even if the stream has not been piped to a destination. This is useful for unit testing. 

setEncoding() for streams is respected too:

```js
myReadableStreamBuffer.setEncoding("utf8");
myReadableStreamBuffer.on("data", function(data) {
	assert.isTrue(data instanceof String);
});
```

Pause and resume are also implemented. pause()'ing stream will allow buffer to continue accumulating, but will not pump any of that data out until it is resume()'d again. 

Destroying the stream will immediately purge the buffer, unless destroySoon() is called, in which case the rest of the buffer will be written out. Either way, any further attempts to put data in the Buffer will be silently ignored. 

```js
myReadableStreamBuffer.destroySoon();
myReadableStreamBuffer.put("A String!");
myReadableStreamBuffer.size();			// will be 0.
```

## Disclaimer

Not supposed to be a speed demon, it's more for tests/debugging or weird edge cases. It works with an internal buffer that it copies contents to/from/around.

## Contributors

Thanks to the following people for taking some time to contribute to this project.

 * Igor Dralyuk <idralyuk@ebay.com>
 * Simon Koudijs <simon.koudijs@intellifi.nl>

## License

node-stream-buffer is free and unencumbered public domain software. For more information, see the accompanying UNLICENSE file.

[badge-travis-img]: http://img.shields.io/travis/samcday/node-stream-buffer.svg?style=flat-square
[badge-travis-url]: https://travis-ci.org/samcday/node-stream-buffer
[badge-climate-img]: http://img.shields.io/codeclimate/github/samcday/node-stream-buffer.svg?style=flat-square
[badge-climate-url]: https://codeclimate.com/github/samcday/node-stream-buffer
[badge-coverage-img]: http://img.shields.io/codeclimate/coverage/github/samcday/node-stream-buffer.svg?style=flat-square
[badge-coverage-url]: https://codeclimate.com/github/samcday/node-stream-buffer
[badge-npm-img]: https://nodei.co/npm/stream-buffers.png?downloads=true&downloadRank=true&stars=true
[badge-npm-url]: https://npmjs.org/package/stream-buffers

[node-buffer-docs]: http://nodejs.org/api/buffer.html


````

### stream@0.0.3

From https://github.com/juliangruber/stream.

**MIT**:


````
stream
======

Node.js streams in the browser.

Ported straight from the [Node.js core](https://github.com/joyent/node/blob/master/lib/stream.js) and adapted to [component/emitter](https://github.com/component/emitter)'s api.

__If you're offended by this, keep in mind that it's old and I don't want to break anyone's build by deleting this.__

For docs:

* [Stream Node.js v0.8.9 Manual & Documentation](http://nodejs.org/api/stream.html)
* [Stream Handbook](https://github.com/substack/stream-handbook)

A [testsuite](https://github.com/juliangruber/stream/blob/master/test.html) for the browser is there too. Just issue `npm install` after you've cloned this repo and then open the html file.

Installation
------------

Install with [component(1)](https://github.com/component/component)

```bash
$ component install juliangruber/stream
```
or

```
$ npm install stream
```

Usage example
-------------

```javascript
var Stream = require('stream');

var src = new Stream();
src.readable = true;

var dest = new Stream();
dest.writable = true;
dest.write = function(data) {
  assert(data == 'test');
};

src.pipe(dest);

src.emit('data', 'test');
```

License
-------
(MIT)

Copyright (c) 2012 Julian Gruber &lt;julian@juliangruber.com&gt;

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


````

### streamx@2.15.0

From https://github.com/mafintosh/streamx.

**MIT**:

Copyright: Copyright (c) 2019 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### strict-uri-encode@2.0.0

From https://github.com/kevva/strict-uri-encode.

**MIT**:

Copyright: Copyright (c) Kevin Martensson <kevinmartensson@gmail.com> (github.com/kevva)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### string-natural-compare@3.0.1

From https://github.com/nwoltman/string-natural-compare.

**MIT**:

Copyright: Copyright (c) 2015-2016 Nathan Woltman

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### string-padding@1.0.2

From https://github.com/timseverien/string-padding.

**MIT**:


````
# String-padding

Padding strings in [node](http://nodejs.org/).

## Installation

`$ npm install string-padding`

## Usage

    var pad = require('string-padding');
    pad(string [, length [, padding [, side ]]]);

- **string**: A string of text of any length.
- **length** (optional): The length the output string should be. It doesn’t truncate the original string.
- **padding** (optional): The character(s) for padding. You can go crazy with multiple characters ;)
- **side** (optional): The side which should be padded; `pad.LEFT`, `pad.RIGHT` or `pad.BOTH`.

## Extending core String object

For those who are fine with extending the core String object, you can do just that. Note you can skip the first parameter and directly call `.pad()` on a string.

```javascript
var pad = require('string-padding');
String.prototype.pad = pad.prototype;

'Hello World!'.pad(16, '0'); // 0000Hello World!
```

Happy padding! :)

````

### string-to-stream@3.0.1

From https://github.com/feross/string-to-stream.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### string-width@4.2.3, string-width@5.1.2, string-width@2.1.1

From https://github.com/sindresorhus/string-width.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### string.prototype.trimend@1.0.4

From https://github.com/es-shims/String.prototype.trimEnd.

**MIT**:

Copyright: Copyright (c) 2017 Khaled Al-Ansari

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### string.prototype.trimstart@1.0.4

From https://github.com/es-shims/String.prototype.trimStart.

**MIT**:

Copyright: Copyright (c) 2017 Khaled Al-Ansari

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### string_decoder@1.1.1, string_decoder@1.3.0

From https://github.com/nodejs/string_decoder.

**MIT**:

```
Node.js is licensed for use as follows:

"""
Copyright Node.js contributors. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
"""

This license applies to parts of Node.js originating from the
https://github.com/joyent/node repository:

"""
Copyright Joyent, Inc. and other Node contributors. All rights reserved.
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
"""


```

### strip-ansi@4.0.0, strip-ansi@5.2.0, strip-ansi@6.0.1, strip-ansi@7.0.1, strip-ansi@3.0.1

From https://github.com/chalk/strip-ansi.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### strip-eof@1.0.0

From https://github.com/sindresorhus/strip-eof.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### strip-final-newline@2.0.0

From https://github.com/sindresorhus/strip-final-newline.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### strip-json-comments@2.0.1

From https://github.com/sindresorhus/strip-json-comments.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### strnum@1.0.5, strnum@1.1.2

From https://github.com/NaturalIntelligence/strnum.

**MIT**:

Copyright: Copyright (c) 2021 Natural Intelligence

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### strtok3@6.3.0

From https://github.com/Borewit/strtok3.

**MIT**:

```
Copyright (c) 2017, Borewit
All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

### structured-headers@0.4.1

From https://github.com/evert/structured-header.

**MIT**:


````
Structured Headers parser for Javascript
========================================

This library is a parser and serializer for the [Structured Headers][1]
specification, a.k.a. "Structured Field Values for HTTP" (RFC8941).

This specification defines a standard serialization for complex HTTP header
values, including lists (arrays), dictionaries (maps) and also numbers,
booleans, and binary data.

The library is written in Typescript, and the examples in this document are
too, but plain Javascript is also fully supported.

Compatibility
-------------

This package has 2725 unittests, the vast majority are supplied from the
official [HTTP WG test suite][2].

However, there are 2 differences in the serializer:

1. Javascript can't differentiate between `1.0` and `1`. As a result we're
   skipping the tests that require a serialiation output of `1.0`.
2. Javascript rounds slightly different from the spec. The tests suggest that
   `0.0025` should round to the nearest event number (`0.002`), but Javascript
   rounds to `0.003`.

No fix is planned for #1, because there's no reasonably way to fix this
without wrapping every number in a custom class, and this will negatively
impact the developer experience. We do intend to fix #2 in the future with a
custom rounding algorithm.

This library emits and expects the _exact_ data structures as they are
suggested by the RFC. The result of this is that the returned types can be
a bit complex.

In the future we intend to loosen the required types for the serializer, and
add new helper functions that give you simpler structures _if_ you don't need
certain features for a header (such as `Parameters`).

Let us know what you would like to see here!

Installation
------------

Using npm:

```
npm install structured-headers
```

API
---

### Parsing an item

The following are examples of `item` headers:

Parsed as string

```
# Parsed as string
Header: "foo"

# A simple string, called a 'Token' in the spec
Header: foo

# Parsed as number
Header: 5
Header: -10
Header: 5.01415

# Parsed into boolean
Header: ?1
Header: ?0

# Binaries are base64 encoded
Header: :RE0gbWUgZm9yIGEgZnJlZSBjb29raWU=:

# Items can have parameters
Header: "Hello world"; a="5"
```


To parse these header values, use the `parseItem`:

```typescript
import { parseItem } from 'structured-headers';

console.log(
  parseItem(header)
);
```

parseItem returns a tuple (array with 2 items), the first item is the value,
the second is a `Map` object with parameters.

The type is roughly:

```typescript

// The raw value
type BareItem = number | string | Token | ByteSequence | boolean;

// The return type of parseItem
type Item = [
  BareItem,
  Map<string, BareItem>
];
```

### Parsing a list

A list is an array of items. Some examples:

```
# A simple list
Header: 5, "foo", bar, ?1

# Each element can have parameters
Header: sometoken; param1; param2=hi, 42

# A list can also contain lists itself. These are called 'inner lists' and
# use parenthesis
Header: sometoken, (innerlistitem1 innerlistitem2), (anotherlist)
```


To parse these:

```typescript
import { parseList } from 'structured-headers';

console.log(
  parseList(header)
);
```

`parseList` returns an array with each member. The return type is:

```typescript
type InnerList = [Item[], Parameters];
type List = (InnerList|Item)[];
```

### Parsing a dictionary

A dictionary is a key->value object. Examples:

```
# A simple dictionary
Header: fn="evert", ln="pot", coffee=?1

# Each item may have parameters too
Header: foo=123; q=1, bar=123, q=0.5

# A dictionary value may be an inner list again
Header: foo=(1 2 3)
```

To parse dictionaries:

```typescript
import { parseDictionary } from 'structured-headers';

console.log(
  parseDictionary(header)
);
```

The return type for `parseDictionary` is a `Map`.

```typescript
type Dictionary = Map<string, Item|InnerList>;
```


### Serializing

The serialiser functions work the exact same way, but in opposite direction.
They all return strings.

Currently the serializes expect the *exact type* that the parsers return, but
the intention is to loosen the types for serialization, so it's a bit more
ergnomic to call. Want this? Let me know by opening an issue.


```javascript
import {
  serializeDictionary,
  serializeList,
  serializeItem
} from 'structured-headers';


// Returns "foo", "bar"
serializeList([
  ['foo', new Map()],
  ['bar', new Map()],
]);

// Returns a=1, b=?0
sh.serializeDictionary(new Map([
  ['a', [1, new Map()]],
  ['b', [false, new Map()]],
]));

// Returns 42
serializeItem([42, new Map()]);

// Returns 5.5
serializeItem([5.5, new Map()]);

// Returns "hello world"
serializeItem(["hello world", new Map()]);

// Returns ?1
serializeItem([true, new Map()]);

// Returns a base-64 representation like: *aGVsbG8=*
serializeItem([new ByteSequence('aGVsbG8='), new Map()]);
```

Browser support
---------------

There is a minified version of this library in the `browser/` directory. This minified
file will expose a global variable called 'structuredHeader' which contains the rest
of the api.


[1]: https://datatracker.ietf.org/doc/html/rfc8941
[2]: https://github.com/httpwg/structured-field-tests


````

### style-mod@4.1.0

From https://github.com/marijnh/style-mod.

**MIT**:

Copyright: Copyright (C) 2018 by Marijn Haverbeke <marijn@haverbeke.berlin> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### styleq@0.1.3

From https://github.com/necolas/styleq.

**MIT**:

Copyright: Copyright (c) Nicolas Gallagher

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### sucrase@3.35.0

From https://github.com/alangpierce/sucrase.

**MIT**:

Copyright: Copyright (c) 2012-2018 various contributors (see AUTHORS)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### sudo-prompt@9.2.1

From https://github.com/jorangreef/sudo-prompt.

**MIT**:

Copyright: Copyright (c) 2015 Joran Dirk Greef

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### supports-color@5.5.0, supports-color@7.2.0, supports-color@8.1.1, supports-color@2.0.0

From https://github.com/chalk/supports-color.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### supports-hyperlinks@2.3.0

From https://github.com/jamestalmage/supports-hyperlinks.

**MIT**:

Copyright: Copyright (c) James Talmage <james@talmage.io> (github.com/jamestalmage)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### supports-preserve-symlinks-flag@1.0.0

From https://github.com/inspect-js/node-supports-preserve-symlinks-flag.

**MIT**:

Copyright: Copyright (c) 2022 Inspect JS

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### symbol-tree@3.2.4

From https://github.com/jsdom/js-symbol-tree.

**MIT**:

Copyright: Copyright (c) 2015 Joris van der Wel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### table-layout@0.4.5

From https://github.com/75lb/table-layout.

**MIT**:

Copyright: Copyright (c) 2015-19 Lloyd Brookes <75pound@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tar-stream@3.1.7, tar-stream@2.2.0

From https://github.com/mafintosh/tar-stream.

**MIT**:

Copyright: Copyright (c) 2014 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tar@6.1.11

From https://github.com/npm/node-tar.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### tar@6.2.1, tar@7.4.3

From https://github.com/isaacs/node-tar.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### tcp-port-used@1.0.2

From https://github.com/stdarg/tcp-port-used.

**MIT**:

Copyright: Copyright (c) 2013 jut-io

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### temp-dir@2.0.0

From https://github.com/sindresorhus/temp-dir.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### temp@0.8.3, temp@0.8.4

From https://github.com/bruce/node-temp.

**MIT**:

Copyright: Copyright (c) 2010-2014 Bruce Williams

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### terminal-link@2.1.1

From https://github.com/sindresorhus/terminal-link.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### terser@5.17.7

From https://github.com/terser/terser.

**BSD-2-Clause**:

```
Terser is released under the BSD license:

Copyright 2012-2018 (c) Mihai Bazon <mihai.bazon@gmail.com>

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above
      copyright notice, this list of conditions and the following
      disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

```

### test-exclude@6.0.0

From https://github.com/istanbuljs/test-exclude.

**ISC**:

```
Copyright (c) 2016, Contributors

Permission to use, copy, modify, and/or distribute this software
for any purpose with or without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE
LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### thenify-all@1.6.0

From https://github.com/thenables/thenify-all.

**MIT**:

Copyright: Copyright (c) 2014 Jonathan Ong me@jongleberry.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### thenify@3.3.1

From https://github.com/thenables/thenify.

**MIT**:

Copyright: Copyright (c) 2014-2016 Jonathan Ong me@jongleberry.com and contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### throat@5.0.0

From https://github.com/ForbesLindesay/throat.

**MIT**:

Copyright: Copyright (c) 2013 Forbes Lindesay

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### through2@2.0.5

From https://github.com/rvagg/through2.

**MIT**:

```
# The MIT License (MIT)

**Copyright (c) Rod Vagg (the "Original Author") and additional contributors**

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### timers@0.1.1

From https://github.com/popomore/timers.

**MIT**:


````
# Schedule

A tiny cron-like tools for humman, implement by Node.js

[![Build Status](https://travis-ci.org/popomore/schedule.png?branch=master)](https://travis-ci.org/popomore/schedule)
[![Coverage Status](https://coveralls.io/repos/popomore/schedule/badge.png)](https://coveralls.io/r/popomore/schedule)

---

## Install

```
$ npm install schedule
```

## Usage

```
var every = require('schedule').every;
every('2s').do(function() {
  // do your job
});
```

You can stop interval when some exception

```
var every = require('schedule').every;
var ins = every('2 seconds').do(cb);

process.on('uncaughtException', function() {
  ins.stop();
})
```

## Format

- ms, millisecond, milliseconds
- s, second, seconds
- m, minite, minites
- h, hour, hours
- d, day, days

## Lisence

MIT


````

### tldts-core@6.1.86, tldts@6.1.86

From https://github.com/remusao/tldts.

**MIT**:

Copyright: Copyright (c) 2017 Thomas Parisot, 2018 Rémi Berson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tmpl@1.0.5

From https://github.com/daaku/nodejs-tmpl.

**BSD-3-Clause**:

```
BSD License

Copyright (c) 2014, Naitik Shah. All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither the name Naitik Shah nor the names of its contributors may be used to
   endorse or promote products derived from this software without specific
   prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### to-fast-properties@2.0.0

From https://github.com/sindresorhus/to-fast-properties.

**MIT**:

```
MIT License

Copyright (c) 2014 Petka Antonov
              2015 Sindre Sorhus

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### to-object-path@0.3.0

From https://github.com/jonschlinkert/to-object-path.

**MIT**:

Copyright: Copyright (c) 2015-2016, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### to-regex-range@2.1.1, to-regex-range@5.0.1

From https://github.com/micromatch/to-regex-range.

**MIT**:

Copyright: Copyright (c) 2015-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### to-regex@3.0.2

From https://github.com/jonschlinkert/to-regex.

**MIT**:

Copyright: Copyright (c) 2016-2018, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### toidentifier@1.0.0, toidentifier@1.0.1

From https://github.com/component/toidentifier.

**MIT**:

Copyright: Copyright (c) 2016 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### token-types@4.2.1

From https://github.com/Borewit/token-types.

**MIT**:

Copyright: Copyright 2017 Borewit

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tough-cookie@2.5.0, tough-cookie@5.1.2

From https://github.com/salesforce/tough-cookie.

**BSD-3-Clause**:

```
Copyright (c) 2015, Salesforce.com, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

3. Neither the name of Salesforce.com nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### tr46@0.0.3

From https://github.com/Sebmaster/tr46.js.

**MIT**:

Copyright: Copyright (c) Sebastian Mayr

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tr46@5.0.0, tr46@5.1.1

From https://github.com/jsdom/tr46.

**MIT**:

Copyright: Copyright (c) Sebastian Mayr

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ts-interface-checker@0.1.13

From https://github.com/gristlabs/ts-interface-checker.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "{}"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright {yyyy} {name of copyright owner}

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### tslib@1.14.1, tslib@2.3.1

From https://github.com/Microsoft/tslib.

**0BSD**:

```
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
```

**NOTICE**:

```
CopyrightNotice.txt:

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */


```

### tslib@2.4.0, tslib@2.5.0

From https://github.com/Microsoft/tslib.

**0BSD**:

```
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
```

**NOTICE**:

```
CopyrightNotice.txt:

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */


```

### tunnel-agent@0.6.0

From https://github.com/mikeal/tunnel-agent.

**Apache-2.0**:

```
Apache License

Version 2.0, January 2004

http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.

"Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.

2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.

3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.

4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of this License; and

You must cause any modified files to carry prominent notices stating that You changed the files; and

You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and

If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.

5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.

7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.

8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS
```

### tweetnacl@0.14.5

From https://github.com/dchest/tweetnacl-js.

**Unlicense**:

```
This is free and unencumbered software released into the public domain.

Anyone is free to copy, modify, publish, use, compile, sell, or
distribute this software, either in source code form or as a compiled
binary, for any purpose, commercial or non-commercial, and by any
means.

In jurisdictions that recognize copyright laws, the author or authors
of this software dedicate any and all copyright interest in the
software to the public domain. We make this dedication for the benefit
of the public at large and to the detriment of our heirs and
successors. We intend this dedication to be an overt act of
relinquishment in perpetuity of all present and future rights to this
software under copyright law.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

For more information, please refer to <http://unlicense.org>

```

### type-detect@4.0.8

From https://github.com/chaijs/type-detect.

**MIT**:

Copyright: Copyright (c) 2013 Jake Luer <jake@alogicalparadox.com> (http://alogicalparadox.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### type-fest@0.21.3, type-fest@0.7.1, type-fest@0.13.1

From https://github.com/sindresorhus/type-fest.

**(MIT OR CC0-1.0)**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https:/sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### typescript@5.8.3

From https://github.com/microsoft/TypeScript.

**Apache-2.0**:

```
Apache License

Version 2.0, January 2004

http://www.apache.org/licenses/ 

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.

"Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.

2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.

3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.

4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of this License; and

You must cause any modified files to carry prominent notices stating that You changed the files; and

You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and

If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.

5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.

7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.

8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS

```

### typical@2.6.1

From https://github.com/75lb/typical.

**MIT**:

Copyright: Copyright (c) 2014-17 Lloyd Brookes <75pound@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ua-parser-js@1.0.35

From https://github.com/faisalman/ua-parser-js.

**MIT**:

Copyright: Copyright (c) 2012-2021 Faisal Salman <<f@faisalman.com>>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### uc.micro@1.0.6

From https://github.com/markdown-it/uc.micro.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### uglify-es@3.3.10

From https://github.com/mishoo/UglifyJS2.git#harmony.

**BSD-2-Clause**:

```
UglifyJS is released under the BSD license:

Copyright 2012-2018 (c) Mihai Bazon <mihai.bazon@gmail.com>

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above
      copyright notice, this list of conditions and the following
      disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

```

### uglify-js@3.17.4

From https://github.com/mishoo/UglifyJS.

**BSD-2-Clause**:

```
UglifyJS is released under the BSD license:

Copyright 2012-2019 (c) Mihai Bazon <mihai.bazon@gmail.com>

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above
      copyright notice, this list of conditions and the following
      disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

```

### uglifycss@0.0.29

From https://github.com/fmarcia/uglifycss.

**MIT**:

```
Copyright (c) Franck Marcia

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

### uid-safe@2.1.5

From https://github.com/crypto-utils/uid-safe.

**MIT**:

Copyright: Copyright (c) 2015-2017 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unbox-primitive@1.0.1

From https://github.com/ljharb/unbox-primitive.

**MIT**:

Copyright: Copyright (c) 2019 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### undici@6.21.2, undici-types@6.20.0

From https://github.com/nodejs/undici.

**MIT**:

Copyright: Copyright (c) Matteo Collina and Undici contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unicode-canonical-property-names-ecmascript@2.0.0

From https://github.com/mathiasbynens/unicode-canonical-property-names-ecmascript.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unicode-match-property-ecmascript@2.0.0

From https://github.com/mathiasbynens/unicode-match-property-ecmascript.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unicode-match-property-value-ecmascript@2.1.0

From https://github.com/mathiasbynens/unicode-match-property-value-ecmascript.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unicode-property-aliases-ecmascript@2.0.0

From https://github.com/mathiasbynens/unicode-property-aliases-ecmascript.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### union-value@1.0.1

From https://github.com/jonschlinkert/union-value.

**MIT**:

Copyright: Copyright (c) 2015-2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unique-filename@1.1.1

From https://github.com/iarna/unique-filename.

**ISC**:

```
Copyright npm, Inc

Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### unique-slug@2.0.2

From https://github.com/iarna/unique-slug.

**ISC**:

```
The ISC License

Copyright npm, Inc

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### unique-string@2.0.0

From https://github.com/sindresorhus/unique-string.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### universalify@0.1.2, universalify@2.0.0

From https://github.com/RyanZim/universalify.

**MIT**:

Copyright: Copyright (c) 2017, Ryan Zimmerman <opensrc@ryanzim.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unpipe@1.0.0

From https://github.com/stream-utils/unpipe.

**MIT**:

Copyright: Copyright (c) 2015 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### unset-value@1.0.0

From https://github.com/jonschlinkert/unset-value.

**MIT**:

Copyright: Copyright (c) 2015, 2017, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### update-browserslist-db@1.0.10, update-browserslist-db@1.0.13, update-browserslist-db@1.0.16, update-browserslist-db@1.1.2

From https://github.com/browserslist/update-db.

**MIT**:

Copyright: Copyright 2022 Andrey Sitnik <andrey@sitnik.ru> and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### upper-case@1.1.3

From https://github.com/blakeembrey/upper-case.

**MIT**:

Copyright: Copyright (c) 2014 Blake Embrey (hello@blakeembrey.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### uri-js@4.4.1

From https://github.com/garycourt/uri-js.

**BSD-2-Clause**:

```
Copyright 2011 Gary Court. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1.	Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2.	Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY GARY COURT "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GARY COURT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those of the authors and should not be interpreted as representing official policies, either expressed or implied, of Gary Court.

```

### urix@0.1.0

From https://github.com/lydell/urix.

**MIT**:

Copyright: Copyright (c) 2013 Simon Lydell

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### url-parse@1.5.10

From https://github.com/unshiftio/url-parse.

**MIT**:

Copyright: Copyright (c) 2015 Unshift.io, Arnout Kazemier,  the Contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### url@0.11.4, url@0.10.3

From https://github.com/defunctzombie/node-url.

**MIT**:

Copyright: Copyright 2014 Joyent, Inc. and other Node contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### use-latest-callback@0.2.3

From https://github.com/satya164/use-latest-callback.

**MIT**:

Copyright: Copyright (c) 2023 Satyajit Sahoo

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### use@3.1.1

From https://github.com/jonschlinkert/use.

**MIT**:

Copyright: Copyright (c) 2015-present, Jon Schlinkert.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### utf8@3.0.0

From https://github.com/mathiasbynens/utf8.js.

**MIT**:

Copyright: Copyright Mathias Bynens <https://mathiasbynens.be/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### util-deprecate@1.0.2

From https://github.com/TooTallNate/util-deprecate.

**MIT**:

Copyright: Copyright (c) 2014 Nathan Rajlich <nathan@tootallnate.net>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### util@0.12.4, util@0.12.5

From https://github.com/browserify/node-util.

**MIT**:

Copyright: Copyright Joyent, Inc. and other Node contributors. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### utils-merge@1.0.1

From https://github.com/jaredhanson/utils-merge.

**MIT**:

Copyright: Copyright (c) 2013-2017 Jared Hanson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### uuid@11.1.0, uuid@3.4.0, uuid@7.0.3, uuid@8.3.2, uuid@8.0.0

From https://github.com/uuidjs/uuid.

**MIT**:

Copyright: Copyright (c) 2010-2020 Robert Kieffer and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### validate-npm-package-name@5.0.0

From https://github.com/npm/validate-npm-package-name.

**ISC**:

```
Copyright (c) 2015, npm, Inc


Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### vary@1.1.2

From https://github.com/jshttp/vary.

**MIT**:

Copyright: Copyright (c) 2014-2017 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### verror@1.10.0

From https://github.com/davepacheco/node-verror.

**MIT**:

```
Copyright (c) 2016, Joyent, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE

```

### vlq@1.0.1

From https://github.com/Rich-Harris/vlq.

**MIT**:

Copyright: Copyright (c) 2017 [these people](https://github.com/Rich-Harris/vlq/graphs/contributors)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### w3c-keyname@2.2.4, w3c-keyname@2.2.8

From https://github.com/marijnh/w3c-keyname.

**MIT**:

Copyright: Copyright (C) 2016 by Marijn Haverbeke <marijnh@gmail.com> and others

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### w3c-xmlserializer@5.0.0

From https://github.com/jsdom/w3c-xmlserializer.

**MIT**:

```
The MIT License (MIT)
=====================

Copyright © Sebastian Mayr

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the “Software”), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

```

### walker@1.0.8

From https://github.com/daaku/nodejs-walker.

**Apache-2.0**:

```
Copyright 2013 Naitik Shah

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

```

### warn-once@0.1.1

From https://github.com/satya164/warn-once.

**MIT**:

Copyright: Copyright (c) 2022 Satyajit Sahoo

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### wcwidth@1.0.1

From https://github.com/timoxley/wcwidth.

**MIT**:

```
wcwidth.js: JavaScript Portng of Markus Kuhn's wcwidth() Implementation
=======================================================================

Copyright (C) 2012 by Jun Woong.

This package is a JavaScript porting of `wcwidth()` implementation
[by Markus Kuhn](http://www.cl.cam.ac.uk/~mgk25/ucs/wcwidth.c).

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.


THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.


```

### webidl-conversions@3.0.1, webidl-conversions@5.0.0, webidl-conversions@7.0.0

From https://github.com/jsdom/webidl-conversions.

**BSD-2-Clause**:

```
# The BSD 2-Clause License

Copyright (c) 2014, Domenic Denicola
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### whatwg-encoding@3.1.1

From https://github.com/jsdom/whatwg-encoding.

**MIT**:

Copyright: Copyright © Domenic Denicola <d@domenic.me>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### whatwg-fetch@3.6.2

From https://github.com/github/fetch.

**MIT**:

Copyright: Copyright (c) 2014-2016 GitHub, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### whatwg-mimetype@4.0.0

From https://github.com/jsdom/whatwg-mimetype.

**MIT**:

Copyright: Copyright © Domenic Denicola <d@domenic.me>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### whatwg-url-without-unicode@8.0.0-3

From https://github.com/charpeni/whatwg-url.

**MIT**:

Copyright: Copyright (c) 2015–2016 Sebastian Mayr

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### whatwg-url@14.0.0, whatwg-url@14.2.0, whatwg-url@5.0.0

From https://github.com/jsdom/whatwg-url.

**MIT**:

Copyright: Copyright (c) Sebastian Mayr

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### which-boxed-primitive@1.0.2

From https://github.com/inspect-js/which-boxed-primitive.

**MIT**:

Copyright: Copyright (c) 2019 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### which-module@2.0.0

From https://github.com/nexdrew/which-module.

**ISC**:

```
Copyright (c) 2016, Contributors

Permission to use, copy, modify, and/or distribute this software for any purpose
with or without fee is hereby granted, provided that the above copyright notice
and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

```

### which-typed-array@1.1.7

From https://github.com/inspect-js/which-typed-array.

**MIT**:

Copyright: Copyright (c) 2015 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### which@1.3.1, which@2.0.2

From https://github.com/isaacs/node-which.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### wide-align@1.1.5

From https://github.com/iarna/wide-align.

**ISC**:

```
Copyright (c) 2015, Rebecca Turner <me@re-becca.org>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


```

### wonka@6.3.4

From https://github.com/0no-co/wonka.

**MIT**:

Copyright: Copyright (c) 0no.co

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### word-wrap@1.2.5

From https://github.com/jonschlinkert/word-wrap.

**MIT**:

Copyright: Copyright (c) 2014-2016, Jon Schlinkert

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### wordwrapjs@3.0.0

From https://github.com/75lb/wordwrapjs.

**MIT**:

Copyright: Copyright (c) 2015-17 Lloyd Brookes <75pound@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### wrap-ansi@6.2.0, wrap-ansi@7.0.0, wrap-ansi@8.1.0, wrap-ansi@3.0.1

From https://github.com/chalk/wrap-ansi.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### wrappy@1.0.2

From https://github.com/npm/wrappy.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### write-file-atomic@2.4.3

From https://github.com/iarna/write-file-atomic.

**ISC**:

```
Copyright (c) 2015, Rebecca Turner

Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


```

### write-file-atomic@4.0.2

From https://github.com/npm/write-file-atomic.

**ISC**:

```
Copyright (c) 2015, Rebecca Turner

Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


```

### ws@6.2.2, ws@6.2.3, ws@7.5.10, ws@7.5.6, ws@7.5.9, ws@8.18.0

From https://github.com/websockets/ws.

**MIT**:

Copyright: Copyright (c) 2011 Einar Otto Stangvik <einaros@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### xcode@3.0.1

From https://github.com/apache/cordova-node-xcode.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

**NOTICE**:

```
NOTICE:

Apache Cordova
Copyright 2012-2020 The Apache Software Foundation

This product includes software developed at
The Apache Software Foundation (http://www.apache.org/).

```

### xml-name-validator@5.0.0

From https://github.com/jsdom/xml-name-validator.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


```

### xml2js@0.4.23, xml2js@0.6.0, xml2js@0.4.19

From https://github.com/Leonidas-from-XIV/node-xml2js.

**MIT**:

Copyright: Copyright 2010, 2011, 2012, 2013. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### xmlbuilder@11.0.1, xmlbuilder@15.1.1, xmlbuilder@9.0.7

From https://github.com/oozcitak/xmlbuilder-js.

**MIT**:

```
The MIT License (MIT)

Copyright (c) 2013 Ozgur Ozcitak

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### xmlchars@2.2.0

From https://github.com/lddubeau/xmlchars.

**MIT**:

Copyright: Copyright Louis-Dominique Dubeau and contributors to xmlchars

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### xtend@4.0.2

From https://github.com/Raynos/xtend.

**MIT**:

Copyright: Copyright (c) 2012-2014 Raynos.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### y18n@4.0.3, y18n@5.0.8

From https://github.com/yargs/y18n.

**ISC**:

```
Copyright (c) 2015, Contributors

Permission to use, copy, modify, and/or distribute this software for any purpose
with or without fee is hereby granted, provided that the above copyright notice
and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

```

### yallist@3.1.1, yallist@4.0.0

From https://github.com/isaacs/yallist.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### yallist@5.0.0

From https://github.com/isaacs/yallist.

**BlueOak-1.0.0**:

```
All packages under `src/` are licensed according to the terms in
their respective `LICENSE` or `LICENSE.md` files.

The remainder of this project is licensed under the Blue Oak
Model License, as follows:

-----

# Blue Oak Model License

Version 1.0.0

## Purpose

This license gives everyone as much permission to work with
this software as possible, while protecting contributors
from liability.

## Acceptance

In order to receive this license, you must agree to its
rules.  The rules of this license are both obligations
under that agreement and conditions to your license.
You must not do anything with this software that triggers
a rule that you cannot or will not follow.

## Copyright

Each contributor licenses you to do everything with this
software that would otherwise infringe that contributor's
copyright in it.

## Notices

You must ensure that everyone who gets a copy of
any part of this software from you, with or without
changes, also gets the text of this license or a link to
<https://blueoakcouncil.org/license/1.0.0>.

## Excuse

If anyone notifies you in writing that you have not
complied with [Notices](#notices), you can keep your
license by taking all practical steps to comply within 30
days after the notice.  If you do not do so, your license
ends immediately.

## Patent

Each contributor licenses you to do everything with this
software that would otherwise infringe any patent claims
they can license or become able to license.

## Reliability

No contributor can revoke this license.

## No Liability

***As far as the law allows, this software comes as is,
without any warranty or condition, and no contributor
will be liable to anyone for any damages related to this
software or this license, under any kind of legal claim.***

```

### yaml@2.4.0

From https://github.com/eemeli/yaml.

**ISC**:

```
Copyright Eemeli Aro <eemeli@gmail.com>

Permission to use, copy, modify, and/or distribute this software for any purpose
with or without fee is hereby granted, provided that the above copyright notice
and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

```

### yargs-parser@18.1.3, yargs-parser@20.2.9, yargs-parser@21.1.1, yargs-parser@7.0.0

From https://github.com/yargs/yargs-parser.

**ISC**:

```
Copyright (c) 2016, Contributors

Permission to use, copy, modify, and/or distribute this software
for any purpose with or without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE
LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### yargs@15.4.1, yargs@16.2.0, yargs@17.7.2

From https://github.com/yargs/yargs.

**MIT**:

Copyright: Copyright 2010 James Halliday (mail@substack.net); Modified work Copyright 2014 Contributors (ben@npmjs.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### yocto-queue@0.1.0

From https://github.com/sindresorhus/yocto-queue.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ant icons

From https://github.com/ant-design/ant-design/blob/master/LICENSE.

**MIT**:

Copyright: Copyright (c) 2015-present Ant UED, https://xtech.antfin.com/

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fontawesome v5 and 6, @fortawesome/fontawesome-free@5.15.4

From https://github.com/FortAwesome/Font-Awesome.

**(CC-BY-4.0 AND OFL-1.1 AND MIT)**:

```
Fonticons, Inc. (https://fontawesome.com)

--------------------------------------------------------------------------------

Font Awesome Free License

Font Awesome Free is free, open source, and GPL friendly. You can use it for
commercial projects, open source projects, or really almost whatever you want.
Full Font Awesome Free license: https://fontawesome.com/license/free.

--------------------------------------------------------------------------------

# Icons: CC BY 4.0 License (https://creativecommons.org/licenses/by/4.0/)

The Font Awesome Free download is licensed under a Creative Commons
Attribution 4.0 International License and applies to all icons packaged
as SVG and JS file types.

--------------------------------------------------------------------------------

# Fonts: SIL OFL 1.1 License

In the Font Awesome Free download, the SIL OFL license applies to all icons
packaged as web and desktop font files.

Copyright (c) 2023 Fonticons, Inc. (https://fontawesome.com)
with Reserved Font Name: "Font Awesome".

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is copied below, and is also available with a FAQ at:
http://scripts.sil.org/OFL

SIL OPEN FONT LICENSE
Version 1.1 - 26 February 2007

PREAMBLE
The goals of the Open Font License (OFL) are to stimulate worldwide
development of collaborative font projects, to support the font creation
efforts of academic and linguistic communities, and to provide a free and
open framework in which fonts may be shared and improved in partnership
with others.

The OFL allows the licensed fonts to be used, studied, modified and
redistributed freely as long as they are not sold by themselves. The
fonts, including any derivative works, can be bundled, embedded,
redistributed and/or sold with any software provided that any reserved
names are not used by derivative works. The fonts and derivatives,
however, cannot be released under any other type of license. The
requirement for fonts to remain under this license does not apply
to any document created using the fonts or their derivatives.

DEFINITIONS
"Font Software" refers to the set of files released by the Copyright
Holder(s) under this license and clearly marked as such. This may
include source files, build scripts and documentation.

"Reserved Font Name" refers to any names specified as such after the
copyright statement(s).

"Original Version" refers to the collection of Font Software components as
distributed by the Copyright Holder(s).

"Modified Version" refers to any derivative made by adding to, deleting,
or substituting — in part or in whole — any of the components of the
Original Version, by changing formats or by porting the Font Software to a
new environment.

"Author" refers to any designer, engineer, programmer, technical
writer or other person who contributed to the Font Software.

PERMISSION & CONDITIONS
Permission is hereby granted, free of charge, to any person obtaining
a copy of the Font Software, to use, study, copy, merge, embed, modify,
redistribute, and sell modified and unmodified copies of the Font
Software, subject to the following conditions:

1) Neither the Font Software nor any of its individual components,
in Original or Modified Versions, may be sold by itself.

2) Original or Modified Versions of the Font Software may be bundled,
redistributed and/or sold with any software, provided that each copy
contains the above copyright notice and this license. These can be
included either as stand-alone text files, human-readable headers or
in the appropriate machine-readable metadata fields within text or
binary files as long as those fields can be easily viewed by the user.

3) No Modified Version of the Font Software may use the Reserved Font
Name(s) unless explicit written permission is granted by the corresponding
Copyright Holder. This restriction only applies to the primary font name as
presented to the users.

4) The name(s) of the Copyright Holder(s) or the Author(s) of the Font
Software shall not be used to promote, endorse or advertise any
Modified Version, except to acknowledge the contribution(s) of the
Copyright Holder(s) and the Author(s) or with their explicit written
permission.

5) The Font Software, modified or unmodified, in part or in whole,
must be distributed entirely under this license, and must not be
distributed under any other license. The requirement for fonts to
remain under this license does not apply to any document created
using the Font Software.

TERMINATION
This license becomes null and void if any of the above conditions are
not met.

DISCLAIMER
THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF THE USE OR INABILITY TO USE THE FONT SOFTWARE OR FROM
OTHER DEALINGS IN THE FONT SOFTWARE.

--------------------------------------------------------------------------------

# Code: MIT License (https://opensource.org/licenses/MIT)

In the Font Awesome Free download, the MIT license applies to all non-font and
non-icon files.

Copyright 2023 Fonticons, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in the
Software without restriction, including without limitation the rights to use, copy,
modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

--------------------------------------------------------------------------------

# Attribution

Attribution is required by MIT, SIL OFL, and CC BY licenses. Downloaded Font
Awesome Free files already contain embedded comments with sufficient
attribution, so you shouldn't need to do anything additional when using these
files normally.

We've kept attribution comments terse, so we ask that you do not actively work
to remove them from files, especially code. They're a great way for folks to
learn about Font Awesome.

--------------------------------------------------------------------------------

# Brand Icons

All brand icons are trademarks of their respective owners. The use of these
trademarks does not indicate endorsement of the trademark holder by Font
Awesome, nor vice versa. **Please do not use brand logos for any purpose except
to represent the company, product, or service to which they refer.**
```

### fontiso icons

From https://github.com/kenangundogan/fontisto.

**(CC-BY-3.0 AND OFL-1.1 AND MIT)**:

```

    The Fontisto font is licensed under the SIL OFL 1.1:
        http://scripts.sil.org/OFL
    Fontisto CSS, LESS, and Sass files are licensed under the MIT License:
        https://opensource.org/licenses/mit-license.html
    The Fontisto documentation is licensed under the CC BY 3.0 License:
        http://creativecommons.org/licenses/by/3.0/
    Attribution is no longer required as of Fontisto 3.0, but much appreciated:
        Fontisto by Kenan Gündoğan - http://fontisto.com
    Full details: http://fontisto.com/license

---

# The SIL OFL 1.1

Copyright (c) <dates>, <Copyright Holder> (<URL|email>),
with Reserved Font Name <Reserved Font Name>.
Copyright (c) <dates>, <additional Copyright Holder> (<URL|email>),
with Reserved Font Name <additional Reserved Font Name>.
Copyright (c) <dates>, <additional Copyright Holder> (<URL|email>).

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is copied below, and is also available with a FAQ at:
http://scripts.sil.org/OFL


-----------------------------------------------------------
SIL OPEN FONT LICENSE Version 1.1 - 26 February 2007
-----------------------------------------------------------

PREAMBLE
The goals of the Open Font License (OFL) are to stimulate worldwide
development of collaborative font projects, to support the font creation
efforts of academic and linguistic communities, and to provide a free and
open framework in which fonts may be shared and improved in partnership
with others.

The OFL allows the licensed fonts to be used, studied, modified and
redistributed freely as long as they are not sold by themselves. The
fonts, including any derivative works, can be bundled, embedded, 
redistributed and/or sold with any software provided that any reserved
names are not used by derivative works. The fonts and derivatives,
however, cannot be released under any other type of license. The
requirement for fonts to remain under this license does not apply
to any document created using the fonts or their derivatives.

DEFINITIONS
"Font Software" refers to the set of files released by the Copyright
Holder(s) under this license and clearly marked as such. This may
include source files, build scripts and documentation.

"Reserved Font Name" refers to any names specified as such after the
copyright statement(s).

"Original Version" refers to the collection of Font Software components as
distributed by the Copyright Holder(s).

"Modified Version" refers to any derivative made by adding to, deleting,
or substituting -- in part or in whole -- any of the components of the
Original Version, by changing formats or by porting the Font Software to a
new environment.

"Author" refers to any designer, engineer, programmer, technical
writer or other person who contributed to the Font Software.

PERMISSION & CONDITIONS
Permission is hereby granted, free of charge, to any person obtaining
a copy of the Font Software, to use, study, copy, merge, embed, modify,
redistribute, and sell modified and unmodified copies of the Font
Software, subject to the following conditions:

1) Neither the Font Software nor any of its individual components,
in Original or Modified Versions, may be sold by itself.

2) Original or Modified Versions of the Font Software may be bundled,
redistributed and/or sold with any software, provided that each copy
contains the above copyright notice and this license. These can be
included either as stand-alone text files, human-readable headers or
in the appropriate machine-readable metadata fields within text or
binary files as long as those fields can be easily viewed by the user.

3) No Modified Version of the Font Software may use the Reserved Font
Name(s) unless explicit written permission is granted by the corresponding
Copyright Holder. This restriction only applies to the primary font name as
presented to the users.

4) The name(s) of the Copyright Holder(s) or the Author(s) of the Font
Software shall not be used to promote, endorse or advertise any
Modified Version, except to acknowledge the contribution(s) of the
Copyright Holder(s) and the Author(s) or with their explicit written
permission.

5) The Font Software, modified or unmodified, in part or in whole,
must be distributed entirely under this license, and must not be
distributed under any other license. The requirement for fonts to
remain under this license does not apply to any document created
using the Font Software.

TERMINATION
This license becomes null and void if any of the above conditions are
not met.

DISCLAIMER
THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF THE USE OR INABILITY TO USE THE FONT SOFTWARE OR FROM
OTHER DEALINGS IN THE FONT SOFTWARE.

---

# CC BY 3.0 License

Attribution 3.0 Unported

CREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE LEGAL SERVICES. DISTRIBUTION OF THIS LICENSE DOES NOT CREATE AN ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS INFORMATION ON AN "AS-IS" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES REGARDING THE INFORMATION PROVIDED, AND DISCLAIMS LIABILITY FOR DAMAGES RESULTING FROM ITS USE.

License

THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS CREATIVE COMMONS PUBLIC LICENSE ("CCPL" OR "LICENSE"). THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.

BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH TERMS AND CONDITIONS.

1. Definitions

    Adaptation means a work based upon the Work, or upon the Work and other pre-existing works, such as a translation, adaptation, derivative work, arrangement of music or other alterations of a literary or artistic work, or phonogram or performance and includes cinematographic adaptations or any other form in which the Work may be recast, transformed, or adapted including in any form recognizably derived from the original, except that a work that constitutes a Collection will not be considered an Adaptation for the purpose of this License. For the avoidance of doubt, where the Work is a musical work, performance or phonogram, the synchronization of the Work in timed-relation with a moving image ("synching") will be considered an Adaptation for the purpose of this License.
    Collection means a collection of literary or artistic works, such as encyclopedias and anthologies, or performances, phonograms or broadcasts, or other works or subject matter other than works listed in Section 1(f) below, which, by reason of the selection and arrangement of their contents, constitute intellectual creations, in which the Work is included in its entirety in unmodified form along with one or more other contributions, each constituting separate and independent works in themselves, which together are assembled into a collective whole. A work that constitutes a Collection will not be considered an Adaptation (as defined above) for the purposes of this License.
    Distribute means to make available to the public the original and copies of the Work or Adaptation, as appropriate, through sale or other transfer of ownership.
    Licensor means the individual, individuals, entity or entities that offer(s) the Work under the terms of this License.
    Original Author means, in the case of a literary or artistic work, the individual, individuals, entity or entities who created the Work or if no individual or entity can be identified, the publisher; and in addition (i) in the case of a performance the actors, singers, musicians, dancers, and other persons who act, sing, deliver, declaim, play in, interpret or otherwise perform literary or artistic works or expressions of folklore; (ii) in the case of a phonogram the producer being the person or legal entity who first fixes the sounds of a performance or other sounds; and, (iii) in the case of broadcasts, the organization that transmits the broadcast.
    Work means the literary and/or artistic work offered under the terms of this License including without limitation any production in the literary, scientific and artistic domain, whatever may be the mode or form of its expression including digital form, such as a book, pamphlet and other writing; a lecture, address, sermon or other work of the same nature; a dramatic or dramatico-musical work; a choreographic work or entertainment in dumb show; a musical composition with or without words; a cinematographic work to which are assimilated works expressed by a process analogous to cinematography; a work of drawing, painting, architecture, sculpture, engraving or lithography; a photographic work to which are assimilated works expressed by a process analogous to photography; a work of applied art; an illustration, map, plan, sketch or three-dimensional work relative to geography, topography, architecture or science; a performance; a broadcast; a phonogram; a compilation of data to the extent it is protected as a copyrightable work; or a work performed by a variety or circus performer to the extent it is not otherwise considered a literary or artistic work.
    You means an individual or entity exercising rights under this License who has not previously violated the terms of this License with respect to the Work, or who has received express permission from the Licensor to exercise rights under this License despite a previous violation.
    Publicly Perform means to perform public recitations of the Work and to communicate to the public those public recitations, by any means or process, including by wire or wireless means or public digital performances; to make available to the public Works in such a way that members of the public may access these Works from a place and at a place individually chosen by them; to perform the Work to the public by any means or process and the communication to the public of the performances of the Work, including by public digital performance; to broadcast and rebroadcast the Work by any means including signs, sounds or images.
    Reproduce means to make copies of the Work by any means including without limitation by sound or visual recordings and the right of fixation and reproducing fixations of the Work, including storage of a protected performance or phonogram in digital form or other electronic medium.

2. Fair Dealing Rights.

Nothing in this License is intended to reduce, limit, or restrict any uses free from copyright or rights arising from limitations or exceptions that are provided for in connection with the copyright protection under copyright law or other applicable laws.

3. License Grant.

Subject to the terms and conditions of this License, Licensor hereby grants You a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the Work as stated below:

    to Reproduce the Work, to incorporate the Work into one or more Collections, and to Reproduce the Work as incorporated in the Collections;

    to create and Reproduce Adaptations provided that any such Adaptation, including any translation in any medium, takes reasonable steps to clearly label, demarcate or otherwise identify that changes were made to the original Work. For example, a translation could be marked "The original work was translated from English to Spanish," or a modification could indicate "The original work has been modified.";

    to Distribute and Publicly Perform the Work including as incorporated in Collections; and,

    to Distribute and Publicly Perform Adaptations.

    For the avoidance of doubt:

        Non-waivable Compulsory License Schemes . In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme cannot be waived, the Licensor reserves the exclusive right to collect such royalties for any exercise by You of the rights granted under this License;

        Waivable Compulsory License Schemes . In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme can be waived, the Licensor waives the exclusive right to collect such royalties for any exercise by You of the rights granted under this License; and,

        Voluntary License Schemes . The Licensor waives the right to collect royalties, whether individually or, in the event that the Licensor is a member of a collecting society that administers voluntary licensing schemes, via that society, from any exercise by You of the rights granted under this License.

The above rights may be exercised in all media and formats whether now known or hereafter devised. The above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats. Subject to Section 8(f) , all rights not expressly granted by Licensor are hereby reserved.

4. Restrictions.

The license granted in Section 3 above is expressly made subject to and limited by the following restrictions:

    You may Distribute or Publicly Perform the Work only under the terms of this License. You must include a copy of, or the Uniform Resource Identifier (URI) for, this License with every copy of the Work You Distribute or Publicly Perform. You may not offer or impose any terms on the Work that restrict the terms of this License or the ability of the recipient of the Work to exercise the rights granted to that recipient under the terms of the License. You may not sublicense the Work. You must keep intact all notices that refer to this License and to the disclaimer of warranties with every copy of the Work You Distribute or Publicly Perform. When You Distribute or Publicly Perform the Work, You may not impose any effective technological measures on the Work that restrict the ability of a recipient of the Work from You to exercise the rights granted to that recipient under the terms of the License. This Section 4(a) applies to the Work as incorporated in a Collection, but this does not require the Collection apart from the Work itself to be made subject to the terms of this License. If You create a Collection, upon notice from any Licensor You must, to the extent practicable, remove from the Collection any credit as required by Section 4(b) , as requested. If You create an Adaptation, upon notice from any Licensor You must, to the extent practicable, remove from the Adaptation any credit as required by Section 4(b) , as requested.

    If You Distribute, or Publicly Perform the Work or any Adaptations or Collections, You must, unless a request has been made pursuant to Section 4(a) , keep intact all copyright notices for the Work and provide, reasonable to the medium or means You are utilizing: (i) the name of the Original Author (or pseudonym, if applicable) if supplied, and/or if the Original Author and/or Licensor designate another party or parties (e.g., a sponsor institute, publishing entity, journal) for attribution ("Attribution Parties") in Licensor's copyright notice, terms of service or by other reasonable means, the name of such party or parties; (ii) the title of the Work if supplied; (iii) to the extent reasonably practicable, the URI, if any, that Licensor specifies to be associated with the Work, unless such URI does not refer to the copyright notice or licensing information for the Work; and, (iv) consistent with Section 3(b) , in the case of an Adaptation, a credit identifying the use of the Work in the Adaptation (e.g., "French translation of the Work by Original Author," or "Screenplay based on original Work by Original Author"). The credit required by this Section 4(b) may be implemented in any reasonable manner; provided, however, that in the case of a Adaptation or Collection, at a minimum such credit will appear, if a credit for all contributing authors of the Adaptation or Collection appears, then as part of these credits and in a manner at least as prominent as the credits for the other contributing authors. For the avoidance of doubt, You may only use the credit required by this Section for the purpose of attribution in the manner set out above and, by exercising Your rights under this License, You may not implicitly or explicitly assert or imply any connection with, sponsorship or endorsement by the Original Author, Licensor and/or Attribution Parties, as appropriate, of You or Your use of the Work, without the separate, express prior written permission of the Original Author, Licensor and/or Attribution Parties.

    Except as otherwise agreed in writing by the Licensor or as may be otherwise permitted by applicable law, if You Reproduce, Distribute or Publicly Perform the Work either by itself or as part of any Adaptations or Collections, You must not distort, mutilate, modify or take other derogatory action in relation to the Work which would be prejudicial to the Original Author's honor or reputation. Licensor agrees that in those jurisdictions (e.g. Japan), in which any exercise of the right granted in Section 3(b) of this License (the right to make Adaptations) would be deemed to be a distortion, mutilation, modification or other derogatory action prejudicial to the Original Author's honor and reputation, the Licensor will waive or not assert, as appropriate, this Section, to the fullest extent permitted by the applicable national law, to enable You to reasonably exercise Your right under Section 3(b) of this License (right to make Adaptations) but not otherwise.

5. Representations, Warranties and Disclaimer

UNLESS OTHERWISE MUTUALLY AGREED TO BY THE PARTIES IN WRITING AND TO THE FULLEST EXTENT PERMITTED BY APPLICABLE LAW, LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF TITLE, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY, OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE. SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO THIS EXCLUSION MAY NOT APPLY TO YOU.

6. Limitation on Liability.

EXCEPT TO THE EXTENT REQUIRED BY APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK, EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

7. Termination

    This License and the rights granted hereunder will terminate automatically upon any breach by You of the terms of this License. Individuals or entities who have received Adaptations or Collections from You under this License, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses. Sections 1, 2, 5, 6, 7, and 8 will survive any termination of this License.
    Subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the Work). Notwithstanding the above, Licensor reserves the right to release the Work under different license terms or to stop distributing the Work at any time; provided, however that any such election will not serve to withdraw this License (or any other license that has been, or is required to be, granted under the terms of this License), and this License will continue in full force and effect unless terminated as stated above.

8. Miscellaneous

    Each time You Distribute or Publicly Perform the Work or a Collection, the Licensor offers to the recipient a license to the Work on the same terms and conditions as the license granted to You under this License.
    Each time You Distribute or Publicly Perform an Adaptation, Licensor offers to the recipient a license to the original Work on the same terms and conditions as the license granted to You under this License.
    If any provision of this License is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this License, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.
    No term or provision of this License shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent.
    This License constitutes the entire agreement between the parties with respect to the Work licensed here. There are no understandings, agreements or representations with respect to the Work not specified here. Licensor shall not be bound by any additional provisions that may appear in any communication from You. This License may not be modified without the mutual written agreement of the Licensor and You.
    The rights granted under, and the subject matter referenced, in this License were drafted utilizing the terminology of the Berne Convention for the Protection of Literary and Artistic Works (as amended on September 28, 1979), the Rome Convention of 1961, the WIPO Copyright Treaty of 1996, the WIPO Performances and Phonograms Treaty of 1996 and the Universal Copyright Convention (as revised on July 24, 1971). These rights and subject matter take effect in the relevant jurisdiction in which the License terms are sought to be enforced according to the corresponding provisions of the implementation of those treaty provisions in the applicable national law. If the standard suite of rights granted under applicable copyright law includes additional rights not granted under this License, such additional rights are deemed to be included in the License; this License is not intended to restrict the license of any rights under applicable law.

---

# The MIT license

MIT License

Copyright (c) <dates>, <Copyright Holder> (<URL|email>),

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

### ionicon icons

From https://github.com/ionic-team/ionicons/blob/main/LICENSE.

**MIT**:

Copyright: Copyright (c) 2015-present Ionic (http://ionic.io/)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### material community icons

From https://pictogrammers.com/docs/general/license/.

**(Apache-2.0 AND MIT)**:

```
Pictogrammers Free License
--------------------------

Last Updated: February 1st, 2023

This package is released as free, open-source, and GPL friendly by
the [Pictogrammers](https://pictogrammers.com/). You may use it
for commercial projects, open-source projects, or anything really.

# Icons: Apache 2.0 (https://www.apache.org/licenses/LICENSE-2.0)
Some of the icons are redistributed under the Apache 2.0 license. All other
icons are either redistributed under their respective licenses or are
distributed under the Apache 2.0 license.

# Fonts: Apache 2.0 (https://www.apache.org/licenses/LICENSE-2.0)
All web and desktop fonts are distributed under the Apache 2.0 license. Web
and desktop fonts contain some icons that are redistributed under the Apache
2.0 license. All other icons are either redistributed under their respective
licenses or are distributed under the Apache 2.0 license.

# Code: MIT (https://opensource.org/licenses/MIT)
The MIT license applies to all non-font and non-icon files.

---

# Apache 2.0


                                 Apache License
                           Version 2.0, January 2004
                        http://www.apache.org/licenses/

   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

   1. Definitions.

      "License" shall mean the terms and conditions for use, reproduction,
      and distribution as defined by Sections 1 through 9 of this document.

      "Licensor" shall mean the copyright owner or entity authorized by
      the copyright owner that is granting the License.

      "Legal Entity" shall mean the union of the acting entity and all
      other entities that control, are controlled by, or are under common
      control with that entity. For the purposes of this definition,
      "control" means (i) the power, direct or indirect, to cause the
      direction or management of such entity, whether by contract or
      otherwise, or (ii) ownership of fifty percent (50%) or more of the
      outstanding shares, or (iii) beneficial ownership of such entity.

      "You" (or "Your") shall mean an individual or Legal Entity
      exercising permissions granted by this License.

      "Source" form shall mean the preferred form for making modifications,
      including but not limited to software source code, documentation
      source, and configuration files.

      "Object" form shall mean any form resulting from mechanical
      transformation or translation of a Source form, including but
      not limited to compiled object code, generated documentation,
      and conversions to other media types.

      "Work" shall mean the work of authorship, whether in Source or
      Object form, made available under the License, as indicated by a
      copyright notice that is included in or attached to the work
      (an example is provided in the Appendix below).

      "Derivative Works" shall mean any work, whether in Source or Object
      form, that is based on (or derived from) the Work and for which the
      editorial revisions, annotations, elaborations, or other modifications
      represent, as a whole, an original work of authorship. For the purposes
      of this License, Derivative Works shall not include works that remain
      separable from, or merely link (or bind by name) to the interfaces of,
      the Work and Derivative Works thereof.

      "Contribution" shall mean any work of authorship, including
      the original version of the Work and any modifications or additions
      to that Work or Derivative Works thereof, that is intentionally
      submitted to Licensor for inclusion in the Work by the copyright owner
      or by an individual or Legal Entity authorized to submit on behalf of
      the copyright owner. For the purposes of this definition, "submitted"
      means any form of electronic, verbal, or written communication sent
      to the Licensor or its representatives, including but not limited to
      communication on electronic mailing lists, source code control systems,
      and issue tracking systems that are managed by, or on behalf of, the
      Licensor for the purpose of discussing and improving the Work, but
      excluding communication that is conspicuously marked or otherwise
      designated in writing by the copyright owner as "Not a Contribution."

      "Contributor" shall mean Licensor and any individual or Legal Entity
      on behalf of whom a Contribution has been received by Licensor and
      subsequently incorporated within the Work.

   2. Grant of Copyright License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      copyright license to reproduce, prepare Derivative Works of,
      publicly display, publicly perform, sublicense, and distribute the
      Work and such Derivative Works in Source or Object form.

   3. Grant of Patent License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      (except as stated in this section) patent license to make, have made,
      use, offer to sell, sell, import, and otherwise transfer the Work,
      where such license applies only to those patent claims licensable
      by such Contributor that are necessarily infringed by their
      Contribution(s) alone or by combination of their Contribution(s)
      with the Work to which such Contribution(s) was submitted. If You
      institute patent litigation against any entity (including a
      cross-claim or counterclaim in a lawsuit) alleging that the Work
      or a Contribution incorporated within the Work constitutes direct
      or contributory patent infringement, then any patent licenses
      granted to You under this License for that Work shall terminate
      as of the date such litigation is filed.

   4. Redistribution. You may reproduce and distribute copies of the
      Work or Derivative Works thereof in any medium, with or without
      modifications, and in Source or Object form, provided that You
      meet the following conditions:

      (a) You must give any other recipients of the Work or
          Derivative Works a copy of this License; and

      (b) You must cause any modified files to carry prominent notices
          stating that You changed the files; and

      (c) You must retain, in the Source form of any Derivative Works
          that You distribute, all copyright, patent, trademark, and
          attribution notices from the Source form of the Work,
          excluding those notices that do not pertain to any part of
          the Derivative Works; and

      (d) If the Work includes a "NOTICE" text file as part of its
          distribution, then any Derivative Works that You distribute must
          include a readable copy of the attribution notices contained
          within such NOTICE file, excluding those notices that do not
          pertain to any part of the Derivative Works, in at least one
          of the following places: within a NOTICE text file distributed
          as part of the Derivative Works; within the Source form or
          documentation, if provided along with the Derivative Works; or,
          within a display generated by the Derivative Works, if and
          wherever such third-party notices normally appear. The contents
          of the NOTICE file are for informational purposes only and
          do not modify the License. You may add Your own attribution
          notices within Derivative Works that You distribute, alongside
          or as an addendum to the NOTICE text from the Work, provided
          that such additional attribution notices cannot be construed
          as modifying the License.

      You may add Your own copyright statement to Your modifications and
      may provide additional or different license terms and conditions
      for use, reproduction, or distribution of Your modifications, or
      for any such Derivative Works as a whole, provided Your use,
      reproduction, and distribution of the Work otherwise complies with
      the conditions stated in this License.

   5. Submission of Contributions. Unless You explicitly state otherwise,
      any Contribution intentionally submitted for inclusion in the Work
      by You to the Licensor shall be under the terms and conditions of
      this License, without any additional terms or conditions.
      Notwithstanding the above, nothing herein shall supersede or modify
      the terms of any separate license agreement you may have executed
      with Licensor regarding such Contributions.

   6. Trademarks. This License does not grant permission to use the trade
      names, trademarks, service marks, or product names of the Licensor,
      except as required for reasonable and customary use in describing the
      origin of the Work and reproducing the content of the NOTICE file.

   7. Disclaimer of Warranty. Unless required by applicable law or
      agreed to in writing, Licensor provides the Work (and each
      Contributor provides its Contributions) on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
      implied, including, without limitation, any warranties or conditions
      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
      PARTICULAR PURPOSE. You are solely responsible for determining the
      appropriateness of using or redistributing the Work and assume any
      risks associated with Your exercise of permissions under this License.

   8. Limitation of Liability. In no event and under no legal theory,
      whether in tort (including negligence), contract, or otherwise,
      unless required by applicable law (such as deliberate and grossly
      negligent acts) or agreed to in writing, shall any Contributor be
      liable to You for damages, including any direct, indirect, special,
      incidental, or consequential damages of any character arising as a
      result of this License or out of the use or inability to use the
      Work (including but not limited to damages for loss of goodwill,
      work stoppage, computer failure or malfunction, or any and all
      other commercial damages or losses), even if such Contributor
      has been advised of the possibility of such damages.

   9. Accepting Warranty or Additional Liability. While redistributing
      the Work or Derivative Works thereof, You may choose to offer,
      and charge a fee for, acceptance of support, warranty, indemnity,
      or other liability obligations and/or rights consistent with this
      License. However, in accepting such obligations, You may act only
      on Your own behalf and on Your sole responsibility, not on behalf
      of any other Contributor, and only if You agree to indemnify,
      defend, and hold each Contributor harmless for any liability
      incurred by, or claims asserted against, such Contributor by reason
      of your accepting any such warranty or additional liability.

   END OF TERMS AND CONDITIONS
```

### material icons and symbols

From https://github.com/google/material-design-icons.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
```

### whisper.cpp

From https://github.com/ggerganov/whisper.cpp/blob/master/LICENSE.

**MIT**:

Copyright: Copyright (c) Copyright (c) 2023-2024 The ggml authors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tkwidgets

From https://github.com/laurent22/tkwidgets.

**MIT**:

Copyright: Copyright (c) 2017-2018 Laurent Cozic

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @cronvel/get-pixels@3.4.0, @cronvel/get-pixels@3.4.1

From https://github.com/cronvel/get-pixels.

**MIT**:

Copyright: Copyright (c) 2013 Mikola Lysenko

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @img/sharp-darwin-x64@0.34.3, sharp@0.34.3

From https://github.com/lovell/sharp.

**Apache-2.0**:

```
Apache License
Version 2.0, January 2004
http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and
distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright
owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities
that control, are controlled by, or are under common control with that entity.
For the purposes of this definition, "control" means (i) the power, direct or
indirect, to cause the direction or management of such entity, whether by
contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising
permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including
but not limited to software source code, documentation source, and configuration
files.

"Object" form shall mean any form resulting from mechanical transformation or
translation of a Source form, including but not limited to compiled object code,
generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made
available under the License, as indicated by a copyright notice that is included
in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that
is based on (or derived from) the Work and for which the editorial revisions,
annotations, elaborations, or other modifications represent, as a whole, an
original work of authorship. For the purposes of this License, Derivative Works
shall not include works that remain separable from, or merely link (or bind by
name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version
of the Work and any modifications or additions to that Work or Derivative Works
thereof, that is intentionally submitted to Licensor for inclusion in the Work
by the copyright owner or by an individual or Legal Entity authorized to submit
on behalf of the copyright owner. For the purposes of this definition,
"submitted" means any form of electronic, verbal, or written communication sent
to the Licensor or its representatives, including but not limited to
communication on electronic mailing lists, source code control systems, and
issue tracking systems that are managed by, or on behalf of, the Licensor for
the purpose of discussing and improving the Work, but excluding communication
that is conspicuously marked or otherwise designated in writing by the copyright
owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
of whom a Contribution has been received by Licensor and subsequently
incorporated within the Work.

2. Grant of Copyright License.

Subject to the terms and conditions of this License, each Contributor hereby
grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
irrevocable copyright license to reproduce, prepare Derivative Works of,
publicly display, publicly perform, sublicense, and distribute the Work and such
Derivative Works in Source or Object form.

3. Grant of Patent License.

Subject to the terms and conditions of this License, each Contributor hereby
grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
irrevocable (except as stated in this section) patent license to make, have
made, use, offer to sell, sell, import, and otherwise transfer the Work, where
such license applies only to those patent claims licensable by such Contributor
that are necessarily infringed by their Contribution(s) alone or by combination
of their Contribution(s) with the Work to which such Contribution(s) was
submitted. If You institute patent litigation against any entity (including a
cross-claim or counterclaim in a lawsuit) alleging that the Work or a
Contribution incorporated within the Work constitutes direct or contributory
patent infringement, then any patent licenses granted to You under this License
for that Work shall terminate as of the date such litigation is filed.

4. Redistribution.

You may reproduce and distribute copies of the Work or Derivative Works thereof
in any medium, with or without modifications, and in Source or Object form,
provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of
this License; and
You must cause any modified files to carry prominent notices stating that You
changed the files; and
You must retain, in the Source form of any Derivative Works that You distribute,
all copyright, patent, trademark, and attribution notices from the Source form
of the Work, excluding those notices that do not pertain to any part of the
Derivative Works; and
If the Work includes a "NOTICE" text file as part of its distribution, then any
Derivative Works that You distribute must include a readable copy of the
attribution notices contained within such NOTICE file, excluding those notices
that do not pertain to any part of the Derivative Works, in at least one of the
following places: within a NOTICE text file distributed as part of the
Derivative Works; within the Source form or documentation, if provided along
with the Derivative Works; or, within a display generated by the Derivative
Works, if and wherever such third-party notices normally appear. The contents of
the NOTICE file are for informational purposes only and do not modify the
License. You may add Your own attribution notices within Derivative Works that
You distribute, alongside or as an addendum to the NOTICE text from the Work,
provided that such additional attribution notices cannot be construed as
modifying the License.
You may add Your own copyright statement to Your modifications and may provide
additional or different license terms and conditions for use, reproduction, or
distribution of Your modifications, or for any such Derivative Works as a whole,
provided Your use, reproduction, and distribution of the Work otherwise complies
with the conditions stated in this License.

5. Submission of Contributions.

Unless You explicitly state otherwise, any Contribution intentionally submitted
for inclusion in the Work by You to the Licensor shall be under the terms and
conditions of this License, without any additional terms or conditions.
Notwithstanding the above, nothing herein shall supersede or modify the terms of
any separate license agreement you may have executed with Licensor regarding
such Contributions.

6. Trademarks.

This License does not grant permission to use the trade names, trademarks,
service marks, or product names of the Licensor, except as required for
reasonable and customary use in describing the origin of the Work and
reproducing the content of the NOTICE file.

7. Disclaimer of Warranty.

Unless required by applicable law or agreed to in writing, Licensor provides the
Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
including, without limitation, any warranties or conditions of TITLE,
NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
solely responsible for determining the appropriateness of using or
redistributing the Work and assume any risks associated with Your exercise of
permissions under this License.

8. Limitation of Liability.

In no event and under no legal theory, whether in tort (including negligence),
contract, or otherwise, unless required by applicable law (such as deliberate
and grossly negligent acts) or agreed to in writing, shall any Contributor be
liable to You for damages, including any direct, indirect, special, incidental,
or consequential damages of any character arising as a result of this License or
out of the use or inability to use the Work (including but not limited to
damages for loss of goodwill, work stoppage, computer failure or malfunction, or
any and all other commercial damages or losses), even if such Contributor has
been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability.

While redistributing the Work or Derivative Works thereof, You may choose to
offer, and charge a fee for, acceptance of support, warranty, indemnity, or
other liability obligations and/or rights consistent with this License. However,
in accepting such obligations, You may act only on Your own behalf and on Your
sole responsibility, not on behalf of any other Contributor, and only if You
agree to indemnify, defend, and hold each Contributor harmless for any liability
incurred by, or claims asserted against, such Contributor by reason of your
accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS

APPENDIX: How to apply the Apache License to your work

To apply the Apache License to your work, attach the following boilerplate
notice, with the fields enclosed by brackets "[]" replaced with your own
identifying information. (Don't include the brackets!) The text should be
enclosed in the appropriate comment syntax for the file format. We also
recommend that a file or class name and description of purpose be included on
the same "printed page" as the copyright notice for easier identification within
third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### @img/sharp-libvips-darwin-x64@1.2.0

From https://github.com/lovell/sharp-libvips.

**LGPL-3.0-or-later**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "{}"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright {yyyy} {name of copyright owner}

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### aws-sdk@2.1340.0

From https://github.com/aws/aws-sdk-js.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

**NOTICE**:

```
NOTICE.txt:

AWS SDK for JavaScript
Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.

This product includes software developed at
Amazon Web Services, Inc. (http://aws.amazon.com/).

```

### chroma-js@2.1.2, chroma-js@2.4.2

From https://github.com/gka/chroma.js.

**(BSD-3-Clause AND Apache-2.0)**:

```
chroma.js - JavaScript library for color conversions

Copyright (c) 2011-2019, Gregor Aisch
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. The name Gregor Aisch may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL GREGOR AISCH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

-------------------------------------------------------

chroma.js includes colors from colorbrewer2.org, which are released under
the following license:

Copyright (c) 2002 Cynthia Brewer, Mark Harrower,
and The Pennsylvania State University.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
either express or implied. See the License for the specific
language governing permissions and limitations under the License.

------------------------------------------------------

Named colors are taken from X11 Color Names.
http://www.w3.org/TR/css3-color/#svg-color

@preserve

```

### compare-version@0.1.2

From https://github.com/kevva/compare-version.

**MIT**:

```
## License

[MIT License](http://en.wikipedia.org/wiki/MIT_License) © [Kevin Mårtensson](https://github.com/kevva)

```

### cross-env@6.0.3

From https://github.com/kentcdodds/cross-env.

**MIT**:

Copyright: Copyright (c) 2017 Kent C. Dodds

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cwise-compiler@1.1.3

From https://github.com/scijs/cwise-compiler.

**MIT**:

Copyright: Copyright (c) 2013 Mikola Lysenko

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### decompress-response@6.0.0

From https://github.com/sindresorhus/decompress-response.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### emphasize@1.5.0

From https://github.com/wooorm/emphasize.

**MIT**:

Copyright: Copyright (c) 2016 Titus Wormer <mailto:tituswormer@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### expand-template@2.0.3

From https://github.com/ralphtheninja/expand-template.

**(MIT OR WTFPL)**:

Copyright: Copyright (c) 2018 Lars-Magnus Skog

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### fault@1.0.4

From https://github.com/wooorm/fault.

**MIT**:

Copyright: Copyright (c) 2015 Titus Wormer <tituswormer@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### format@0.2.2

From https://github.com/samsonjs/format.

**MIT**:

```
format
======

printf, sprintf, and vsprintf for JavaScript


Installation
============

npm install format

The code works in browsers as well, you can copy these functions into your project
or otherwise include them with your other JavaScript.

Usage
=====

    var format = require('format')
      , printf = format.printf
      , vsprintf = format.vsprintf
      // or if you want to keep it old school
      , sprintf = format

    // Print 'hello world'
    printf('%s world', 'hello')

    var what = 'life, the universe, and everything'
    format('%d is the answer to %s', 42, what)
    // => '42 is the answer to life, the universe, and everything'

    vsprintf('%d is the answer to %s', [42, what])
    // => '42 is the answer to life, the universe, and everything'

Supported format specifiers: b, c, d, f, o, s, x, and X.

See `man 3 printf` or `man 1 printf` for details.

Precision is supported for floating point numbers.

License
=======

Copyright 2010 - 2014 Sami Samhuri sami@samhuri.net

[MIT license](http://sjs.mit-license.org)


```

### fs-constants@1.0.0

From https://github.com/mafintosh/fs-constants.

**MIT**:

Copyright: Copyright (c) 2018 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### github-from-package@0.0.0

From https://github.com/substack/github-from-package.

**MIT**:

```
This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### has-ansi@2.0.0

From https://github.com/sindresorhus/has-ansi.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### highlight.js@9.12.0

From https://github.com/isagalaev/highlight.js.

**BSD-3-Clause**:

```
Copyright (c) 2006, Ivan Sagalaev
All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of highlight.js nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### iota-array@1.0.0

From https://github.com/mikolalysenko/iota-array.

**MIT**:

Copyright: Copyright (c) 2013 Mikola Lysenko

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### jmespath@0.16.0

From https://github.com/jmespath/jmespath.js.

**Apache-2.0**:

```
Copyright 2014 James Saryerwinnie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

```

### joplin@3.5.1

From https://github.com/laurent22/joplin.

**UNLICENSED**:

```
All code in this repository is licensed under the AGPL-3.0-or-later License
**unless a directory contains a LICENSE or LICENSE.md file**, in which case that
file applies to the code in that sub-directory.

For example, packages/server contains a LICENSE.md file, thus all code under the
packages/server directory is licensed under that license.

For example, packages/app-cli does NOT contain a LICENSE file, thus all code
under that directory is licensed under the default license, which is
AGPL-3.0-or-later.

* * *

Joplin® is a trademark of JOPLIN SAS registered in the European Union, with
filing number 018544315.

* * *

Logo and Icon License

The Joplin logos and icons are copyright (c) Laurent Cozic, all rights reserved,
and may not be used without a permission. If you would like to use the logos or
icons please contact the author in order to get a permission.

* * *

AGPL-3.0-or-later License

Copyright (c) 2016-2025 Laurent Cozic

https://spdx.org/licenses/AGPL-3.0-or-later.html

```

### jpeg-js@0.4.3, jpeg-js@0.4.4

From https://github.com/eugeneware/jpeg-js.

**BSD-3-Clause**:

```
Copyright (c) 2014, Eugene Ware
All rights reserved.
  
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:  

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.  
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.  
3. Neither the name of Eugene Ware nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.  
  
THIS SOFTWARE IS PROVIDED BY EUGENE WARE ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL EUGENE WARE BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### keytar@7.9.0

From https://github.com/atom/node-keytar.

**MIT**:

Copyright: Copyright (c) 2013 GitHub Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lazyness@1.2.0

From https://github.com/cronvel/lazyness.

**MIT**:

Copyright: Copyright (c) 2014 cronvel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lowlight@1.9.2

From https://github.com/wooorm/lowlight.

**MIT**:

Copyright: Copyright (c) 2016 Titus Wormer <tituswormer@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mimic-response@3.1.0, mimic-response@1.0.1

From https://github.com/sindresorhus/mimic-response.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### mkdirp-classic@0.5.3

From https://github.com/mafintosh/mkdirp-classic.

**MIT**:

Copyright: Copyright (c) 2020 James Halliday (mail@substack.net) and Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### napi-build-utils@1.0.2

From https://github.com/inspiredware/napi-build-utils.

**MIT**:

Copyright: Copyright (c) 2018 inspiredware

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ndarray-pack@1.2.1

From https://github.com/mikolalysenko/ndarray-pack.

**MIT**:

Copyright: Copyright (c) 2013 Mikola Lysenko

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ndarray@1.0.19

From https://github.com/mikolalysenko/ndarray.

**MIT**:

Copyright: Copyright (c) 2013-2016 Mikola Lysenko

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nextgen-events@1.5.2, nextgen-events@1.5.3

From https://github.com/cronvel/nextgen-events.

**MIT**:

Copyright: Copyright (c) 2014 Cédric Ronvel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-abi@3.28.0

From https://github.com/lgeiger/node-abi.

**MIT**:

Copyright: Copyright (c) 2016 Lukas Geiger

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-bitmap@0.0.1

From https://github.com/nowelium/node-bitmap.

**MIT***:

```
# node-bitmap

Bitmap library Node.JS

## Installation

via npm:

    $ npm install socket.io-store-memcached

## License 

(The MIT License)

Copyright (c) 2012 Yusuke Hata

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### omggif@1.0.10

From https://github.com/deanm/omggif.

**MIT**:

```
omggif is a JavaScript implementation of a GIF 89a encoder and decoder.

https://github.com/deanm/omggif


(c) Dean McNamee <dean@gmail.com>, 2013.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

```

### pngjs@5.0.0, pngjs@6.0.0

From https://github.com/lukeapage/pngjs.

**MIT**:

```
pngjs2 original work Copyright (c) 2015 Luke Page & Original Contributors
pngjs derived work Copyright (c) 2012 Kuba Niegowski

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### prebuild-install@7.1.1

From https://github.com/prebuild/prebuild-install.

**MIT**:

Copyright: Copyright (c) 2015 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### proper-lockfile@4.1.2

From https://github.com/moxystudio/node-proper-lockfile.

**MIT**:

Copyright: Copyright (c) 2018 Made With MOXY Lda <hello@moxy.studio>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### querystring@0.2.0

From https://github.com/Gozala/querystring.

**MIT**:

Copyright: Copyright 2012 Irakli Gozalishvili. All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### seventh@0.7.40, seventh@0.9.2

From https://github.com/cronvel/seventh.

**MIT**:

Copyright: Copyright (c) 2014 cronvel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### simple-concat@1.0.1

From https://github.com/feross/simple-concat.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### simple-get@4.0.0

From https://github.com/feross/simple-get.

**MIT**:

Copyright: Copyright (c) Feross Aboukhadijeh

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### string-kit@0.11.10, string-kit@0.19.2

From https://github.com/cronvel/string-kit.

**MIT**:

Copyright: Copyright (c) 2014 Cédric Ronvel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tar-fs@2.1.1

From https://github.com/mafintosh/tar-fs.

**MIT**:

Copyright: Copyright (c) 2014 Mathias Buus

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### terminal-kit@1.49.4, terminal-kit@3.1.2

From https://github.com/cronvel/terminal-kit.

**MIT**:

Copyright: Copyright (c) 2014 cronvel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tree-kit@0.7.4, tree-kit@0.8.7

From https://github.com/cronvel/tree-kit.

**MIT**:

Copyright: Copyright (c) 2014 Cédric Ronvel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### uniq@1.0.1

From https://github.com/mikolalysenko/uniq.

**MIT**:

Copyright: Copyright (c) 2013 Mikola Lysenko

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @electron/get@2.0.2

From https://github.com/electron/get.

**MIT**:

Copyright: Copyright (c) Contributors to the Electron project

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @electron/remote@2.1.2

From https://github.com/electron/remote.

**MIT**:

Copyright: Copyright (c) 2019-2022 Electron contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @sindresorhus/is@4.2.0

From https://github.com/sindresorhus/is.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @szmarczak/http-timer@4.0.6

From https://github.com/szmarczak/http-timer.

**MIT**:

Copyright: Copyright (c) 2018 Szymon Marczak

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### boolean@3.1.4

From https://github.com/thenativeweb/boolean.

**MIT**:

Copyright: Copyright (c) 2014-2021 the native web.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### buffer-crc32@0.2.13

From https://github.com/brianloveswords/buffer-crc32.

**MIT**:

Copyright: Copyright (c) 2013 Brian J. Brennan

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cacheable-lookup@5.0.4

From https://github.com/szmarczak/cacheable-lookup.

**MIT**:

Copyright: Copyright (c) 2019 Szymon Marczak

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cacheable-request@7.0.2

From https://github.com/lukechilds/cacheable-request.

**MIT**:

Copyright: Copyright (c) 2017 Luke Childs

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### clone-response@1.0.2

From https://github.com/lukechilds/clone-response.

**MIT**:

Copyright: Copyright (c) 2017 Luke Childs

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### defer-to-connect@2.0.1

From https://github.com/szmarczak/defer-to-connect.

**MIT**:

Copyright: Copyright (c) 2018 Szymon Marczak

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### detect-node@2.1.0

From https://github.com/iliakan/detect-node.

**MIT**:

Copyright: Copyright (c) 2017 Ilya Kantor

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### electron@37.7.0

From https://github.com/electron/electron.

**MIT**:

Copyright: Copyright (c) 2013-2020 GitHub Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### es6-error@4.1.1

From https://github.com/bjyoungblood/es6-error.

**MIT**:

Copyright: Copyright (c) 2015 Ben Youngblood

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### extract-zip@2.0.1

From https://github.com/maxogden/extract-zip.

**BSD-2-Clause**:

```
Copyright (c) 2014 Max Ogden and other contributors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### fd-slicer@1.1.0

From https://github.com/andrewrk/node-fd-slicer.

**MIT**:

Copyright: Copyright (c) 2014 Andrew Kelley

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### global-agent@3.0.0

From https://github.com/gajus/global-agent.

**BSD-3-Clause**:

```
Copyright (c) 2019, Gajus Kuizinas (http://gajus.com/)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Gajus Kuizinas (http://gajus.com/) nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL ANUARY BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### globalthis@1.0.2

From https://github.com/ljharb/System.global.

**MIT**:

Copyright: Copyright (c) 2016 Jordan Harband

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### got@11.8.6

From https://github.com/sindresorhus/got.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### http2-wrapper@1.0.3

From https://github.com/szmarczak/http2-wrapper.

**MIT**:

Copyright: Copyright (c) 2018 Szymon Marczak

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### json-buffer@3.0.1

From https://github.com/dominictarr/json-buffer.

**MIT**:

Copyright: Copyright (c) 2013 Dominic Tarr

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### keyv@4.0.4

From https://github.com/jaredwray/keyv.

**MIT**:

Copyright: Copyright (c) 2017-2021 Jared Wray & Luke Childs

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### lowercase-keys@2.0.0

From https://github.com/sindresorhus/lowercase-keys.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### matcher@3.0.0

From https://github.com/sindresorhus/matcher.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### normalize-url@6.1.0

From https://github.com/sindresorhus/normalize-url.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### p-cancelable@2.1.1

From https://github.com/sindresorhus/p-cancelable.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pend@1.2.0

From https://github.com/andrewrk/node-pend.

**MIT**:

```
The MIT License (Expat)

Copyright (c) 2014 Andrew Kelley

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation files
(the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### quick-lru@5.1.1

From https://github.com/sindresorhus/quick-lru.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### resolve-alpn@1.2.1

From https://github.com/szmarczak/resolve-alpn.

**MIT**:

Copyright: Copyright (c) 2018 Szymon Marczak

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### responselike@2.0.0

From https://github.com/lukechilds/responselike.

**MIT**:

Copyright: Copyright (c) 2017 Luke Childs

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### roarr@2.15.4

From https://github.com/gajus/roarr.

**BSD-3-Clause**:

```
Copyright (c) 2019, Gajus Kuizinas (http://gajus.com/)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Gajus Kuizinas (http://gajus.com/) nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL ANUARY BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### semver-compare@1.0.0

From https://github.com/substack/semver-compare.

**MIT**:

```
This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### sumchecker@3.0.1

From https://github.com/malept/sumchecker.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### yauzl@2.10.0

From https://github.com/thejoshwolfe/yauzl.

**MIT**:

Copyright: Copyright (c) 2014 Josh Wolfe

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @authenio/samlify-xmllint-wasm@1.0.1

From https://github.com/authenio/samlify-xmllint-wasm.

**MIT**:

Copyright: Copyright (c) 2023 Authen

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @authenio/xml-encryption@2.0.2

From https://github.com/auth0/node-xml-encryption.

**MIT**:

Copyright: Copyright (c) 2015 Auth0, Inc. <support@auth0.com> (http://auth0.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @koa/cors@3.4.3

From https://github.com/koajs/cors.

**MIT**:

```
This software is licensed under the MIT License.

Copyright (c) 2015 - present koajs and other contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### @xmldom/is-dom-node@1.0.1

From https://github.com/xmldom/is-dom-node.

**MIT**:

```
# MIT License

Copyright (c) 2023 Chris Barth

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### bcryptjs@2.4.3

From https://github.com/dcodeIO/bcrypt.js.

**MIT**:

```
bcrypt.js
---------
Copyright (c) 2012 Nevins Bartolomeo <nevins.bartolomeo@gmail.com>
Copyright (c) 2012 Shane Girish <shaneGirish@gmail.com>
Copyright (c) 2014 Daniel Wirtz <dcode@dcode.io>
 
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

isaac.js
--------
Copyright (c) 2012 Yves-Marie K. Rinquin

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### bulma@1.0.4

From https://github.com/jgthms/bulma.

**MIT**:

Copyright: Copyright (c) 2023 Jeremy Thomas

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cache-content-type@1.0.1

From https://github.com/node-modules/cache-content-type.

**MIT**:

Copyright: Copyright (c) 2018-present node-modules and the contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### co@4.6.0

From https://github.com/tj/co.

**MIT**:

Copyright: Copyright (c) 2014 TJ Holowaychuk &lt;tj@vision-media.ca&gt;

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### content-disposition@0.5.3

From https://github.com/jshttp/content-disposition.

**MIT**:

Copyright: Copyright (c) 2014-2017 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### content-type@1.0.4

From https://github.com/jshttp/content-type.

**MIT**:

Copyright: Copyright (c) 2015 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### cookies@0.9.1

From https://github.com/pillarjs/cookies.

**MIT**:

Copyright: Copyright (c) 2015-2016 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### deep-equal@1.0.1

From https://github.com/substack/node-deep-equal.

**MIT**:

```
This software is released under the MIT license:

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### dezalgo@1.0.4

From https://github.com/npm/dezalgo.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter and Contributors

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### esm@3.2.25

From https://github.com/standard-things/esm.

**MIT**:

```
The MIT License (MIT)

Copyright esm contributors

Based on reify, copyright Ben Newman <https://github.com/benjamn/reify>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### formidable@2.1.2

From https://github.com/node-formidable/formidable.

**MIT**:

Copyright: Copyright (c) 2011-present Felix Geisendörfer, and contributors.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### getopts@2.3.0

From https://github.com/jorgebucaran/getopts.

**MIT**:

Copyright: Copyright © Jorge Bucaran <<https://jorgebucaran.com>>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### hexoid@1.0.0

From https://github.com/lukeed/hexoid.

**MIT**:

Copyright: Copyright (c) Luke Edwards <luke.edwards05@gmail.com> (lukeed.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### http-assert@1.5.0

From https://github.com/jshttp/http-assert.

**MIT**:

Copyright: Copyright (c) 2014

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ignore-by-default@1.0.1

From https://github.com/novemberborn/ignore-by-default.

**ISC**:

```
ISC License (ISC)
Copyright (c) 2016, Mark Wubben

Permission to use, copy, modify, and/or distribute this software for any purpose
with or without fee is hereby granted, provided that the above copyright notice
and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

```

### interpret@2.2.0

From https://github.com/gulpjs/interpret.

**MIT**:

Copyright: Copyright (c) 2014-2018 Tyler Kellen <tyler@sleekcode.net>, Blaine Bublitz <blaine.bublitz@gmail.com>, and Eric Schoffstall <yo@contra.io>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### jquery@3.7.1

From https://github.com/jquery/jquery.

**MIT**:

Copyright: Copyright OpenJS Foundation and other contributors, https://openjsf.org/

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### keygrip@1.1.0

From https://github.com/crypto-utils/keygrip.

**MIT**:

Copyright: Copyright (c) 2011-2014 Jed Schmidt <where@jed.is> (http://jedschmidt.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### knex@3.1.0

From https://github.com/knex/knex.

**MIT**:

Copyright: Copyright (c) 2013-present Tim Griesser

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### koa-compose@4.1.0

From https://github.com/koajs/compose.

**MIT**:


````

# koa-compose

[![NPM version][npm-image]][npm-url]
[![Build status][travis-image]][travis-url]
[![Test coverage][codecov-image]][codecov-url]
[![Dependency Status][david-image]][david-url]
[![License][license-image]][license-url]
[![Downloads][downloads-image]][downloads-url]

 Compose middleware.

## Installation

```js
$ npm install koa-compose
```

## API

### compose([a, b, c, ...])

  Compose the given middleware and return middleware.

## License

  MIT

[npm-image]: https://img.shields.io/npm/v/koa-compose.svg?style=flat-square
[npm-url]: https://npmjs.org/package/koa-compose
[travis-image]: https://img.shields.io/travis/koajs/compose/next.svg?style=flat-square
[travis-url]: https://travis-ci.org/koajs/compose
[codecov-image]: https://img.shields.io/codecov/c/github/koajs/compose/next.svg?style=flat-square
[codecov-url]: https://codecov.io/github/koajs/compose
[david-image]: http://img.shields.io/david/koajs/compose.svg?style=flat-square
[david-url]: https://david-dm.org/koajs/compose
[license-image]: http://img.shields.io/npm/l/koa-compose.svg?style=flat-square
[license-url]: LICENSE
[downloads-image]: http://img.shields.io/npm/dm/koa-compose.svg?style=flat-square
[downloads-url]: https://npmjs.org/package/koa-compose


````

### koa-convert@2.0.0

From https://github.com/gyson/koa-convert.

**MIT**:

Copyright: Copyright (c) 2020 Koa.js contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### koa@2.16.1

From https://github.com/koajs/koa.

**MIT**:

Copyright: Copyright (c) 2019 Koa contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### later@1.2.0

From https://github.com/bunkat/later.

**MIT**:

Copyright: Copyright © 2013 BunKat

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### ldapts@7.4.0

From https://github.com/ldapts/ldapts.

**MIT**:

Copyright: Copyright (c) 2018 jim@biacreations.com

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### media-typer@0.3.0

From https://github.com/jshttp/media-typer.

**MIT**:

Copyright: Copyright (c) 2014 Douglas Christopher Wilson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### node-cron@3.0.3

From https://github.com/merencia/node-cron.

**ISC**:

```
## ISC License

Copyright (c) 2016, Lucas Merencia \<lucas.merencia@gmail.com\>

Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### node-os-utils@1.3.7

From https://github.com/SunilWang/node-os-utils.

**MIT**:

Copyright: Copyright (c) 2017 Sunil Wang

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nodemailer@6.10.1

From https://github.com/nodemailer/nodemailer.

**MIT-0**:

```
Copyright (c) 2011-2023 Andris Reinman

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### nodemon@3.1.10

From https://github.com/remy/nodemon.

**MIT**:

Copyright: Copyright (c) 2010 - present, Remy Sharp, https://remysharp.com <remy@remysharp.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### nopt@1.0.10

From https://github.com/isaacs/nopt.

**MIT**:

Copyright: Copyright 2009, 2010, 2011 Isaac Z. Schlueter.

All rights reserved.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### only@0.0.2

From https://github.com/visionmedia/node-only.

**MIT***:


````

# only

  Return whitelisted properties of an object.

## Installation

    $ npm install only

## API

 An array or space-delimited string may be given:

```js
var obj = {
  name: 'tobi',
  last: 'holowaychuk',
  email: 'tobi@learnboost.com',
  _id: '12345'
};

var user = only(obj, 'name last email');
```

yields:

```js
{
  name: 'tobi',
  last: 'holowaychuk',
  email: 'tobi@learnboost.com'
}
```

## License 

(The MIT License)

Copyright (c) 2012 TJ Holowaychuk &lt;tj@vision-media.ca&gt;

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

````

### pako@1.0.11

From https://github.com/nodeca/pako.

**(MIT AND Zlib)**:

Copyright: Copyright (C) 2014-2017 by Vitaly Puzrin and Andrei Tuputcyn

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pg-cloudflare@1.2.7, pg-connection-string@2.6.2, pg-connection-string@2.9.1, pg-pool@3.10.1, pg-protocol@1.10.3, pg@8.16.3

From https://github.com/brianc/node-postgres.

**MIT**:

Copyright: Copyright (c) 2010 - 2021 Brian Carlson

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### pg-int8@1.0.1

From https://github.com/charmander/pg-int8.

**ISC**:

```
Copyright © 2017, Charmander <~@charmander.me>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED “AS IS” AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

```

### pg-types@2.2.0

From https://github.com/brianc/node-pg-types.

**MIT**:

```
## license

The MIT License (MIT)

Copyright (c) 2014 Brian M. Carlson

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### pgpass@1.0.5

From https://github.com/hoegaarden/pgpass.

**MIT**:

```
## License

Copyright (c) 2013-2016 Hannes Hörl

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### postgres-array@2.0.0

From https://github.com/bendrucker/postgres-array.

**MIT**:

Copyright: Copyright (c) Ben Drucker <bvdrucker@gmail.com> (bendrucker.me)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### postgres-bytea@1.0.0

From https://github.com/bendrucker/postgres-bytea.

**MIT**:

Copyright: Copyright (c) Ben Drucker <bvdrucker@gmail.com> (bendrucker.me)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### postgres-date@1.0.7

From https://github.com/bendrucker/postgres-date.

**MIT**:

Copyright: Copyright (c) Ben Drucker <bvdrucker@gmail.com> (bendrucker.me)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### postgres-interval@1.2.0

From https://github.com/bendrucker/postgres-interval.

**MIT**:

Copyright: Copyright (c) Ben Drucker <bvdrucker@gmail.com> (bendrucker.me)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### prettycron@0.10.0

From https://github.com/azza-bazoo/prettycron.

**Custom: http://fsf.org/**:

```
GNU LESSER GENERAL PUBLIC LICENSE
=================================

Version 3, 29 June 2007

Copyright © 2007 Free Software Foundation, Inc. <http://fsf.org/>  
Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  1. Additional Definitions. 

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  2. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  3. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

     1. under this License, provided that you make a good faith effort to
     ensure that, in the event an Application does not supply the
     function or data, the facility still operates, and performs
     whatever part of its purpose remains meaningful, or

     2. under the GNU GPL, with none of the additional permissions of
     this License applicable to that copy.

  4. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

     1. Give prominent notice with each copy of the object code that the
     Library is used in it and that the Library and its use are
     covered by this License.

     2. Accompany the object code with a copy of the GNU GPL and this license
     document.

  5. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

     1. Give prominent notice with each copy of the Combined Work that
     the Library is used in it and that the Library and its use are
     covered by this License.

     2. Accompany the Combined Work with a copy of the GNU GPL and this license
     document.

     3. For a Combined Work that displays copyright notices during
     execution, include the copyright notice for the Library among
     these notices, as well as a reference directing the user to the
     copies of the GNU GPL and this license document.

     4. Do one of the following:

        1. Convey the Minimal Corresponding Source under the terms of this
        License, and the Corresponding Application Code in a form
        suitable for, and under terms that permit, the user to
        recombine or relink the Application with a modified version of
        the Linked Version to produce a modified Combined Work, in the
        manner specified by section 6 of the GNU GPL for conveying
        Corresponding Source.

        2. Use a suitable shared library mechanism for linking with the
        Library.  A suitable mechanism is one that (a) uses at run time
        a copy of the Library already present on the user's computer
        system, and (b) will operate properly with a modified version
        of the Library that is interface-compatible with the Linked
        Version. 

     5. Provide Installation Information, but only if you would otherwise
     be required to provide such information under section 6 of the
     GNU GPL, and only to the extent that such information is
     necessary to install and execute a modified version of the
     Combined Work produced by recombining or relinking the
     Application with a modified version of the Linked Version. (If
     you use option 4d0, the Installation Information must accompany
     the Minimal Corresponding Source and Corresponding Application
     Code. If you use option 4d1, you must provide the Installation
     Information in the manner specified by section 6 of the GNU GPL
     for conveying Corresponding Source.)

     6. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

     1. Accompany the combined library with a copy of the same work based
     on the Library, uncombined with any other library facilities,
     conveyed under the terms of this License.

     2. Give prominent notice with the combined library that part of it
     is a work based on the Library, and explaining where to find the
     accompanying uncombined form of the same work.

  7. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
```

### pstree.remy@1.1.8

From https://github.com/remy/pstree.

**MIT**:

```
The MIT License (MIT)
Copyright © 2019 Remy Sharp, https://remysharp.com <remy@remysharp.com>
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### rate-limiter-flexible@6.2.1

From https://github.com/animir/node-rate-limiter-flexible.

**ISC**:

```
## ISC License (ISC)

Copyright 2019 Roman Voloboev

Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### raw-body@3.0.0

From https://github.com/stream-utils/raw-body.

**MIT**:

Copyright: Copyright (c) 2014-2022 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### rechoir@0.8.0

From https://github.com/gulpjs/rechoir.

**MIT**:

Copyright: Copyright (c) 2014-2019, 2021 Tyler Kellen <tyler@sleekcode.net>, Blaine Bublitz <blaine.bublitz@gmail.com>, and Eric Schoffstall <yo@contra.io>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### samlify@2.10.1

From https://github.com/tngan/samlify.

**MIT**:

Copyright: Copyright (c) 2016-present Tony Ngan

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### simple-update-notifier@2.0.0

From https://github.com/alexbrazier/simple-update-notifier.

**MIT**:

Copyright: Copyright (c) 2022 Alex Brazier

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### split2@4.2.0

From https://github.com/mcollina/split2.

**ISC**:

```
Copyright (c) 2014-2018, Matteo Collina <hello@matteocollina.com>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### strict-event-emitter-types@2.0.0

From https://github.com/bterlson/typed-event-emitter.

**ISC**:


````
## Typed Event Emitter

**NOTE: REQUIRES TYPESCRIPT 3.0**

A TypeScript library for strongly typed event emitters in 0 kB. Declare events using a simple interface mapping event names to their payloads to get stricter versions of `emit`, `on`, and other common EventEmitter APIs. Works with any kind of EventEmitter.

### Installation

```
npm i strict-event-emitter-types
```

### Example

```ts
import StrictEventEmitter from 'strict-event-emitter-types';

// define your events
interface Events {
  request: (request: Request, response: Response) => void;
  done: void;
}

// grab an event emitter
import { EventEmitter } from 'events';

// Create strict event emitter types
let ee: StrictEventEmitter<EventEmitter, Events> = new EventEmitter;

// now enjoy your strongly typed EventEmitter API!🎉

ee.on('request', (r, resp) => ... );
// r and resp are contextually typed to Request and Response

ee.on('somethingElse');
// Error: unknown event

ee.on('done', x => x);
// Error: The 'done' event does not have a payload

ee.emit('request', new Request());
// Error: missing event payload (the response)

ee.emit('request', new Request(), false);
// Error: incorrect payload type
```

### Usage

#### Event Records

Event records are interfaces or object types that map event names to the event's payload types. In the following example, three events are declared:

```ts
interface Events {
  req: (request: Request, response: Response) => void;
  done: void;
  conn: Connection;
}
```

Each event shows one of three ways to type the event payloads:

1.  **Function type:** Parameters are the event payload. The return type is ignored.
1.  **`void`:** A shortcut for an event with no payload, i.e. `() => void`
1.  **Anything else:** A shortcut for an event with one payload, for example `(p: number) => void` can be written as just `number`.

#### StrictEventEmitter&lt;TEmitterType, TEventRecord, TEmitRecord>

The default export. A generic type that takes three type parameters:

1.  _TEmitterType_: Your EventEmitter type (e.g. node's EventEmitter or socket.io socket)
2.  _TEventRecord_: A type mapping event names to event payloads
3.  _TEmitRecord_: Optionally, a similar type mapping things you can emit.

The third parameter is handy when typing web sockets where client and server can listen to and emit different events. For example, if you are using socket.io:

```ts
// create types representing the server side and client
// side sockets
export type ServerSocket =
  StrictEventEmitter<SocketIO.Socket, EventsFromServer, EventsFromClient>;
export type ClientSocket =
  StrictEventEmitter<SocketIOClient.Socket, EventsFromClient, EventsFromServer>;

// elsewhere on server
let serverSocket: ServerSocket = new SocketIO.Socket();
serverSocket.on(/* only events that are sent from the client are allowed */, ...)
serverSocket.emit(/* only events that are emitted from the server are allowed */, ...)

// elsewhere on client
let clientSocket: ClientSocket = new SocketIOClient.Socket();
clientSocket.on(/* only events that are sent from the server are allowed */, ...)
clientSocket.emit(/* only events that are emitted from the client are allowed */, ...)
```

##### Usage with Subclasses

To subclass an EventEmitter you need to cast the base EventEmitter to the strict EventEmitter before extending:

```ts
type MyEmitter = StrictEventEmitter<EventEmitter, Events>;

class MyEventEmitter extends (EventEmitter as { new(): MyEmitter }) {
  doEmit() {
    this.emit(...); // strict
  }
}
```

### StrictBroadcast&lt;TStrictEventEmitter>

A type for a function which takes (and strictly checks) an emit event and a payload. _TStrictEventEmitter_ is the event emitter type instantiated from StrictEventEmitter.

Useful for broadcast abstractions. It is not possible to contextually type assigments to this type, so your declarations will look something like this:

```ts
import { StrictBroadcast } from 'strict-event-emitter-types';

const broadcast: StrictBroadcast<ServerSocket> = function(
  event: string,
  payload?: any
) {
  // ...
};
```

Note that the loose types for event and payload only apply inside the broadcast function (consumers will see a much stricter signature). Declaring more precise parameter types or narrowing using type guards would allow strongly-typed dispatching to emitters.


````

### stripe@8.222.0

From https://github.com/stripe/stripe-node.

**MIT**:

Copyright: Copyright (C) 2013 Stripe, Inc. (https://stripe.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tarn@3.0.2

From https://github.com/vincit/tarn.js.

**MIT**:

Copyright: Copyright (c) 2015 Vincit Oy

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### tildify@2.0.0

From https://github.com/sindresorhus/tildify.

**MIT**:

Copyright: Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### touch@3.1.0

From https://github.com/isaacs/node-touch.

**ISC**:

```
The ISC License

Copyright (c) Isaac Z. Schlueter

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

```

### tsscmp@1.0.6

From https://github.com/suryagh/tsscmp.

**MIT**:

```
The MIT License (MIT)

Copyright (c) 2016

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### type-is@1.6.18

From https://github.com/jshttp/type-is.

**MIT**:

Copyright: Copyright (c) 2014-2015 Douglas Christopher Wilson <doug@somethingdoug.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### undefsafe@2.0.5

From https://github.com/remy/undefsafe.

**MIT**:

Copyright: Copyright © 2016 Remy Sharp, http://remysharp.com <remy@remysharp.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### xml-crypto@6.1.2

From https://github.com/node-saml/xml-crypto.

**MIT**:

```
(The MIT License)

Copyright (c) Yaron Naveh <yaronn01@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### xml-escape@1.1.0

From https://github.com/miketheprogrammer/xml-escape.

**MIT***:

Copyright: Copyright (c) 2014 Michael Hernandez

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### xml@1.0.1

From https://github.com/dylang/node-xml.

**MIT**:

Copyright: Copyright (c) 2011-2016 Dylan Greene <dylang@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### xmllint-wasm@4.0.2

From https://github.com/noppa/xmllint-wasm.

**MIT**:

```
This project is MIT licensed, just like libxml which it is a port of.

 Copyright (C) 1998-2018 libxml and libxml.js authors.  All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is fur-
nished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FIT-
NESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


```

### xpath@0.0.32, xpath@0.0.33

From https://github.com/goto100/xpath.

**MIT**:

```
MIT License 

Copyright (c) 2018 Cameron McCormack 

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

```

### ylru@1.2.1

From https://github.com/node-modules/ylru.

**MIT**:

Copyright: Copyright (c) 2016 'Dominic Tarr'

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### zxcvbn@4.4.2

From https://github.com/dropbox/zxcvbn.

**MIT**:

Copyright: Copyright (c) 2012-2016 Dan Wheeler and Dropbox, Inc.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.



## Development dependencies



Dependencies in this section are listed as "Development" dependencies in one of the `package.json` files of a Joplin package, or a dependency of a Joplin package.

### @ampproject/remapping@2.2.1

From https://github.com/ampproject/remapping.

**Apache-2.0**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### @asamuzakjp/css-color@3.2.0

From https://github.com/asamuzaK/cssColor.

**MIT**:

```
MIT License

Copyright (c) 2024 asamuzaK (Kazz)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### @babel/code-frame@7.22.13, @babel/code-frame@7.22.5, @babel/code-frame@7.24.7, @babel/code-frame@7.26.2, @babel/compat-data@7.22.5, @babel/compat-data@7.23.2, @babel/compat-data@7.24.7, @babel/core@7.12.9, @babel/core@7.22.5, @babel/core@7.23.2, @babel/core@7.26.10, @babel/generator@7.22.5, @babel/generator@7.23.0, @babel/generator@7.24.7, @babel/helper-annotate-as-pure@7.22.5, @babel/helper-annotate-as-pure@7.25.9, @babel/helper-builder-binary-assignment-operator-visitor@7.22.5, @babel/helper-builder-binary-assignment-operator-visitor@7.24.7, @babel/helper-compilation-targets@7.22.15, @babel/helper-compilation-targets@7.22.5, @babel/helper-compilation-targets@7.24.7, @babel/helper-create-class-features-plugin@7.22.15, @babel/helper-create-class-features-plugin@7.24.7, @babel/helper-create-class-features-plugin@7.27.0, @babel/helper-create-regexp-features-plugin@7.22.5, @babel/helper-create-regexp-features-plugin@7.24.7, @babel/helper-create-regexp-features-plugin@7.27.0, @babel/helper-environment-visitor@7.22.20, @babel/helper-environment-visitor@7.22.5, @babel/helper-function-name@7.22.5, @babel/helper-function-name@7.23.0, @babel/helper-hoist-variables@7.22.5, @babel/helper-member-expression-to-functions@7.22.5, @babel/helper-member-expression-to-functions@7.23.0, @babel/helper-member-expression-to-functions@7.25.9, @babel/helper-module-imports@7.22.15, @babel/helper-module-imports@7.22.5, @babel/helper-module-imports@7.24.7, @babel/helper-module-transforms@7.22.5, @babel/helper-module-transforms@7.23.0, @babel/helper-module-transforms@7.24.7, @babel/helper-module-transforms@7.26.0, @babel/helper-optimise-call-expression@7.22.5, @babel/helper-optimise-call-expression@7.25.9, @babel/helper-plugin-utils@7.10.4, @babel/helper-plugin-utils@7.22.5, @babel/helper-plugin-utils@7.24.7, @babel/helper-plugin-utils@7.24.8, @babel/helper-plugin-utils@7.26.5, @babel/helper-remap-async-to-generator@7.22.20, @babel/helper-remap-async-to-generator@7.22.5, @babel/helper-remap-async-to-generator@7.24.7, @babel/helper-remap-async-to-generator@7.25.9, @babel/helper-replace-supers@7.22.20, @babel/helper-replace-supers@7.22.5, @babel/helper-replace-supers@7.24.7, @babel/helper-replace-supers@7.26.5, @babel/helper-simple-access@7.22.5, @babel/helper-skip-transparent-expression-wrappers@7.22.5, @babel/helper-skip-transparent-expression-wrappers@7.25.9, @babel/helper-split-export-declaration@7.22.5, @babel/helper-split-export-declaration@7.22.6, @babel/helper-string-parser@7.22.5, @babel/helper-string-parser@7.24.7, @babel/helper-string-parser@7.24.8, @babel/helper-validator-identifier@7.22.20, @babel/helper-validator-identifier@7.22.5, @babel/helper-validator-identifier@7.24.7, @babel/helper-validator-option@7.22.15, @babel/helper-validator-option@7.22.5, @babel/helper-validator-option@7.25.9, @babel/helper-wrap-function@7.22.20, @babel/helper-wrap-function@7.22.5, @babel/helper-wrap-function@7.24.7, @babel/helpers@7.22.5, @babel/helpers@7.23.2, @babel/highlight@7.22.20, @babel/highlight@7.22.5, @babel/highlight@7.24.7, @babel/parser@7.22.5, @babel/parser@7.23.0, @babel/parser@7.24.7, @babel/parser@7.25.6, @babel/parser@7.27.0, @babel/plugin-bugfix-firefox-class-in-computed-class-key@7.25.9, @babel/plugin-bugfix-safari-class-field-initializer-scope@7.25.9, @babel/plugin-bugfix-safari-id-destructuring-collision-in-function-expression@7.22.15, @babel/plugin-bugfix-safari-id-destructuring-collision-in-function-expression@7.25.9, @babel/plugin-bugfix-v8-spread-parameters-in-optional-chaining@7.22.15, @babel/plugin-bugfix-v8-spread-parameters-in-optional-chaining@7.24.7, @babel/plugin-bugfix-v8-static-class-fields-redefine-readonly@7.25.9, @babel/plugin-proposal-export-default-from@7.25.9, @babel/plugin-proposal-object-rest-spread@7.12.1, @babel/plugin-syntax-class-properties@7.12.13, @babel/plugin-syntax-class-static-block@7.14.5, @babel/plugin-syntax-export-default-from@7.25.9, @babel/plugin-syntax-flow@7.26.0, @babel/plugin-syntax-import-assertions@7.22.5, @babel/plugin-syntax-import-assertions@7.24.7, @babel/plugin-syntax-import-attributes@7.22.5, @babel/plugin-syntax-import-attributes@7.24.7, @babel/plugin-syntax-import-meta@7.10.4, @babel/plugin-syntax-jsx@7.12.1, @babel/plugin-syntax-jsx@7.18.6, @babel/plugin-syntax-jsx@7.22.5, @babel/plugin-syntax-jsx@7.25.9, @babel/plugin-syntax-logical-assignment-operators@7.10.4, @babel/plugin-syntax-numeric-separator@7.10.4, @babel/plugin-syntax-private-property-in-object@7.14.5, @babel/plugin-syntax-top-level-await@7.14.5, @babel/plugin-syntax-typescript@7.20.0, @babel/plugin-syntax-typescript@7.22.5, @babel/plugin-syntax-typescript@7.25.9, @babel/plugin-syntax-unicode-sets-regex@7.18.6, @babel/plugin-transform-arrow-functions@7.22.5, @babel/plugin-transform-arrow-functions@7.24.7, @babel/plugin-transform-async-generator-functions@7.23.2, @babel/plugin-transform-async-generator-functions@7.26.8, @babel/plugin-transform-async-to-generator@7.22.5, @babel/plugin-transform-async-to-generator@7.24.7, @babel/plugin-transform-block-scoped-functions@7.22.5, @babel/plugin-transform-block-scoped-functions@7.24.7, @babel/plugin-transform-block-scoping@7.23.0, @babel/plugin-transform-block-scoping@7.27.0, @babel/plugin-transform-class-properties@7.22.5, @babel/plugin-transform-class-properties@7.24.7, @babel/plugin-transform-class-properties@7.25.9, @babel/plugin-transform-class-static-block@7.22.11, @babel/plugin-transform-class-static-block@7.24.7, @babel/plugin-transform-classes@7.22.15, @babel/plugin-transform-classes@7.25.9, @babel/plugin-transform-computed-properties@7.22.5, @babel/plugin-transform-computed-properties@7.24.7, @babel/plugin-transform-destructuring@7.23.0, @babel/plugin-transform-destructuring@7.25.9, @babel/plugin-transform-dotall-regex@7.22.5, @babel/plugin-transform-dotall-regex@7.24.7, @babel/plugin-transform-duplicate-keys@7.22.5, @babel/plugin-transform-duplicate-keys@7.24.7, @babel/plugin-transform-duplicate-named-capturing-groups-regex@7.25.9, @babel/plugin-transform-dynamic-import@7.22.11, @babel/plugin-transform-dynamic-import@7.24.7, @babel/plugin-transform-exponentiation-operator@7.22.5, @babel/plugin-transform-exponentiation-operator@7.24.7, @babel/plugin-transform-export-namespace-from@7.22.11, @babel/plugin-transform-export-namespace-from@7.24.7, @babel/plugin-transform-flow-strip-types@7.26.5, @babel/plugin-transform-for-of@7.22.15, @babel/plugin-transform-for-of@7.24.7, @babel/plugin-transform-function-name@7.22.5, @babel/plugin-transform-function-name@7.25.9, @babel/plugin-transform-json-strings@7.22.11, @babel/plugin-transform-json-strings@7.24.7, @babel/plugin-transform-literals@7.22.5, @babel/plugin-transform-literals@7.25.9, @babel/plugin-transform-logical-assignment-operators@7.22.11, @babel/plugin-transform-logical-assignment-operators@7.24.7, @babel/plugin-transform-member-expression-literals@7.22.5, @babel/plugin-transform-member-expression-literals@7.24.7, @babel/plugin-transform-modules-amd@7.23.0, @babel/plugin-transform-modules-amd@7.24.7, @babel/plugin-transform-modules-commonjs@7.23.0, @babel/plugin-transform-modules-commonjs@7.26.3, @babel/plugin-transform-modules-systemjs@7.23.0, @babel/plugin-transform-modules-systemjs@7.25.9, @babel/plugin-transform-modules-umd@7.22.5, @babel/plugin-transform-modules-umd@7.24.7, @babel/plugin-transform-named-capturing-groups-regex@7.22.5, @babel/plugin-transform-named-capturing-groups-regex@7.24.7, @babel/plugin-transform-new-target@7.22.5, @babel/plugin-transform-new-target@7.24.7, @babel/plugin-transform-nullish-coalescing-operator@7.22.11, @babel/plugin-transform-nullish-coalescing-operator@7.24.7, @babel/plugin-transform-numeric-separator@7.22.11, @babel/plugin-transform-numeric-separator@7.24.7, @babel/plugin-transform-object-rest-spread@7.22.15, @babel/plugin-transform-object-rest-spread@7.24.7, @babel/plugin-transform-object-super@7.22.5, @babel/plugin-transform-object-super@7.24.7, @babel/plugin-transform-optional-catch-binding@7.22.11, @babel/plugin-transform-optional-catch-binding@7.24.7, @babel/plugin-transform-optional-chaining@7.23.0, @babel/plugin-transform-optional-chaining@7.24.7, @babel/plugin-transform-optional-chaining@7.25.9, @babel/plugin-transform-parameters@7.22.15, @babel/plugin-transform-parameters@7.24.7, @babel/plugin-transform-private-methods@7.22.5, @babel/plugin-transform-private-methods@7.24.7, @babel/plugin-transform-private-property-in-object@7.22.11, @babel/plugin-transform-private-property-in-object@7.24.7, @babel/plugin-transform-property-literals@7.22.5, @babel/plugin-transform-property-literals@7.24.7, @babel/plugin-transform-react-constant-elements@7.22.5, @babel/plugin-transform-react-display-name@7.22.5, @babel/plugin-transform-react-display-name@7.24.7, @babel/plugin-transform-react-jsx-development@7.22.5, @babel/plugin-transform-react-jsx-self@7.25.9, @babel/plugin-transform-react-jsx-source@7.25.9, @babel/plugin-transform-react-jsx@7.22.15, @babel/plugin-transform-react-jsx@7.25.9, @babel/plugin-transform-react-pure-annotations@7.22.5, @babel/plugin-transform-regenerator@7.22.10, @babel/plugin-transform-regenerator@7.24.7, @babel/plugin-transform-reserved-words@7.22.5, @babel/plugin-transform-reserved-words@7.24.7, @babel/plugin-transform-runtime@7.23.2, @babel/plugin-transform-runtime@7.26.10, @babel/plugin-transform-shorthand-properties@7.22.5, @babel/plugin-transform-shorthand-properties@7.24.7, @babel/plugin-transform-spread@7.22.5, @babel/plugin-transform-spread@7.24.7, @babel/plugin-transform-sticky-regex@7.22.5, @babel/plugin-transform-sticky-regex@7.24.7, @babel/plugin-transform-template-literals@7.22.5, @babel/plugin-transform-template-literals@7.24.7, @babel/plugin-transform-typeof-symbol@7.22.5, @babel/plugin-transform-typeof-symbol@7.27.0, @babel/plugin-transform-typescript@7.22.15, @babel/plugin-transform-typescript@7.27.0, @babel/plugin-transform-unicode-escapes@7.22.10, @babel/plugin-transform-unicode-escapes@7.24.7, @babel/plugin-transform-unicode-property-regex@7.22.5, @babel/plugin-transform-unicode-property-regex@7.24.7, @babel/plugin-transform-unicode-regex@7.22.5, @babel/plugin-transform-unicode-regex@7.24.7, @babel/plugin-transform-unicode-sets-regex@7.22.5, @babel/plugin-transform-unicode-sets-regex@7.24.7, @babel/preset-env@7.23.2, @babel/preset-env@7.25.3, @babel/preset-react@7.22.15, @babel/preset-typescript@7.23.2, @babel/runtime-corejs3@7.23.2, @babel/runtime@7.22.5, @babel/runtime@7.23.2, @babel/runtime@7.25.0, @babel/template@7.22.15, @babel/template@7.22.5, @babel/template@7.24.7, @babel/template@7.25.0, @babel/traverse@7.22.5, @babel/traverse@7.23.2, @babel/traverse@7.24.7, @babel/types@7.22.5, @babel/types@7.23.0, @babel/types@7.24.7, @babel/types@7.25.6, @babel/types@7.27.0, @babel/plugin-proposal-object-rest-spread@7.20.7, @babel/plugin-transform-destructuring@7.22.5, @babel/plugin-transform-parameters@7.22.5, @babel/plugin-transform-react-jsx@7.19.0

From https://github.com/babel/babel.

**MIT**:

Copyright: Copyright (c) 2014-present Sebastian McKenzie and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/helper-define-polyfill-provider@0.4.3, @babel/helper-define-polyfill-provider@0.6.2, @babel/helper-define-polyfill-provider@0.6.4, babel-plugin-polyfill-corejs2@0.4.11, babel-plugin-polyfill-corejs2@0.4.6, babel-plugin-polyfill-corejs3@0.10.4, babel-plugin-polyfill-corejs3@0.11.1, babel-plugin-polyfill-corejs3@0.8.6, babel-plugin-polyfill-regenerator@0.5.3, babel-plugin-polyfill-regenerator@0.6.2

From https://github.com/babel/babel-polyfills.

**MIT**:

Copyright: Copyright (c) 2014-present Nicolò Ribaudo and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/plugin-proposal-private-property-in-object@7.21.0-placeholder-for-preset-env.2

From https://github.com/babel/babel-plugin-proposal-private-property-in-object.

**MIT**:

Copyright: Copyright (c) 2014-present Sebastian McKenzie and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/plugin-syntax-async-generators@7.8.4, @babel/plugin-syntax-bigint@7.8.3, @babel/plugin-syntax-dynamic-import@7.8.3, @babel/plugin-syntax-export-namespace-from@7.8.3, @babel/plugin-syntax-json-strings@7.8.3, @babel/plugin-syntax-nullish-coalescing-operator@7.8.3, @babel/plugin-syntax-object-rest-spread@7.8.3, @babel/plugin-syntax-optional-catch-binding@7.8.3, @babel/plugin-syntax-optional-chaining@7.8.3, babel-plugin-syntax-jsx@6.18.0

From https://github.com/babel/babel.git#master.

**MIT**:

Copyright: Copyright (c) 2014-present Sebastian McKenzie and other contributors

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/preset-modules@0.1.6-no-external-plugins

From https://github.com/babel/preset-modules.

**MIT**:

Copyright: Copyright (c) 2020 Babel

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @babel/regjsgen@0.8.0, regjsgen@0.8.0

From https://github.com/bnjmnt4n/regjsgen.

**MIT**:

Copyright: Copyright 2014-2020 Benjamin Tan <https://ofcr.se/>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @bcoe/v8-coverage@0.2.3

From https://github.com/demurgos/v8-coverage.

**MIT**:

Copyright: Copyright © 2015-2017 Charles Samborski

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @colors/colors@1.5.0

From https://github.com/DABH/colors.js.

**MIT**:

```
MIT License

Original Library
  - Copyright (c) Marak Squires

Additional Functionality
 - Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)
 - Copyright (c) DABH (https://github.com/DABH)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

```

### @cspotcode/source-map-support@0.8.1

From https://github.com/cspotcode/node-source-map-support.

**MIT**:

Copyright: Copyright (c) 2014 Evan Wallace

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @csstools/color-helpers@5.0.2

From https://github.com/csstools/postcss-plugins.

**MIT-0**:

```
MIT No Attribution (MIT-0)

Copyright © CSSTools Contributors

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the “Software”), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

```

### @csstools/css-calc@2.1.4, @csstools/css-color-parser@3.0.10, @csstools/css-parser-algorithms@3.0.5, @csstools/css-tokenizer@3.0.4

From https://github.com/csstools/postcss-plugins.

**MIT**:

Copyright: Copyright 2022 Romain Menke, Antonio Laguna <antonio@laguna.es>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @discoveryjs/json-ext@0.5.6, @discoveryjs/json-ext@0.5.7

From https://github.com/discoveryjs/json-ext.

**MIT**:

Copyright: Copyright (c) 2020 Roman Dvornov <rdvornov@gmail.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @docusaurus/core@2.4.3, @docusaurus/cssnano-preset@2.4.3, @docusaurus/logger@2.4.3, @docusaurus/mdx-loader@2.4.3, @docusaurus/plugin-sitemap@2.4.3, @docusaurus/types@2.4.3, @docusaurus/utils-common@2.4.3, @docusaurus/utils-validation@2.4.3, @docusaurus/utils@2.4.3

From https://github.com/facebook/docusaurus.

**MIT**:

Copyright: Copyright (c) Facebook, Inc. and its affiliates.

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @docusaurus/react-loadable@5.5.2

From https://github.com/thejameskyle/react-loadable.

**MIT**:

Copyright: Copyright (c) 2018-present Jamie Kyle <me@thejameskyle.com>

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @esbuild/darwin-x64@0.25.8, esbuild@0.25.8

From https://github.com/evanw/esbuild.

**MIT**:

Copyright: Copyright (c) 2020 Evan Wallace

See [Appendix B](#appendix-b-the-mit-license) for the full MIT license.

### @gar/promisify@1.1.2, @gar/promisify@1.1.3

From https://github.com/wraithgar/gar-promisify.

**MIT**:

```
The MIT License (MIT)

Copyright © 2020-2022 Michael Garvin

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


```

### @hapi/hoek@9.2.1

From https://github.com/hapijs/hoek.

**BSD-3-Clause**:

```
Copyright (c) 2011-2020, Sideway Inc, and project contributors  
Copyright (c) 2011-2014, Walmart  
Copyright (c) 2011, Yahoo Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS OFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @hapi/topo@5.1.0

From https://github.com/hapijs/topo.

**BSD-3-Clause**:

```
Copyright (c) 2012-2020, Sideway Inc, and project contributors  
Copyright (c) 2012-2014, Walmart.  
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* The names of any contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS OFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

```

### @img/sharp-darwin-x64@0.34.3, sharp@0.34.3

From https://github.com/lovell/sharp.

**Apache-2.0**:

```
Apache License
Version 2.0, January 2004
http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction, and
distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by the copyright
owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all other entities
that control, are controlled by, or are under common control with that entity.
For the purposes of this definition, "control" means (i) the power, direct or
indirect, to cause the direction or management of such entity, whether by
contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity exercising
permissions granted by this License.

"Source" form shall mean the preferred form for making modifications, including
but not limited to software source code, documentation source, and configuration
files.

"Object" form shall mean any form resulting from mechanical transformation or
translation of a Source form, including but not limited to compiled object code,
generated documentation, and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or Object form, made
available under the License, as indicated by a copyright notice that is included
in or attached to the work (an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object form, that
is based on (or derived from) the Work and for which the editorial revisions,
annotations, elaborations, or other modifications represent, as a whole, an
original work of authorship. For the purposes of this License, Derivative Works
shall not include works that remain separable from, or merely link (or bind by
name) to the interfaces of, the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including the original version
of the Work and any modifications or additions to that Work or Derivative Works
thereof, that is intentionally submitted to Licensor for inclusion in the Work
by the copyright owner or by an individual or Legal Entity authorized to submit
on behalf of the copyright owner. For the purposes of this definition,
"submitted" means any form of electronic, verbal, or written communication sent
to the Licensor or its representatives, including but not limited to
communication on electronic mailing lists, source code control systems, and
issue tracking systems that are managed by, or on behalf of, the Licensor for
the purpose of discussing and improving the Work, but excluding communication
that is conspicuously marked or otherwise designated in writing by the copyright
owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
of whom a Contribution has been received by Licensor and subsequently
incorporated within the Work.

2. Grant of Copyright License.

Subject to the terms and conditions of this License, each Contributor hereby
grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
irrevocable copyright license to reproduce, prepare Derivative Works of,
publicly display, publicly perform, sublicense, and distribute the Work and such
Derivative Works in Source or Object form.

3. Grant of Patent License.

Subject to the terms and conditions of this License, each Contributor hereby
grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
irrevocable (except as stated in this section) patent license to make, have
made, use, offer to sell, sell, import, and otherwise transfer the Work, where
such license applies only to those patent claims licensable by such Contributor
that are necessarily infringed by their Contribution(s) alone or by combination
of their Contribution(s) with the Work to which such Contribution(s) was
submitted. If You institute patent litigation against any entity (including a
cross-claim or counterclaim in a lawsuit) alleging that the Work or a
Contribution incorporated within the Work constitutes direct or contributory
patent infringement, then any patent licenses granted to You under this License
for that Work shall terminate as of the date such litigation is filed.

4. Redistribution.

You may reproduce and distribute copies of the Work or Derivative Works thereof
in any medium, with or without modifications, and in Source or Object form,
provided that You meet the following conditions:

You must give any other recipients of the Work or Derivative Works a copy of
this License; and
You must cause any modified files to carry prominent notices stating that You
changed the files; and
You must retain, in the Source form of any Derivative Works that You distribute,
all copyright, patent, trademark, and attribution notices from the Source form
of the Work, excluding those notices that do not pertain to any part of the
Derivative Works; and
If the Work includes a "NOTICE" text file as part of its distribution, then any
Derivative Works that You distribute must include a readable copy of the
attribution notices contained within such NOTICE file, excluding those notices
that do not pertain to any part of the Derivative Works, in at least one of the
following places: within a NOTICE text file distributed as part of the
Derivative Works; within the Source form or documentation, if provided along
with the Derivative Works; or, within a display generated by the Derivative
Works, if and wherever such third-party notices normally appear. The contents of
the NOTICE file are for informational purposes only and do not modify the
License. You may add Your own attribution notices within Derivative Works that
You distribute, alongside or as an addendum to the NOTICE text from the Work,
provided that such additional attribution notices cannot be construed as
modifying the License.
You may add Your own copyright statement to Your modifications and may provide
additional or different license terms and conditions for use, reproduction, or
distribution of Your modifications, or for any such Derivative Works as a whole,
provided Your use, reproduction, and distribution of the Work otherwise complies
with the conditions stated in this License.

5. Submission of Contributions.

Unless You explicitly state otherwise, any Contribution intentionally submitted
for inclusion in the Work by You to the Licensor shall be under the terms and
conditions of this License, without any additional terms or conditions.
Notwithstanding the above, nothing herein shall supersede or modify the terms of
any separate license agreement you may have executed with Licensor regarding
such Contributions.

6. Trademarks.

This License does not grant permission to use the trade names, trademarks,
service marks, or product names of the Licensor, except as required for
reasonable and customary use in describing the origin of the Work and
reproducing the content of the NOTICE file.

7. Disclaimer of Warranty.

Unless required by applicable law or agreed to in writing, Licensor provides the
Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
including, without limitation, any warranties or conditions of TITLE,
NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
solely responsible for determining the appropriateness of using or
redistributing the Work and assume any risks associated with Your exercise of
permissions under this License.

8. Limitation of Liability.

In no event and under no legal theory, whether in tort (including negligence),
contract, or otherwise, unless required by applicable law (such as deliberate
and grossly negligent acts) or agreed to in writing, shall any Contributor be
liable to You for damages, including any direct, indirect, special, incidental,
or consequential damages of any character arising as a result of this License or
out of the use or inability to use the Work (including but not limited to
damages for loss of goodwill, work stoppage, computer failure or malfunction, or
any and all other commercial damages or losses), even if such Contributor has
been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability.

While redistributing the Work or Derivative Works thereof, You may choose to
offer, and charge a fee for, acceptance of support, warranty, indemnity, or
other liability obligations and/or rights consistent with this License. However,
in accepting such obligations, You may act only on Your own behalf and on Your
sole responsibility, not on behalf of any other Contributor, and only if You
agree to indemnify, defend, and hold each Contributor harmless for any liability
incurred by, or claims asserted against, such Contributor by reason of your
accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS

APPENDIX: How to apply the Apache License to your work

To apply the Apache License to your work, attach the following boilerplate
notice, with the fields enclosed by brackets "[]" replaced with your own
identifying information. (Don't include the brackets!) The text should be
enclosed in the appropriate comment syntax for the file format. We also
recommend that a file or class name and description of purpose be included on
the same "printed page" as the copyright notice for easier identification within
third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### @img/sharp-libvips-darwin-x64@1.2.0

From https://github.com/lovell/sharp-libvips.

**LGPL-3.0-or-later**:

See [Appendix A](#appendix-a-the-apache-2-license) for the Apache 2 license.

This package's copy of the Apache 2 license includes the following appendix:

```


   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "{}"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright {yyyy} {name of copyright owner}

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

```

### @isaacs/balanced-match@4.0.1

From https://github.com/isaacs/balanced-match.

**MIT**:

```
(MIT)

Original code Copyright Julian Gruber <julian@juliangruber.com>

Port to TypeScript Copyright Isaac Z. Schlueter <i@izs.me>

Permission is hereby granted, free of charge, to any person obtaining