/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.dnssec;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.ExtendedErrorCodeOption;
import org.xbill.DNS.Header;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.dnssec.DefaultTrustAnchorStore;
import org.xbill.DNS.dnssec.FindKeyState;
import org.xbill.DNS.dnssec.JustifiedSecStatus;
import org.xbill.DNS.dnssec.KeyCache;
import org.xbill.DNS.dnssec.KeyEntry;
import org.xbill.DNS.dnssec.NSEC3ValUtils;
import org.xbill.DNS.dnssec.Nsec3ValidationState;
import org.xbill.DNS.dnssec.R;
import org.xbill.DNS.dnssec.ResponseClassification;
import org.xbill.DNS.dnssec.SMessage;
import org.xbill.DNS.dnssec.SRRset;
import org.xbill.DNS.dnssec.SecurityStatus;
import org.xbill.DNS.dnssec.TrustAnchorStore;
import org.xbill.DNS.dnssec.ValUtils;

public final class ValidatingResolver
implements Resolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatingResolver.class);
    public static final String TRUST_ANCHOR_FILE_PROPERTY = "dnsjava.dnssec.trust_anchor_file";
    public static final int VALIDATION_REASON_QCLASS = 65280;
    private static final long DEFAULT_TA_BAD_KEY_TTL = 60L;
    private final KeyCache keyCache;
    private final TrustAnchorStore trustAnchors;
    private final ValUtils valUtils;
    private final NSEC3ValUtils n3valUtils;
    private final Resolver headResolver;
    private final Clock clock;
    private boolean isAddReasonToAdditional = true;

    public ValidatingResolver(Resolver headResolver) {
        this(headResolver, Clock.systemUTC());
    }

    public ValidatingResolver(Resolver headResolver, Clock clock) {
        this.headResolver = headResolver;
        this.clock = clock;
        headResolver.setEDNS(0, 0, 32768, new EDNSOption[0]);
        headResolver.setIgnoreTruncation(false);
        this.keyCache = new KeyCache();
        this.valUtils = new ValUtils();
        this.n3valUtils = new NSEC3ValUtils();
        this.trustAnchors = new DefaultTrustAnchorStore();
        try {
            this.init(System.getProperties());
        }
        catch (IOException e) {
            log.error("Could not initialize from system properties", e);
        }
    }

    public void init(Properties config) throws IOException {
        this.keyCache.init(config);
        this.n3valUtils.init(config);
        this.valUtils.init(config);
        String s = config.getProperty(TRUST_ANCHOR_FILE_PROPERTY);
        if (s != null) {
            log.debug("Reading trust anchor file: {}", (Object)s);
            this.loadTrustAnchors(new FileInputStream(s));
        }
    }

    public void loadTrustAnchors(InputStream data) throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        try (Master master = new Master(data, Name.root, 0L);){
            Record mr;
            while ((mr = master.nextRecord()) != null) {
                records.add(mr);
            }
        }
        Collections.sort(records);
        SRRset currentRrset = new SRRset();
        for (Record r : records) {
            if (r.getType() != 48 && r.getType() != 43) continue;
            if (currentRrset.size() == 0) {
                currentRrset.addRR(r);
                continue;
            }
            if (currentRrset.getName().equals(r.getName()) && currentRrset.getType() == r.getType() && currentRrset.getDClass() == r.getDClass()) {
                currentRrset.addRR(r);
                continue;
            }
            this.trustAnchors.store(currentRrset);
            currentRrset = new SRRset();
            currentRrset.addRR(r);
        }
        if (currentRrset.size() > 0) {
            this.trustAnchors.store(currentRrset);
        }
    }

    public TrustAnchorStore getTrustAnchors() {
        return this.trustAnchors;
    }

    private void removeSpuriousAuthority(SMessage response) {
        if (response.getSectionRRsets(1).isEmpty() && response.getSectionRRsets(2).size() == 1) {
            return;
        }
        Iterator<SRRset> authRrsetIterator = response.getSectionRRsets(2).iterator();
        while (authRrsetIterator.hasNext()) {
            SRRset rrset = authRrsetIterator.next();
            if (rrset.getType() != 2 || !rrset.sigs().isEmpty()) continue;
            log.trace("Removing spurious unsigned NS record (likely inserted by forwarder) {}/{}/{}", rrset.getName(), Type.string(rrset.getType()), DClass.string(rrset.getDClass()));
            authRrsetIterator.remove();
        }
    }

    private CompletionStage<Void> validatePositiveResponse(Message request, SMessage response, Nsec3ValidationState nsec3State, Executor executor) {
        HashMap<Name, Name> wcs = new HashMap<Name, Name>(1);
        ArrayList nsec3s = new ArrayList(0);
        ArrayList nsecs = new ArrayList(0);
        return this.validateAnswerAndGetWildcards(response, request.getQuestion().getType(), wcs, executor).thenCompose(success -> {
            if (Boolean.TRUE.equals(success)) {
                int[] sections = request.getQuestion().getType() == 255 ? new int[]{1, 2} : new int[]{2};
                return this.validatePositiveResponseRecursive(response, wcs, nsec3s, nsecs, sections, new AtomicInteger(0), new AtomicInteger(0), executor);
            }
            return CompletableFuture.completedFuture(false);
        }).thenAccept(success -> {
            if (!Boolean.TRUE.equals(success)) {
                return;
            }
            if (!wcs.isEmpty()) {
                for (Map.Entry wc : wcs.entrySet()) {
                    boolean wcNsecOk = false;
                    for (SRRset set : nsecs) {
                        NSECRecord nsec;
                        if (!ValUtils.nsecProvesNameError(set, nsec = (NSECRecord)set.first(), (Name)wc.getKey())) continue;
                        try {
                            Name nsecWc = ValUtils.nsecWildcard((Name)wc.getKey(), set, nsec);
                            if (!((Name)wc.getValue()).equals(nsecWc)) continue;
                            wcNsecOk = true;
                            break;
                        }
                        catch (NameTooLongException e) {
                            throw new IllegalStateException(R.get("failed.positive.wildcardgeneration", new Object[0]));
                        }
                    }
                    if (!wcNsecOk && !nsec3s.isEmpty()) {
                        if (this.n3valUtils.allNSEC3sIgnorable(nsec3s, this.keyCache)) {
                            response.setStatus(SecurityStatus.INSECURE, -1, R.get("failed.nsec3_ignored", new Object[0]));
                            return;
                        }
                        SecurityStatus status = this.n3valUtils.proveWildcard(nsec3s, (Name)wc.getKey(), ((SRRset)nsec3s.get(0)).getSignerName(), (Name)wc.getValue(), nsec3State);
                        if (status == SecurityStatus.INSECURE) {
                            response.setStatus(status, -1);
                            return;
                        }
                        if (status == SecurityStatus.SECURE) {
                            wcNsecOk = true;
                        }
                    }
                    if (wcNsecOk) continue;
                    response.setBogus(R.get("failed.positive.wildcard_too_broad", new Object[0]));
                    return;
                }
            }
            response.setStatus(SecurityStatus.SECURE, -1);
        });
    }

    private CompletionStage<Boolean> validatePositiveResponseRecursive(SMessage response, Map<Name, Name> wcs, List<SRRset> nsec3s, List<SRRset> nsecs, int[] sections, AtomicInteger sectionIndex, AtomicInteger setIndex, Executor executor) {
        if (sectionIndex.get() >= sections.length) {
            return CompletableFuture.completedFuture(true);
        }
        List<SRRset> sectionRRsets = response.getSectionRRsets(sections[sectionIndex.get()]);
        if (setIndex.get() >= sectionRRsets.size()) {
            sectionIndex.getAndIncrement();
            setIndex.set(0);
            return this.validatePositiveResponseRecursive(response, wcs, nsec3s, nsecs, sections, sectionIndex, setIndex, executor);
        }
        SRRset set = sectionRRsets.get(setIndex.getAndIncrement());
        return this.prepareFindKey(set, executor).thenCompose(ke -> {
            JustifiedSecStatus kve = ke.validateKeyFor(set);
            if (kve != null) {
                kve.applyToResponse(response);
                return CompletableFuture.completedFuture(false);
            }
            JustifiedSecStatus res = this.valUtils.verifySRRset(set, (KeyEntry)ke, this.clock.instant());
            if (res.status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.authority.positive", set));
                return CompletableFuture.completedFuture(false);
            }
            if (!wcs.isEmpty()) {
                if (set.getType() == 47) {
                    nsecs.add(set);
                } else if (set.getType() == 50) {
                    nsec3s.add(set);
                }
            }
            return this.validatePositiveResponseRecursive(response, wcs, nsec3s, nsecs, sections, sectionIndex, setIndex, executor);
        });
    }

    private CompletionStage<Boolean> validateAnswerAndGetWildcards(SMessage response, int qtype, Map<Name, Name> wcs, Executor executor) {
        return this.validateAnswerAndGetWildcardsRecursive(response, qtype, wcs, new AtomicInteger(0), executor);
    }

    private CompletionStage<Boolean> validateAnswerAndGetWildcardsRecursive(SMessage response, int qtype, Map<Name, Name> wcs, AtomicInteger setIndex, Executor executor) {
        List<SRRset> sectionRRsets = response.getSectionRRsets(1);
        if (setIndex.get() >= sectionRRsets.size()) {
            return CompletableFuture.completedFuture(true);
        }
        SRRset set = sectionRRsets.get(setIndex.get());
        return this.prepareFindKey(set, executor).thenCompose(ke -> {
            Name wc;
            JustifiedSecStatus kve = ke.validateKeyFor(set);
            if (kve != null) {
                kve.applyToResponse(response);
                return CompletableFuture.completedFuture(false);
            }
            JustifiedSecStatus res = this.valUtils.verifySRRset(set, (KeyEntry)ke, this.clock.instant());
            if (res.status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.answer.positive", set));
                return CompletableFuture.completedFuture(false);
            }
            try {
                wc = ValUtils.rrsetWildcard(set);
            }
            catch (RuntimeException ex) {
                response.setBogus(R.get(ex.getMessage(), set.getName()));
                return CompletableFuture.completedFuture(false);
            }
            if (wc != null) {
                if (set.getType() == 39) {
                    response.setBogus(R.get("failed.dname.wildcard", set.getName()));
                    return CompletableFuture.completedFuture(false);
                }
                wcs.put(set.getName(), wc);
            }
            if (qtype != 39 && set.getType() == 39) {
                SRRset cnameSet;
                DNAMERecord dname = (DNAMERecord)set.first();
                if (setIndex.getAndIncrement() < sectionRRsets.size() && (cnameSet = (SRRset)sectionRRsets.get(setIndex.get())).getType() == 5 && dname != null) {
                    if (cnameSet.size() > 1) {
                        response.setBogus(R.get("failed.synthesize.multiple", new Object[0]));
                        return CompletableFuture.completedFuture(false);
                    }
                    CNAMERecord cname = (CNAMERecord)cnameSet.first();
                    try {
                        Name expected = Name.concatenate(cname.getName().relativize(dname.getName()), dname.getTarget());
                        if (!expected.equals(cname.getTarget())) {
                            response.setBogus(R.get("failed.synthesize.nomatch", cname.getTarget(), expected));
                            return CompletableFuture.completedFuture(false);
                        }
                    }
                    catch (NameTooLongException e) {
                        response.setBogus(R.get("failed.synthesize.toolong", new Object[0]));
                        return CompletableFuture.completedFuture(false);
                    }
                    cnameSet.setSecurityStatus(SecurityStatus.SECURE);
                }
            }
            setIndex.getAndIncrement();
            return this.validateAnswerAndGetWildcardsRecursive(response, qtype, wcs, setIndex, executor);
        });
    }

    private CompletionStage<Void> validateNodataResponse(Message request, SMessage response, Nsec3ValidationState nsec3State, Executor executor) {
        Name intermediateQname = request.getQuestion().getName();
        int qtype = request.getQuestion().getType();
        for (SRRset set : response.getSectionRRsets(1)) {
            if (set.getSecurityStatus() != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.answer.cname_nodata", set.getName()));
                return CompletableFuture.completedFuture(null);
            }
            if (set.getType() != 5) continue;
            intermediateQname = ((CNAMERecord)set.first()).getTarget();
        }
        Name qname = intermediateQname;
        return this.validateNodataResponseRecursive(response, new AtomicInteger(0), nsec3State, executor).handleAsync((result, ex) -> {
            if (ex != null) {
                return null;
            }
            boolean hasValidNSEC = false;
            Name ce = null;
            ValUtils.NsecProvesNodataResponse ndp = new ValUtils.NsecProvesNodataResponse();
            ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
            Name nsec3Signer = null;
            int edeReason = 12;
            for (SRRset set : response.getSectionRRsets(2)) {
                if (set.getType() == 47) {
                    NSECRecord nsec = (NSECRecord)set.first();
                    ndp = ValUtils.nsecProvesNodata(set, nsec, qname, qtype);
                    if (ndp.result) {
                        hasValidNSEC = true;
                    } else {
                        edeReason = 6;
                    }
                    if (ValUtils.nsecProvesNameError(set, nsec, qname)) {
                        ce = ValUtils.closestEncloser(qname, set.getName(), nsec.getNext());
                    }
                }
                if (set.getType() != 50) continue;
                nsec3s.add(set);
                nsec3Signer = set.getSignerName();
            }
            if (ndp.wc != null && (ce == null || !ce.equals(ndp.wc) && !qname.equals(ce))) {
                edeReason = 6;
                hasValidNSEC = false;
            }
            this.n3valUtils.stripUnknownAlgNSEC3s(nsec3s);
            if (!hasValidNSEC && !nsec3s.isEmpty()) {
                log.debug("Using NSEC3 records");
                if (this.n3valUtils.allNSEC3sIgnorable(nsec3s, this.keyCache)) {
                    response.setBogus(R.get("failed.nsec3_ignored", new Object[0]));
                    return null;
                }
                JustifiedSecStatus res = this.n3valUtils.proveNodata(nsec3s, qname, qtype, nsec3Signer, nsec3State);
                edeReason = res.edeReason;
                if (res.status == SecurityStatus.INSECURE) {
                    response.setStatus(SecurityStatus.INSECURE, -1);
                    return null;
                }
                boolean bl = hasValidNSEC = res.status == SecurityStatus.SECURE;
            }
            if (!hasValidNSEC) {
                response.setBogus(R.get("failed.nodata", new Object[0]), edeReason);
                log.trace("Failed NODATA for {}", (Object)qname);
                return null;
            }
            log.trace("Successfully validated NODATA response");
            response.setStatus(SecurityStatus.SECURE, -1);
            return null;
        });
    }

    private CompletionStage<Void> validateNodataResponseRecursive(SMessage response, AtomicInteger setIndex, Nsec3ValidationState nsec3State, Executor executor) {
        if (setIndex.get() >= response.getSectionRRsets(2).size()) {
            return CompletableFuture.completedFuture(null);
        }
        SRRset set = response.getSectionRRsets(2).get(setIndex.getAndIncrement());
        return this.prepareFindKey(set, executor).thenComposeAsync(ke -> {
            JustifiedSecStatus kve = ke.validateKeyFor(set);
            if (kve != null) {
                kve.applyToResponse(response);
                return this.failedFuture(new Exception(kve.reason));
            }
            JustifiedSecStatus res = this.valUtils.verifySRRset(set, (KeyEntry)ke, this.clock.instant());
            if (res.status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.authority.nodata", set));
                return this.failedFuture(new Exception("failed.authority.nodata"));
            }
            return this.validateNodataResponseRecursive(response, setIndex, nsec3State, executor);
        });
    }

    private <T> CompletionStage<T> failedFuture(Throwable e) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(e);
        return f;
    }

    private CompletionStage<Void> validateNameErrorResponse(Message request, SMessage response, Nsec3ValidationState nsec3State, Executor executor) {
        Name intermediateQname = request.getQuestion().getName();
        for (SRRset set : response.getSectionRRsets(1)) {
            if (set.getSecurityStatus() != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.nxdomain.cname_nxdomain", set));
                return CompletableFuture.completedFuture(null);
            }
            if (set.getType() != 5) continue;
            intermediateQname = ((CNAMERecord)set.first()).getTarget();
        }
        Name qname = intermediateQname;
        return this.validateNameErrorResponseRecursive(response, new AtomicInteger(0), executor).thenComposeAsync(v -> {
            boolean hasValidNSEC = false;
            boolean hasValidWCNSEC = false;
            ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
            Name nsec3Signer = null;
            int previousClosestEncloseLabels = 0;
            for (SRRset set : response.getSectionRRsets(2)) {
                if (set.getType() == 47) {
                    NSECRecord nsec = (NSECRecord)set.first();
                    if (ValUtils.nsecProvesNameError(set, nsec, qname)) {
                        hasValidNSEC = true;
                    }
                    Name next = nsec.getNext();
                    int closestEncloserLabels = ValUtils.closestEncloser(qname, set.getName(), next).labels();
                    if (closestEncloserLabels > previousClosestEncloseLabels || closestEncloserLabels == previousClosestEncloseLabels && !hasValidWCNSEC) {
                        hasValidWCNSEC = ValUtils.nsecProvesNoWC(set, nsec, qname);
                    }
                    previousClosestEncloseLabels = closestEncloserLabels;
                }
                if (set.getType() != 50) continue;
                nsec3s.add(set);
                nsec3Signer = set.getSignerName();
            }
            this.n3valUtils.stripUnknownAlgNSEC3s(nsec3s);
            if (!(hasValidNSEC && hasValidWCNSEC || nsec3s.isEmpty())) {
                log.debug("Validating nxdomain: using NSEC3 records");
                if (this.n3valUtils.allNSEC3sIgnorable(nsec3s, this.keyCache)) {
                    response.setStatus(SecurityStatus.INSECURE, -1, R.get("failed.nsec3_ignored", new Object[0]));
                    return CompletableFuture.completedFuture(null);
                }
                SecurityStatus status = this.n3valUtils.proveNameError(nsec3s, qname, nsec3Signer, nsec3State);
                if (status != SecurityStatus.SECURE) {
                    if (status == SecurityStatus.INSECURE) {
                        response.setStatus(status, -1, R.get("failed.nxdomain.nsec3_insecure", new Object[0]));
                    } else {
                        response.setStatus(status, 6, R.get("failed.nxdomain.nsec3_bogus", new Object[0]));
                    }
                    return CompletableFuture.completedFuture(null);
                }
                hasValidNSEC = true;
                hasValidWCNSEC = true;
            }
            if (!hasValidNSEC || !hasValidWCNSEC) {
                boolean hasValidNSEC2 = hasValidNSEC;
                return this.validateNodataResponse(request, response, nsec3State, executor).thenRun(() -> {
                    if (response.getStatus() == SecurityStatus.SECURE) {
                        response.getHeader().setRcode(0);
                    } else {
                        if (!hasValidNSEC2) {
                            response.setBogus(R.get("failed.nxdomain.exists", response.getQuestion().getName()));
                            return;
                        }
                        response.setBogus(R.get("failed.nxdomain.haswildcard", new Object[0]));
                    }
                });
            }
            log.trace("Successfully validated NAME ERROR response");
            response.setStatus(SecurityStatus.SECURE, -1);
            return CompletableFuture.completedFuture(null);
        }).exceptionally(ex -> null);
    }

    private CompletionStage<Void> validateNameErrorResponseRecursive(SMessage response, AtomicInteger setIndex, Executor executor) {
        if (setIndex.get() >= response.getSectionRRsets(2).size()) {
            return CompletableFuture.completedFuture(null);
        }
        SRRset set = response.getSectionRRsets(2).get(setIndex.getAndIncrement());
        return this.prepareFindKey(set, executor).thenCompose(ke -> {
            JustifiedSecStatus kve = ke.validateKeyFor(set);
            if (kve != null) {
                kve.applyToResponse(response);
                return this.failedFuture(new Exception(kve.reason));
            }
            JustifiedSecStatus res = this.valUtils.verifySRRset(set, (KeyEntry)ke, this.clock.instant());
            if (res.status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.nxdomain.authority", set));
                return this.failedFuture(new Exception("failed.nxdomain.authority"));
            }
            return this.validateNameErrorResponseRecursive(response, setIndex, executor);
        });
    }

    private CompletionStage<SMessage> sendRequest(Message request, Executor executor) {
        Record q = request.getQuestion();
        log.trace("Sending request: <{}/{}/{}>", q.getName(), Type.string(q.getType()), DClass.string(q.getDClass()));
        Message localRequest = request.clone();
        localRequest.getHeader().setFlag(11);
        return this.headResolver.sendAsync(localRequest, executor).thenApply(message -> new SMessage(message.normalize(localRequest)));
    }

    private CompletionStage<KeyEntry> prepareFindKey(SRRset rrset, Executor executor) {
        RRset trustAnchorRRset;
        FindKeyState state = new FindKeyState();
        state.signerName = rrset.getSignerName();
        state.qclass = rrset.getDClass();
        if (state.signerName == null) {
            state.signerName = rrset.getName();
        }
        if ((trustAnchorRRset = this.trustAnchors.find(state.signerName, rrset.getDClass())) == null) {
            KeyEntry ke = KeyEntry.newNullKeyEntry(state.signerName, rrset.getDClass(), 60L);
            return CompletableFuture.completedFuture(ke);
        }
        SRRset trustAnchorSRRset = new SRRset(trustAnchorRRset);
        trustAnchorSRRset.setSecurityStatus(SecurityStatus.SECURE);
        state.keyEntry = this.keyCache.find(state.signerName, rrset.getDClass());
        if (state.keyEntry == null || !state.keyEntry.getName().equals(state.signerName) && state.keyEntry.isGood()) {
            if (trustAnchorSRRset.getType() == 43) {
                state.dsRRset = trustAnchorSRRset;
                state.keyEntry = null;
                state.currentDSKeyName = new Name(trustAnchorRRset.getName(), 1);
                return this.processFindKey(state, executor).thenApply(v -> state.keyEntry);
            }
            state.keyEntry = KeyEntry.newKeyEntry(trustAnchorSRRset);
            state.keyEntry.setSecurityStatus(SecurityStatus.SECURE);
            this.keyCache.store(state.keyEntry);
        }
        return CompletableFuture.completedFuture(state.keyEntry);
    }

    private CompletionStage<Void> processFindKey(FindKeyState state, Executor executor) {
        int currentLabels;
        int targetLabels;
        int l;
        int qclass = state.qclass;
        Name targetKeyName = state.signerName;
        Name currentKeyName = Name.empty;
        if (state.keyEntry != null) {
            currentKeyName = state.keyEntry.getName();
        }
        if (state.currentDSKeyName != null) {
            currentKeyName = state.currentDSKeyName;
            state.currentDSKeyName = null;
        }
        if (currentKeyName.equals(targetKeyName)) {
            return CompletableFuture.completedFuture(null);
        }
        if (state.emptyDSName != null) {
            currentKeyName = state.emptyDSName;
        }
        if ((l = (targetLabels = targetKeyName.labels()) - (currentLabels = currentKeyName.labels()) - 1) < 0) {
            return CompletableFuture.completedFuture(null);
        }
        Name nextKeyName = new Name(targetKeyName, l);
        log.trace("Key search: targetKeyName = {}, currentKeyName = {}, nextKeyName = {}", targetKeyName, currentKeyName, nextKeyName);
        if (state.dsRRset == null || !state.dsRRset.getName().equals(nextKeyName)) {
            Message dsRequest = Message.newQuery(Record.newRecord(nextKeyName, 43, qclass));
            return this.sendRequest(dsRequest, executor).thenComposeAsync(dsResponse -> this.processDSResponse(dsRequest, (SMessage)dsResponse, state, executor));
        }
        Message dnskeyRequest = Message.newQuery(Record.newRecord(state.dsRRset.getName(), 48, qclass));
        return this.sendRequest(dnskeyRequest, executor).thenComposeAsync(dnskeyResponse -> this.processDNSKEYResponse(dnskeyRequest, (SMessage)dnskeyResponse, state, executor));
    }

    private KeyEntry dsResponseToKE(SMessage response, Message request, KeyEntry keyRrset) {
        Name qname = request.getQuestion().getName();
        int qclass = request.getQuestion().getDClass();
        ResponseClassification subtype = ValUtils.classifyResponse(request, response);
        KeyEntry bogusKE = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
        switch (subtype) {
            case POSITIVE: {
                SRRset dsRrset = response.findAnswerRRset(qname, 43, qclass);
                JustifiedSecStatus res = this.valUtils.verifySRRset(dsRrset, keyRrset, this.clock.instant());
                if (res.status != SecurityStatus.SECURE) {
                    bogusKE.setBadReason(res.edeReason, res.reason);
                    return bogusKE;
                }
                if (!this.valUtils.atLeastOneSupportedAlgorithm(dsRrset)) {
                    KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, dsRrset.getTTL());
                    nullKey.setBadReason(1, R.get("insecure.ds.noalgorithms", qname));
                    return nullKey;
                }
                log.trace("DS RRset was good");
                return KeyEntry.newKeyEntry(dsRrset);
            }
            case CNAME: {
                SRRset cnameRrset = response.findAnswerRRset(qname, 5, qclass);
                JustifiedSecStatus res = this.valUtils.verifySRRset(cnameRrset, keyRrset, this.clock.instant());
                if (res.status == SecurityStatus.SECURE) {
                    return null;
                }
                bogusKE.setBadReason(6, R.get("failed.ds.cname", new Object[0]));
                return bogusKE;
            }
            case NODATA: 
            case NAMEERROR: {
                return this.dsResponseToKeForNodata(response, request, keyRrset);
            }
        }
        bogusKE.setBadReason(6, R.get("failed.ds.notype", new Object[]{subtype}));
        return bogusKE;
    }

    private KeyEntry dsResponseToKeForNodata(SMessage response, Message request, KeyEntry keyRrset) {
        Name qname = request.getQuestion().getName();
        int qclass = request.getQuestion().getDClass();
        KeyEntry bogusKE = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
        if (!this.valUtils.hasSignedNsecs(response)) {
            bogusKE.setBadReason(10, R.get("failed.ds.nonsec", qname));
            return bogusKE;
        }
        JustifiedSecStatus status = this.valUtils.nsecProvesNodataDsReply(request, response, keyRrset, this.clock.instant());
        switch (status.status) {
            case SECURE: {
                KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, 60L);
                nullKey.setBadReason(-1, R.get("insecure.ds.nsec", new Object[0]));
                return nullKey;
            }
            case INSECURE: {
                return null;
            }
            case BOGUS: {
                bogusKE.setBadReason(status.edeReason, status.reason);
                return bogusKE;
            }
        }
        List<SRRset> nsec3Rrsets = response.getSectionRRsets(2, 50);
        ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
        Name nsec3Signer = null;
        long nsec3TTL = -1L;
        if (!nsec3Rrsets.isEmpty()) {
            for (SRRset nsec3set : nsec3Rrsets) {
                JustifiedSecStatus res = this.valUtils.verifySRRset(nsec3set, keyRrset, this.clock.instant());
                if (res.status != SecurityStatus.SECURE) {
                    log.debug("Skipping bad NSEC3");
                    continue;
                }
                nsec3Signer = nsec3set.getSignerName();
                if (nsec3TTL < 0L || nsec3set.getTTL() < nsec3TTL) {
                    nsec3TTL = nsec3set.getTTL();
                }
                nsec3s.add(nsec3set);
            }
            Nsec3ValidationState nsec3State = new Nsec3ValidationState();
            switch (this.n3valUtils.proveNoDS(nsec3s, qname, nsec3Signer, nsec3State)) {
                case SECURE: 
                case INSECURE: {
                    KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, nsec3TTL);
                    nullKey.setBadReason(-1, R.get("insecure.ds.nsec3", new Object[0]));
                    return nullKey;
                }
                case INDETERMINATE: {
                    log.debug("NSEC3s for the referral proved no delegation");
                    return null;
                }
                case BOGUS: {
                    bogusKE.setBadReason(6, R.get("failed.ds.nsec3", new Object[0]));
                    return bogusKE;
                }
            }
            bogusKE.setBadReason(6, R.get("unknown.ds.nsec3", new Object[0]));
            return bogusKE;
        }
        bogusKE.setBadReason(6, R.get("failed.ds.unknown", new Object[0]));
        return bogusKE;
    }

    private CompletionStage<Void> processDSResponse(Message request, SMessage response, FindKeyState state, Executor executor) {
        Name qname = request.getQuestion().getName();
        state.emptyDSName = null;
        state.dsRRset = null;
        KeyEntry dsKE = this.dsResponseToKE(response, request, state.keyEntry);
        if (dsKE == null) {
            state.emptyDSName = qname;
        } else if (dsKE.isGood()) {
            state.dsRRset = dsKE;
            state.currentDSKeyName = new Name(dsKE.getName(), 1);
        } else {
            state.keyEntry = dsKE;
            if (dsKE.isNull()) {
                this.keyCache.store(dsKE);
            }
            return CompletableFuture.completedFuture(null);
        }
        return this.processFindKey(state, executor);
    }

    private CompletionStage<Void> processDNSKEYResponse(Message request, SMessage response, FindKeyState state, Executor executor) {
        int qclass;
        Name qname = request.getQuestion().getName();
        SRRset dnskeyRrset = response.findAnswerRRset(qname, 48, qclass = request.getQuestion().getDClass());
        if (dnskeyRrset == null) {
            state.keyEntry = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
            state.keyEntry.setBadReason(9, R.get("dnskey.no_rrset", qname));
            return CompletableFuture.completedFuture(null);
        }
        state.keyEntry = this.valUtils.verifyNewDNSKEYs(dnskeyRrset, state.dsRRset, 60L, this.clock.instant());
        if (!state.keyEntry.isGood()) {
            return CompletableFuture.completedFuture(null);
        }
        this.keyCache.store(state.keyEntry);
        return this.processFindKey(state, executor);
    }

    private CompletionStage<SMessage> processValidate(Message request, SMessage response, Executor executor) {
        CompletionStage<Void> completionStage;
        ResponseClassification subtype = ValUtils.classifyResponse(request, response);
        if (subtype != ResponseClassification.REFERRAL) {
            this.removeSpuriousAuthority(response);
        }
        Nsec3ValidationState nsec3State = new Nsec3ValidationState();
        switch (subtype) {
            case POSITIVE: 
            case CNAME: 
            case ANY: {
                log.trace("Validating a positive response");
                completionStage = this.validatePositiveResponse(request, response, nsec3State, executor);
                break;
            }
            case NODATA: {
                log.trace("Validating a nodata response");
                completionStage = this.validateNodataResponse(request, response, nsec3State, executor);
                break;
            }
            case CNAME_NODATA: {
                log.trace("Validating a CNAME_NODATA response");
                completionStage = this.validatePositiveResponse(request, response, nsec3State, executor).thenCompose(v -> {
                    if (response.getStatus() != SecurityStatus.INSECURE) {
                        response.setStatus(SecurityStatus.UNCHECKED, -1);
                        return this.validateNodataResponse(request, response, nsec3State, executor);
                    }
                    return CompletableFuture.completedFuture(null);
                });
                break;
            }
            case NAMEERROR: {
                log.trace("Validating a nxdomain response");
                completionStage = this.validateNameErrorResponse(request, response, nsec3State, executor);
                break;
            }
            case CNAME_NAMEERROR: {
                log.trace("Validating a cname_nxdomain response");
                completionStage = this.validatePositiveResponse(request, response, nsec3State, executor).thenCompose(v -> {
                    if (response.getStatus() != SecurityStatus.INSECURE) {
                        response.setStatus(SecurityStatus.UNCHECKED, -1);
                        return this.validateNameErrorResponse(request, response, nsec3State, executor);
                    }
                    return CompletableFuture.completedFuture(null);
                });
                break;
            }
            default: {
                response.setBogus(R.get("validate.response.unknown", new Object[]{subtype}));
                completionStage = CompletableFuture.completedFuture(null);
            }
        }
        return completionStage.thenApply(v -> this.processFinishedState(request, response));
    }

    private SMessage processFinishedState(Message request, SMessage response) {
        SecurityStatus status = response.getStatus();
        String reason = response.getBogusReason();
        int edeReason = response.getEdeReason();
        switch (status) {
            case BOGUS: {
                int code = response.getHeader().getRcode();
                if (code == 0 || code == 3) {
                    code = 2;
                }
                response = ValidatingResolver.errorMessage(request, code);
                break;
            }
            case SECURE: {
                response.getHeader().setFlag(10);
                break;
            }
            case INSECURE: 
            case UNCHECKED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected security status");
            }
        }
        response.setStatus(status, edeReason, reason);
        return response;
    }

    @Override
    public void setPort(int port) {
        this.headResolver.setPort(port);
    }

    @Override
    public void setTCP(boolean flag) {
        this.headResolver.setTCP(flag);
    }

    @Override
    public void setIgnoreTruncation(boolean flag) {
    }

    @Override
    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        if (version == -1) {
            throw new IllegalArgumentException("EDNS cannot be disabled");
        }
        this.headResolver.setEDNS(version, payloadSize, flags | 0x8000, options);
    }

    @Override
    public void setTSIGKey(TSIG key) {
        this.headResolver.setTSIGKey(key);
    }

    @Override
    public Duration getTimeout() {
        return this.headResolver.getTimeout();
    }

    @Override
    public void setTimeout(Duration duration) {
        this.headResolver.setTimeout(duration);
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query, Executor executor) {
        return this.sendRequest(query, executor).thenCompose(response -> {
            response.getHeader().unsetFlag(10);
            if (query.getHeader().getFlag(11)) {
                return CompletableFuture.completedFuture(response.getMessage());
            }
            Message rrsigResponse = response.getMessage();
            if (query.getQuestion().getType() == 46 && rrsigResponse.getHeader().getRcode() == 0 && !rrsigResponse.getSectionRRsets(1).isEmpty()) {
                rrsigResponse.getHeader().unsetFlag(10);
                return CompletableFuture.completedFuture(rrsigResponse);
            }
            return this.processValidate(query, (SMessage)response, executor).thenApply(validated -> {
                Message m = validated.getMessage();
                String reason = validated.getBogusReason();
                if (reason != null) {
                    this.applyEdeToOpt((SMessage)validated, m);
                    if (this.isAddReasonToAdditional) {
                        this.addValidationReasonTxtRecord(m, reason);
                    }
                }
                return m;
            });
        });
    }

    private void applyEdeToOpt(SMessage validated, Message m) {
        OPTRecord newOpt;
        if (validated.getEdeReason() <= -1) {
            return;
        }
        OPTRecord old = m.getOPT();
        ArrayList<EDNSOption> options = new ArrayList<EDNSOption>();
        options.add(new ExtendedErrorCodeOption(validated.getEdeReason(), validated.getBogusReason()));
        if (old != null) {
            options.addAll(old.getOptions().stream().filter(o -> o.getCode() != 15).collect(Collectors.toList()));
            newOpt = new OPTRecord(old.getPayloadSize(), old.getExtendedRcode(), old.getVersion(), old.getFlags(), options);
            m.removeRecord(m.getOPT(), 3);
        } else {
            newOpt = new OPTRecord(1280, 0, 0, 0, options);
        }
        m.addRecord(newOpt, 3);
    }

    private void addValidationReasonTxtRecord(Message m, String reason) {
        int maxTxtRecordStringLength = 255;
        String[] parts = new String[reason.length() / 255 + 1];
        for (int i = 0; i < parts.length; ++i) {
            int length = Math.min((i + 1) * 255, reason.length());
            parts[i] = reason.substring(i * 255, length);
        }
        m.addRecord(new TXTRecord(Name.root, 65280, 0L, Arrays.asList(parts)), 3);
    }

    private static SMessage errorMessage(Message request, int rcode) {
        SMessage m = new SMessage(request.getHeader().getID(), request.getQuestion());
        Header h = m.getHeader();
        h.setRcode(rcode);
        h.setFlag(0);
        return m;
    }

    @Generated
    public boolean isAddReasonToAdditional() {
        return this.isAddReasonToAdditional;
    }

    @Generated
    public void setAddReasonToAdditional(boolean isAddReasonToAdditional) {
        this.isAddReasonToAdditional = isAddReasonToAdditional;
    }
}

