# -*- coding: binary -*-
require 'spec_helper'


RSpec.describe Msf::Post::Windows::Priv do

  subject do
    context_described_class = described_class

    klass = Class.new(Msf::Post) do
      include context_described_class
    end

    klass.new
  end

  let(:boot_key_vista) do
    "\x50\xfb\xae\x5f\x5c\xd7\x70\x39\x54\xe5\x50\x48\x32\x1b\x81\x8d"
  end
  let(:boot_key_xp) do
    "\x27\x18\x0a\x2e\xe0\xfb\x98\x52\x77\x06\x24\x8e\x21\x80\xf4\x56"
  end

  describe "#capture_lsa_key" do
    let(:pol_enc_key_vista) do
      "\x00\x00\x00\x01\xec\xff\xe1\x7b\x2a\x99\x74\x40\xaa\x93\x9a\xdb"+
      "\xff\x26\xf1\xfc\x03\x00\x00\x00\x00\x00\x00\x00\x67\xe0\x47\xa1"+
      "\xb9\xea\x6c\xa4\x1b\xf7\x95\x75\x69\xdf\x87\x6b\x66\x99\x99\x56"+
      "\x1f\xe4\x0a\xbd\xf3\x08\xd1\x72\x62\x54\xb7\xe8\xfb\x13\x15\x69"+
      "\x88\xe0\x71\xbd\xd0\xab\x54\x66\x4c\x7c\x33\xb7\xfc\x16\x23\xa5"+
      "\x94\xd2\xe3\x5d\xbe\x1a\x6c\x2f\xaf\xb0\xfa\x16\x02\x69\x3e\x05"+
      "\xce\x3e\xf2\x9f\xa5\xd8\xb9\x18\x6e\x8a\x03\x7e\x8f\x2f\x56\x5d"+
      "\xf4\x65\xee\xc9\x84\x52\x48\x9f\x5a\x6f\xb8\x17\x78\x28\x09\x40"+
      "\xc1\x7c\xdf\x46\x65\x7d\x94\xe5\x79\x17\xb9\x40\x7a\xc7\x35\x3a"+
      "\x7d\x39\x9f\x65\x91\x7f\x26\x51\xaf\x57\x03\x2f\x81\xe5\xcd\x5f"+
      "\xfc\x21\xe3\xf5\xd1\xd6\xed\xd1\x60\x6e\xc9\x15"
    end
    let(:pol_enc_key_xp) do
      "\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x26\x07\x4d\x67"+
      "\x85\x3f\x55\x36\x6f\x89\x8d\x6f\x9f\x78\x20\xbd\xc9\xed\x66\x96"+
      "\x28\x49\x1f\x45\x65\x7c\xb9\xe1\x65\x2d\xec\x8d\x54\xe9\xdf\x27"+
      "\xc4\xfd\x38\xf4\x8d\x5d\xc0\xcb\xa3\x8d\xef\xcb\xeb\x46\x32\x23"+
      "\xb8\x86\x95\x2c\x79\xee\x6f\x89\x61\x8b\x89\x14"
    end

    context "with an XP or older registry" do
      let(:pol_enc_key) { pol_enc_key_xp }
      let(:boot_key) { boot_key_xp }

      it "should produce expected LSA key" do
        expect(subject).to receive(:registry_getvaldata).with("HKLM\\SECURITY\\Policy\\PolSecretEncryptionKey", "").and_return(pol_enc_key_xp)
        subject.capture_lsa_key(boot_key_xp)
      end
    end

    context "with a Vista or newer registry" do
      let(:pol_enc_key) { pol_enc_key_vista }
      let(:boot_key) { boot_key_vista }

      it "should produce expected LSA key" do
        expect(subject).to receive(:registry_getvaldata).with("HKLM\\SECURITY\\Policy\\PolSecretEncryptionKey", "").and_return(nil)
        expect(subject).to receive(:registry_getvaldata).with("HKLM\\SECURITY\\Policy\\PolEKList", "").and_return(pol_enc_key_vista)
        subject.capture_lsa_key(boot_key)
      end
    end
  end
end
