# Code of Conduct

## Contributor Code of Conduct

We follow the [CNCF Contributor Code of Conduct](https://github.com/cncf/foundation/blob/main/code-of-conduct.md). Additionally, we commit to the following guidelines as detailed on the [SPIFFE Code of Conduct](https://github.com/spiffe/spiffe/blob/main/CODE-OF-CONDUCT.md):

## Community Guidelines

- Our goal is to foster an inclusive and diverse community of technology enthusiasts.

- Try to be your best self. Treat your fellow community members with kindness and empathy. We welcome disagreements when they are conducted respectfully and without personal attacks.

- We ask that you keep unstructured critique to a minimum. Disparaging remarks about the project are unnecessary and a drain on community morale. Feedback should be constructive and relevant. Having passionately held opinions on what should improve is encouraged! We hope you will use that enthusiasm to roll up your sleeves and get involved by submitting pull requests. We have additional guidelines on [how to ask constructive questions](https://github.com/linkerd/linkerd/wiki/How-To-Ask-Questions-in-Slack).

- We don't tolerate insults, spamming, trolling, flaming, baiting, or harassment. We don't tolerate sexual language, imagery, or unwanted advances. Private harassment is also unacceptable.

- We do our best to avoid [subtle-isms](https://www.recurse.com/manual#sub-sec-social-rules): small actions that make others feel uncomfortable. If you witness a subtle-ism, you may respectfully point it out to the person publicly or privately, or you may ask a moderator to say something. Accidentally saying something biased is common, expected, and readily forgiven. It is not in and of itself a bannable offense.

## Moderation

- If you feel any of SPIFFE's Slack channels require moderation, please e-mail [SPIFFE's Technical Steering Committee (TSC)](mailto:tsc@spiffe.io). The TSC will issue a warning to users who don't follow this code of conduct. A second offense results in a temporary ban. A third offense warrants a permanent ban. It is at the moderator's discretion to un-ban offending users, or to immediately ban a toxic user without warning.
