/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.option;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class HashSeperatedPairs {
    private HashSeperatedPairs() {
    }

    public static List<String[]> parse(String text) throws ParseException {
        ArrayList<String[]> optionEntities = new ArrayList<String[]>();
        if (text.contains("=")) {
            List<String> keysWithValues = HashSeperatedPairs.split(text, '#');
            for (String keyWithValue : keysWithValues) {
                List<String> keyAndValue = HashSeperatedPairs.split(keyWithValue, '=');
                if (keyAndValue.size() != 2) {
                    throw new ParseException("Unable to parse substring: \"" + keyWithValue + "\"", 0);
                }
                String[] pair = new String[2];
                for (int i = 0; i < 2; ++i) {
                    pair[i] = HashSeperatedPairs.unescape(keyAndValue.get(i));
                }
                optionEntities.add(pair);
            }
        }
        return optionEntities;
    }

    private static List<String> split(String text, char delimiter) {
        ArrayList<String> keysWithValues = new ArrayList<String>();
        int startIndex = 0;
        boolean hadSlash = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\\') {
                hadSlash = !hadSlash;
                continue;
            }
            if (ch == delimiter && !hadSlash) {
                keysWithValues.add(text.substring(startIndex, i));
                startIndex = i + 1;
            }
            hadSlash = false;
        }
        keysWithValues.add(text.substring(startIndex));
        return keysWithValues;
    }

    private static String unescape(String str2) {
        return str2.replaceAll("\\\\([\\\\=#])", "$1");
    }
}

