/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api.serialize;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class HubSeedReader {
    public HubSeedDescriptor readSeed(InputStream is) throws IOException {
        return this.readSeed(IOUtils.toString((InputStream)is, (String)"UTF-8"));
    }

    public HubSeedDescriptor readSeed(String text) throws IOException {
        HubSeedDescriptor seed = null;
        if (!StringUtilities.isNullOrEmpty((String)text)) {
            seed = HubSeedReader.isXml(text = text.trim()) ? this.fromXmlSeed(text) : this.fromJsonSeed(text);
        }
        return seed;
    }

    public HubSeeds read(InputStream is) throws IOException {
        return this.read(IOUtils.toString((InputStream)is, (String)"UTF-8"));
    }

    public HubSeeds read(String text) throws IOException {
        HubSeeds seeds = null;
        if (!StringUtilities.isNullOrEmpty((String)text)) {
            seeds = HubSeedReader.isXml(text = text.trim()) ? this.fromXml(text) : this.fromJson(text);
        }
        return seeds;
    }

    private HubSeedDescriptor fromJsonSeed(String text) throws JsonSyntaxException {
        Gson gson = new Gson();
        return (HubSeedDescriptor)gson.fromJson(text, HubSeedDescriptor.class);
    }

    private HubSeedDescriptor fromXmlSeed(String text) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        return (HubSeedDescriptor)serializer.read(HubSeedDescriptor.class, text);
    }

    private HubSeeds fromJson(String text) throws JsonSyntaxException {
        Gson gson = new Gson();
        return (HubSeeds)gson.fromJson(text, HubSeeds.class);
    }

    private HubSeeds fromXml(String text) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        return (HubSeeds)serializer.read(HubSeeds.class, text);
    }

    private static boolean isXml(String text) {
        return text.startsWith("<");
    }
}

