/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.selection;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.util.ui.WindowUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class GraphStoreSelection
extends GraphSelection {
    private static final Logger LOG = Logger.getLogger(GraphStoreSelection.class.getName());
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private GraphStoreView _view;
    private GraphStore _modelStore;
    private GraphModelViewMappings _modelViewMappings;
    private Set<EntityID> _selectedModelEntities;
    private Set<EntityID> _selectedViewEntities;
    private Set<LinkID> _selectedModelLinks;
    private Set<LinkID> _selectedViewLinks;
    private boolean _fireUpdate = false;

    GraphStoreSelection(GraphID graphID) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.getGraphStructureStore().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
                    LOG.log(Level.FINE, "Structure changed: {0}", mods);
                    GraphStoreSelection.this._fireUpdate = false;
                    if (GraphStoreSelection.this._selectedModelEntities != null && !GraphStoreSelection.this._selectedModelEntities.isEmpty()) {
                        GraphStoreSelection.this._fireUpdate = GraphStoreSelection.this._selectedModelEntities.removeAll(mods.getEntitiesRemoved());
                        if (GraphStoreSelection.this._fireUpdate) {
                            LOG.fine("Selected entities removed");
                        }
                        GraphStoreSelection.this._selectedViewEntities = null;
                    }
                    if (GraphStoreSelection.this._selectedModelLinks != null && !GraphStoreSelection.this._selectedModelLinks.isEmpty()) {
                        boolean selectedLinksRemoved = GraphStoreSelection.this._selectedModelLinks.removeAll(mods.getLinksRemoved().keySet());
                        if (selectedLinksRemoved) {
                            GraphStoreSelection.this._fireUpdate = true;
                            LOG.fine("Selected links removed");
                        }
                        GraphStoreSelection.this._selectedViewLinks = null;
                    }
                }
            });
            this._view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            this._view.getGraphStructureStore().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
                    LOG.log(Level.FINE, "View structure changed: {0}", mods);
                    if (GraphStoreSelection.this._selectedModelEntities != null && !GraphStoreSelection.this._selectedModelEntities.isEmpty() && !mods.getCollectionMods().isEmpty()) {
                        GraphStoreSelection.this._fireUpdate = true;
                        LOG.fine("Collection was split");
                        GraphStoreSelection.this._selectedViewEntities = null;
                    }
                    if (GraphStoreSelection.this._fireUpdate) {
                        GraphStoreSelection.this.fireChange();
                    }
                }
            });
            this._modelStore = this._view.getModel();
            this._modelViewMappings = this._view.getModelViewMappings();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean hasSelection() {
        return this.hasSelectedEntities() || this.hasSelectedLinks();
    }

    public boolean hasSelectedEntities() {
        return this.getSelectedModelEntityCount() > 0;
    }

    public boolean hasSelectedLinks() {
        return this.getSelectedModelLinkCount() > 0;
    }

    public int getSelectedModelEntityCount() {
        return this.getSelectedModelEntities().size();
    }

    public int getSelectedViewEntityCount() {
        return this.getSelectedViewEntities().size();
    }

    public int getSelectedModelLinkCount() {
        return this.getSelectedModelLinks().size();
    }

    public int getSelectedViewLinkCount() {
        return this.getSelectedViewLinks().size();
    }

    public Set<EntityID> getSelectedViewEntities() {
        return Collections.unmodifiableSet(this.getSelectedViewEntitiesMutable());
    }

    private Set<EntityID> getSelectedViewEntitiesMutable() {
        if (this._selectedViewEntities == null) {
            this._selectedViewEntities = this.getViewEntitiesForModelEntities(this._selectedModelEntities);
        }
        return this._selectedViewEntities;
    }

    private Set<EntityID> getViewEntitiesForModelEntities(Collection<EntityID> modelEntities) {
        HashSet<EntityID> viewEntities = new HashSet<EntityID>();
        if (modelEntities != null) {
            try {
                for (EntityID modelEntity : modelEntities) {
                    EntityID viewEntity = this._modelViewMappings.getViewEntity(modelEntity);
                    LOG.log(Level.FINE, "model {0} -> view {1}", new Object[]{modelEntity, viewEntity});
                    viewEntities.add(viewEntity);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return viewEntities;
    }

    public Set<EntityID> getSelectedModelEntities() {
        if (this._selectedModelEntities == null) {
            this._selectedModelEntities = this.getSelectedModelEntitiesMutable();
        }
        return Collections.unmodifiableSet(this._selectedModelEntities);
    }

    private Set<EntityID> getSelectedModelEntitiesMutable() {
        if (this._selectedModelEntities == null) {
            this._selectedModelEntities = this.getModelEntitiesForViewEntities(this._selectedViewEntities);
        }
        return this._selectedModelEntities;
    }

    private Set<EntityID> getModelEntitiesForViewEntities(Collection<EntityID> viewEntities) {
        HashSet<EntityID> modelEntities = new HashSet<EntityID>();
        if (viewEntities != null) {
            try {
                modelEntities.addAll(this._modelViewMappings.getModelEntities(viewEntities));
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return modelEntities;
    }

    public Set<EntityID> getSelectedModelEntities(EntityID viewEntityID) {
        HashSet modelEntities = Collections.EMPTY_SET;
        try {
            modelEntities = new HashSet(this._modelViewMappings.getModelEntities(viewEntityID));
            modelEntities.retainAll(this.getSelectedModelEntitiesMutable());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelEntities;
    }

    public boolean isSelectedInModel(EntityID modelEntityID) {
        return this.getSelectedModelEntities().contains(modelEntityID);
    }

    public SelectionState getViewSelectionState(EntityID viewEntityID) {
        Set<EntityID> modelEntities = this.getModelEntitiesForViewEntities(Collections.singleton(viewEntityID));
        boolean hasSelected = false;
        boolean hasUnselected = false;
        for (EntityID modelEntity : modelEntities) {
            if (this.isSelectedInModel(modelEntity)) {
                hasSelected = true;
            } else {
                hasUnselected = true;
            }
            if (!hasSelected || !hasUnselected) continue;
            return SelectionState.PARTIAL;
        }
        return hasSelected ? SelectionState.YES : SelectionState.NO;
    }

    public Set<LinkID> getSelectedViewLinks() {
        return Collections.unmodifiableSet(this.getSelectedViewLinksMutable());
    }

    private Set<LinkID> getSelectedViewLinksMutable() {
        if (this._selectedViewLinks == null) {
            this._selectedViewLinks = this.getViewLinksForModelLinks(this._selectedModelLinks);
        }
        return this._selectedViewLinks;
    }

    private Set<LinkID> getViewLinksForModelLinks(Collection<LinkID> modelLinks) {
        HashSet<LinkID> viewLinks = new HashSet<LinkID>();
        if (modelLinks != null) {
            try {
                for (LinkID modelLink : modelLinks) {
                    LinkID viewLink = this._modelViewMappings.getViewLink(modelLink);
                    viewLinks.add(viewLink);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return viewLinks;
    }

    public Set<LinkID> getSelectedModelLinks() {
        if (this._selectedModelLinks == null) {
            this._selectedModelLinks = this.getSelectedModelLinksMutable();
        }
        return Collections.unmodifiableSet(this._selectedModelLinks);
    }

    private Set<LinkID> getSelectedModelLinksMutable() {
        if (this._selectedModelLinks == null) {
            this._selectedModelLinks = this.getModelLinksForViewLinks(this._selectedViewLinks);
        }
        return this._selectedModelLinks;
    }

    private Set<LinkID> getModelLinksForViewLinks(Collection<LinkID> viewLinks) {
        HashSet<LinkID> modelLinks = new HashSet<LinkID>();
        if (viewLinks != null) {
            try {
                modelLinks.addAll(this._modelViewMappings.getModelLinks(viewLinks));
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return modelLinks;
    }

    public Set<LinkID> getSelectedModelLinks(LinkID viewLinkID) {
        HashSet modelLinks = Collections.EMPTY_SET;
        try {
            modelLinks = new HashSet(this._modelViewMappings.getModelLinks(viewLinkID));
            modelLinks.retainAll(this.getSelectedModelLinksMutable());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelLinks;
    }

    public boolean isSelectedInModel(LinkID modelLinkID) {
        return this.getSelectedModelLinks().contains(modelLinkID);
    }

    public boolean isSelectedInView(LinkID viewLinkID) {
        return this.getSelectedViewLinks().contains(viewLinkID);
    }

    public SelectionState getViewSelectionState(LinkID viewLinkID) {
        Set<LinkID> modelLinks = this.getModelLinksForViewLinks(Collections.singleton(viewLinkID));
        boolean hasSelected = false;
        boolean hasUnselected = false;
        for (LinkID modelLink : modelLinks) {
            if (this.isSelectedInModel(modelLink)) {
                hasSelected = true;
            } else {
                hasUnselected = true;
            }
            if (!hasSelected || !hasUnselected) continue;
            return SelectionState.PARTIAL;
        }
        return hasSelected ? SelectionState.YES : SelectionState.NO;
    }

    public void setSelectedModelEntities(Collection<EntityID> modelEntityIDs) {
        LOG.log(Level.FINE, "Select entities: {0}", modelEntityIDs);
        try {
            HashSet<EntityID> newSelection;
            WindowUtil.showWaitCursor();
            HashSet<Object> hashSet = newSelection = modelEntityIDs != null ? new HashSet<EntityID>(modelEntityIDs) : new HashSet();
            if (!newSelection.equals(this.getSelectedModelEntitiesMutable())) {
                this.clearCache();
                this._selectedModelEntities = newSelection;
                this.fireChange();
            }
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    public void setSelectedViewEntities(Collection<EntityID> viewEntityIDs) {
        LOG.log(Level.FINE, "Select view entities: {0}", viewEntityIDs);
        try {
            HashSet<EntityID> newSelection;
            WindowUtil.showWaitCursor();
            HashSet<Object> hashSet = newSelection = viewEntityIDs != null ? new HashSet<EntityID>(viewEntityIDs) : new HashSet();
            if (!newSelection.equals(this.getSelectedViewEntitiesMutable())) {
                this.clearCache();
                this._selectedViewEntities = newSelection;
                this.fireChange();
            }
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    public void setSelectedModelLinks(Collection<LinkID> modelLinkIDs) {
        LOG.log(Level.FINE, "Select links: {0}", modelLinkIDs);
        try {
            HashSet<LinkID> newSelection;
            WindowUtil.showWaitCursor();
            HashSet<Object> hashSet = newSelection = modelLinkIDs != null ? new HashSet<LinkID>(modelLinkIDs) : new HashSet();
            if (!newSelection.equals(this.getSelectedModelLinksMutable())) {
                this.clearCache();
                this._selectedModelLinks = newSelection;
                this.fireChange();
            }
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    public void setSelectedViewLinks(Collection<LinkID> viewLinkIDs) {
        LOG.log(Level.FINE, "Select view links: {0}", viewLinkIDs);
        try {
            HashSet<LinkID> newSelection;
            WindowUtil.showWaitCursor();
            HashSet<Object> hashSet = newSelection = viewLinkIDs != null ? new HashSet<LinkID>(viewLinkIDs) : new HashSet();
            if (!newSelection.equals(this.getSelectedViewLinksMutable())) {
                this.clearCache();
                this._selectedViewLinks = newSelection;
                this.fireChange();
            }
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    public void setModelEntitiesSelected(Collection<EntityID> modelEntityIDs, boolean selected) {
        if (selected) {
            LOG.log(Level.FINE, "Select entities: {0}", modelEntityIDs);
            this.addSelectedModelEntities(modelEntityIDs);
        } else {
            LOG.log(Level.FINE, "Unselect entities: {0}", modelEntityIDs);
            if (this._selectedModelEntities != null) {
                this._selectedModelEntities.removeAll(modelEntityIDs);
            }
            if (this._selectedViewEntities != null) {
                Set<EntityID> viewEntities = this.getViewEntitiesForModelEntities(modelEntityIDs);
                if (this._selectedModelEntities == null) {
                    this._selectedViewEntities.removeAll(viewEntities);
                } else {
                    for (EntityID viewEntity : viewEntities) {
                        Set<EntityID> modelEntities = this.getModelEntitiesForViewEntities(Collections.singleton(viewEntity));
                        if (!Collections.disjoint(modelEntities, this._selectedModelEntities)) continue;
                        this._selectedViewEntities.remove(viewEntity);
                    }
                }
            }
            this.fireChange();
        }
    }

    public void setViewEntitiesSelected(Collection<EntityID> viewEntityIDs, boolean selected) {
        if (selected) {
            LOG.log(Level.FINE, "Select view entities: {0}", viewEntityIDs);
            this.addSelectedViewEntities(viewEntityIDs);
        } else {
            LOG.log(Level.FINE, "Unselect view entities: {0}", viewEntityIDs);
            if (this._selectedViewEntities != null) {
                this._selectedViewEntities.removeAll(viewEntityIDs);
            }
            if (this._selectedModelEntities != null) {
                Set<EntityID> modelEntities = this.getModelEntitiesForViewEntities(viewEntityIDs);
                this._selectedModelEntities.removeAll(modelEntities);
            }
            this.fireChange();
        }
    }

    public void setModelLinksSelected(Collection<LinkID> modelLinkIDs, boolean selected) {
        if (selected) {
            LOG.log(Level.FINE, "Select links: {0}", modelLinkIDs);
            this.addSelectedModelLinks(modelLinkIDs);
        } else {
            LOG.log(Level.FINE, "Unselect links: {0}", modelLinkIDs);
            if (this._selectedModelLinks != null) {
                this._selectedModelLinks.removeAll(modelLinkIDs);
            }
            if (this._selectedViewLinks != null) {
                Set<LinkID> viewLinks = this.getViewLinksForModelLinks(modelLinkIDs);
                if (this._selectedModelLinks == null) {
                    this._selectedViewLinks.removeAll(viewLinks);
                } else {
                    for (LinkID viewLink : viewLinks) {
                        Set<LinkID> modelLinks = this.getModelLinksForViewLinks(Collections.singleton(viewLink));
                        if (!Collections.disjoint(modelLinks, this._selectedModelLinks)) continue;
                        this._selectedViewLinks.remove(viewLink);
                    }
                }
            }
            this.fireChange();
        }
    }

    public void setViewLinksSelected(Collection<LinkID> viewLinkIDs, boolean selected) {
        if (selected) {
            LOG.log(Level.FINE, "Select view links: {0}", viewLinkIDs);
            this.addSelectedViewLinks(viewLinkIDs);
        } else {
            LOG.log(Level.FINE, "Unselect view links: {0}", viewLinkIDs);
            if (this._selectedViewLinks != null) {
                this._selectedViewLinks.removeAll(viewLinkIDs);
            }
            if (this._selectedModelLinks != null) {
                Set<LinkID> modelLinks = this.getModelLinksForViewLinks(viewLinkIDs);
                this._selectedModelLinks.removeAll(modelLinks);
            }
            this.fireChange();
        }
    }

    public void addSelectedModelEntities(Collection<EntityID> modelEntityIDs) {
        LOG.log(Level.FINE, "Add selected entities: {0}", modelEntityIDs);
        this.clearLinkCache();
        Set<EntityID> selectedModelEntities = this.getSelectedModelEntitiesMutable();
        selectedModelEntities.addAll(modelEntityIDs);
        if (this._selectedViewEntities != null) {
            Set<EntityID> viewEntities = this.getViewEntitiesForModelEntities(modelEntityIDs);
            this._selectedViewEntities.addAll(viewEntities);
        }
        this.fireChange();
    }

    public void addSelectedViewEntities(Collection<EntityID> viewEntityIDs) {
        LOG.log(Level.FINE, "Add selected view entities: {0}", viewEntityIDs);
        this.clearLinkCache();
        Set<EntityID> selectedViewEntities = this.getSelectedViewEntitiesMutable();
        selectedViewEntities.addAll(viewEntityIDs);
        if (this._selectedModelEntities != null) {
            Set<EntityID> modelEntities = this.getModelEntitiesForViewEntities(viewEntityIDs);
            this._selectedModelEntities.addAll(modelEntities);
        }
        this.fireChange();
    }

    public void addSelectedModelLinks(Collection<LinkID> modelLinkIDs) {
        LOG.log(Level.FINE, "Add selected links: {0}", modelLinkIDs);
        this.clearEntityCache();
        Set<LinkID> selectedModelLinks = this.getSelectedModelLinksMutable();
        selectedModelLinks.addAll(modelLinkIDs);
        if (this._selectedViewLinks != null) {
            Set<LinkID> viewLinks = this.getViewLinksForModelLinks(modelLinkIDs);
            this._selectedViewLinks.addAll(viewLinks);
        }
        this.fireChange();
    }

    public void addSelectedViewLinks(Collection<LinkID> viewLinkIDs) {
        LOG.log(Level.FINE, "Add selected view links: {0}", viewLinkIDs);
        this.clearEntityCache();
        Set<LinkID> selectedViewLinks = this.getSelectedViewLinksMutable();
        selectedViewLinks.addAll(viewLinkIDs);
        if (this._selectedModelLinks != null) {
            Set<LinkID> modelLinks = this.getModelLinksForViewLinks(viewLinkIDs);
            this._selectedModelLinks.addAll(modelLinks);
        }
        this.fireChange();
    }

    public void selectAllEntities() {
        this.clearCache();
        this.invertSelection(true);
    }

    public void selectAllLinks() {
        this.clearCache();
        this.invertSelection(false);
    }

    public void invertSelection(boolean entitiesIfNoSelection) {
        try {
            if (this._selectedModelEntities != null && !this._selectedModelEntities.isEmpty()) {
                this.invertModelEntities();
            } else if (this._selectedViewEntities != null && !this._selectedViewEntities.isEmpty()) {
                this.invertViewEntities();
            } else if (this._selectedModelLinks != null && !this._selectedModelLinks.isEmpty()) {
                this.invertModelLinks();
            } else if (this._selectedViewLinks != null && !this._selectedViewLinks.isEmpty()) {
                this.invertViewLinks();
            } else if (entitiesIfNoSelection) {
                this.setSelectedModelEntities(this._modelStore.getGraphStructureStore().getStructureReader().getEntities());
            } else {
                this.setSelectedModelLinks(this._modelStore.getGraphStructureStore().getStructureReader().getLinks());
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChange();
    }

    private void invertModelEntities() throws GraphStoreException {
        this.clearLinkCache();
        this._selectedViewEntities = null;
        GraphStructureReader structureReader = this._modelStore.getGraphStructureStore().getStructureReader();
        HashSet<EntityID> entities = new HashSet<EntityID>(structureReader.getEntities());
        entities.removeAll(this._selectedModelEntities);
        this._selectedModelEntities = entities;
    }

    private void invertViewEntities() throws GraphStoreException {
        this.clearLinkCache();
        this._selectedModelEntities = null;
        GraphStructureReader structureReader = this._view.getGraphStructureStore().getStructureReader();
        HashSet<EntityID> entities = new HashSet<EntityID>(structureReader.getEntities());
        entities.removeAll(this._selectedViewEntities);
        this._selectedViewEntities = entities;
    }

    private void invertModelLinks() throws GraphStoreException {
        this.clearEntityCache();
        this._selectedViewLinks = null;
        GraphStructureReader structureReader = this._modelStore.getGraphStructureStore().getStructureReader();
        HashSet<LinkID> links = new HashSet<LinkID>(structureReader.getLinks());
        links.removeAll(this._selectedModelLinks);
        this._selectedModelLinks = links;
    }

    private void invertViewLinks() throws GraphStoreException {
        this.clearEntityCache();
        this._selectedModelLinks = null;
        GraphStructureReader structureReader = this._view.getGraphStructureStore().getStructureReader();
        HashSet<LinkID> links = new HashSet<LinkID>(structureReader.getLinks());
        links.removeAll(this._selectedViewLinks);
        this._selectedViewLinks = links;
    }

    public void clearSelection() {
        if (this.hasSelection()) {
            this.clearCache();
            this.fireChange();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void clearCache() {
        this.clearEntityCache();
        this.clearLinkCache();
    }

    private void clearEntityCache() {
        this._selectedModelEntities = null;
        this._selectedViewEntities = null;
    }

    private void clearLinkCache() {
        this._selectedModelLinks = null;
        this._selectedViewLinks = null;
    }

    private void fireChange() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Fire selection changed");
            LOG.fine("Selected model entities: " + this.getSelectedModelEntities());
            LOG.fine("Selected model links: " + this.getSelectedModelLinks());
        }
        this._changeSupport.firePropertyChange("selectionChanged", null, "");
        this._fireUpdate = false;
    }
}

