/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.chatapi.msg.ChatMessagePropagator;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.chatapi.reconnect.AbstractReconnectController;
import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.collab.ui.ChatFilterSettings;
import com.paterva.maltego.collab.ui.MessageColors;
import com.paterva.maltego.util.output.OutputMessage;
import java.awt.Color;

public class CollaborationReconnectController
extends AbstractReconnectController {
    private ChatRoom _chatRoom;

    public CollaborationReconnectController(ChatRoom chatRoom) {
        this._chatRoom = chatRoom;
    }

    public ChatRoom getChatRoom() {
        return this._chatRoom;
    }

    protected boolean isConnected() {
        return ConnectionStatus.Offline != this._chatRoom.getConnectionStatus();
    }

    protected void doWork() throws Exception {
        ChatRoom chatRoom = this.getChatRoom();
        if (ConnectionStatus.Offline == chatRoom.getConnectionStatus()) {
            chatRoom.reconnect((ConnectionInitiationCallback)new ReconnectCallback());
        }
    }

    private class ReconnectCallback
    implements ConnectionInitiationCallback {
        private ReconnectCallback() {
        }

        public void progress(LogMessageLevel level, String message, int percent) {
            this.progress(level, message);
            CollaborationReconnectController.this.getReconnectProgress().setProgress(percent);
        }

        public void progress(LogMessageLevel level, String message) {
            CollaborationReconnectController.this.getReconnectProgress().setProgressText(message);
            this.log(level, message);
        }

        public boolean isCancelled() {
            return CollaborationReconnectController.this.isCancelled();
        }

        public void debug(String message) {
            System.out.println(message);
            this.log(LogMessageLevel.Debug, message);
        }

        private void log(LogMessageLevel level, String message) {
            if (ChatFilterSettings.isShow(level, this.isDebugMode())) {
                ChatMessagePropagator.logMessage((ChatRoom)CollaborationReconnectController.this.getChatRoom(), (LogMessageLevel)level, (OutputMessage)new OutputMessage(message), (Color)MessageColors.getColor(level), null);
            }
        }

        private boolean isDebugMode() {
            if (CollaborationReconnectController.this._chatRoom instanceof GraphChatRoom) {
                return ((GraphChatRoom)CollaborationReconnectController.this._chatRoom).isDebugMode();
            }
            return false;
        }
    }
}

