/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.polyglot.DefaultScope;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.util.Map;
import java.util.Objects;
import org.graalvm.polyglot.Value;

@ExportLibrary(value=InteropLibrary.class)
final class PolyglotBindings
implements TruffleObject {
    private final PolyglotContextImpl context;
    private final PolyglotLanguageContext languageContext;
    private volatile Map<String, Value> bindings;

    PolyglotBindings(PolyglotContextImpl context) {
        this(context, null);
    }

    PolyglotBindings(PolyglotLanguageContext languageContext) {
        this(languageContext.context, languageContext);
    }

    private PolyglotBindings(PolyglotContextImpl context, PolyglotLanguageContext languageContext) {
        Objects.requireNonNull(context);
        this.context = context;
        this.languageContext = languageContext;
    }

    public Map<String, Value> getBindings() {
        Map<String, Value> localBindings = this.bindings;
        if (localBindings == null) {
            this.bindings = localBindings = this.context.getPolyglotGuestBindings();
        }
        return localBindings;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        Value value = this.getBindings().get(member);
        if (value == null) {
            Value legacyValue = this.context.findLegacyExportedSymbol(member);
            if (legacyValue != null) {
                return this.context.getAPIAccess().getReceiver(legacyValue);
            }
            throw UnknownIdentifierException.create(member);
        }
        if (this.languageContext != null) {
            return this.context.toGuestValue(null, value, false);
        }
        return this.context.getAPIAccess().getReceiver(value);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value) {
        Value v = this.languageContext != null ? this.languageContext.asValue(value) : this.context.asValue(value);
        this.getBindings().put(member, v);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeMember(String member) throws UnknownIdentifierException {
        Value ret = this.getBindings().remove(member);
        if (ret == null) {
            throw UnknownIdentifierException.create(member);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new DefaultScope.VariableNamesObject(this.getBindings().keySet());
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberModifiable"), @ExportMessage(name="isMemberRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isMemberExisting(String member) {
        boolean existing = this.getBindings().containsKey(member);
        if (!existing) {
            return this.context.findLegacyExportedSymbol(member) != null;
        }
        return existing;
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return !this.isMemberExisting(member);
    }
}

