/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.crypto;

public enum FipsMode {
    NON_STRICT("org.keycloak.crypto.fips.FIPS1402Provider"),
    STRICT("org.keycloak.crypto.fips.Fips1402StrictCryptoProvider"),
    DISABLED("org.keycloak.crypto.def.DefaultCryptoProvider");

    private final String providerClassName;
    private final String optionName;

    private FipsMode(String providerClassName) {
        this.providerClassName = providerClassName;
        this.optionName = this.name().toLowerCase().replace('_', '-');
    }

    public boolean isFipsEnabled() {
        return this.equals((Object)NON_STRICT) || this.equals((Object)STRICT);
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public static FipsMode valueOfOption(String name) {
        return FipsMode.valueOf(name.toUpperCase().replace('-', '_'));
    }

    public String toString() {
        return this.optionName;
    }
}

