/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.palette;

import java.util.Objects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class Favourite {
    private final String folderName;
    private final String fileName;

    public Favourite(String folderName, String fileName) {
        this.folderName = folderName;
        this.fileName = fileName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileObject getFileObject() {
        FileObject maltego = FileUtil.getConfigRoot().getFileObject("Maltego");
        if (maltego == null) {
            return null;
        }
        FileObject entities = maltego.getFileObject("Entities");
        if (entities == null) {
            return null;
        }
        FileObject folder = entities.getFileObject(this.folderName);
        if (folder == null) {
            return null;
        }
        return folder.getFileObject(this.fileName);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.folderName);
        hash = 83 * hash + Objects.hashCode(this.fileName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Favourite other = (Favourite)obj;
        if (!Objects.equals(this.folderName, other.folderName)) {
            return false;
        }
        return Objects.equals(this.fileName, other.fileName);
    }

    public String toString() {
        return "Favourite{folderName=" + this.folderName + ", fileName=" + this.fileName + '}';
    }
}

