/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.xsocket.DataConverter;
import org.xsocket.IDataSink;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserDatagram
implements IDataSource,
IDataSink {
    private SocketAddress remoteSocketAddress = null;
    private ByteBuffer data;
    private String defaultEncoding = "UTF-8";

    public UserDatagram(int size) {
        this.init(this.remoteSocketAddress, ByteBuffer.allocate(size));
    }

    public UserDatagram(String remoteHost, int remotePort, int size) {
        this.init(new InetSocketAddress(remoteHost, remotePort), ByteBuffer.allocate(size));
    }

    public UserDatagram(InetAddress remoteAddress, int remotePort, int size) {
        this.init(new InetSocketAddress(remoteAddress, remotePort), ByteBuffer.allocate(size));
    }

    public UserDatagram(SocketAddress address, int size) {
        this.init(address, ByteBuffer.allocate(size));
    }

    public UserDatagram(ByteBuffer data) {
        this(null, data);
    }

    public UserDatagram(SocketAddress remoteSocketAddress, ByteBuffer data) {
        this(remoteSocketAddress, data, "UTF-8");
    }

    UserDatagram(SocketAddress remoteSocketAddress, ByteBuffer data, String defaultEncoding) {
        this.init(remoteSocketAddress, data);
        this.defaultEncoding = defaultEncoding;
    }

    public UserDatagram(byte[] data) {
        this(null, data);
    }

    public UserDatagram(String remoteHost, int remotePort, byte[] data) {
        this((SocketAddress)new InetSocketAddress(remoteHost, remotePort), data);
    }

    public UserDatagram(SocketAddress remoteSocketAddress, byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.position(buffer.limit());
        this.init(remoteSocketAddress, buffer);
    }

    private void init(SocketAddress remoteSocketAddress, ByteBuffer data) {
        this.remoteSocketAddress = remoteSocketAddress;
        this.data = data;
    }

    void prepareForSend() {
        this.data.clear();
    }

    void setRemoteAddress(SocketAddress remoteSocketAddress) {
        this.remoteSocketAddress = remoteSocketAddress;
    }

    protected ByteBuffer getData() {
        return this.data;
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public void setEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    public InetAddress getRemoteAddress() {
        if (this.remoteSocketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.remoteSocketAddress).getAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this.remoteSocketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.remoteSocketAddress).getPort();
        }
        return -1;
    }

    @Override
    public byte readByte() throws IOException, BufferUnderflowException {
        return this.data.get();
    }

    public ByteBuffer readSingleByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        if (length <= 0) {
            if (length == 0) {
                return ByteBuffer.allocate(0);
            }
            throw new IllegalArgumentException("length has to be positive");
        }
        int savedLimit = this.data.limit();
        int savedPosition = this.data.position();
        this.data.limit(this.data.position() + length);
        ByteBuffer sliced = this.data.slice();
        this.data.position(savedPosition + length);
        this.data.limit(savedLimit);
        return sliced;
    }

    @Override
    public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return DataConverter.toString(this.readByteBufferByLength(length), encoding);
    }

    @Override
    public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByLength(length, this.defaultEncoding);
    }

    @Override
    public double readDouble() throws IOException, BufferUnderflowException {
        return this.data.getDouble();
    }

    @Override
    public int readInt() throws IOException, BufferUnderflowException {
        return this.data.getInt();
    }

    @Override
    public short readShort() throws IOException, BufferUnderflowException {
        return this.data.getShort();
    }

    @Override
    public long readLong() throws IOException, BufferUnderflowException {
        return this.data.getLong();
    }

    public ByteBuffer readByteBuffer() throws IOException, BufferUnderflowException {
        ByteBuffer sliced = this.data.slice();
        this.data.position(this.data.limit());
        return sliced;
    }

    public byte[] readBytes() throws IOException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBuffer());
    }

    public String readString() throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readString(this.defaultEncoding);
    }

    public String readString(String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return DataConverter.toString(this.readByteBuffer(), encoding);
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        int size = buffer.remaining();
        int available = buffer.remaining();
        if (available == 0) {
            return -1;
        }
        if (available < size) {
            size = available;
        }
        if (size > 0) {
            ByteBuffer[] bufs;
            for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
                while (buf.hasRemaining()) {
                    buffer.put(buf);
                }
            }
        }
        return size;
    }

    @Override
    public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, this.defaultEncoding);
    }

    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.defaultEncoding, maxLength);
    }

    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return DataConverter.toString(this.readByteBufferByDelimiter(delimiter, encoding, maxLength), encoding);
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        return this.readByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        return this.readByteBufferByDelimiter(delimiter, this.defaultEncoding, maxLength);
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        return new ByteBuffer[]{this.readSingleByteBufferByDelimiter(delimiter, encoding, maxLength)};
    }

    @Override
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        return new ByteBuffer[]{this.readSingleByteBufferByLength(length)};
    }

    public ByteBuffer readSingleByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
        return this.readSingleByteBufferByDelimiter(delimiter, this.defaultEncoding);
    }

    public ByteBuffer readSingleByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        return this.readSingleByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    public ByteBuffer readSingleByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        byte[] delimiterBytes = delimiter.getBytes(encoding);
        int startPos = UserDatagram.findDelimiter(this.data, delimiterBytes, maxLength);
        if (startPos >= 0) {
            int savedLimit = this.data.limit();
            this.data.limit(startPos);
            ByteBuffer result = this.data.slice();
            this.data.limit(savedLimit);
            this.data.position(startPos + delimiterBytes.length);
            return result;
        }
        throw new BufferUnderflowException();
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
        return this.readBytesByDelimiter(delimiter, this.defaultEncoding);
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        return this.readBytesByDelimiter(delimiter, this.defaultEncoding, maxLength);
    }

    public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        return this.readBytesByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, this.defaultEncoding, maxLength));
    }

    @Override
    public long transferTo(WritableByteChannel target, int length) throws IOException, ClosedChannelException, BufferUnderflowException {
        ByteBuffer[] buffers;
        long written = 0L;
        for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    private static int findDelimiter(ByteBuffer buffer, byte[] delimiter, int maxLength) throws MaxReadSizeExceededException {
        int result = -1;
        int delimiterPosition = 0;
        for (int pos = buffer.position(); pos < buffer.limit(); ++pos) {
            byte b = buffer.get(pos);
            if (b == delimiter[delimiterPosition]) {
                if (++delimiterPosition != delimiter.length) continue;
                result = pos - delimiterPosition + 1;
                break;
            }
            delimiterPosition = 0;
        }
        if (result > maxLength) {
            throw new MaxReadSizeExceededException();
        }
        return result;
    }

    @Override
    public int write(byte b) throws IOException, BufferOverflowException {
        this.data.put(b);
        return 1;
    }

    @Override
    public int write(short s) throws IOException, BufferOverflowException {
        this.data.putShort(s);
        return 2;
    }

    @Override
    public int write(byte ... bytes) throws IOException, BufferOverflowException {
        this.data.put(bytes);
        return bytes.length;
    }

    @Override
    public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
        this.data.put(bytes, offset, length);
        return length;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
        int length = buffer.remaining();
        this.data.put(buffer);
        return length;
    }

    @Override
    public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
        int length = 0;
        for (ByteBuffer buffer : buffers) {
            length += this.write(buffer);
        }
        return length;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.write(DataConverter.toByteBuffers(srcs, offset, length));
    }

    @Override
    public long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
        int length = 0;
        for (ByteBuffer buffer : buffers) {
            length += this.write(buffer);
        }
        return length;
    }

    @Override
    public int write(double d) throws IOException, BufferOverflowException {
        this.data.putDouble(d);
        return 8;
    }

    @Override
    public int write(int i) throws IOException, BufferOverflowException {
        this.data.putInt(i);
        return 4;
    }

    @Override
    public int write(long l) throws IOException, BufferOverflowException {
        this.data.putLong(l);
        return 8;
    }

    @Override
    public int write(String message) throws IOException, BufferOverflowException {
        return this.write(message, this.defaultEncoding);
    }

    public int write(String message, String encoding) throws IOException, BufferOverflowException {
        byte[] bytes = message.getBytes(encoding);
        this.data.put(bytes);
        return bytes.length;
    }

    @Override
    public long transferFrom(FileChannel source) throws IOException, BufferOverflowException {
        return this.transferFrom((ReadableByteChannel)source);
    }

    @Override
    public long transferFrom(ReadableByteChannel sourceChannel) throws IOException, BufferOverflowException {
        return this.transferFrom(sourceChannel, 8196);
    }

    @Override
    public long transferFrom(ReadableByteChannel sourceChannel, int chunkSize) throws IOException, BufferOverflowException {
        long transfered = 0L;
        int read = 0;
        do {
            ByteBuffer transferBuffer;
            if ((read = sourceChannel.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
            if (transferBuffer.remaining() == 0) {
                transferBuffer.flip();
                this.write(transferBuffer);
            } else {
                transferBuffer.flip();
                this.write(transferBuffer.slice());
            }
            transfered += (long)read;
        } while (read > 0);
        return transfered;
    }

    public int getSize() {
        return this.data.limit();
    }

    public int getRemaining() {
        return this.data.remaining();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.remoteSocketAddress != null) {
            sb.append("remoteAddress=" + this.remoteSocketAddress.toString() + " ");
        } else {
            sb.append("remoteAddress=null ");
        }
        if (this.data != null) {
            sb.append("data=" + DataConverter.toHexString(new ByteBuffer[]{this.data.duplicate()}, 500) + " ");
        } else {
            sb.append("data=null ");
        }
        return sb.toString();
    }
}

