/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.paterva.maltego.reporting.pdf.PdfReportCommonGenerator;
import com.paterva.maltego.reporting.pdf.PdfReportFasterGenerator;
import com.paterva.maltego.reporting.pdf.PdfReportGenerator;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.analytics.export.ExportGraphEvent;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.paterva.maltego.util.ui.components.BinaryOptionRadioButtons;
import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import com.paterva.maltego.util.ui.filechooser.SaveValidationFileChooser;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import yguard.A.J.U;

public class ReportAction
extends TopGraphAction {
    private static final String PREF_SAVED_DIR = "exportAsPdfDir";
    private static final String PREF_SAVED_EXPORT_SPEED = "exportAsPdfExportSpeed";
    private static final String PREF_SAVED_IMAGE_BOUNDS_GRAPH = "exportAsPdfImageBoundsGraph";
    private static final String PREF_SAVED_ENTITY_IMAGES = "exportAsPdfEntityImages";
    private static final String PREF_SAVED_DISPLAY_INFO_IMAGES = "exportAsPdfDisplayInfoImages";
    private static final String PREF_SAVED_EMPTY_PROPS = "exportAsPdfEmptyProps";
    private static final String PREF_SAVED_USER_PROPS = "exportAsPdfUserProps";
    private static final String PREF_SAVED_ANONYMOUS_REPORT = "anonymousReports";

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return "Generate Report";
    }

    protected String iconResource() {
        return "com/paterva/maltego/reporting/resources/ReportExport.png";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionPerformed(TopComponent tc) {
        ExportGraphEvent.send((ExportGraphEvent.ExportTo)ExportGraphEvent.ExportTo.GENERATE_REPORT);
        String pdfExt = "pdf";
        SaveValidationFileChooser fileChooser = new SaveValidationFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        Preferences prefs = NbPreferences.forModule(ReportAction.class);
        FileChooserUtil.setDirectoryAndFile((Preferences)prefs, (String)PREF_SAVED_DIR, (JFileChooser)fileChooser, (String)GraphUtils.getTopGraphName((TopComponent)tc, (String)"GraphPDF"));
        fileChooser.addChoosableFileFilter((FileFilter)new FileNameExtensionFilter("PDF document (*.pdf)", "pdf"));
        boolean initDefaultSpeed = prefs.getBoolean(PREF_SAVED_EXPORT_SPEED, true);
        BinaryOptionRadioButtons exportSpeedRadios = new BinaryOptionRadioButtons(initDefaultSpeed, "Normal", "Very high (faster, but may cause OutOfMemoryError)", null, "Increase the maximum memory available to Maltego in Options->Java Options");
        boolean initWholeGraph = prefs.getBoolean(PREF_SAVED_IMAGE_BOUNDS_GRAPH, true);
        BinaryOptionRadioButtons imageBoundsRadios = new BinaryOptionRadioButtons(initWholeGraph, "Whole graph", "Current view only");
        JCheckBox entityImagesCheckbox = new JCheckBox();
        entityImagesCheckbox.setEnabled(true);
        boolean initEntityImages = prefs.getBoolean(PREF_SAVED_ENTITY_IMAGES, true);
        entityImagesCheckbox.setSelected(initEntityImages);
        JCheckBox displayInfoImagesCheckbox = new JCheckBox();
        displayInfoImagesCheckbox.setToolTipText("Transforms may attach HTML (including images) to an Entity, that is displayed in the Detail View. This option exports images found in the Display Info. Will not work in Stealth Privacy Mode.");
        displayInfoImagesCheckbox.setEnabled(true);
        boolean initDisplayInfoImages = prefs.getBoolean(PREF_SAVED_DISPLAY_INFO_IMAGES, true);
        displayInfoImagesCheckbox.setSelected(initDisplayInfoImages);
        JCheckBox emptyPropCheckbox = new JCheckBox();
        emptyPropCheckbox.setEnabled(true);
        boolean initEmptyProps = prefs.getBoolean(PREF_SAVED_EMPTY_PROPS, true);
        emptyPropCheckbox.setSelected(initEmptyProps);
        JCheckBox userPropCheckbox = new JCheckBox();
        userPropCheckbox.setEnabled(true);
        boolean initUserProps = prefs.getBoolean(PREF_SAVED_USER_PROPS, false);
        userPropCheckbox.setSelected(initUserProps);
        JCheckBox anonymousReportCheckbox = new JCheckBox();
        anonymousReportCheckbox.setToolTipText("\"maltego.\" prefix will be excluded from Entity Type Names (IDs) in the report content");
        anonymousReportCheckbox.setEnabled(true);
        boolean initAnonymousReport = prefs.getBoolean(PREF_SAVED_ANONYMOUS_REPORT, false);
        anonymousReportCheckbox.setSelected(initAnonymousReport);
        ArrayList labelGrouping = FileChooserUtil.addAdditionalFieldsToChooser((JFileChooser)fileChooser, (String[])new String[]{"Export memory usage:", "Graph image bounds:"}, (JComponent[])new JComponent[]{exportSpeedRadios, imageBoundsRadios});
        FileChooserUtil.addAdditionalFieldsGroupToChooser((JFileChooser)fileChooser, (String)"Include:", (int)7, (ArrayList)labelGrouping, (String[])new String[]{"Entity images:", "Images from Entity Display Info:", "Empty Entity Properties:", "User Properties:", "Anonymous Report:"}, (JComponent[])new JComponent[]{entityImagesCheckbox, displayInfoImagesCheckbox, emptyPropCheckbox, userPropCheckbox, anonymousReportCheckbox});
        int result = fileChooser.showSaveDialog((Component)WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            file = FileChooserUtil.addExtenstionIfMissing((File)file, (String)"pdf");
            JComponent viewControl = this.getTopGraphViewCookie().getGraphView().getViewControl();
            if (viewControl instanceof U) {
                TopComponent activeTC = TopComponent.getRegistry().getActivated();
                Cursor oldCursor = activeTC.getCursor();
                try {
                    activeTC.setCursor(Cursor.getPredefinedCursor(3));
                    boolean defaultSpeed = exportSpeedRadios.isOption1();
                    boolean wholeGraph = imageBoundsRadios.isOption1();
                    boolean graphImage = true;
                    boolean entityImages = entityImagesCheckbox.isSelected();
                    boolean displayInfoImages = displayInfoImagesCheckbox.isSelected();
                    boolean emptyProps = emptyPropCheckbox.isSelected();
                    boolean hiddenProps = false;
                    boolean userProps = userPropCheckbox.isSelected();
                    boolean anonymousReport = anonymousReportCheckbox.isSelected();
                    PdfReportCommonGenerator report = new PdfReportGenerator(false, false);
                    if (!defaultSpeed) {
                        report = new PdfReportFasterGenerator(false, false);
                    }
                    if (report.generateReport(file, (U)viewControl, wholeGraph, graphImage, entityImages, displayInfoImages, emptyProps, hiddenProps, userProps, anonymousReport)) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Report generated successfully.", 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    String currentDirectory = fileChooser.getCurrentDirectory().getAbsolutePath();
                    prefs.put(PREF_SAVED_DIR, currentDirectory);
                    prefs.putBoolean(PREF_SAVED_EXPORT_SPEED, defaultSpeed);
                    prefs.putBoolean(PREF_SAVED_IMAGE_BOUNDS_GRAPH, wholeGraph);
                    prefs.putBoolean(PREF_SAVED_ENTITY_IMAGES, entityImages);
                    prefs.putBoolean(PREF_SAVED_DISPLAY_INFO_IMAGES, displayInfoImages);
                    prefs.putBoolean(PREF_SAVED_EMPTY_PROPS, emptyProps);
                    prefs.putBoolean(PREF_SAVED_USER_PROPS, userProps);
                    prefs.putBoolean(PREF_SAVED_ANONYMOUS_REPORT, anonymousReport);
                }
                finally {
                    activeTC.setCursor(oldCursor);
                }
            }
        }
    }
}

