/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub.settings;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.hub.settings.HubSeedRequiredSettingsPanel;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.beans.PropertyChangeListener;
import org.openide.WizardDescriptor;

public class HubSeedRequiredSettingsController
extends ValidatingController<HubSeedRequiredSettingsPanel> {
    private final HubSeedDescriptor seed;
    private PropertyChangeListener settingsListener;

    public HubSeedRequiredSettingsController(HubSeedDescriptor seed) {
        this.seed = seed;
    }

    protected HubSeedRequiredSettingsPanel createComponent() {
        return new HubSeedRequiredSettingsPanel(this, this.seed);
    }

    public boolean hasRequiredInputs() {
        boolean hasRequired = true;
        HubSeedSettings settings = HubSeedSettings.getDefault();
        DisplayDescriptorCollection props = settings.getGlobalTransformProperties(this.seed);
        DataSource globalTxSettings = settings.getGlobalTransformSettings(this.seed);
        for (DisplayDescriptor prop : props) {
            if (prop.isNullable() || !StringUtilities.isNullString((Object)prop.getDefaultValue()) || !StringUtilities.isNullString((Object)globalTxSettings.getValue((PropertyDescriptor)prop))) continue;
            hasRequired = false;
            break;
        }
        return hasRequired;
    }

    protected String getFirstError(HubSeedRequiredSettingsPanel component) {
        return this.hasRequiredInputs() ? null : "Please complete all required fields";
    }

    protected void readSettings(WizardDescriptor settings) {
        this.settingsListener = ignored -> this.doValidate();
        HubSeedSettings.getDefault().addPropertyChangeListener(this.settingsListener);
    }

    protected void storeSettings(WizardDescriptor settings) {
        if (this.settingsListener != null) {
            HubSeedSettings.getDefault().removePropertyChangeListener(this.settingsListener);
            this.settingsListener = null;
        }
    }
}

