/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.http;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.http.AuthenticationPopup;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbPreferences;

public class PopupAuthenticator
extends Authenticator {
    private static final String PROXY_PASSWORD_KEY = "http.proxyPassword";
    private static final String PROXY_USER_KEY = "http.proxyUser";
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String USERNAME_KEY = "LastUsedAuthenticatorUsername";

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String prop;
        if (this.useAuthentication()) {
            String proxyUser = System.getProperty(PROXY_USER_KEY);
            String proxyPass = System.getProperty(PROXY_PASSWORD_KEY);
            if (!StringUtilities.isNullOrEmpty((String)proxyUser) && !StringUtilities.isNullOrEmpty((String)proxyPass)) {
                return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
            }
        }
        Preferences prefs = NbPreferences.forModule(PopupAuthenticator.class);
        AuthenticationPopup ctrl = new AuthenticationPopup();
        String username = prefs.get(USERNAME_KEY, "");
        if (username.isEmpty() && (prop = System.getProperty(PROXY_USER_KEY)) != null) {
            username = prop;
        }
        ctrl.setUsername(username);
        ctrl.setAuthenticationType(this.getRequestingScheme() == null ? "" : this.getRequestingScheme().toUpperCase());
        ctrl.setHost(this.getRequestingHost());
        ctrl.setPort(String.valueOf(this.getRequestingPort()));
        ctrl.setUrl(this.getRequestingURL() == null ? "null" : this.getRequestingURL().toString());
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
            ctrl.setServerType("Proxy");
        } else {
            ctrl.setServerType("Server");
        }
        PasswordAuthentication auth = null;
        DialogDescriptor dd = new DialogDescriptor((Object)ctrl, "Authentication required");
        JButton okButton = new JButton("Ok");
        JButton cancelButton = new JButton("Cancel");
        Object[] options = new Object[]{okButton, cancelButton};
        dd.setOptions(options);
        dd.setOptionsAlign(0);
        dd.setClosingOptions(options);
        dd.setModal(true);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == okButton) {
            username = ctrl.getUsername();
            char[] password = ctrl.getPassword();
            auth = new PasswordAuthentication(username, password);
            prefs.put(USERNAME_KEY, username);
        }
        return auth;
    }

    private boolean useAuthentication() {
        Preferences pref = NbPreferences.root().node("org/netbeans/core");
        if (pref != null) {
            return pref.getBoolean(USE_PROXY_AUTHENTICATION, false);
        }
        return false;
    }
}

