/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.edit;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ui.image.ImageStripRenderer;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class SummaryImageStripRenderer
implements ImageStripRenderer {
    private ImageCallback _callback;

    public void paint(Graphics g, Object imageObj, int width, int height) {
        if (imageObj instanceof Attachment) {
            Attachment att = (Attachment)imageObj;
            Image image = ImageFactory.getDefault().getImage((Object)att, -1, 200, this._callback);
            if (image != null) {
                g.drawImage(image, 0, 0, width, height, null);
            } else {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("darculaMod.iconColor"));
                g.fillRect(0, 0, width, height);
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("7-white"));
                int heightDiv2 = height / 2;
                g.fillRect((int)((float)width * 0.375f), heightDiv2, 3, 3);
                g.fillRect((int)((float)width * 0.5f), heightDiv2, 3, 3);
                g.fillRect((int)((float)width * 0.625f), heightDiv2, 3, 3);
            }
        } else if (imageObj instanceof LineBorder) {
            this.paintBox(g, width, height);
        }
    }

    public void paintHighlight(Graphics g, Object image, int width, int height) {
        g.setColor(UIManager.getLookAndFeelDefaults().getColor("7-focus-color"));
        g.fillRoundRect(0, 0, width, height, 0, 0);
    }

    public void paintEmpty(Graphics g, int width, int height) {
        this.paintBox(g, width, height);
        GraphicsUtil.setupTextAntialiasing((Graphics)g, null);
        String text = "Use the + button to add images\n";
        FontMetrics fontMetrics = g.getFontMetrics();
        int stringWidth = fontMetrics.stringWidth("Use the + button to add images\n");
        int descent = fontMetrics.getDescent();
        g.setColor(UIManager.getLookAndFeelDefaults().getColor("summary-view-text-fg"));
        g.drawString("Use the + button to add images\n", (width - stringWidth) / 2, (int)((float)height / 2.0f + (float)descent));
    }

    public void paintBox(Graphics g, int width, int height) {
        g.setColor(UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor"));
        g.drawRoundRect(0, 0, width - 1, height - 1, 0, 0);
    }

    public void setCallback(ImageCallback callback) {
        this._callback = callback;
    }
}

