/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.serializer;

import com.paterva.maltego.graph.table.HeaderTypeOptions;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraph;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.ui.serializer.MappedPropertyStub;
import com.paterva.maltego.graph.table.ui.serializer.StrictPropertiesTypeStub;
import com.paterva.maltego.graph.table.ui.serializer.StrictPropertyStub;
import com.paterva.maltego.graph.table.ui.serializer.TabularGraphEntityStub;
import com.paterva.maltego.graph.table.ui.serializer.TabularGraphLinkStub;
import com.paterva.maltego.graph.table.ui.serializer.TabularGraphStub;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TabularGraphTranslator {
    private TabularGraphTranslator() {
    }

    public static TabularGraph translate(TabularGraphStub stub) {
        DefaultTabularGraph tabularGraph = new DefaultTabularGraph();
        if (stub.hasTypeRow()) {
            if (stub.hasHeaderRow()) {
                if (stub.getTypeRowIndex() < stub.getHeaderRowIndex()) {
                    tabularGraph.setHeaderTypeOptions(HeaderTypeOptions.TYPE_THEN_HEAD);
                } else {
                    tabularGraph.setHeaderTypeOptions(HeaderTypeOptions.HEAD_THEN_TYPE);
                }
            } else {
                tabularGraph.setHeaderTypeOptions(HeaderTypeOptions.TYPE_ONLY);
            }
        } else if (stub.hasHeaderRow()) {
            tabularGraph.setHeaderTypeOptions(HeaderTypeOptions.HEAD_ONLY);
        } else {
            tabularGraph.setHeaderTypeOptions(HeaderTypeOptions.NO_HEAD_OR_TYPE);
        }
        tabularGraph.setName(stub.getName());
        tabularGraph.setDescription(stub.getDescription());
        tabularGraph.setSavedDate(stub.getSavedDate());
        HashMap<Integer, TabularGraphEntity> idTBGEntityMap = new HashMap<Integer, TabularGraphEntity>(stub.getEntities().size());
        for (TabularGraphEntityStub entityStub : stub.getEntities()) {
            TabularGraphEntity tbGEntity = TabularGraphTranslator.translate(entityStub);
            idTBGEntityMap.put(entityStub.getId(), tbGEntity);
            tabularGraph.putEntity(tbGEntity);
        }
        for (TabularGraphLinkStub linkStub : stub.getLinks()) {
            tabularGraph.putLink(TabularGraphTranslator.translate(linkStub, idTBGEntityMap));
        }
        Map<String, Set<String>> typeStrictProperties = TabularGraphTranslator.translateStrictProperties(stub);
        tabularGraph.getTypeStrictProperties().putAll(typeStrictProperties);
        return tabularGraph;
    }

    private static TabularGraphEntity translate(TabularGraphEntityStub stub) {
        DefaultTabularGraphEntity tbEntity = new DefaultTabularGraphEntity(stub.getType());
        for (MappedPropertyStub propStub : stub.getMappedProperties()) {
            tbEntity.put(propStub.getColumn(), TabularGraphTranslator.translate(propStub));
        }
        return tbEntity;
    }

    private static TabularGraphLink translate(TabularGraphLinkStub stub, Map<Integer, TabularGraphEntity> idTBGEntityMap) {
        DefaultTabularGraphLink tbLink = new DefaultTabularGraphLink(idTBGEntityMap.get(stub.getSourceEntity()), idTBGEntityMap.get(stub.getTargetEntity()));
        tbLink.setIndex(stub.getIndex());
        for (MappedPropertyStub propStub : stub.getMappedProperties()) {
            tbLink.put(propStub.getColumn(), TabularGraphTranslator.translate(propStub));
        }
        return tbLink;
    }

    private static PropertyDescriptor translate(MappedPropertyStub stub) {
        PropertyDescriptor descriptor = new PropertyDescriptor(TypeRegistry.getDefault().getType(stub.getType()).getType(), stub.getName(), stub.getDisplayName());
        descriptor.setHidden(stub.isHidden());
        descriptor.setNullable(stub.isNullable());
        descriptor.setReadonly(stub.isReadonly());
        return descriptor;
    }

    private static Map<String, Set<String>> translateStrictProperties(TabularGraphStub stub) {
        HashMap<String, Set<String>> typeStrictProperties = new HashMap<String, Set<String>>();
        List<StrictPropertiesTypeStub> strictPropertyTypes = stub.getStrictProperties();
        for (StrictPropertiesTypeStub strictPropertyType : strictPropertyTypes) {
            String specName = strictPropertyType.getSpecName();
            List<StrictPropertyStub> propertyNames = strictPropertyType.getPropertyNames();
            HashSet<String> propNames = new HashSet<String>(propertyNames.size());
            for (StrictPropertyStub propertyName : propertyNames) {
                propNames.add(propertyName.getName());
            }
            typeStrictProperties.put(specName, propNames);
        }
        return typeStrictProperties;
    }

    public static TabularGraphStub translate(TabularGraph mapping) {
        TabularGraphStub stub = new TabularGraphStub();
        boolean hasTypeRow = mapping.hasTypeRow();
        if (hasTypeRow) {
            stub.setHasTypeRow(hasTypeRow, mapping.getTypeRowIndex());
        } else {
            stub.setHasTypeRow(hasTypeRow);
        }
        boolean hasHeaderRow = mapping.hasHeaderRow();
        if (hasHeaderRow) {
            stub.setHasHeaderRow(hasHeaderRow, mapping.getHeaderRowIndex());
        } else {
            stub.setHasHeaderRow(hasHeaderRow);
        }
        stub.setName(mapping.getName());
        stub.setDescription(mapping.getDescription());
        stub.setNumEntities(mapping.getEntities().size());
        stub.setNumLinks(mapping.getLinks().size());
        stub.setSavedDate(mapping.getSavedDate());
        HashMap<TabularGraphEntity, Integer> tbgEntityIDMap = new HashMap<TabularGraphEntity, Integer>(mapping.getEntities().size());
        stub.setEntities(TabularGraphTranslator.translateEntity(mapping.getEntities(), tbgEntityIDMap));
        stub.setLinks(TabularGraphTranslator.translateLink(mapping.getLinks(), tbgEntityIDMap));
        stub.setStrictProperties(TabularGraphTranslator.translatStrictProperties(mapping));
        return stub;
    }

    private static List<TabularGraphEntityStub> translateEntity(List<TabularGraphEntity> entities, Map<TabularGraphEntity, Integer> tbgEntityIDMap) {
        ArrayList<TabularGraphEntityStub> stubEntities = new ArrayList<TabularGraphEntityStub>(entities.size());
        int id = 0;
        for (TabularGraphEntity entity : entities) {
            tbgEntityIDMap.put(entity, id);
            TabularGraphEntityStub entityStub = new TabularGraphEntityStub();
            String typeName = entity.getEntitySpecName();
            entityStub.setType(typeName);
            entityStub.setId(id++);
            for (int column : entity.getColumns()) {
                PropertyDescriptor pd = entity.getProperty(column);
                entityStub.addMappedProperty(TabularGraphTranslator.translate(pd, column));
            }
            stubEntities.add(entityStub);
        }
        return stubEntities;
    }

    private static List<TabularGraphLinkStub> translateLink(List<TabularGraphLink> links, Map<TabularGraphEntity, Integer> tbgEntityIDMap) {
        ArrayList<TabularGraphLinkStub> stubLinks = new ArrayList<TabularGraphLinkStub>(links.size());
        for (TabularGraphLink link : links) {
            TabularGraphLinkStub linkStub = new TabularGraphLinkStub();
            linkStub.setSourceEntity(tbgEntityIDMap.get(link.getSource()));
            linkStub.setTargetEntity(tbgEntityIDMap.get(link.getTarget()));
            linkStub.setIndex(link.getIndex());
            for (int column : link.getColumns()) {
                PropertyDescriptor pd = link.getProperty(column);
                linkStub.addMappedProperty(TabularGraphTranslator.translate(pd, column));
            }
            stubLinks.add(linkStub);
        }
        return stubLinks;
    }

    private static MappedPropertyStub translate(PropertyDescriptor descriptor, int column) {
        MappedPropertyStub mappedPropStub = new MappedPropertyStub();
        mappedPropStub.setColumn(column);
        mappedPropStub.setName(descriptor.getName());
        mappedPropStub.setDisplayName(descriptor.getDisplayName());
        TypeDescriptor type = TypeRegistry.getDefault().getType(descriptor.getType());
        mappedPropStub.setType(type.getTypeName());
        mappedPropStub.setHidden(descriptor.isHidden());
        mappedPropStub.setNullable(descriptor.isNullable());
        mappedPropStub.setReadonly(descriptor.isReadonly());
        return mappedPropStub;
    }

    private static List<StrictPropertiesTypeStub> translatStrictProperties(TabularGraph mapping) {
        ArrayList<StrictPropertiesTypeStub> typeStrictProperties = new ArrayList<StrictPropertiesTypeStub>();
        for (Map.Entry entrySet : mapping.getTypeStrictProperties().entrySet()) {
            String specName = (String)entrySet.getKey();
            Set propNames = (Set)entrySet.getValue();
            ArrayList<StrictPropertyStub> propertyNames = new ArrayList<StrictPropertyStub>(propNames.size());
            for (String propName : propNames) {
                propertyNames.add(new StrictPropertyStub(propName));
            }
            typeStrictProperties.add(new StrictPropertiesTypeStub(specName, propertyNames));
        }
        return typeStrictProperties;
    }
}

