/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexableField;

class ComplexArrayFieldSplitter {
    private final List<Container> _containers = new ArrayList<Container>();
    private Container _currentContainer;

    public void collectAll(List<IndexableField> fields) throws PandoraException {
        this.collectAll(fields, "");
    }

    public void collectAll(List<IndexableField> fields, String prefix) throws PandoraException {
        for (IndexableField indexField : fields) {
            this.collect(indexField, prefix);
        }
    }

    private void collect(IndexableField field, String prefix) throws PandoraException {
        String fieldName = field.name().substring(prefix.length());
        TypeConverter converter = TypeConverter.get(fieldName);
        if (converter == null) {
            if (prefix.isEmpty()) {
                throw new PandoraException(String.format("Could not find a TypeConverter for field: %s.", field.name()));
            }
            throw new PandoraException(String.format("Could not find a TypeConverter for field: %s with prefix: %s.", field.name(), prefix));
        }
        String property = converter.getProperty(fieldName);
        if (this._currentContainer == null || !this._currentContainer.add(property, field)) {
            this._currentContainer = new Container();
            this._currentContainer.add(property, field);
            this._containers.add(this._currentContainer);
        }
    }

    public boolean hasArray() {
        return this._containers.size() > 1;
    }

    public List<Container> getContainers() {
        return this._containers;
    }

    public static class Container {
        private final List<IndexableField> _fields = new ArrayList<IndexableField>();
        private final List<String> _properties = new ArrayList<String>();
        private String _lastProperty;

        private Container() {
        }

        private boolean add(String property, IndexableField field) {
            if (this._lastProperty == null) {
                this._fields.add(field);
                this._properties.add(property);
            } else if (this._lastProperty.equals(property)) {
                this._fields.add(field);
            } else if (!this._properties.contains(property)) {
                this._fields.add(field);
                this._properties.add(property);
            } else {
                return false;
            }
            this._lastProperty = property;
            return true;
        }

        public List<IndexableField> getFields() {
            return this._fields;
        }
    }
}

