/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing;

import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.util.StringUtilities;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class UserInfo {
    private String userId = "";
    private String firstNames = "";
    private String lastName = "";
    private String username = "";
    private String email = "";
    private boolean isEmailUser = true;
    private String country = "";
    private String alias = "";
    private String namespace = "";
    private String licenseType = "Unspecified";
    private String organization = "";
    private String region = "";
    private String currentPlan = "";
    private Long validFrom;
    private Long validTo;

    public UserInfo() {
        this(LicenseManager.A().A(false));
    }

    public UserInfo(A licenseMode) {
        if (licenseMode.Q()) {
            this.firstNames = com.paterva.maltego.licensing.free.A.O().orElse("");
            this.lastName = com.paterva.maltego.licensing.free.A.B().orElse("");
            this.email = com.paterva.maltego.licensing.free.A.A().orElse("");
            this.country = com.paterva.maltego.licensing.free.A.J().orElse("");
            this.alias = com.paterva.maltego.licensing.free.A.P().orElse("");
            this.namespace = com.paterva.maltego.licensing.free.A.C().orElse("");
            this.validFrom = com.paterva.maltego.licensing.free.A.I();
            this.validTo = com.paterva.maltego.licensing.free.A.R();
            this.licenseType = "Maltego " + (licenseMode.I() ? "Community Edition" : "CaseFile");
        } else if (licenseMode.B()) {
            D license = licenseMode.A();
            this.firstNames = license.B();
            this.lastName = license.E();
            this.email = license.J();
            E capability = licenseMode.J().J();
            this.validFrom = capability.H();
            this.validTo = capability.G();
            this.licenseType = capability.F();
        } else if (licenseMode.W()) {
            this.userId = com.paterva.maltego.licensing.free.A.T();
            this.firstNames = com.paterva.maltego.licensing.free.A.O().orElse("");
            this.lastName = com.paterva.maltego.licensing.free.A.B().orElse("");
            this.email = com.paterva.maltego.licensing.free.A.A().orElse("");
            this.isEmailUser = !StringUtilities.isNullOrEmpty((String)this.email);
            this.username = com.paterva.maltego.licensing.free.A.F();
            this.country = com.paterva.maltego.licensing.free.A.J().orElse("");
            this.alias = com.paterva.maltego.licensing.free.A.P().orElse("");
            this.namespace = com.paterva.maltego.licensing.free.A.C().orElse("");
            this.organization = com.paterva.maltego.licensing.free.A.K().orElse("");
            this.region = com.paterva.maltego.licensing.free.A.S().orElse("");
            this.currentPlan = licenseMode.X().getProductPlan().getDisplayName();
            E capability = licenseMode.R().J();
            this.validFrom = capability.H();
            this.validTo = capability.G();
            this.licenseType = capability.F();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFirstNames() {
        return this.firstNames;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return Stream.of(this.firstNames, this.lastName).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.joining(" "));
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailUser() {
        return this.isEmailUser;
    }

    public String getCountry() {
        return this.country;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Long getValidFrom() {
        return this.validFrom;
    }

    public Long getValidTo() {
        return this.validTo;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCurrentPlan() {
        return this.currentPlan;
    }
}

