"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferencesProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
class ReferencesProvider {
  constructor(queries, index) {
    (0, _defineProperty2.default)(this, "queries", []);
    (0, _defineProperty2.default)(this, "index", {});
    const {
      names,
      namesByQuery,
      referencesByName,
      referencesByQueryAndName
    } = index;
    this.queries = queries;
    this.index = {
      names: Object.keys(names),
      namesByQuery: namesByQuery.map(q => Object.keys(q)),
      referencesByName,
      referencesByQueryAndName
    };
  }
  getReferences(name, query = null) {
    if (query == null) {
      return this.index.referencesByName[name];
    }
    const pos = this.queries.indexOf(query);
    return (this.index.referencesByQueryAndName[pos] || {})[name];
  }
  getNames(query = null) {
    if (query == null) {
      return this.index.names;
    }
    const pos = this.queries.indexOf(query);
    return this.index.namesByQuery[pos] || [];
  }
}
exports.ReferencesProvider = ReferencesProvider;