/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.CandidateInfo;
import org.chefproject.core.CandidateInfoEdit;
import org.chefproject.core.CandidatePath;
import org.chefproject.core.CandidatePathEdit;
import org.chefproject.core.Dissertation;
import org.chefproject.core.DissertationEdit;
import org.chefproject.core.DissertationStep;
import org.chefproject.core.DissertationStepEdit;
import org.chefproject.core.StepStatus;
import org.chefproject.core.StepStatusEdit;
import org.chefproject.service.component.BaseDissertationService;
import org.chefproject.service.component.BaseXmlFileStorage;

public class XmlFileDissertationService
extends BaseDissertationService {
    protected String m_dissertationStoragePath = null;
    protected String m_stepStoragePath = null;
    protected String m_pathStoragePath = null;
    protected String m_statusStoragePath = null;
    protected String m_infoStoragePath = null;

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_dissertationStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("dissertationpath", "db/dissertation_dissertation.xml"));
        Log.info("chef", this + ".init(RunData): dissertation storage path: " + this.m_dissertationStoragePath);
        this.m_stepStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("steppath", "db/dissertation_step.xml"));
        Log.info("chef", this + ".init(RunData): step storage path: " + this.m_stepStoragePath);
        this.m_pathStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("pathpath", "db/dissertation_path.xml"));
        Log.info("chef", this + ".init(RunData): path storage path: " + this.m_pathStoragePath);
        this.m_statusStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("statuspath", "db/dissertation_status.xml"));
        Log.info("chef", this + ".init(RunData): status storage path: " + this.m_statusStoragePath);
        this.m_infoStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("infopath", "db/dissertation_info.xml"));
        Log.info("chef", this + ".init(RunData): info storage path: " + this.m_infoStoragePath);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_dissertationCache.disable();
        this.m_stepCache.disable();
        this.m_pathCache.disable();
        this.m_statusCache.disable();
        this.m_infoCache.disable();
    }

    protected BaseDissertationService.DissertationStorage newDissertationStorage() {
        return new XmlFileDissertationStorage(new BaseDissertationService.DissertationStorageUser());
    }

    protected BaseDissertationService.DissertationStepStorage newDissertationStepStorage() {
        return new XmlFileDissertationStepStorage(new BaseDissertationService.DissertationStepStorageUser());
    }

    protected BaseDissertationService.CandidatePathStorage newCandidatePathStorage() {
        return new XmlFileCandidatePathStorage(new BaseDissertationService.CandidatePathStorageUser());
    }

    protected BaseDissertationService.StepStatusStorage newStepStatusStorage() {
        return new XmlFileStepStatusStorage(new BaseDissertationService.StepStatusStorageUser());
    }

    protected BaseDissertationService.CandidateInfoStorage newCandidateInfoStorage() {
        return new XmlFileCandidateInfoStorage(new BaseDissertationService.CandidateInfoStorageUser());
    }

    protected class XmlFileCandidateInfoStorage
    extends BaseXmlFileStorage
    implements BaseDissertationService.CandidateInfoStorage {
        public XmlFileCandidateInfoStorage(BaseDissertationService.CandidateInfoStorageUser info) {
            super(XmlFileDissertationService.this.m_infoStoragePath, "infos", null, "info", info);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public CandidateInfo get(String id) {
            return (CandidateInfo)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public CandidateInfoEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (CandidateInfoEdit)super.putResource(null, id, other);
        }

        public CandidateInfoEdit edit(String id) {
            return (CandidateInfoEdit)super.editResource(null, id);
        }

        public void commit(CandidateInfoEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(CandidateInfoEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(CandidateInfoEdit edit) {
            super.removeResource(null, edit);
        }
    }

    protected class XmlFileStepStatusStorage
    extends BaseXmlFileStorage
    implements BaseDissertationService.StepStatusStorage {
        public XmlFileStepStatusStorage(BaseDissertationService.StepStatusStorageUser status) {
            super(XmlFileDissertationService.this.m_statusStoragePath, "statusi", null, "status", status);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public StepStatus get(String id) {
            return (StepStatus)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public StepStatusEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (StepStatusEdit)super.putResource(null, id, other);
        }

        public StepStatusEdit edit(String id) {
            return (StepStatusEdit)super.editResource(null, id);
        }

        public void commit(StepStatusEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(StepStatusEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(StepStatusEdit edit) {
            super.removeResource(null, edit);
        }
    }

    protected class XmlFileCandidatePathStorage
    extends BaseXmlFileStorage
    implements BaseDissertationService.CandidatePathStorage {
        public XmlFileCandidatePathStorage(BaseDissertationService.CandidatePathStorageUser path) {
            super(XmlFileDissertationService.this.m_pathStoragePath, "paths", null, "path", path);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public CandidatePath get(String id) {
            return (CandidatePath)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public CandidatePathEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (CandidatePathEdit)super.putResource(null, id, other);
        }

        public CandidatePathEdit edit(String id) {
            return (CandidatePathEdit)super.editResource(null, id);
        }

        public void commit(CandidatePathEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(CandidatePathEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(CandidatePathEdit edit) {
            super.removeResource(null, edit);
        }
    }

    protected class XmlFileDissertationStepStorage
    extends BaseXmlFileStorage
    implements BaseDissertationService.DissertationStepStorage {
        public XmlFileDissertationStepStorage(BaseDissertationService.DissertationStepStorageUser step) {
            super(XmlFileDissertationService.this.m_stepStoragePath, "steps", null, "step", step);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public DissertationStep get(String id) {
            return (DissertationStep)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public DissertationStepEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (DissertationStepEdit)super.putResource(null, id, other);
        }

        public DissertationStepEdit edit(String id) {
            return (DissertationStepEdit)super.editResource(null, id);
        }

        public void commit(DissertationStepEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(DissertationStepEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(DissertationStepEdit edit) {
            super.removeResource(null, edit);
        }
    }

    protected class XmlFileDissertationStorage
    extends BaseXmlFileStorage
    implements BaseDissertationService.DissertationStorage {
        public XmlFileDissertationStorage(BaseDissertationService.DissertationStorageUser dissertation) {
            super(XmlFileDissertationService.this.m_dissertationStoragePath, "dissertations", null, "dissertation", dissertation);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public Dissertation get(String id) {
            return (Dissertation)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public DissertationEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (DissertationEdit)super.putResource(null, id, other);
        }

        public DissertationEdit edit(String id) {
            return (DissertationEdit)super.editResource(null, id);
        }

        public void commit(DissertationEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(DissertationEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(DissertationEdit edit) {
            super.removeResource(null, edit);
        }
    }
}

