/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizeSequencingPolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizeSequencingPolicy;

public class RibbonTask {
    private JRibbon ribbon;
    private ArrayList<AbstractRibbonBand<?>> bands;
    private String title;
    private RibbonContextualTaskGroup contextualGroup;
    private RibbonBandResizeSequencingPolicy resizeSequencingPolicy;
    private String keyTip;
    private RichTooltip richTooltip;

    public RibbonTask(String title, AbstractRibbonBand<?> ... bands) {
        if (bands == null || bands.length == 0) {
            throw new IllegalArgumentException("Cannot have empty ribbon task");
        }
        this.title = title;
        this.bands = new ArrayList();
        for (AbstractRibbonBand<?> band : bands) {
            band.setRibbonTask(this);
            this.bands.add(band);
        }
        this.resizeSequencingPolicy = new CoreRibbonResizeSequencingPolicies.RoundRobin(this);
    }

    public int getBandCount() {
        return this.bands.size();
    }

    public AbstractRibbonBand<?> getBand(int index) {
        return this.bands.get(index);
    }

    public String getTitle() {
        return this.title;
    }

    void setContextualGroup(RibbonContextualTaskGroup contextualGroup) {
        if (this.contextualGroup != null) {
            throw new IllegalStateException("The task already belongs to another contextual task group");
        }
        this.contextualGroup = contextualGroup;
    }

    public RibbonContextualTaskGroup getContextualGroup() {
        return this.contextualGroup;
    }

    public List<AbstractRibbonBand<?>> getBands() {
        return Collections.unmodifiableList(this.bands);
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.ribbon != null) {
            this.ribbon.fireStateChanged();
        }
    }

    void setRibbon(JRibbon ribbon) {
        if (this.ribbon != null) {
            throw new IllegalStateException("The task already belongs to another ribbon");
        }
        this.ribbon = ribbon;
    }

    public RibbonBandResizeSequencingPolicy getResizeSequencingPolicy() {
        return this.resizeSequencingPolicy;
    }

    public void setResizeSequencingPolicy(RibbonBandResizeSequencingPolicy resizeSequencingPolicy) {
        this.resizeSequencingPolicy = resizeSequencingPolicy;
    }

    public String getKeyTip() {
        return this.keyTip;
    }

    public void setKeyTip(String keyTip) {
        this.keyTip = keyTip;
    }

    public void setRichTooltip(RichTooltip richTooltip) {
        this.richTooltip = richTooltip;
    }

    public RichTooltip getRichTooltip() {
        return this.richTooltip;
    }
}

