/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import com.paterva.maltego.util.ui.breadcrumb.BreadCrumbBar;
import com.paterva.maltego.util.ui.breadcrumb.BreadCrumbSection;
import com.paterva.maltego.util.ui.ctxmenu.BackButton;
import com.paterva.maltego.util.ui.ctxmenu.ContextActionsPanel;
import com.paterva.maltego.util.ui.ctxmenu.PagedTreeListScrollPane;
import com.paterva.maltego.util.ui.ctxmenu.RootPagedTreeListItem;
import com.paterva.maltego.util.ui.ctxmenu.TitlePane;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import com.paterva.maltego.util.ui.search.SearchPanel;
import com.paterva.maltego.util.ui.treelist.DefaultTreeListComponentFactory;
import com.paterva.maltego.util.ui.treelist.DefaultTreeListItemRenderer;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemListener;
import com.paterva.maltego.util.ui.treelist.TreeListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PagedPopupMenu
extends JPanel {
    private static final String BREAD_CRUMB_ROOT = "Transforms";
    private final RootPagedTreeListItem _treeListRoot;
    private final BreadCrumbBar _breadCrumbBar;
    private final PagedTreeListScrollPane _scrollPane;
    private boolean _resizeScheduled = false;
    private ViewContainerListener _viewContainerListener;
    private boolean _firstUpdate = true;
    private TreeListListener _treeListListener;
    private BreadCrumbListener _breadCrumbListener;
    private final BackButton _backButton;
    private final SearchPanel _searchPanel;
    private final TreeListPanel _treeListPanel;

    public PagedPopupMenu(Action[] actions, TreeListItem treeListRoot, TextQuickFilter filter) {
        this.setLayout(new BorderLayout());
        this._treeListRoot = new RootPagedTreeListItem(treeListRoot);
        this._searchPanel = new SearchPanel(this, filter);
        this._breadCrumbBar = new BreadCrumbBar(this.createBreadCrumbSections());
        GraphicsConfiguration gfxConfig = PagedPopupMenu.getGfxConfig(MouseInfo.getPointerInfo().getLocation());
        Rectangle screenArea = PagedPopupMenu.getScreenArea(gfxConfig);
        int maxWidth = screenArea.width / 3;
        int maxHeight = screenArea.height / 3;
        this._treeListPanel = this.createTreeListPanel(maxWidth, maxHeight);
        this._scrollPane = new PagedTreeListScrollPane(this._treeListPanel, maxWidth, maxHeight);
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        JPanel actionsPanel = new JPanel(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
        LineBorder lineBorder = new LineBorder(laf.getColor("ctx-menu-actions-border"));
        actionsPanel.setBackground(laf.getColor("ctx-menu-actions-bg"));
        actionsPanel.setBorder(new CompoundBorder(lineBorder, emptyBorder));
        if (actions != null && actions.length > 0) {
            actionsPanel.add(new ContextActionsPanel(actions));
        }
        this._backButton = new BackButton();
        this._backButton.addActionListener(new BackListener());
        JPanel listWithSearchPanel = new JPanel(new BorderLayout());
        listWithSearchPanel.add((Component)this._searchPanel, "North");
        listWithSearchPanel.add((Component)this._scrollPane, "Center");
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)new TitlePane(), "North");
        listPanel.add((Component)this._backButton, "West");
        listPanel.add((Component)listWithSearchPanel, "Center");
        this.add((Component)actionsPanel, "South");
        this.add((Component)listPanel, "Center");
        this.update();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._viewContainerListener = new ViewContainerListener();
        ((Container)this._scrollPane.getViewport().getView()).addContainerListener(this._viewContainerListener);
        this.scheduleSizeUpdate();
        this._treeListListener = new TreeListListener();
        this._treeListRoot.addPropertyChangeListener(this._treeListListener);
        this._treeListRoot.addNotify();
        this._breadCrumbListener = new BreadCrumbListener();
        this._breadCrumbBar.addChangeListener(this._breadCrumbListener);
        this.requestFocus();
    }

    @Override
    public void removeNotify() {
        this.removeAll();
        super.removeNotify();
        this._breadCrumbBar.removeChangeListener(this._breadCrumbListener);
        this._breadCrumbListener = null;
        this._treeListRoot.removePropertyChangeListener(this._treeListListener);
        this._treeListRoot.removeNotify();
        this._treeListListener = null;
        ((Container)this._scrollPane.getViewport().getView()).removeContainerListener(this._viewContainerListener);
        this._viewContainerListener = null;
    }

    private void updateSize() {
        Dimension preferredSize = this._scrollPane.getPreferredSize();
        Dimension size = this._scrollPane.getSize();
        if (this._firstUpdate || !preferredSize.equals(size)) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null && window.isVisible()) {
                this._firstUpdate = false;
                if (!(window instanceof JFrame)) {
                    window.pack();
                    Rectangle windowRect = window.getBounds();
                    GraphicsConfiguration gfxConfig = PagedPopupMenu.getGfxConfig(window.getLocationOnScreen());
                    Rectangle screenRect = PagedPopupMenu.getScreenArea(gfxConfig);
                    if (windowRect.getMaxX() > screenRect.getMaxX()) {
                        windowRect.x = Math.max(screenRect.x, screenRect.x + screenRect.width - windowRect.width);
                    }
                    if (windowRect.getMaxY() > screenRect.getMaxY()) {
                        windowRect.y = Math.max(screenRect.y, screenRect.y + screenRect.height - windowRect.height);
                    }
                    if (!windowRect.equals(window.getBounds())) {
                        window.setBounds(windowRect);
                    }
                } else {
                    Container parent = this.getParent();
                    parent.setSize(preferredSize);
                    ((JComponent)parent).revalidate();
                }
                this.repaint();
            } else {
                this.scheduleSizeUpdate();
            }
        }
    }

    public static GraphicsConfiguration getGfxConfig(Point p) {
        GraphicsConfiguration gfxConfig = null;
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (!gd.getDefaultConfiguration().getBounds().contains(p)) continue;
            gfxConfig = gd.getDefaultConfiguration();
            break;
        }
        return gfxConfig;
    }

    public static Rectangle getScreenArea(GraphicsConfiguration gc) {
        Insets insets;
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (gc != null) {
            screenBounds = gc.getBounds();
            insets = toolkit.getScreenInsets(gc);
        } else {
            screenBounds = new Rectangle(toolkit.getScreenSize());
            insets = new Insets(0, 0, 0, 0);
        }
        screenBounds.x += insets.left;
        screenBounds.y += insets.top;
        screenBounds.width -= insets.left + insets.right;
        screenBounds.height -= insets.top + insets.bottom;
        return screenBounds;
    }

    private void scheduleSizeUpdate() {
        if (!this._resizeScheduled) {
            this._resizeScheduled = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PagedPopupMenu.this.updateSize();
                    PagedPopupMenu.this._resizeScheduled = false;
                }
            });
        }
    }

    private TreeListPanel createTreeListPanel(int maxWidth, int maxHeight) {
        DefaultTreeListComponentFactory factory = new DefaultTreeListComponentFactory(new ContextTreeListItemRenderer());
        TreeListItemClickListener clickListener = new TreeListItemClickListener();
        TreeListPanel panel = new TreeListPanel(this._treeListRoot, factory, clickListener);
        panel.setStretchHeightToViewport(false);
        panel.setMaximumSize(new Dimension(maxWidth, maxHeight));
        panel.setItemIndentSize(0);
        return panel;
    }

    private List<BreadCrumbSection> createBreadCrumbSections() {
        LinkedList<String> branch = this._treeListRoot.getBranch();
        ArrayList<BreadCrumbSection> sections = new ArrayList<BreadCrumbSection>(branch.size());
        sections.add(new BreadCrumbSection(BREAD_CRUMB_ROOT));
        for (String name : branch) {
            sections.add(new BreadCrumbSection(name));
        }
        return sections;
    }

    private void update() {
        this._breadCrumbBar.setSections(this.createBreadCrumbSections());
        LinkedList<String> branch = this._treeListRoot.getBranch();
        this._backButton.setEnabled(!branch.isEmpty());
        this._backButton.setSection(branch.isEmpty() ? BREAD_CRUMB_ROOT : this._treeListRoot.getBranchDisplayName(branch.getLast()));
    }

    class ContextTreeListItemRenderer
    extends DefaultTreeListItemRenderer {
        ContextTreeListItemRenderer() {
        }

        @Override
        protected String getLafKey(TreeListItem item, String attribute) {
            return super.getLafKey(item, attribute) + "-ctx";
        }

        @Override
        public void paintBackground(TreeListItem item, Graphics2D g2D, int widht, int height, boolean hovered) {
            this.paintBackground(item, g2D, widht, height, hovered, true);
        }

        @Override
        public void paintBorder(TreeListItem item, Graphics2D g2D, int widht, int height, boolean hovered) {
            this.paintBackground(item, g2D, widht, height, hovered, true);
        }
    }

    private class BreadCrumbListener
    implements ChangeListener {
        private BreadCrumbListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            List<BreadCrumbSection> sections = PagedPopupMenu.this._breadCrumbBar.getSections();
            int count = PagedPopupMenu.this._treeListRoot.getBranch().size() - (sections.size() - 1);
            PagedPopupMenu.this._treeListRoot.doBack(count);
        }
    }

    private class TreeListListener
    implements PropertyChangeListener {
        private TreeListListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PagedPopupMenu.this.update();
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PagedPopupMenu.this._treeListRoot.doBack();
        }
    }

    private class ViewContainerListener
    implements ContainerListener {
        private ViewContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            PagedPopupMenu.this.scheduleSizeUpdate();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            PagedPopupMenu.this.scheduleSizeUpdate();
        }
    }

    private class TreeListItemClickListener
    implements TreeListItemListener {
        private TreeListItemClickListener() {
        }

        @Override
        public boolean onClicked(TreeListItem item, MouseEvent e) {
            PagedPopupMenu.this._treeListRoot.onClicked(item, e);
            return true;
        }
    }
}

