/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.script;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.view.customization.ui.script.ReadonlyLink;
import com.paterva.maltego.view.customization.ui.script.ReadonlyPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.openide.util.Exceptions;
import yguard.A.A.D;

public class ReadonlyEntity
extends ReadonlyPart<EntityID, MaltegoEntity> {
    ReadonlyEntity(GraphID graphID, EntityID id, GraphWrapper wrapper) {
        super(graphID, id, wrapper, (SpecRegistry)EntityRegistry.forGraph((D)wrapper.getGraph()));
    }

    @Override
    public boolean isCollection() {
        return this.getWrapper().isCollectionNode((EntityID)this.getPartID());
    }

    @Override
    protected MaltegoEntity getPart() {
        return this.getWrapper().getEntity((EntityID)this.getPartID());
    }

    @Override
    protected String getCollectionType() {
        String typeName = null;
        try {
            Set<EntityID> modelEntities = this.getModelEntities();
            EntityID entity = modelEntities.iterator().next();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this.getGraphID());
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            typeName = dataReader.getEntityType(entity);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return typeName;
    }

    public int getWeight() {
        int weight = 0;
        try {
            weight = this.isCollection() ? this.getModelEntities().size() : this.getPart().getWeight();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return weight;
    }

    public int linksIn() {
        int count = 0;
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this.getGraphID());
            GraphStructureReader viewStructureReader = view.getGraphStructureStore().getStructureReader();
            Set viewLinks = viewStructureReader.getIncoming((EntityID)this.getPartID());
            GraphModelViewMappings mappings = view.getModelViewMappings();
            count = mappings.getModelLinks((Collection)viewLinks).size();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return count;
    }

    public int linksOut() {
        int count = 0;
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this.getGraphID());
            GraphStructureReader viewStructureReader = view.getGraphStructureStore().getStructureReader();
            Set viewLinks = viewStructureReader.getOutgoing((EntityID)this.getPartID());
            GraphModelViewMappings mappings = view.getModelViewMappings();
            count = mappings.getModelLinks((Collection)viewLinks).size();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return count;
    }

    public int linksAll() {
        return this.linksIn() + this.linksOut();
    }

    public ReadonlyLink[] incoming() {
        return this.getReadonlyLinks(this.getWrapper().incomingIDs((EntityID)this.getPartID()));
    }

    public ReadonlyLink[] outgoing() {
        return this.getReadonlyLinks(this.getWrapper().outgoingIDs((EntityID)this.getPartID()));
    }

    public ReadonlyLink[] links() {
        return this.getReadonlyLinks(this.getWrapper().linkIDs((EntityID)this.getPartID()));
    }

    private ReadonlyLink[] getReadonlyLinks(Iterable<LinkID> linkIDs) {
        ArrayList<ReadonlyLink> readonlyLinks = new ArrayList<ReadonlyLink>();
        for (LinkID linkID : linkIDs) {
            readonlyLinks.add(new ReadonlyLink(this.getGraphID(), linkID, this.getWrapper()));
        }
        return readonlyLinks.toArray(new ReadonlyLink[readonlyLinks.size()]);
    }

    private Set<EntityID> getModelEntities() throws GraphStoreException {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this.getGraphID());
        GraphModelViewMappings mappings = view.getModelViewMappings();
        Set modelEntities = mappings.getModelEntities((EntityID)this.getPartID());
        return modelEntities;
    }
}

