/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.files;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.file.FileOperationFactory;
import com.paterva.maltego.chatapi.file.FileTransferController;
import com.paterva.maltego.chatapi.file.send.FileSendOperation;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class SendFileAction
extends SystemAction {
    public SendFileAction() {
        final ChatRoomTopComponentRegistry registry = ChatRoomTopComponentRegistry.getDefault();
        registry.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChatRoom chatRoom = registry.getActiveChatRoom();
                SendFileAction.this.setEnabled(chatRoom != null);
            }
        });
    }

    public String getName() {
        return "Send File";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ev) {
        FileTransferController fileTransferController;
        ChatRoom chatRoom = ChatRoomTopComponentRegistry.getDefault().getActiveChatRoom();
        if (chatRoom != null && (fileTransferController = chatRoom.getFileTransferController()) != null) {
            FileChooserBuilder builder = new FileChooserBuilder(SendFileAction.class);
            builder.setApproveText("Send");
            builder.setFilesOnly(true);
            File file = builder.showOpenDialog();
            if (file != null) {
                FileSendOperation fileSendOperation = FileOperationFactory.getDefault().createSendOperation(chatRoom, file);
                fileTransferController.startSendFile(fileSendOperation);
            }
        }
    }
}

