/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews.list;

import com.paterva.maltego.runregistry.item.RunCategoryItem;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunnableItem;
import com.paterva.maltego.runviews.list.ContextRunAction;
import com.paterva.maltego.runviews.list.ContextSettingsAction;
import com.paterva.maltego.runviews.list.ToolbarFavoriteAction;
import com.paterva.maltego.runviews.list.ToolbarRunAction;
import com.paterva.maltego.runviews.list.ToolbarRunAllAction;
import com.paterva.maltego.runviews.list.ToolbarShowConfigAction;
import com.paterva.maltego.runviews.list.ToolbarShowHelpAction;
import com.paterva.maltego.runviews.list.ToolbarShowSettingsAction;
import com.paterva.maltego.util.ui.treelist.AbstractTreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.openide.util.Utilities;

class RunProviderTreeListItem
extends AbstractTreeListItem {
    private static final Logger LOG = Logger.getLogger(RunProviderTreeListItem.class.getName());
    private RunProviderItem _item;
    private PropertyChangeListener _itemListener;

    public RunProviderTreeListItem(TreeListItem parent, RunProviderItem item, int depth) {
        super(parent, item.getName(), depth, item.isExpandedByDefault());
        this._item = item;
    }

    public void addNotify() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "addNotify {0} {1}", new Object[]{this, this.getName()});
        }
        if (this._itemListener == null) {
            this._itemListener = new ItemChangeListener();
            this._item.addPropertyChangeListener(this._itemListener);
        }
    }

    public void removeNotify() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "removeNotify {0} {1}", new Object[]{this, this.getName()});
        }
        if (this._itemListener != null) {
            this._item.removePropertyChangeListener(this._itemListener);
            this._itemListener = null;
        }
    }

    public void setItem(RunProviderItem item) {
        this._item = item;
    }

    public RunProviderItem getItem() {
        return this._item;
    }

    public String getDisplayName() {
        return this._item.getDisplayName();
    }

    public String getDescription() {
        return this._item.getDescription();
    }

    public Icon getIcon() {
        return this._item.getIcon();
    }

    public String getLafPrefix() {
        return this._item.getLafPrefix();
    }

    public boolean isRemeberPage() {
        return this._item.isRememberPage();
    }

    public Action getDefaultAction() {
        AbstractAction action = null;
        if (!(this._item instanceof RunCategoryItem)) {
            if (this._item instanceof RunnableItem) {
                RunnableItem runnable = (RunnableItem)this._item;
                if (runnable.canRun()) {
                    action = new ToolbarRunAction(runnable);
                }
            } else {
                action = new DoNothingAction();
            }
        }
        return action;
    }

    public List<Action> getContextActions() {
        ArrayList<Action> wrappedActions = new ArrayList<Action>();
        if (this._item instanceof RunnableItem) {
            RunnableItem runnableItem = (RunnableItem)this._item;
            if (runnableItem.canRun()) {
                wrappedActions.add(new WrappedAction(ContextRunAction.getInstance()));
            }
            if (runnableItem.hasSettings()) {
                wrappedActions.add(new WrappedAction(ContextSettingsAction.getInstance()));
            }
        }
        for (Action action : this._item.getContextActions()) {
            wrappedActions.add(new WrappedAction(action));
        }
        return wrappedActions;
    }

    public List<Action> getToolbarActions() {
        ArrayList<AbstractAction> actions = this._item.getToolbarActions();
        if (this._item instanceof RunnableItem) {
            RunnableItem runnable = (RunnableItem)this._item;
            actions = new ArrayList<AbstractAction>(this._item.getToolbarActions());
            if (runnable.canRun()) {
                if (runnable instanceof RunCategoryItem) {
                    actions.add(new ToolbarRunAllAction((RunCategoryItem)runnable));
                } else {
                    actions.add(new ToolbarRunAction(runnable));
                }
            }
            if (runnable.hasSettings()) {
                actions.add(new ToolbarShowSettingsAction(runnable));
            }
            if (runnable.hasConfig()) {
                actions.add(new ToolbarShowConfigAction(runnable));
            }
            if (runnable.hasHelp()) {
                actions.add(new ToolbarShowHelpAction(runnable));
            }
            if (runnable.canFavorite()) {
                actions.add(new ToolbarFavoriteAction(runnable));
            }
        }
        return actions;
    }

    public String toString() {
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.getDepth(); ++i) {
                sb.append("  ");
            }
            sb.append(this.getName());
            sb.append(": ");
            sb.append(this.getDisplayName());
            sb.append(" (");
            sb.append(this._item.getClass());
            sb.append(")");
            sb.append("\n");
            for (TreeListItem item : this.getChildren()) {
                sb.append(item);
            }
            return sb.toString();
        }
        return super.toString();
    }

    private static class DoNothingAction
    extends AbstractAction {
        private DoNothingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ItemChangeListener
    implements PropertyChangeListener {
        private ItemChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunProviderTreeListItem item = RunProviderTreeListItem.this;
            RunProviderTreeListItem.this.fireChanged((TreeListItem)item, -1, RunProviderTreeListItem.this.getListIndex((TreeListItem)item));
        }
    }

    private static class WrappedAction
    extends AbstractAction {
        private final Action _action;

        public WrappedAction(Action action) {
            this((String)action.getValue("Name"), action);
        }

        public WrappedAction(String name, Action action) {
            super(name);
            this._action = action;
        }

        @Override
        public Object getValue(String key) {
            return this._action.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List treeItems = (List)e.getSource();
            ArrayList<RunProviderItem> runItems = new ArrayList<RunProviderItem>();
            for (TreeListItem treeListItem : treeItems) {
                RunProviderItem runItem = ((RunProviderTreeListItem)treeListItem).getItem();
                runItems.add(runItem);
            }
            e.setSource(runItems);
            this._action.actionPerformed(e);
        }

        public int hashCode() {
            return this._action.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof WrappedAction) {
                return Utilities.compareObjects((Object)this._action, (Object)((WrappedAction)obj)._action);
            }
            return false;
        }
    }
}

