/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import com.paterva.maltego.util.IconSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import org.openide.util.ImageUtilities;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

class DiscreteResizableIcon
implements ResizableIcon {
    private String _iconBase;
    private int _size;
    private Icon _delegate;
    private static final int ICON_SIZE_TINY_16 = IconSize.TINY.getSize();
    private static final int[] SIZES = new int[]{ICON_SIZE_TINY_16, IconSize.SMALL.getSize(), IconSize.MEDIUM.getSize(), IconSize.LARGE.getSize(), 64, 72, 128, 256};

    public DiscreteResizableIcon(String iconBase) {
        this._iconBase = iconBase;
    }

    public void setDimension(Dimension newDimension) {
        this.setSize(newDimension.height);
    }

    protected void setSize(int size) {
        if (this._size != size) {
            IconSizePair pair = this.findBestMatch(size);
            this._delegate = pair.icon;
            this._size = pair.size;
        }
    }

    public int getIconHeight() {
        return this._size;
    }

    public int getIconWidth() {
        return this._size;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this._delegate != null) {
            this._delegate.paintIcon(c, g, x, y);
        } else {
            g.setColor(Color.red);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        }
    }

    private IconSizePair findBestMatch(int size) {
        int index = DiscreteResizableIcon.findClosestIndex(size);
        int realSize = DiscreteResizableIcon.getSize(index);
        Icon icon = this.getIcon(realSize);
        while (icon == null && index >= 0) {
            realSize = DiscreteResizableIcon.getSize(--index);
            icon = this.getIcon(realSize);
        }
        return new IconSizePair(realSize, icon);
    }

    private Icon getIcon(int size) {
        if (size == ICON_SIZE_TINY_16) {
            return ImageUtilities.loadImageIcon((String)this._iconBase, (boolean)true);
        }
        return ImageUtilities.loadImageIcon((String)DiscreteResizableIcon.insertBeforeSuffix(this._iconBase, size), (boolean)true);
    }

    public static String insertBeforeSuffix(String path, int size) {
        String withoutSuffix = path;
        String suffix = "";
        if (path.lastIndexOf(46) >= 0) {
            withoutSuffix = path.substring(0, path.lastIndexOf(46));
            suffix = path.substring(path.lastIndexOf(46), path.length());
        }
        return withoutSuffix + size + suffix;
    }

    private static int findClosestIndex(int size) {
        for (int i = 0; i < SIZES.length; ++i) {
            int currentSize = DiscreteResizableIcon.getSize(i);
            if (currentSize == size) {
                return i;
            }
            if (currentSize <= size) continue;
            return i - 1;
        }
        return 0;
    }

    private static int getSize(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > SIZES.length - 1) {
            index = SIZES.length - 1;
        }
        return SIZES[index];
    }

    private static class IconSizePair {
        public int size;
        public Icon icon;

        public IconSizePair(int size, Icon icon) {
            this.size = size;
            this.icon = icon;
        }
    }
}

