/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphFreezableRegistry;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformResultHandler;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.impl.TransformBatchResult;
import com.paterva.maltego.transform.runner.api.impl.TransformResultBatcher;
import com.paterva.maltego.util.Args;

public class DefaultTransformResultHandler
extends TransformResultHandler {
    @Override
    public void updateGraph(TransformRunContext ctx, TransformResult result) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull((Object)result, (String)"result");
        boolean transformComplete = result.transformComplete();
        this.handleGraphUpdate(ctx, result);
        if (transformComplete) {
            this.fireTransformsFinished(ctx);
        }
    }

    protected void handleGraphUpdate(TransformRunContext ctx, TransformResult result) {
        GraphID targetGraphID = ctx.getTargetGraphID();
        int entityCount = result.getEntityCount();
        ctx.incrementOutputEntityCount(entityCount);
        TransformResultBatcher batcher = (TransformResultBatcher)GraphFreezableRegistry.getDefault().forGraph(targetGraphID);
        TransformBatchResult batchResult = new TransformBatchResult(ctx, result);
        batcher.addTransformBatchResult(batchResult);
    }
}

