/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.merging;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.merging.MergeUtils;

public abstract class PartMergeStrategy {
    public static final PartMergeStrategy KeepOriginal = new KeepOriginal();
    public static final PartMergeStrategy PreferOriginal = new PreferOriginal();
    public static final PartMergeStrategy PreferNew = new PreferNew();
    public static final PartMergeStrategy Replace = new Replace();
    public static final PartMergeStrategy Update = new Update();
    public static final PartMergeStrategy AddProperties = new AddProperties();
    public static final PartMergeStrategy DeleteProperties = new DeleteProperties();
    public static final PartMergeStrategy UpdateWithoutProperties = new UpdateWithoutProperties();

    public abstract MaltegoPart merge(MaltegoPart var1, MaltegoPart var2);

    private static class DeleteProperties
    extends PartMergeStrategy {
        private DeleteProperties() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart part, MaltegoPart update) {
            MergeUtils.removeProperties(part, update);
            return part;
        }
    }

    private static class AddProperties
    extends PartMergeStrategy {
        private AddProperties() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart part, MaltegoPart update) {
            MergeUtils.removeProperties(part, update);
            MergeUtils.addMissingProperties(part, update);
            MergeUtils.replacePropertyValues(part, update, false);
            return part;
        }
    }

    private static class UpdateWithoutProperties
    extends Update {
        private UpdateWithoutProperties() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart part, MaltegoPart update) {
            this.updateTypeName(part, update);
            this.updateOther(part, update);
            return part;
        }
    }

    private static class Update
    extends PartMergeStrategy {
        private Update() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart part, MaltegoPart update) {
            this.updateTypeName(part, update);
            MergeUtils.addMissingProperties(part, update);
            MergeUtils.replacePropertyValues(part, update, false);
            MergeUtils.updateSpecialPropertyMapping(part, update);
            MergeUtils.mergeOverlays(part, update);
            this.updateOther(part, update);
            return part;
        }

        protected void updateTypeName(MaltegoPart part, MaltegoPart update) {
            if (update.getTypeName() != null) {
                part.setTypeName(update.getTypeName());
            }
        }

        protected void updateOther(MaltegoPart part, MaltegoPart update) {
            Integer bookmark;
            Boolean showNotes;
            String notes;
            DisplayInformationCollection displayInfo = update.getDisplayInformation();
            if (displayInfo != null) {
                MergeUtils.replaceDisplayInformation(part, update);
            }
            if ((notes = update.getNotes()) != null) {
                part.setNotes(notes);
            }
            if ((showNotes = update.isShowNotesValue()) != null) {
                part.setShowNotes(showNotes);
            }
            if ((bookmark = update.getBookmarkValue()) != null) {
                part.setBookmark(bookmark);
            }
            if (part instanceof MaltegoEntity && update instanceof MaltegoEntity) {
                MaltegoEntity destEntity = (MaltegoEntity)part;
                MaltegoEntity srcEntity = (MaltegoEntity)update;
                srcEntity.getWeightValue().ifPresent(arg_0 -> ((MaltegoEntity)destEntity).setWeight(arg_0));
            } else if (part instanceof MaltegoLink && update instanceof MaltegoLink) {
                MaltegoLink destLink = (MaltegoLink)part;
                MaltegoLink srcLink = (MaltegoLink)update;
                Boolean reversed = srcLink.isReversed();
                if (reversed != null) {
                    destLink.setReversed(reversed);
                }
            }
        }
    }

    private static class Replace
    extends PartMergeStrategy {
        private Replace() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart dest, MaltegoPart src) {
            dest.setTypeName(src.getTypeName());
            MergeUtils.replaceProperties(dest, src);
            MergeUtils.replaceOverlays(dest, src);
            MergeUtils.replacePropertyValues(dest, src, false);
            MergeUtils.copySpecialPropertyMapping(dest, src, true);
            MergeUtils.replaceDisplayInformation(dest, src);
            dest.setNotes(src.getNotes());
            dest.setShowNotes(src.isShowNotesValue());
            dest.setBookmark(Integer.valueOf(src.getBookmark()));
            if (dest instanceof MaltegoEntity && src instanceof MaltegoEntity) {
                MaltegoEntity destEntity = (MaltegoEntity)dest;
                MaltegoEntity srcEntity = (MaltegoEntity)src;
                destEntity.setWeight((Integer)srcEntity.getWeightValue().orElse(null));
            } else if (dest instanceof MaltegoLink && src instanceof MaltegoLink) {
                MaltegoLink destLink = (MaltegoLink)dest;
                MaltegoLink srcLink = (MaltegoLink)src;
                destLink.setReversed(srcLink.isReversed());
            }
            return dest;
        }
    }

    private static class PreferNew
    extends PartMergeStrategy {
        private PreferNew() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart dest, MaltegoPart src) {
            MergeUtils.addMissingProperties(dest, src);
            MergeUtils.mergePropertyValues(dest, src, true);
            MergeUtils.mergeSpecialPropertyMapping(dest, src, true);
            MergeUtils.mergeDisplayInformation(dest, src, true);
            MergeUtils.mergeNotes(dest, src, true);
            MergeUtils.mergeWeight(dest, src);
            MergeUtils.mergeReversed(dest, src, true);
            MergeUtils.mergeOverlays(dest, src);
            if (src.getBookmarkValue() != null) {
                dest.setBookmark(Integer.valueOf(src.getBookmark()));
            }
            return dest;
        }
    }

    private static class PreferOriginal
    extends PartMergeStrategy {
        private PreferOriginal() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart dest, MaltegoPart src) {
            MergeUtils.addMissingProperties(dest, src);
            MergeUtils.mergePropertyValues(dest, src, false);
            MergeUtils.mergeSpecialPropertyMapping(dest, src, false);
            MergeUtils.mergeDisplayInformation(dest, src, false);
            MergeUtils.mergeNotes(dest, src, false);
            MergeUtils.mergeWeight(dest, src);
            MergeUtils.mergeReversed(dest, src, false);
            return dest;
        }
    }

    private static class KeepOriginal
    extends PartMergeStrategy {
        private KeepOriginal() {
        }

        @Override
        public MaltegoPart merge(MaltegoPart dest, MaltegoPart src) {
            return dest;
        }
    }
}

