/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics;

import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.logging.Logger;

public class AnalyticsSession {
    private static final Logger LOG = Logger.getLogger(AnalyticsSession.class.getName());
    private static final int SESSION_DURATION_MILLIS = 1800000;
    private static long sessionId = -1L;
    private static long lastActiveEvent;
    private static final AWTEventListener awtListener;

    public static void init() {
        Toolkit.getDefaultToolkit().addAWTEventListener(awtListener, 24L);
    }

    public static long getSessionId() {
        if (sessionId < 0L) {
            LOG.info("New analytics session started");
            sessionId = System.currentTimeMillis();
        }
        return sessionId;
    }

    public static void reset() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(awtListener);
    }

    static {
        awtListener = event -> {
            boolean eventToOmit;
            boolean bl = eventToOmit = event.getID() == 504 || event.getID() == 505;
            if (!eventToOmit) {
                long eventTime = System.currentTimeMillis();
                if (eventTime - lastActiveEvent > 1800000L) {
                    sessionId = -1L;
                }
                lastActiveEvent = eventTime;
            }
        };
    }
}

