/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store;

import com.paterva.graph.store.memory.InMemoryGraphStore;
import com.paterva.graph.store.pandora.PandoraGraphStore;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.AbstractGraphStore;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreFactory;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;

public class DefaultGraphStoreFactory
extends GraphStoreFactory {
    public GraphStore create(GraphID graphID, boolean inMemory) throws GraphStoreException {
        if (graphID == null) {
            throw new IllegalArgumentException("Graph ID may not be null");
        }
        try {
            AbstractGraphStore graphStore = inMemory ? new InMemoryGraphStore(graphID) : new PandoraGraphStore(graphID);
            GraphStoreRegistry.getDefault().register(graphID, (GraphStore)graphStore);
            return graphStore;
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not create graph store for id: " + graphID, (Throwable)ex);
        }
    }
}

