<!-- Please use this template (unless you have a very good reason not to). PRs that do not use the template may be closed. -->

## Description

_A description of the change, what it does, and why it was made. If relevant (e.g. UI changes), **please also provide screenshots/recordings**:_

## Issue

_If applicable, what issue does this address?_

Closes: #<issue-number>

## Testing

_If relevant, please state how this was tested (including steps):_

_If this change affects the program, please also indicate which platforms were tested:_

- [ ] _Windows_
- [ ] _macOS (specify version below)_
- [ ] _Linux (specify distro below)_
- [ ] _Other (specify below)_

## Checklist

_Ensure **all** of these are met:_

- [ ] _If this is a code change, areas your change affects have been linted using (`cargo fmt`)_
- [ ] _If this is a code change, your changes pass `cargo clippy --all -- -D warnings`_
- [ ] _If this is a code change, new tests were added if relevant_
- [ ] _If this is a code change, your changes pass `cargo test`_
- [ ] _The change has been tested to work (see above) and doesn't appear to break other things_
- [ ] _Documentation has been updated if needed (`README.md`, help menu, docs, configs, etc.)_
- [ ] _There are no merge conflicts_
- [ ] _You have reviewed the changes first_
- [ ] _The pull request passes the provided CI pipeline_

## Other

_Anything else that maintainers should know about this PR:_
