/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef ITKTEMPLATES_IMAGESOURCE_H
#define ITKTEMPLATES_IMAGESOURCE_H

#include <ItkTemplatesAPI.h>
#include <itkImageSource.h>

extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<bool, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<bool, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<double, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<double, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<float, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<float, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<int, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<int, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::CovariantVector<double, 2u>, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::CovariantVector<double, 3u>, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::Vector<double, 1u>, 1u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::Vector<double, 2u>, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::Vector<double, 3u>, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::Vector<float, 1u>, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::Vector<float, 2u>, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<itk::Vector<float, 3u>, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<long, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<long, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<long long, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<long long, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<short, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<short, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<signed char, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<signed char, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<std::complex<double>, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<std::complex<double>, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<std::complex<float>, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<std::complex<float>, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned char, 1u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned char, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned char, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned int, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned int, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned long, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned long, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned long long, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned long long, 3u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned short, 2u>>;
extern template class ITKTEMPLATES_API itk::ImageSource<itk::Image<unsigned short, 3u>>;

#endif // ITKTEMPLATES_IMAGESOURCE_H