/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package internalfakes

import (
	"sync"
)

type FakeImpl struct {
	LookupEnvStub        func(string) (string, bool)
	lookupEnvMutex       sync.RWMutex
	lookupEnvArgsForCall []struct {
		arg1 string
	}
	lookupEnvReturns struct {
		result1 string
		result2 bool
	}
	lookupEnvReturnsOnCall map[int]struct {
		result1 string
		result2 bool
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeImpl) LookupEnv(arg1 string) (string, bool) {
	fake.lookupEnvMutex.Lock()
	ret, specificReturn := fake.lookupEnvReturnsOnCall[len(fake.lookupEnvArgsForCall)]
	fake.lookupEnvArgsForCall = append(fake.lookupEnvArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.LookupEnvStub
	fakeReturns := fake.lookupEnvReturns
	fake.recordInvocation("LookupEnv", []interface{}{arg1})
	fake.lookupEnvMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) LookupEnvCallCount() int {
	fake.lookupEnvMutex.RLock()
	defer fake.lookupEnvMutex.RUnlock()
	return len(fake.lookupEnvArgsForCall)
}

func (fake *FakeImpl) LookupEnvCalls(stub func(string) (string, bool)) {
	fake.lookupEnvMutex.Lock()
	defer fake.lookupEnvMutex.Unlock()
	fake.LookupEnvStub = stub
}

func (fake *FakeImpl) LookupEnvArgsForCall(i int) string {
	fake.lookupEnvMutex.RLock()
	defer fake.lookupEnvMutex.RUnlock()
	argsForCall := fake.lookupEnvArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) LookupEnvReturns(result1 string, result2 bool) {
	fake.lookupEnvMutex.Lock()
	defer fake.lookupEnvMutex.Unlock()
	fake.LookupEnvStub = nil
	fake.lookupEnvReturns = struct {
		result1 string
		result2 bool
	}{result1, result2}
}

func (fake *FakeImpl) LookupEnvReturnsOnCall(i int, result1 string, result2 bool) {
	fake.lookupEnvMutex.Lock()
	defer fake.lookupEnvMutex.Unlock()
	fake.LookupEnvStub = nil
	if fake.lookupEnvReturnsOnCall == nil {
		fake.lookupEnvReturnsOnCall = make(map[int]struct {
			result1 string
			result2 bool
		})
	}
	fake.lookupEnvReturnsOnCall[i] = struct {
		result1 string
		result2 bool
	}{result1, result2}
}

func (fake *FakeImpl) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.lookupEnvMutex.RLock()
	defer fake.lookupEnvMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeImpl) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
