# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.confidentialledger import ConfidentialLedger

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestConfidentialLedgerLedgerOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ConfidentialLedger)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_get(self, resource_group):
        response = self.client.ledger.get(
            resource_group_name=resource_group.name,
            ledger_name="str",
            api_version="2024-09-19-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_begin_delete(self, resource_group):
        response = self.client.ledger.begin_delete(
            resource_group_name=resource_group.name,
            ledger_name="str",
            api_version="2024-09-19-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_begin_create(self, resource_group):
        response = self.client.ledger.begin_create(
            resource_group_name=resource_group.name,
            ledger_name="str",
            confidential_ledger={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "aadBasedSecurityPrincipals": [{"ledgerRoleName": "str", "principalId": "str", "tenantId": "str"}],
                    "applicationType": "str",
                    "certBasedSecurityPrincipals": [{"cert": "str", "ledgerRoleName": "str"}],
                    "enclavePlatform": "str",
                    "hostLevel": "str",
                    "identityServiceUri": "str",
                    "ledgerInternalNamespace": "str",
                    "ledgerName": "str",
                    "ledgerSku": "str",
                    "ledgerType": "str",
                    "ledgerUri": "str",
                    "maxBodySizeInMb": 0,
                    "nodeCount": 0,
                    "provisioningState": "str",
                    "runningState": "str",
                    "subjectName": "str",
                    "workerThreads": 0,
                    "writeLBAddressPrefix": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-09-19-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_begin_update(self, resource_group):
        response = self.client.ledger.begin_update(
            resource_group_name=resource_group.name,
            ledger_name="str",
            confidential_ledger={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "aadBasedSecurityPrincipals": [{"ledgerRoleName": "str", "principalId": "str", "tenantId": "str"}],
                    "applicationType": "str",
                    "certBasedSecurityPrincipals": [{"cert": "str", "ledgerRoleName": "str"}],
                    "enclavePlatform": "str",
                    "hostLevel": "str",
                    "identityServiceUri": "str",
                    "ledgerInternalNamespace": "str",
                    "ledgerName": "str",
                    "ledgerSku": "str",
                    "ledgerType": "str",
                    "ledgerUri": "str",
                    "maxBodySizeInMb": 0,
                    "nodeCount": 0,
                    "provisioningState": "str",
                    "runningState": "str",
                    "subjectName": "str",
                    "workerThreads": 0,
                    "writeLBAddressPrefix": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-09-19-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_list_by_resource_group(self, resource_group):
        response = self.client.ledger.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-09-19-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_list_by_subscription(self, resource_group):
        response = self.client.ledger.list_by_subscription(
            api_version="2024-09-19-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_begin_backup(self, resource_group):
        response = self.client.ledger.begin_backup(
            resource_group_name=resource_group.name,
            ledger_name="str",
            confidential_ledger={"uri": "str", "restoreRegion": "str"},
            api_version="2024-09-19-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ledger_begin_restore(self, resource_group):
        response = self.client.ledger.begin_restore(
            resource_group_name=resource_group.name,
            ledger_name="str",
            confidential_ledger={"fileShareName": "str", "restoreRegion": "str", "uri": "str"},
            api_version="2024-09-19-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
