# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.serialization import Deserializer, Serializer
from ...operations._operations import build_decompile_operation_group_bicep_request
from .._configuration import BicepMgmtClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DecompileOperationGroupOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.resource.bicep.aio.BicepMgmtClient`'s
        :attr:`decompile_operation_group` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BicepMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def bicep(
        self,
        decompile_operation_request: _models.DecompileOperationRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DecompileOperationSuccessResponse:
        """Decompiles an ARM json template into a Bicep template.

        :param decompile_operation_request: The request body. Required.
        :type decompile_operation_request: ~azure.mgmt.resource.bicep.models.DecompileOperationRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DecompileOperationSuccessResponse. The DecompileOperationSuccessResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.resource.bicep.models.DecompileOperationSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def bicep(
        self, decompile_operation_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DecompileOperationSuccessResponse:
        """Decompiles an ARM json template into a Bicep template.

        :param decompile_operation_request: The request body. Required.
        :type decompile_operation_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DecompileOperationSuccessResponse. The DecompileOperationSuccessResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.resource.bicep.models.DecompileOperationSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def bicep(
        self, decompile_operation_request: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DecompileOperationSuccessResponse:
        """Decompiles an ARM json template into a Bicep template.

        :param decompile_operation_request: The request body. Required.
        :type decompile_operation_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DecompileOperationSuccessResponse. The DecompileOperationSuccessResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.resource.bicep.models.DecompileOperationSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def bicep(
        self, decompile_operation_request: Union[_models.DecompileOperationRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.DecompileOperationSuccessResponse:
        """Decompiles an ARM json template into a Bicep template.

        :param decompile_operation_request: The request body. Is one of the following types:
         DecompileOperationRequest, JSON, IO[bytes] Required.
        :type decompile_operation_request: ~azure.mgmt.resource.bicep.models.DecompileOperationRequest
         or JSON or IO[bytes]
        :return: DecompileOperationSuccessResponse. The DecompileOperationSuccessResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.resource.bicep.models.DecompileOperationSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DecompileOperationSuccessResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(decompile_operation_request, (IOBase, bytes)):
            _content = decompile_operation_request
        else:
            _content = json.dumps(decompile_operation_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_decompile_operation_group_bicep_request(
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DecompileOperationSuccessResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
