## roxygen documentation for data objects

#' Spider data from CANOCO, long format
#' 
#' data from spider2 directory, CANOCO FORTRAN package, with trait
#' variables added; taken from the \code{mvabund} package and converted to long form. Variables:
#' \itemize{
#' \item soil.dry
#' \item bare.sand
#' \item fallen.leaves
#' \item moss
#' \item herb.layer
#' \item reflection 
#' \item id
#' \item Species
#' \item abund
#' }
#' @name spider_long
#' @docType data
#' @keywords data

#' @references
#' \itemize{
#'   \item ter Braak, C. J. F. and Smilauer, P. (1998) CANOCO reference manual and user's guide to CANOCO for Windows: software for canonical community ordination (version 4). Microcomputer Power, New York, New York, USA
#'   \item van der Aart, P. J. M., and Smeenk-Enserink, N. (1975) Correlations between distributions of hunting spiders (Lycosidae, Ctenidae) and environmental characteristics in a dune area. Netherlands Journal of Zoology 25, 1-45.
#' } 
"spider_long"

