% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.R
\name{rc_new_token}
\alias{rc_new_token}
\title{Request a new token for submissions to the R Consortium runners}
\usage{
rc_new_token(email = NULL, token = NULL)
}
\arguments{
\item{email}{Email address to verify We try to detect this, but
if the detection fails, you can specify it explicitly.
If this argument is missing (or \code{NULL}), then you can specify it
interactively.}

\item{token}{Token to add. If you already received a token in an email
from R-hub, you can specify that here.}
}
\description{
To build and check R packages on the RC runners of R-hub, you'll need
to verify your email address. R-hub will send a token to your email
address, and this token will be stored on your computer.
}
\details{
You need to store a token on every computer you want to submit
jobs from, either using the same token from the email you got, or
you can request additional tokens for the new machines. Your old token
will stay valid as well.

If you already have a token from a previous version of R-hub, you can
reuse that and you don't need to do anything.

Run

\if{html}{\out{<div class="sourceCode">}}\preformatted{rhub:::email_file()
}\if{html}{\out{</div>}}

to see the file rhub uses to store your tokens.
}
\seealso{
Other RC runners API: 
\code{\link{rc_list_local_tokens}()},
\code{\link{rc_list_repos}()},
\code{\link{rc_submit}()}
}
\concept{RC runners API}
