include(FindPkgConfig)

pkg_check_modules(GLIB glib-2.0 REQUIRED)
pkg_check_modules(GOBJECT gobject-2.0 REQUIRED)
pkg_check_modules(GSTREAMER gstreamer-1.0 REQUIRED)
pkg_check_modules(GSTREAMER_BASE gstreamer-base-1.0 REQUIRED)
pkg_check_modules(GSTREAMER_BASE_APP gstreamer-app-1.0 REQUIRED)
pkg_check_modules(ZLIB REQUIRED zlib REQUIRED)
pkg_check_modules(TAGLIB REQUIRED taglib REQUIRED)
pkg_check_modules(GIO gio-2.0 REQUIRED)

# in order to choose another qt installation set CMAKE_PREFIX_PATH
find_package(Qt5 5.8 COMPONENTS Core Widgets Sql Network DBus Xml Svg Test REQUIRED)
find_package(Qt5LinguistTools REQUIRED)

include_directories(${Qt5Core_INCLUDE_DIRS})
include_directories(${Qt5Widgets_INCLUDE_DIRS})
include_directories(${Qt5Xml_INCLUDE_DIRS})
include_directories(${Qt5Sql_INCLUDE_DIRS})
include_directories(${Qt5DBus_INCLUDE_DIRS})
include_directories(${Qt5Network_INCLUDE_DIRS})
include_directories(${Qt5Svg_INCLUDE_DIRS})
include_directories(${GLIB_INCLUDE_DIRS})
include_directories(${GOBJECT_INCLUDE_DIRS})
include_directories(${GSTREAMER_INCLUDE_DIRS})
include_directories(${GSTREAMER_BASE_INCLUDE_DIRS})
include_directories(${GSTREAMER_BASE_APP_INCLUDE_DIRS})
include_directories(${TAGLIB_INCLUDE_DIRS})
include_directories(${ZLIB_INCLUDE_DIRS})

add_definitions(${Qt5Core_DEFINITIONS})
add_definitions(${QT_DEFINITIONS})

link_directories(${TAGLIB_LIBRARY_DIRS})
link_directories(${GLIB_LIBRARY_DIRS})
link_directories(${GSTREAMER_LIBRARY_DIRS})
if(GIO_LIBRARY_DIRS)
    link_directories(${GIO_LIBRARY_DIRS})
endif()